/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  config.c
;
;  This file contains sets of configuration parameters for running the
;  system.
;
;***************************************************************************/

#include "common.h"
#include "ghs.h"

/* =============================================== */
/* static variable declarations */
/* =============================================== */

/* Dummy variable declarations. Used only for G.DMT */
uint8 guca_US_BAT23_TCM_ON;
uint8 guca_DS_BAT68_TCM_ON;

/* Bit allocation tables, used to test various channels */
uint8 guca_US_BAT28[32] = {
   0, 0, 0, 0, 0, 0, 6, 6, 5, 5,
   4, 4, 3, 5, 2, 15, 0, 15, 14, 14,
   13, 13, 12, 12, 11, 11, 10, 10, 9, 9,
   8, 8};
uint8 guca_DS_BAT41[128] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    /* 0-32              */
   4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                         /* 33-49 */
   8, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 0, 5, 4, 4, 4, 4,                   /* 50-69 */
   3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                   /* 70-89 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                   /* 90-119 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0};                        /* 120-117 */
uint8 guca_DS_BAT68[128] = {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    /* 0-32              */
   4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8,                         /* 33-49 */
   8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 0, 11, 12, 12, 12, 12,          /* 50-69 */
   13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 2, 2, 2, 2, 2, 2, 2, 2,          /* 70-89 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,                   /* 90-119 */
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0};                        /* 120-117 */
int16 gsa_FineGains[128] = {
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000,
   0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000};

/* =============================================== */
/* global variable declarations */
/* =============================================== */
/* Configuration parameters: */

/* when used for g.bis each set contains the following parameter */
/* {
/* Nbc,
/* Nlp,
/* {Rp[0],...,Rp[Nlp-1]},
/* {Mp[0],...,Mp[Nlp-1]},
/* {Lp[0],...,Lp[Nlp-1]} ,
/* {Tp[0],...,Tp[Nlp-1]},
/* {Dp[0],...,Dp[Nlp-1]},
/* {
/*    {Bpn[0][0],...,Bpn[0][Nbc-1]},
/*    {Bpn[0][0],...,Bpn[0][Nbc-1]},
/*    :
/*    :
/*    :
/*    {Bpn[Nlp-1][0],...,Bpn[Nlp-1][Nbc-1]}
/* },
/* x,
/* MSGlp,
/* IBITSlp,
/* MSGc,
/* array_name_of_BitAllocationTable,
/* array_name_FineGainsTable
/* }
/* where Nbc = number of frame bearers to be supported */
/*       Nlp = number of latency paths to transport */
/*       Rp[p] = number of R-S check bytes per FEC codeword in the path p */
/*       Mp[p] = number of mux frames per FEC data frame in path p */
/*       Lp[p] = number of bits from latency path p */
/*       Tp[p] = ratio of mux data frames to number of overhead octets in path p */
/*          Dp[p] = interleave depth in path p */
/*          Bpn[p][n] = number of raw bytes per mux data frame on Bearer Channel n, Latency Path p */
/*                n is in {0, 1,...,Nbc-1} */
/*                p is in {0, 1,...,Nlp-1} */
/*          x = entry is not applicable */
/*          MSGlp = label of the latency path used to transport the message based overhead information */
/*          IBITSlp = label of the latency path used to transport the indicator bits */
/*          MSGc = number of octets in the message based portion of the overhead structure */
/*          pBAT = pointer to Bit Allocation Table */
/*       pFineGains = pointer to Fine Gains Table */

/* when used for DS g.dmt each set contains the following parameter */
/* {
/* 7(NUM_DS_BEARER_CHANNELS),
/* 2(NUM_DATA_PATHS),
/* {Ri,Rf},
/* {S,x},
/* {x,x} ,
/* {x,x},
/* {D,x},
/* {
/*    {N_AS0i, N_AS1i, N_AS2i, N_AS3i, N_LS0i, N_LS1i, N_LS2i},
/*    {N_AS0f, N_AS1f, N_AS2f, N_AS3f, N_LS0f, N_LS1f, N_LS2f},
/* },
/* FM,
/* x,
/* x,
/* x,
/* array_name_of_BitAllocationTable,
/* array_name_FineGainsTable
/* }
/* when used for US g.dmt each set contains the following parameter */
/* {
/* 7(NUM_DS_BEARER_CHANNELS),
/* 2(NUM_DATA_PATHS),
/* {Ri,Rf},
/* {S,x},
/* {x,x} ,
/* {x,x},
/* {D,x},
/* {
/*    {N_LS0i, N_LS1i, N_LS2i, x, x, x, x},
/*    {N_LS0f, N_LS1f, N_LS2f, x, x, x, x},
/* },
/* FM,
/* x,
/* x,
/* x,
/* array_name_of_BitAllocationTable,
/* array_name_FineGainsTable
/* }
/* where Rf = number of R-S check bytes per symbol in the Fast Latency Path  */
/*       Ri = number of R-S check bytes per FEC codeword in the Interleaved Latency Path   */
/*       S = number of symbols per FEC codeword in the Interleaved Path */
/*          FM = framing mode (0, 1, 2, 3) */
/*       x = entry is not applicable */
/*          D = interleave depth */
/*          N_BBBp = number of raw bytes per mux data frame on Bearer Channel BBB, Latency Path p */
/*                   BBB is in {AS0, AS1, AS2, AS3, LS0, LS1, LS2} */
/*                   p = f, Fast Latency Path; p = i, Interleaved Latency Path */
/*          pBAT = pointer to Bit Allocation Table */
/*       pFineGains = pointer to Fine Gains Table */

/* when used for g.lite only each set contains the following parameter */
/* {
/* NUM_DS_BEARER_CHANNELS(1),
/* NUM_DATA_PATHS(1),
/* {Ri},
/* {S},
/* {x} ,
/* {x},
/* {D},
/* {N},
/* REDUCED_MERGED,
/* x,
/* x,
/* x,
/* array_name_of_BitAllocationTable,
/* array_name_FineGainsTable
/* }
/* where Ri = number of R-S check bytes per FEC codeword in the Interleaved Latency Path   */
/*       S = number of symbols per FEC codeword in the Interleaved Path */
/*          x = entry is not applicable */
/*          D = interleave depth */
/*          N = number of raw bytes per mux data frame (not including synch byte) */
/*          pBAT = pointer to Bit Allocation Table */
/*       pFineGains = pointer to Fine Gains Table */

/* The following configuration parameter sets are used to test different Rf, Ri, S, D and NBBBp. */
/* Each given Rf, Ri, S, D and NBBBp is selected such that Reed Solomon check byte overhead is  */
/* close to 10% of a codeword. */

/* The real configuration parameter should be supplied at the end of training process. */

/* Configuration parameters, where each set contains the following parameter */
/* {R/S, S, D, N, array_name_of_BitAllocationTable} */
/* where R = number of R-S check bytes per symbol  */
/*       S = number of symbols per FEC codeword */
/*       D = interleave depth */
/*       N = number of raw bytes per mux data frame (not including synch byte) */
/*       pBAT = pointer to Bit Allocation Table */

/* The following configuration parameter sets are used for test different R, S, D and N. */
/* For each given R, S and N are selected such that Reed Solomon check byte overhead is  */
/* close to 15% of a codeword. */

/* The real configuration parameter should be supplied at the end of training process. */
Config_t gt_config_set[NUM_CONFIG_SETS] = {
    /* Down stream ====================== */
   /* R=16, S=2, D=16, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {2, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{59, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 0 */

   /* R=8, S=1, D=16, N = 59 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {1, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{59, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_DS_BAT68, gsa_FineGains
   }, /* 1 */

   /* Up stream ======================= */
   /* R=16, S=4, D=8, N=23 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {16, 0}, {4, -1}, {-1, -1}, {-1, -1}, {8, -1},
      {{23, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT28, gsa_FineGains
   }, /* 2 */

   /* R=8, S=2, D=16, N=23 */
   {  NUM_DS_BEARER_CHANNELS, NUM_DATA_PATHS, {8, 0}, {2, -1}, {-1, -1}, {-1, -1}, {16, -1},
      {{23, 0, 0, 0, 0, 0, 0},{0, 0, 0, 0, 0, 0, 0}},
      REDUCED_MERGED, -1, -1, -1, guca_US_BAT28, gsa_FineGains
   }, /* 3 */

};


