/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ALP_Ini.c
 *
 *   Alphaeus Initialization function.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"

/***************************************************************************************
;  Subroutine Name: InitAlphaeus
;
;  Description:
;     This function initializes the Alphaeus core at modem start-up.
;     The core is left disabled upon initialization.
;
;  Prototype:
;     void InitAlphaeus(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
void InitAlphaeus(void)
{
   // reset all global registers
   FillCoreBuf32(ALP_CVER_ADDR, 0, ALP_NUM_GLOBAL_REG);
   // reset all TX registers
   FillCoreBuf32(ALP_T_CONFIG_ADDR, 0, ALP_NUM_TX_REG_BLOCK1);
   FillCoreBuf32(ALP_T_PCNTL_BC0_ADDR, 0, ALP_NUM_TX_REG_BLOCK2);
   FillCoreBuf32(ALP_T_PCNTL_BC1_ADDR, 0, ALP_NUM_TX_REG_BLOCK3);
   // reset all RX registers
   FillCoreBuf32(ALP_R_CONFIG_ADDR, 0, ALP_NUM_RX_REG_BLOCK1);
   FillCoreBuf32(ALP_R_PCNTL_BC0_ADDR, 0, ALP_NUM_RX_REG_BLOCK2);
   FillCoreBuf32(ALP_R_PCNTL_BC1_ADDR, 0, ALP_NUM_RX_REG_BLOCK3);

   // these registers are later initialized in TxDataPumpSetUp()
   // and RxDataPumpSetUp() before showtime
}
