/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: Config_Interp3_4.c
;
;  Initialization of strymon core interp 3 and 4 blocks
;
*****************************************************************************/
//*******************************************************************
// Config_Interp3_4.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 07/03/2012 Stefan/Sriram : Use Tx Interpolator coefficient for Annex-M and Annex-L mode
//             Grep for Enhc_US_Bis_ALL_Annex_L_filter
// 07/06/2012 Raghu M Fix FIR scaling programming bug grep for JIRA: XDSLRTFW 407
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2. Use Annex-B filters in oISDN binary.
//          Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 16/05/2013 Naveen: Use Annex J (Mask 5-9) Tx Interpolation filter before GHS
//            Grep for XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs
//*****************************************************************************

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_ini.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "cmv.h"
#include "ec_data.h"


/****************************************************************************
; Name: Config_Interp3;
;
; Prototype:
;  void Config_Interp3(void)
;
; Description: Not appl for HWengine6.2
;
*****************************************************************************/
C_SCOPE void Config_Interp3(void)
{
}
/****************************************************************************
; Name: Config_Interp4;
;
; Prototype:
;  void Config_Interp4(void)
;
; Description: Not appl for HWengine6.2
*****************************************************************************/
C_SCOPE void Config_Interp4(void)
{
   // No INTERP4 Filter
}

/****************************************************************************
; Name: Config_Potshpf;
;
; Prototype:
;  void Config_Potshpf(void)
;
; Description: ; Description: Not appl for HWengine6.2
*****************************************************************************/
C_SCOPE void Config_Potshpf(void)
{
   // see TXIIR Filter
}
/****************************************************************************
; Name: Config_Interp1;
;
; Prototype:
;  void Config_Interp1(int32 l_SelectedMode)
;
; Description:
;
; Interp1      input rate:    4.5MHz(bis), 9MHz(plus)
;           output rate:   72MHz
;
; The following interp1 filters are defined:
;
;           filter         output rate       used when
;           ------         ---------         ---------
;
;
;
; Arguments:
; Input: (i) SelectedMode
;
; Return Value:
;  N/A
;
; Globals:
;  gt_StrymonCPE_FilterTable
*****************************************************************************/
//Feature_US_BisPlus_ALL_Bringup_Annex_M Start

C_SCOPE void Config_Interp1(int32 l_SelectedMode)              // XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
{

   uint32 ul_data, ul_CntlReg;
    uint16 us_TX_FS, us_NCo, us_factor;
    uint16  *pusa_Co ;//us_OS, us_CntlReg, us_LF, us_NCo;


   //read V_Interp_CFG register and update Interp filter output scaling
   ReadCoreReg(V_INTERP_CFG_ADDR, &ul_CntlReg);

   //get interp factor
   us_factor = (uint16)(ul_CntlReg & 0x7);

   //clear bits other than TX.INTERP.IN_RATE amd TX.INTERP.FACTOR
   ul_CntlReg &= ((0xF<<20)|0x7);


   //read the sample rate for TX src input
   ReadCoreReg(V_SRC_CFG_ADDR, &ul_data);
   us_TX_FS = (uint16)((ul_data >>20)&0xF);

    //TX src input rate = 144/(1<<(8-us_TX_FS))
   //g.bis or g.dmt

   if(us_TX_FS == 2)
   {

      //set interp filter output scaling field
      ul_CntlReg &= 0x8FFFFFFF;// // JIRA: XDSLRTFW 407 Zero out bits 28,29,30
      ul_CntlReg |= ((gt_StrymonCPE_FilterTable.s_OS_TxInterp_Bis_AB& 0x7)<<28);

#ifndef ISDN
      // update filter coefficients
        //
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
        // programe FIR scale for Annexm filter.
        // Since FIR coeff are different.
      if ((l_SelectedMode == (MODE_G992_3 | ANNEX_M)))   // XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_AnxM_bis;
         //set interp filter output scaling field
         ul_CntlReg &= 0x8FFFFFFF;// // JIRA: XDSLRTFW 407 Zero out bits 28,29,30
         ul_CntlReg |= ((gt_StrymonCPE_FilterTable.s_OS_TxInterp_Bis_M&0x7)<<28);
      }
      // XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (END)
      // Enhc_US_Bis_ALL_Annex_L_filter (Start)
      // Use Anx-M Tx Interpolator filter for Anx-L Mode as well
      else if ((l_SelectedMode == (MODE_G992_3 | ANNEX_L)))  // XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_Bis;
      }
      else
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_Bis;
      }
      // Enhc_US_Bis_ALL_Annex_L_filter (End)
#else
        pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_Bis;
#endif

      //update filter length = acutal length/2 due to symmetric filter constraint
      us_NCo  = MAX_LENGTH_TXINTERP_DIV_2;

      //TX.INTERP.LEN
      ul_CntlReg |=  ((gt_StrymonCPE_FilterTable.us_Length_TxInterp_Bis-1) <<8);

   }
   else /* default value */
   {

      //set interp filter output scaling field
      ul_CntlReg &= 0x8FFFFFFF;// // JIRA: XDSLRTFW 407 Zero out bits 28,29,30
      ul_CntlReg |= ((gt_StrymonCPE_FilterTable.s_OS_TxInterp_Plus_AB &0x7)<<28);

#ifdef ISDN
      // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
      // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
      // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
      // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
      // PSDs because of the reconfiguration of the tx-path after G.Hs
      // As Annex-J activation tones are currently not used in any field deployment the activation
      // tones and G.Hs filter configurations are hard-coded to Annex-B.
      // this part of the code is called only in LinkStartForTest.c

       // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (Start)
      // Use Annex J (Mask 5-9) Tx Interpolation filter before GHS
      // After GHs the mode is determined. Then, use the appropriate Annex B filter
      // if the mode is Annex B or use the appropriate Annex J filter if the mode is Annex J
#if 0
      //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
      //update filter coefficients
      if (l_SelectedMode & ANNEX_J)
         pusa_Co = gsa_StrymonFir_Filter_TxInterp_AnxJ;
      else
         pusa_Co = gsa_StrymonFir_Filter_TxInterp_Plus;
      //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)
#else
      if (l_SelectedMode & ANNEX_B)
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_Plus;
      }
      else
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_AnxJ;
      }
#endif
       // XDSLRTFW-911 Feature_US_Plus_All_UseAnxJfilt_BeforeGHs (End)
#else
      if ((l_SelectedMode == (MODE_G992_5 | ANNEX_M)))
      {
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_AnxM;
         //set interp filter output scaling field
         ul_CntlReg &= 0x8FFFFFFF; // // JIRA: XDSLRTFW 407 Zero out bits 28,29,30
         ul_CntlReg |= ((gt_StrymonCPE_FilterTable.s_OS_TxInterp_Plus_M&0x7)<<28);
      }
      else
         pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_TxInterp_Plus;
#endif

      //update filter length = acutal length/2 due to symmetric filter constraint
      us_NCo  = MAX_LENGTH_TXINTERP_DIV_2;


      //TX.INTERP.LEN
      ul_CntlReg |= ((gt_StrymonCPE_FilterTable.us_Length_TxInterp_Plus-1) <<8);

   }

   Init_StrymonCPE_Filter(TXINTERPFIR, ul_CntlReg,  us_NCo, 0, pusa_Co);

}

//Feature_US_BisPlus_ALL_Bringup_Annex_M End

