/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   Configure_TCM_Bits.C
 *
 *   Iridia QT TCM Bits functions
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"


/***************************************************************************************
;  Subroutine Name: void Configure_TCM_Bits(uint16 us_Rx_Tcm_Num1bits, uint16 us_Rx_1Bit_Index)
;
;  Description:
;
;  Initializes IR_TCM_CTRL register
;
;  Prototype:
;     void Configure_TCM_Bits(uint16 us_Rx_Tcm_Num1bits, uint16 us_Rx_1Bit_Index)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/

C_SCOPE void Configure_TCM_Bits(uint16 us_Rx_Tcm_Num1bits, uint16 us_Rx_1Bit_Index)
{
   FlagT ft_TcmFlag;
   uint32 ul_data;

   ul_data = (uint32)((us_Rx_Tcm_Num1bits/2) & 0x0FFF) << 13;
   ul_data |= (uint32)(us_Rx_1Bit_Index & 0x01FFF);
   if (gft_ModemType == G_DMT_BIS)
      ft_TcmFlag = gft_TcmFlag_bis_DS;
   else
      ft_TcmFlag = gft_TcmFlag;
   if (ft_TcmFlag == TRUE)
      ul_data |= MASK_BIT25;
   WriteCoreReg((uint32)IRI_QT_REG_RX_TCM_CTRL_ADDR, ul_data);
}
