/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "qt_memmap.h"
#include "qtp_memmap.h"
#include "IRI_Iof.h"
#include "gdata_bis.h"



//=========================================================
// Global variables
//=========================================================
extern int16 gs_RxToneOffset;
//=========================================================
// Static variables
//=========================================================

//=========================================================
// Local functions
//=========================================================

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Trigger_IFFT
 *
 * Prototype:
 *    void Trigger_IFFT(void);
 *
 *  Abstract:
 *    Triggers the IFFT functionality in the Iridia core
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *------------------------------------------------------------------------
 */

void Trigger_IFFT()
{
   //empty function for adsl_62
}

/***************************************************************************************
;  Subroutine Name: ResetManualFFT
;
;  Description:
;     This routine sets the FFT in register mode. So it needs to be
;               kicked off manually
;
;  Prototype:
;     void ResetManulaFFT()
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
void ResetManualFFT()
{
      //empty function for adsl_62
}


void Reset_MTE_Overflow(void)
{
   // IFFT overflow, FFT overflow
   SetCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, (uint32)(MASK_BIT8|MASK_BIT6)); // write 1's to clear all bits

   // TX GS overflow
   ResetCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, (uint32)MASK_BIT8); // write 0's to clear all bits

   // RX GS overflow,  overflow, Feedforward MAC overflow, Feedback MAC overflow
   ResetCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, (uint32)(MASK_BIT7|MASK_BIT8|MASK_BIT9)); // write 0's to clear all bits
}


void TriggerFFT(void)
{
   SetCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)REGISTER_START_RX_FFT_START);
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    ReverbSegueDetectorSelect
 *
 * Prototype:
 *    void ReverbSegueDetectorSelect(int16 s_signalType);
 *
 *  Abstract:
 *    ReverbSegueDetectorSelect(int16 s_signalType) -
 *
 *    This function selects whether h/w reverb segue detector matches
 *    against Reverb or Segue signal
 *
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
void ReverbSegueDetectorSelect(int16 s_signalType)
{
   //For Hercules we use a SW Reverb/Segue Detector.
   if(s_signalType == C_SEGUE)
      gft_L2_Detect = C_SEGUE;
   else //s_signalType == C_REVERB
      gft_L2_Detect = C_REVERB;
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype:  ConfigRTVBuf0_RCD_OUT(void)
*
*  This function configures RTV buffer 0 to store  output during showtime
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigRTVBuf0_RCD_OUT(void)
{
   uint32 ul_tmpWord;
   ul_tmpWord =  (CDEC_OUTPUT << 25)               // Write Error output to RTV buffer 0
            | gs_RxToneOffset                // Init offset for RTV buffer 0 to 0
               | (1<<31); // Enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

    //Cnt is written in the following register, moved from the above reg
   ul_tmpWord = (gs_RxNumTones-1);
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);


    //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype:  ConfigRTVBuf1_SFDQ_OUT(void)
*
*  This function configures RTV buffer 0 to store  output during showtime
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigRTVBuf1_SFDQ_OUT(void)
{
   uint32 ul_tmpWord;
   ul_tmpWord =  (SFDQ_OUTPUT << 25)               // Write Error output to RTV buffer 0
            | gs_RxToneOffset                // Init offset for RTV buffer 0 to 0
               | (1<<31); // Enable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, ul_tmpWord);
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_CNT_35B_ADDR, (uint32)(gs_RxNumTones-1));
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: uint32 GetPingPongTableAddress(int16 s_table_id, int16 s_segment_idx )
*
*  This function gets the starting address of ping-pong table in inactive buffer
*
*  Input Arguments:
*     s_table_id: TX_BAT/RX_BAT, TX_GST/RX_GST, TX_TRT/RX_TRT, TX_EGT/RX_EGT
*     s_segment_idx: TX_INACTIVE_SEG0 (0), RX_INACTIVE_SEG0 (1),
*                      TX_INACTIVE_SEG1 (2), RX_INACTIVE_SEG1 (3)
*
*  Output Arguments:
*
*  Returns:
*     ul_addr: 32-bit address
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

uint32 GetPingPongTableAddress(int16 s_table_id, int16 s_segment_idx)
{

    uint32 ul_base_addr = 0;


    switch (s_table_id)
    {

        case TX_BAT:
        case RX_BAT:
            //offset = (gus_segment_size <<2) * s_segment_idx /4 //byte packed
            ul_base_addr = IRI_QT_RAM_INACTIVE_BAT_ADDR +  gus_segment_size * s_segment_idx;
         break;

      case TX_GST:
      case RX_GST:
            //offset = (gus_segment_size <<2) * s_segment_idx /2, word packed
         ul_base_addr = IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR    + gus_segment_size * s_segment_idx *2;
         break;

      case TX_TRT:
      case RX_TRT:
            //offset = (gus_segment_size <<2) * s_segment_idx /2, word packed
         ul_base_addr = IRI_QT_RAM_INACTIVE_TOT_ADDR +  gus_segment_size * s_segment_idx *2;
         break;

        case TX_EGT:
      case RX_EGT:
            //offset = (gus_segment_size <<2) * s_segment_idx /4, byte packed
         ul_base_addr = IRI_QT_RAM_INACTIVE_EGT_ADDR  +  gus_segment_size * s_segment_idx ;
         break;
   }
   return (ul_base_addr);
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void CopyTxTable_InactiveToActive(int16 s_mintone, int16 s_maxtone)
*
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void CopyTxTable_InactiveToActive(int16 s_mintone, int16 s_maxtone)
{
   uint32 ul_data;
    FlagT ft_tot_disable, ft_tx_prbs;

    // set TC direction inactive to active
    ResetCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, MASK_BIT0);
    //read QTP txtc control to get tot_dis
    ReadCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, &ul_data);
    ft_tot_disable = (uint8)((ul_data &(1<<5)) >> 5) ;


    //QTP_TX_CTRL.
   // Read and preserve QTP PRBS information first
   ReadCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, &ul_data);
    ft_tx_prbs = (uint8)((ul_data & MASK_BIT1) >> 1);
    WriteCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, ((uint32)(s_maxtone << 2)|(ft_tx_prbs << 1)));

    if (!ft_tot_disable)
    {
        //MAX_ITOT_ADDR and MIN_ITOT_ADDR
        ul_data = (uint32)( (uint32)( (TX_NUM_TONES-1)<< 13) | 0);
        WriteCoreReg(IRI_QTP_REG_TXTC_TOT_ADDR, ul_data);
    }

   //IRI_QTP_REG_TXTC_ACTIVE_ADDR
   ul_data = (uint32)( (uint32)(s_maxtone << 13)|s_mintone);
   WriteCoreReg(IRI_QTP_REG_TXTC_ACTIVE_ADDR, ul_data);

    //enable table copying
    SetCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, MASK_BIT0);
 }

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void CopyRxTable_InactiveToActive(int16 s_mintone, int16 s_maxtone)
*
*
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void CopyRxTable_InactiveToActive(int16 s_mintone, int16 s_maxtone)
{
   // Set TBLCP_ENA bit - auto cleared after copy
   uint32 ul_data;
   int16 us_startAddr = 0;
    FlagT ft_tot_disable,ft_rx_prbs;

    // TC direction inactive to active
   ResetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, MASK_BIT0);
     //read QTP rxtc control to get tot_dis
    ReadCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, &ul_data);
    ft_tot_disable = (uint8)((ul_data &(1<<5)) >> 5) ;

    // If TOT_DIS = 1, we need to write MAX_RX_TONES to QTP_RX_CTRL.
    // Read and preserve QTP PRBS information first
    // QTP_RX_CTRL
   ReadCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, &ul_data);
    ft_rx_prbs = (uint8)((ul_data & MASK_BIT1) >> 1);
    WriteCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, ((uint32)( (s_maxtone-1) << 2)|(ft_rx_prbs << 1)));

    // QTP_RXTC_TOT_AD
    if (!ft_tot_disable)
    {
        //set the min and max addresses used by the transmitter for accessing the active table
      ul_data = (uint32)( (uint32)((gs_RxNumTones-1) << 13) |0);
        WriteCoreReg(IRI_QTP_REG_RXTC_TOT_ADDR, ul_data);
    }

    // QTP_RXTC_ACT_AD
    ul_data = (uint32)( (uint32)(s_maxtone << 13) |s_mintone);
   WriteCoreReg(IRI_QTP_REG_RXTC_ACTIVE_ADDR, ul_data);

    // QTP_RXTC_CTRL set TC direction inactive to active
    ResetCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, MASK_BIT0);

    // Enable table copying
   SetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, MASK_BIT0);

}
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigIridiaQtpRxPath(void)
*
*  This function initializes Iridia-QTP core for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigIridiaQtpRxPath(void)
{
    int32 ul_data;
    int16 s_Rx_NumLogical_Tones, s_Rx_Num0bits_Tones,  s_Rx_NumGT1bits_Tones;

   uint8 uc_1bit_at_end;
    //QTP_RX_CTRL  configured in CopyRxTable_InactiveToActive

    // QTP_RXTC_CTRL
    // calculate the number of tones with bi=0 and with bi>0
    // guc_RxQtInactiveTblSeg
    s_Rx_NumLogical_Tones = gus_Rx_MaxToneIndx - gus_Rx_MinToneIndx + 1;
    s_Rx_Num0bits_Tones =  s_Rx_NumLogical_Tones - gus_ncloaded;
    s_Rx_NumGT1bits_Tones = gus_ncloaded - gus_Rx_Tcm_Num1bits;

   //QTP_TXTC
   if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_DS)
      uc_1bit_at_end = MASK_BIT1;      //if ADSL2 and Trellis On
   else
      uc_1bit_at_end = 0;
   ul_data = ( (uint32)
            ( ( s_Rx_Num0bits_Tones &   ((1<<13)-1) ) << 19) |  // set Num0bits_Tones
            ( ( s_Rx_NumGT1bits_Tones & ((1<<13)-1) ) << 6)  |  // set Rx_NumGT1bits_Tones
                (0<<5) |  // enable tone reordering
                (guc_RxQtInactiveTblSeg<<2 )|   // select the segment
               uc_1bit_at_end   // 1-bit tones after greater than 1 bit tones
              ) ; // TOT_DIS=0; segment = 1 ; tc_Dir =0= inactive->active
   WriteCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, ul_data);

    CopyRxTable_InactiveToActive(gus_Rx_MinToneIndx, gus_Rx_MaxToneIndx);
}

/*-----------------------------------------------------------
*
*  Prototype: void ConfigIridiaQtpTxPath(void)
*
*  This function initializes Iridia-QTP core for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigIridiaQtpTxPath(void)
{
    int32 ul_data;
    int16 s_Tx_NumLogical_Tones, s_Tx_Num0bits_Tones,  s_Tx_NumGT1bits_Tones;
    uint8 uc_1bit_at_end;

    //write TXTC_CTRL register
    //calculate the number of tones with bi=0 and with bi>0
    s_Tx_NumLogical_Tones = gs_TxNumTones;
    s_Tx_Num0bits_Tones =  s_Tx_NumLogical_Tones - gs_TxNumLoadedTones;
    s_Tx_NumGT1bits_Tones = gs_TxNumLoadedTones - gus_Tx_Tcm_Num1bits;

    //QTP_TXTC
   if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_US)
      uc_1bit_at_end = MASK_BIT1;      //if ADSL2 and Trellis On
   else
      uc_1bit_at_end = 0;
   ul_data = ( (uint32)
            ( ( s_Tx_Num0bits_Tones &   ((1<<13)-1) ) << 19) |  // set Num0bits_Tones
            ( ( s_Tx_NumGT1bits_Tones & ((1<<13)-1) ) << 6)  |  // set Tx_NumGT1bits_Tones
                ( 0 <<5) |  // enable tone reordering
                (guc_TxQtInactiveTblSeg<<2 )|   // select the segment
                uc_1bit_at_end  // 1-bit tones after greater than 1 bit tones
              ) ; // TOT_DIS=0; segment = 0 ; tc_Dir =0= inactive->active
   WriteCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, ul_data);

    CopyTxTable_InactiveToActive(0, (uint16)(gs_TxNumTones-1));
}




#ifndef TARGET_HW
/***************************************************************************************
;  Subroutine Name: AccessIfftBuffer
;
;  Description:
;     This function access the IFFT buffer by either read from or write to it.
;     It can access any, A, B or C buffer as specified by the input flag.
;     It can also use the DSP reorder feature as specified by the input flag.
;
;  Prototype:
;     void AccessIfftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones, FlagT gft_InOut, FlagT gft_ReadWrite)
;
;  Input Arguments:
;     psa_buf  -- pointer to the buffer to store the input or output data
;       s_offset -- the first location of the IFFT buffer to access (in unit of 32-word address)
;     s_NumTones -- the number of tones (or a pair of samples) to access
;       gft_DigitRev  -- indicator of IFFT input (1) or output (0) of IFFT output buffer
;     gft_ReadWrite -- indicator of reading or writing operation
;       gft_WhichBuf -- indicate which buffer, QT, FT or FDF to access
;
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;**********************************************************************************************/

void AccessIfftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
               FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf)
{
   uint32 ul_data_sav;
   uint32 ul_IfftBufAddr;

   ReadCoreReg(IRI_FTB_CTRL_ADDR, &ul_data_sav);

   //Decide which one is the current IFFT buffer
   //Note in the 6.2 HW, the IFFT input and output has the same buffer
   GetIfftBufAddr(&ul_IfftBufAddr, gft_WhichBuf);

   if(gft_DigitRev == IFFT_DSP_REORD_ENA)
   {
      //IFFT input is stored in digit-reversed order
      //set the IFFT_DSP_REORD to 1
      SetCoreReg(IRI_FTB_CTRL_ADDR, (1<<11));
   }
   else //if(gft_DigitRev == IFFT_DSP_REORD_DIS)
   {
      //IFFT output is stored in linear order
      //set the IFFT_DSP_REORD to 0
      ResetCoreReg(IRI_FTB_CTRL_ADDR, (1<<11));
   }

   if(gft_ReadWrite == IFFT_BUF_READ)
      ReadCoreBuf32(ul_IfftBufAddr+s_offset, psa_buf, s_NumTones);
   else //gft_ReadWrite == IFFT_BUF_WRITE)
      WriteCoreBuf32(ul_IfftBufAddr+s_offset, psa_buf, s_NumTones);

   //Restore the original value of register FTB_CTRL
   WriteCoreReg(IRI_FTB_CTRL_ADDR, ul_data_sav);
}

/***************************************************************************************
;  Subroutine Name: GetIfftBufAddr
;
;  Description:
;     This function retrieves one of the IFFT buffer addresses for the following buffer:
;  TX_QT_BUF, TX_FT_BUF and TX_FDF.
;
;  Prototype:
;     void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
;
;  Input Arguments:
;     pul_addr  -- pointer to the returned buffer address
;       gft_WhichBuf -- specify one of the IFFT buffers: TX_QT_BUF, TX_FT_BUF or TX_FDF
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;**********************************************************************************************/
void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
{
   uint32 ul_TxBufferStat;
   int16 i;

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_TxBufferStat);

   switch(gft_WhichBuf)
   {
   case TX_QT_BUF:
      i = 0;
      break;
   case TX_FT_BUF:
      i = 3;
      break;
   case TX_FDF_BUF:
      i = 6;
      break;
   }

   //Get the status bits
   i = (int16)((ul_TxBufferStat>>i) & 3);

   switch(i)
   {
    case 0:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
      break;

    case 1:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
      break;

    case 2:
      *pul_addr = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
      break;
   }
}

//Function to read the FTB_TX_STATUS register
void ReadIfftBufStatus(uint32 *pul_data)
{
   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, pul_data);
}


/****************************************************************************************
;  Subroutine Name: AccessFftBuffer
;
;  Description:
;     This function access the IFFT buffer by either read from or write to it.
;     It can access any, A, B or C buffer as specified by the input flag.
;     It can also use the DSP reorder feature as specified by the input flag.
;
;  Prototype:
;     void AccessFftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones, FlagT gft_InOut, FlagT gft_ReadWrite)
;
;  Input Arguments:
;     psa_buf  -- pointer to the buffer to store the input or output data
;       s_offset -- the first location of the IFFT buffer to access (in unit of 32-word address)
;     s_NumTones -- the number of tones (or a pair of samples) to access
;       gft_DigitRev  -- indicator of IFFT input (1) or output (0) of IFFT output buffer
;     gft_ReadWrite -- indicator of reading or writing operation
;     gft_WhichBuf -- indicate which buffer, QT, FT or FDF to access
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;**********************************************************************************************/

void AccessFftBuffer(int16 *psa_buf, int16 s_offset, int16 s_NumTones,
               FlagT gft_DigitRev, FlagT gft_ReadWrite, FlagT gft_WhichBuf)
{
   uint32 ul_data_sav;
   uint32 ul_FftBufAddr;

   ReadCoreReg(IRI_FTB_CTRL_ADDR, &ul_data_sav);

   //Decide which one is the current FFT buffer
   //Note in the 6.2 HW, the IFFT input and output has the same buffer
   GetFftBufAddr(&ul_FftBufAddr, gft_WhichBuf);

   if(gft_DigitRev == FFT_DSP_REORD_ENA)
   {
      //FFT output is stored in digit-reversed order
      //set the FFT_DSP_REORD to 1
      SetCoreReg(IRI_FTB_CTRL_ADDR, (1<<3));
   }
   else //if(gft_DigitRev == IFFT_DSP_REORD_DIS)
   {
      //FFT input is stored in linear order
      //set the FFT_DSP_REORD to 0
      ResetCoreReg(IRI_FTB_CTRL_ADDR, (1<<3));
   }

   if(gft_ReadWrite == FFT_BUF_READ)
      ReadCoreBuf32(ul_FftBufAddr+s_offset, psa_buf, s_NumTones);
   else //gft_ReadWrite == FFT_BUF_WRITE)
      WriteCoreBuf32(ul_FftBufAddr+s_offset, psa_buf, s_NumTones);

   //Restore the original value of register FTB_CTRL
   WriteCoreReg(IRI_FTB_CTRL_ADDR, ul_data_sav);
}

/***************************************************************************************
;  Subroutine Name: GetFftBufAddr
;
;  Description:
;     This function retrieves one of the FFT buffer addresses for the following buffer:
;  RX_QT_BUF, RX_FT_BUF and RX_FDF_BUF.
;
;  Prototype:
;     void GetIfftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
;
;  Input Arguments:
;     pul_addr  -- pointer to the returned buffer address
;       gft_WhichBuf -- specify one of the IFFT buffers: RX_QT_BUF, RX_FT_BUF or RX_FDF
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;**********************************************************************************************/
void GetFftBufAddr(uint32 *pul_addr, FlagT gft_WhichBuf)
{
   uint32 ul_TxBufferStat;
   int16 i;

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_TxBufferStat);

   switch(gft_WhichBuf)
   {
   case RX_QT_BUF:
      i = 0;
      break;
   case RX_FT_BUF:
      i = 3;
      break;
   case RX_FDF_BUF:
      i = 6;
      break;
   }

   //Get the status bits
   i = (int16)((ul_TxBufferStat>>i) & 3);

   switch(i)
   {
    case 0:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
      break;

    case 1:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
      break;

    case 2:
      *pul_addr = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
      break;
   }
}



//Function to fetch the time domain samples
void ReadFftBuffer(int16 *psa_out, int16 s_offset, int16 s_NumTones, FlagT ft_timedomain)
{
   uint32  ul_FFTInput, ul_FFTOutput;

    if(ft_timedomain)
    {
        //read the time domain samples
        WhichFFTBuffers2(&ul_FFTInput, &ul_FFTOutput);
        ReadCoreBuf32((ul_FFTInput+s_offset), psa_out, s_NumTones);
    }
    else
    {
        // Read the buffer.
      WhichFFTBuffers(&ul_FFTInput, &ul_FFTOutput);
        //read the frequency domain output
        ReadCoreBuf32((ul_FFTOutput+s_offset), psa_out, s_NumTones);
    }
}
#endif
