/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_showtime.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
// 19/06/2012 Raghu M
//          L2 related changes grep for XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "iri_iof.h"
#include "detect.h"

/*****************************************************************************
;  Subroutine Name: RxSyncFrameSetup()
;
;  This subroutine set gain scale block in register mode and enables Rx FDQ done interrupt
;  during sync frame
;
;  Prototype:
;     void RxSyncFrameSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE void RxSyncFrameSetup(void)
{
   // disable QT BS (bit-stuffer)
   SetCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, (uint32)MASK_BIT15);
}

/*****************************************************************************
;  Subroutine Name: RxSyncFrameTearDown()
;
;  This subroutine set gain scale block in cascade mode and disables Rx FDQ done interrupt
;  after sync frame
;
;  Prototype:
;     void RxSyncFrameTearDown(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE void RxSyncFrameTearDown(void)
{
   // enable QT BS (bit-stuffer)
   ResetCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, (uint32)MASK_BIT15);
}



/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    void SaveQamOutputState(void)
 *
 * Prototype:
 *    void SaveQamOutputState(void)
 *
 *  Abstract:
 *    Saves the last known good qam output state
 *    (i.e. Gets the Rx Ratebuffer write pointer and Rx Bit Fifo)
 *    so that we can restore it after l2 exit sequence
 *    detection inspite of decoding the l2 exit sequence as data
 *
 *  Returns:
 *    None
 *------------------------------------------------------------------------
 */
C_SCOPE void SaveQamOutputState(void)
{
   int16 s_LatencyPath;
   uint32 ul_data;
   uint32 ul_bitFifoAddr[NUM_DATA_PATHS] = {IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR, IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR};

   for(s_LatencyPath=0; s_LatencyPath<NUM_DATA_PATHS; s_LatencyPath++)
   {
      ReadCoreReg ((uint32)ul_bitFifoAddr[s_LatencyPath], &ul_data);
      gt_RxOLRPMVars.usa_rxBitFifo[s_LatencyPath] = (uint16)(ul_data & 0x00007FF);
   }
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    void RestoreQamOutputState(void)
 *
 * Prototype:
 *    void RestoreQamOutputState(void)
 *
 *  Abstract:
 *    Restores the last known good qam output state
 *    (i.e. writes the saved Rx Ratebuffer write pointer and Rx Bit Fifo)
 *    to account for decoding the l2 exit sequence as data, before
 *    entering the L0 state
 *
 *  Returns:
 *    None
 *------------------------------------------------------------------------
 */
C_SCOPE void RestoreQamOutputState(void)
{
   int16 s_LatencyPath;
   uint32 ul_bitFifoAddr[NUM_DATA_PATHS] = {IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR, IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR};

   for(s_LatencyPath=0; s_LatencyPath<NUM_DATA_PATHS; s_LatencyPath++)
      WriteCoreReg (ul_bitFifoAddr[s_LatencyPath], gt_RxOLRPMVars.usa_rxBitFifo[s_LatencyPath]);

}


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    WhichPhysicalBuffer
 *
 * Prototype:
 *    void WhichPhysicalBuffer(uint16 s_logicalBuffer);
 *
 *  Abstract:
 *    WhichPhysicalBuffer() -
 *
 *    This function identifies which physical buffer given the
 *              logical buffer
 *
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
C_SCOPE uint16 WhichPhysicalBuffer(uint16 s_logicalBuffer)
{
   // not used in Hercules build
   return(0);
}
/*****************************************************************************
;  Prototype:
;     void LoadDDFDQ(void)
;
;  Input Arguments: None
;  Output Arguments: None
;
;  Time Critical function to load the FDQ coefficients and their shifts as
;  computed by decision directed processing in showtime data frames
;
;  Global Variables:
;     Inputs:
;        gs_DD_RxFirstChannel
;        gs_DD_RxLastChannel
;        gsa_pre_FDQ_coef - FDQ coefficients computed during training
;        gsa_pre_FDQ_exp - shifts values for FDQ coefficients computed during training
;
;
;     Outputs:
;
;****************************************************************************/

C_SCOPE void LoadDDFDQ(void)
{
   int16 i, j, s_length;

   i = gs_DD_RxFirstChannel;
   j = gs_DD_RxLastChannel;
   s_length = j - i + 1;

    // write SFDQ mantissa
   WriteCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR + 4*i),  &(gsa_pre_FDQ_coef[2*i]), s_length);
    // write SFDQ exponent
   WriteCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*i),    &(guca_pre_FDQ_exp[i]), s_length);
}


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    isReverbSegueDetected
 *
 * Prototype:
 *    FlagT isReverbSegueDetected(void);
 *
 *  Abstract:
 *    isReverbSegueDetected() -
 *
 *    This function returns the results reverb segue detector.
 *      This tries to mimic reverg segue detecter in the Danube HW.
 *      This function replaces the reverb segue detector that was in Danube HW.
 *
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
C_SCOPE FlagT isReverbSegueDetected(int16 s_x)
{
   int16 s_num_reverb_matches;
   int16 s_num_segue_matches;

   switch(s_x){

   case 2: // Input signal is a Sync Frame

      if(gs_RxSyncToneType != DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, NULL, NULL))
         return TRUE;
      else
         return FALSE;
      break;

   case 1: //Input signal is a Data frame (looking for L2 exit sequence)

      DetectReverbSegue(gsa_RSDetect_Bins, gsa_RSDetect_PNSeq, gs_RSDetect_NumBins, &s_num_reverb_matches, &s_num_segue_matches);

      // XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (START)
      if(gft_L2_Detect == C_REVERB)
      {
         if(s_num_reverb_matches > gs_RSDetect_NumBins_L2)
            return TRUE;
         else
            return FALSE;
      }
      else // gft_L2_Detect == C_SEGUE
      {
         if(s_num_segue_matches > gs_RSDetect_NumBins_L2)
            return TRUE;
         else
            return FALSE;
      }
      // XDSLRTFQ-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)

      break;
   default :
            return FALSE; //avoid compiler warning
   }
}

