/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
//*******************************************************************
// IRI_IOf_showtime.c
//
// History
//
//
// 12/01/2012 Kannan : Mirrored complex conjugate images are enabled for T1413 mode
//                     to emulate 64pt IFFT in showtime for sync symbols
//                     Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
//*****************************************************************************
#include <stdio.h>
#include <string.h>
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
extern int16 gsa_TxTimeBuf[];  // size = 1024


/*****************************************************************************
;  Subroutine Name: TxSyncFrameSetup()
;
;  This subroutine set ifft block in register start mode during sync frame
;
;  Prototype:
;     void TxSyncFrameSetup(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/



C_SCOPE void TxSyncFrameSetup(void)
{
//PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
if ((gft_TxImages ==1) || (gft_IFFT64_T1413_TxImages == 1))
{
   //int i,j;
   int16 s_fftlen, ntones, ntones2;
   int16 i, s_numbytes;
   /* ======================================================================== */
   /* LoadTxOutBuffer moves the data contained in TxToneBuf to the IFFT buffer   */
   /* ======================================================================== */
   ntones = gs_TxNumTones;
   ntones2 = ntones*2;
   s_fftlen = gs_TxFftLength_Oversample;

#if 1
    //numbytes = number of tones * 4 bytes (Real: 2 bytes, imag: 2 bytes)
   //gsa_TxTimeBuf[0] : Tone 0 Real
   //gsa_TxTimeBuf[1] : Tone 0 Imag
   //gsa_TxTimeBuf[0:127] = gsa_Showtime_TxToneBuf[0:127]
    memcpy(gsa_TxTimeBuf, gsa_Showtime_TxToneBuf, (ntones * sizeof(int16) * 2));
#else
   for (i=0 ; i<ntones ; i++)
   {
      gsa_TxTimeBuf[2*i] = gsa_Showtime_TxToneBuf[2*i];
      gsa_TxTimeBuf[2*i+1] = gsa_Showtime_TxToneBuf[2*i+1];
   }
#endif
   gsa_TxTimeBuf[2*ntones] = 0;
   gsa_TxTimeBuf[2*ntones+1] = 0; //NyQuist

   //prepare for the conjugate signals
   for (i=ntones+1 ; i<ntones2 ; i++)
   {
      gsa_TxTimeBuf[2*i] = gsa_TxTimeBuf[2*(ntones2-i)];
      gsa_TxTimeBuf[2*i+1] = -gsa_TxTimeBuf[2*(ntones2-i)+1];
   }
#if 1
   //s_fftlen = 512
   //num bytes = number of tones * 4 bytes (Real: 2 bytes, imag: 2 bytes)
   //Tones[128:255] = Tones[0:127]; each tone has real and imag so 4 bytes.
   //gsa_TxTimeBuf[256] : Tone 128 Real
   //gsa_TxTimeBuf[257] : Tone 128 Imag
   //gsa_TxTimeBuf[256:511] = gsa_TxTimeBuf[0:255]
   s_numbytes = (((s_fftlen>>1) - ntones2) * sizeof(int16) * 2);
   memcpy(&gsa_TxTimeBuf[ntones2<<1], &gsa_TxTimeBuf[0], s_numbytes);
#else
   //prepare for the images at gs_TxFftLength*2
   for (i=ntones2,j=0 ; i < (s_fftlen>>1) ; i++,j++)
   {
      gsa_TxTimeBuf[2*i] = gsa_TxTimeBuf[2*j];
      gsa_TxTimeBuf[2*i+1] = gsa_TxTimeBuf[2*j+1];
   }

#endif
   LoadTxOutBuffer(gsa_TxTimeBuf, s_fftlen);
}

else

   LoadTxOutBuffer(gsa_Showtime_TxToneBuf, gs_TxFftLength);


    //Disable TxPms
   DisableTxPms();

   // Disable Tx QT from pulling data bytes from dtb
// DisableTxQTEncode();
   {
      // turn off trellis for sync frame.
   ResetCoreReg(IRI_QT_REG_TX_TCM_CTRL_ADDR, MASK_BIT25); //TTE

   // enable PRBS mode
   SetCoreReg(IRI_QT_REG_TX_MISC_ADDR,1<<5); //PRBS_GEN

   }


}

/*****************************************************************************
;  Subroutine Name: TxSyncFrameTearDown()
;
;  This subroutine set ifft block in cascade start mode during frame 0
;
;  Prototype:
;     void TxSyncFrameTearDown(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

C_SCOPE void TxSyncFrameTearDown(void)
{
   //disable DCI
   ResetCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, MASK_BIT0 );

    //enable PMS for data symbol
   EnableTxPms();

   //enable TXQT.
// EnableTxQTEncode();
   {
   extern FlagT   gft_TcmFlag_bis_US;
   FlagT ft_TcmFlag;
   // reactivate trellis
   if (gft_ModemType == G_DMT_BIS)
      ft_TcmFlag = gft_TcmFlag_bis_US;
   else
      ft_TcmFlag = gft_TcmFlag;

   if (ft_TcmFlag == TRUE)
   SetCoreReg(IRI_QT_REG_TX_TCM_CTRL_ADDR, MASK_BIT25); //TTE

   // disable PRBS mode
   ResetCoreReg(IRI_QT_REG_TX_MISC_ADDR,1<<5); //PRBS_GEN

   }
}


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    void GetTxLpBits(int16 s_LatencyPath, int16 *ps_BitsLp)
 *
 * Prototype:
 *    void GetTxLpBits(int16 s_LatencyPath, int16 *ps_BitsLp)
 *
 *  Abstract:
 *    Gets the Tx Lp Parameter
 *
 *  Returns:
 *    None
 *------------------------------------------------------------------------
 */
C_SCOPE void GetTxLpBits(int16 s_LatencyPath, int16 *ps_BitsLp)
{
   // not used in Hercules build
}

