/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */

/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf_tables.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "fifo.h"
#include "tone_reord_load.h"
#include "tone_ord.h"
#include "bitload_const.h"
#include "string.h"

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadRxBitAllocationTable(void)
*
*  This function loads RX Bit Allocation Table (BAT).
*
*  Input Arguments:
*     s_segment_idx: TX_INACTIVE_SEG0 (0), RX_INACTIVE_SEG0 (1),
*                      TX_INACTIVE_SEG1 (2), RX_INACTIVE_SEG1 (3)
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/


C_SCOPE void LoadRxBitAllocationTable(void)
{
   uint32 ul_addr;
   int16 s_MaxNumTones, s_InNumTones, s_OutNumTones;

   // note that the direction bit of RX ping-pong buffers is not set
   // that is, all tones are considered as RX tones, therefore initialize for all tones

   s_MaxNumTones = gs_RxFftLength >> 1;
   s_InNumTones = gs_RxNumTones;
   s_OutNumTones = s_MaxNumTones - s_InNumTones;

   // write BAT
   ul_addr = GetPingPongTableAddress(RX_BAT, guc_RxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)(void *)gt_rx_config.psa_BAT, (uint16)(s_InNumTones >> 2));

   // take care of outband tones
   ul_addr += (s_InNumTones >> 2)*4;
   FillCoreBuf32(ul_addr, 0, (uint16)(s_OutNumTones >> 2));
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadRxGainScaleTable(void)
*
*  This function loads RX Gain Scale Table (GST).
*
*  Input Arguments:
*        s_segment_idx: TX_INACTIVE_SEG0 (0), RX_INACTIVE_SEG0 (1),
*                      TX_INACTIVE_SEG1 (2), RX_INACTIVE_SEG1 (3)
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadRxGainScaleTable(void)
{
   uint32 ul_addr;
   int16 s_MaxNumTones, s_InNumTones, s_OutNumTones;

   // note that the direction bit of RX ping-pong buffers is not set
   // that is, all tones are considered as RX tones, therefore initialize for all tones

   s_MaxNumTones = gs_RxFftLength >> 1;
   s_InNumTones = gs_RxNumTones;
   s_OutNumTones = s_MaxNumTones - s_InNumTones;

   // write GST
   ul_addr = GetPingPongTableAddress(RX_GST, guc_RxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)gsa_RxCombinedGains, (uint16)(s_InNumTones >> 1));

   // take care of outband tones
   ul_addr += (s_InNumTones >> 1)*4;
   FillCoreBuf32(ul_addr, 0, (uint16)(s_OutNumTones >> 1));
}
//XDSLRTFW-1727
C_SCOPE void LoadRxGainScaleL2Table(void)
{
        uint32 ul_addr;
        int16 s_MaxNumTones, s_InNumTones, s_OutNumTones;
        // note that the direction bit of RX ping-pong buffers is not set
        // that is, all tones are considered as RX tones, therefore initialize for all tones

        s_MaxNumTones = gs_RxFftLength >> 1;
        s_InNumTones = gs_RxNumTones;
        s_OutNumTones = s_MaxNumTones - s_InNumTones;

        // write GST for L2 tables
        ul_addr = GetPingPongTableAddress(RX_GST, guc_RxQtInactiveTblSeg);
        WriteCoreBuf32(ul_addr, (int16*)(void *)gusa_RxL2CombinGains, (uint16)(s_InNumTones >> 1));

        // take care of outband tones
        ul_addr += (s_InNumTones >> 1)*4;
        FillCoreBuf32(ul_addr, 0, (uint16)(s_OutNumTones >> 1));
}
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadRxToneReorderTable(void)
*
*  This function loads RX Tone Reordering Table (GST).
*
*  Input Arguments:
*        s_segment_idx: TX_INACTIVE_SEG0 (0), RX_INACTIVE_SEG0 (1),
*                      TX_INACTIVE_SEG1 (2), RX_INACTIVE_SEG1 (3)
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadRxToneReorderTable(void)
{
   uint32 ul_addr;

   // perform tone re-ordering when we have tcm on (this can be done in FG or BG)
   if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_DS) { // if ADSL2 and Trellis On
      // add to background task
      if (guc_RxToneOrderLoadState == RXTONEORDERLOAD_WAITING) {
         AddFunctionToBkgdFifo((PtrToBkgdFunc)BgRxToneReorderLoad);
         guc_RxToneOrderLoadState = RXTONEORDERLOAD_BKGD_IN_PROGRESS;
      }
   } else {
      // load TRT immediately
      guc_RxToneOrderLoadState = RXTONEORDERLOAD_TC_LOAD;
   }

   // note that the direction bit of RX ping-pong buffers is not set
   // that is, all tones are considered as RX tones, therefore initialize for all tones

   // write TRT
   // for ADSL2, BG task triggers TRT loading
   if (guc_RxToneOrderLoadState == RXTONEORDERLOAD_TC_LOAD) {
      ul_addr = GetPingPongTableAddress(RX_TRT, guc_RxQtInactiveTblSeg);
      WriteCoreBuf32(ul_addr, gsa_RxToneOrder, (uint16)(gs_RxNumTones >> 1));
      if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_DS) // if ADSL2 and Trellis On
         // wait until background task triggers
         guc_RxToneOrderLoadState = RXTONEORDERLOAD_BKGD_IN_PROGRESS;
      else
         guc_RxToneOrderLoadState = RXTONEORDERLOAD_BKGD_DONE;
   }
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadTxBitAllocationTable(void)
*
*  This function loads TX Bit Allocation Table (BAT).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadTxBitAllocationTable(void)
{
   uint32 ul_addr;
   int16 s_MaxNumTones, s_InNumTones, s_OutNumTones;

   // note that the direction bit of TX ping-pong buffers is set from tone 0 to 63
   // higher tones are not considered as TX tones, therefore no need to be cleared

   s_MaxNumTones = gs_TxFftLength >> 1;
   s_InNumTones = gs_TxNumTones;
   s_OutNumTones = s_MaxNumTones - s_InNumTones;

   // write BAT
   ul_addr = GetPingPongTableAddress(TX_BAT, guc_TxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)(void *)gt_tx_config.psa_BAT, (uint16)(s_InNumTones >> 2));

   // take care of outband tones
   ul_addr += s_InNumTones ;
   FillCoreBuf32(ul_addr, 0, (uint16)(s_OutNumTones >> 2));
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadTxGainScaleTable(void)
*
*  This function loads TX Gain Scale Table (GST).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadTxGainScaleTable(void)
{
   uint32 ul_addr;
   int16 s_MaxNumTones, s_InNumTones, s_OutNumTones;

   // note that the direction bit of TX ping-pong buffers is set from tone 0 to 63
   // higher tones are not considered as TX tones, therefore no need to be cleared

   s_MaxNumTones = gs_TxFftLength >> 1;
   s_InNumTones = gs_TxNumTones;
   s_OutNumTones = s_MaxNumTones - s_InNumTones;

   // write GST
   ul_addr = GetPingPongTableAddress(TX_GST, guc_TxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, (int16*)gsa_TxCombinedGains, (uint16)(s_InNumTones >> 1));

   // take care of outband tones
   ul_addr += (s_InNumTones >> 1)*4;
   FillCoreBuf32(ul_addr, 0, (uint16)(s_OutNumTones >> 1));
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadTxToneReorderTable(void)
*
*  This function loads TX Tone Reordering Table (GST).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadTxToneReorderTable(void)
{
   int16 i, *psa_tmp, s_MaxNumTones, s_InNumTones, s_OutNumTones;
   int32 la_TxToneOrder[TX_NUM_TONES/2], la_TxToneOrderTCM[TX_NUM_TONES/2];
   uint32 ul_addr;
   int16* sa_TxToneOrder = (int16 *)(void *)&la_TxToneOrder[0];
   int16* sa_TxToneOrderTCM = (int16 *)(void *)&la_TxToneOrderTCM[0];

   // perform tone re-ordering when we have tcm on (this can be done in FG or BG)
   if ((( gl_SelectedMode & (MODE_ADSL2)  )) && gft_TcmFlag_bis_US) { // if ADSL2 and Trellis On
      // reorder to move 1 bit tones to the end
      ToneOrdering1BitTcm(gt_tx_config.psa_BAT, gsa_TxToneOrder, gs_TxNumTones, gs_TxNumLoadedTones, gus_Tx_Tcm_Num1bits, sa_TxToneOrderTCM);
      psa_tmp = sa_TxToneOrderTCM;
   } else {
      psa_tmp = gsa_TxToneOrder;
   }

   // note that the direction bit of TX ping-pong buffers is set from tone 0 to 63
   // higher tones are not considered as TX tones, therefore no need to be cleared

   s_MaxNumTones = gs_TxFftLength >> 1;
   s_InNumTones = gs_TxNumTones;
   s_OutNumTones = s_MaxNumTones - s_InNumTones;

   for (i=0;i<s_OutNumTones;i++)
      sa_TxToneOrder[i] = i+gs_TxNumTones;

   // take care of outband tones
   ul_addr = GetPingPongTableAddress(TX_TRT, guc_TxQtInactiveTblSeg);
   WriteCoreBuf32(ul_addr, sa_TxToneOrder, (uint16)(s_OutNumTones >> 1));

   // write TRT
   ul_addr += (s_OutNumTones >> 1)*4;
   WriteCoreBuf32(ul_addr, psa_tmp, (uint16)(s_InNumTones >> 1));
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadTxExtendedGainTable(void)
*
*  This function loads TX extended gain Table (EGT).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void LoadTxExtendedGainTable(void)
{
    int16 i;
    uint32 ul_addr;
    int16  s_MaxNumTones, s_InNumTones, s_OutNumTones;
   uint32 pla_egt[TX_NUM_TONES/4];
    uint8* puca_egt_array = (uint8 *)(void *)&pla_egt[0];

    s_MaxNumTones = gs_TxFftLength >> 1;
    s_InNumTones = gs_TxNumTones;
    s_OutNumTones = s_MaxNumTones - s_InNumTones;


    //zero out local array
    memset(puca_egt_array, 0, TX_NUM_TONES);

    // set EGT tables
   ul_addr = GetPingPongTableAddress(TX_EGT, guc_TxQtInactiveTblSeg);


    for (i=0; i<s_InNumTones; i++)
    {
        //fill in TX tone bit
        puca_egt_array[i] = 0x10;

      if(gl_SelectedMode & (MODE_ADSL2)) {
         //fill in NSSi
         if ( !IS_TONEFLAGSET(gp_SUPPORTEDset_US, i) )
            puca_egt_array[i] |= 1;
         //blackout tone is handled in FW
      }
    }

   WriteCoreBuf32(ul_addr,(int16 *)(void *)puca_egt_array, (uint16)(gs_TxNumTones>>2));

}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadRxExtendedGainTable(void)
*
*  This function loads RX extended gain Table (EGT).
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
C_SCOPE void LoadRxExtendedGainTable(void)
{
    uint32 ul_addr;

   uint32 pla_egt[(RX_NUM_TONES)/4 ];
   uint8 uc_data;
   uint8* puca_egt_array = (uint8 *)(void *)&pla_egt[0];
   //copy the extended gain to segment used by rx in EGT
   //assign the correct number of tones as TX, based on decision taken to put gus_Rx_MinToneindex

    ul_addr = GetPingPongTableAddress(RX_EGT, guc_RxQtInactiveTblSeg);

   uc_data = (MASK_BIT4|MASK_BIT3);

   memset(puca_egt_array, 0, gs_RxNumTones);

   memset(puca_egt_array, uc_data, gus_Rx_MinToneIndx );


    WriteCoreBuf32(ul_addr,(int16 *)(void *)puca_egt_array, (uint16)((gus_Rx_MinToneIndx+3)>>2));

}
