/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "cmv.h"
#include "pll.h"
#include "acc40.h"
//=========================================================
// Global variables
//=========================================================
int16 gs_RxToneOffset=0;
//=========================================================
// Static variables
//=========================================================

//=========================================================
// Local functions
//=========================================================

#ifndef TARGET_HW
/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    ReverbSegueDetectorDisable
 *
 * Prototype:
 *    void ReverbSegueDetectorDisable(void);
 *
 *  Abstract:
 *    ReverbSegueDetectorDisable() -
 *
 *    This function disables the h/w reverb segue detector
 *
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
void ReverbSegueDetectorDisable(void)
{
//Empty function
}

#endif

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Disable_IFFT_Reordering
 *
 * Prototype:
 *    void Disable_IFFT_Reordering(void);
 *
 *  Abstract:
 *    Disable_IFFT_Reordering() -
 *
 *       IFFT strymon connection always uses bit reversed addressing.
 *       The Disable_IFFT_Reordering actually does a second reordering
 *       on the read into SW memory that reverses the bit reversed addressing
 *       and results in a time-sequence read of the data.
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */

void Disable_IFFT_Reordering(void)
{
//empty function for adsl_62
}


void Disable_IFFT(void)
{
    //FT_TX_CTRL and FT_TX_CTRL register
   ResetCoreReg((uint32)IRI_FT_REG_TX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

    //FT_TX_CTRL_A and FT_TX_CTRL register
   ResetCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

    //Disable IFFT_Reordering at QT interface
    SetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT17);
}

void Disable_FFT(void)
{
    // write inactive register
    ResetCoreReg((uint32)IRI_FT_REG_RX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

   //Disable FFT - write to active register
    ResetCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

    //Disable FFT Reordering at strymon interface
    SetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT7);
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Enable_IFFT_Reordering
 *
 * Prototype:
 *    void Enable_IFFT_Reordering(void);
 *
 *  Abstract:
 *    Enable_IFFT_Reordering() -
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */

void Enable_IFFT_Reordering(void)
{
//empty function for adsl_62
}

void Enable_IFFT(void)
{
    //FT_TX_CTRL and FT_TX_CTRL register
   SetCoreReg((uint32)IRI_FT_REG_TX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

    //FT_TX_CTRL_A and FT_TX_CTRL register
   SetCoreReg((uint32)IRI_FT_REG_TX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

    //Enable IFFT_Reordering at QT interface
    ResetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT17);
}


void Enable_FFT(void)
{
    //Enable FFT
    SetCoreReg((uint32)IRI_FT_REG_RX_CTRL_ADDR, MASK_BIT0|MASK_BIT1);

    //Enable FFT
    SetCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, MASK_BIT0|MASK_BIT1);

    //Enable FFT Reordering at strymon interface
    ResetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT7);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype:  ConfigRTVBuf0_train(void)
*
*  This function configures RTV buffer 0 to store FFT/ERR/SFDQ output.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigRTVBuf0_train(void)
{
   uint32 ul_tmpWord;

   ul_tmpWord =  (gs_RtvSelect << 25)              // Write output to RTV buffer 0
            |  gs_RxToneOffset                  // Init offset for RTV buffer 0 to 0
               | (1<<31); // Enable RTV capture
    if(gs_RtvSelect == ERROR_OUTPUT)
      ul_tmpWord |= (1<<28);        // Disable tone rotation

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

   //Cnt is written in the following register, moved from the above reg
   ul_tmpWord = gs_RxNumTones-1;
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));

}


/*
*-------------------------------------------------------------------------------
*
*  Prototype:  ConfigRTVBuf0_train_Accum(void)
*
*  This function configures RTV buffer 0 to accumulate power data.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigRTVBuf0_train_Accum(void)
{
   uint32 ul_tmpWord;


   SaveRtvCaptureModeSetting();

   ul_tmpWord =  (gs_RtvSelect << 25)              // Write output to RTV buffer 0
            |  gs_RxToneOffset                  // Init offset for RTV buffer 0 to 0
               | (0<<31)         // DO not Enable RTV capture
            | (1<<28);        // Disable tone rotation

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

   ul_tmpWord = gs_RxNumTones-1;
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Enable IR_NPR_ACCUM, also put NP_SHIFT to be 10, to match with software noiseacc() function
   ul_tmpWord = (uint32)(1<<22) | (uint32)(2<<24);
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_tmpWord);

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));

}

#ifdef HW_REIM_ACCUM
/*
*-------------------------------------------------------------------------------
*
*  Prototype:  ConfigRTVBuf0_ReIm_Accum(void)
*
*  This function configures RTV buffer 0 to accumulate ReIm.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ConfigRTVBuf0_ReIm_Accum(void)
{
   uint32 ul_tmpWord;


   SaveRtvCaptureModeSetting();

   ul_tmpWord =  (gs_RtvSelect << 25)              // Write output to RTV buffer 0
            |  gs_RxToneOffset                  // Init offset for RTV buffer 0 to 0
               | (0<<31)         // DO not Enable RTV capture
            | (1<<28);        // Disable tone rotation
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_tmpWord);

    //Cnt is written in the following register, moved from the above reg
    ul_tmpWord = (gs_RxNumTones-1);
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_tmpWord);

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Enable ReIm accum
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (MASK_BIT22|MASK_BIT23));

   //Disable RTV1
   ResetCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, (1<<31));
}

#endif //HW_REIM_ACCUM


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void TriggerVectorPower(void)
*
*  This sets the VectorPower block for calculating the power of the FFT output
*   in the RD_RNG0
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
// For Vector Power
void TriggerVectorPower(void)
{
   uint32 ul_data;


    SaveRtvCaptureModeSetting();

   //Disable IR_REIM_ACCUM, IR_NPR_ACCUM and VECPOW_ACCUM
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x7<<21));

   //Enable VECPOW_ACCUM
   SetCoreReg(IRI_QT_REG_RX_MISC_ADDR, (uint32)(0x1<<21));

   ul_data = (1<<28)                         //disable rotation
         | (SFDQ_OUTPUT<<25)                    //RAW FFT
         | (0<<31);;                      // Tone Start

   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, ul_data);
    //Cnt is written in the following register, moved from the above reg
    ul_data = gs_RxNumTones-1;
    WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, ul_data);

   //Clear the vector accumulation register
   WriteCoreReg((uint32)IRI_QT_REG_RX_VECPOW_L_ADDR,0);
   WriteCoreReg((uint32)IRI_QT_REG_RX_VECPOW_H_ADDR,0);
}


void SaveRtvCaptureModeSetting(void)
{
   // Save RTV0 and MISC registers
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, &gul_FD_RNG0Shadow);
   ReadCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, &gul_FD_RNG0CNTShadow);
   ReadCoreReg(IRI_QT_REG_RX_MISC_ADDR, &gul_RX_MISC_Shadow);
}

void RestoreRtvCaptureModeSetting(void)
{
   //Restore the previous register value
   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, gul_RX_MISC_Shadow);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_ADDR, gul_FD_RNG0Shadow);
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG0_CNT_35B_ADDR, gul_FD_RNG0CNTShadow);
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ReadVectorPower(int16 s_GuardBits)
*
*  This reads and combines the Low and High words of the Vector Power and divides by 2^13.
*   The average power is added to gl_Pa.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void ReadVectorPower(void)
{
   uint32 pul_word[2];
   int32 acc_Lo, acc_Hi;

   ReadCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR, &pul_word[0]);
   ReadCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR, &pul_word[1]);

   // compute the average signal power; divide by total # of samples in a frame
   // (an extra 1 rsh is to match to that done in BgDDRxPowerCalc()

   acc_Hi = (int32) (pul_word[1]<<16)| (pul_word[0]>>16);
   acc_Lo = (int32) (pul_word[0] & 0xFFFF);

   gl_Pa_VecPow  += round_acc40(acc_Hi, acc_Lo, (int16)gs_NPR_GuardBits);

   //reset VECPOW register
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR, 0);
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR, 0);

}

#ifndef TARGET_HW
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WhichIFFTBuffers(uint32 *pul_IFFTInputBuffer,
*     uint32 *pul_IFFTOutputBuffer)
*
*  This function identifies which IFFT input/output buffers can be used by DSP.
*
*  Input Arguments:
*
*  Output Arguments:
*     pul_FFTInputBuffer: pointer to the input IFFT buffer prior to
*        running the IFFT. This input buffer contains frequency domain data.
*     pul_FFTOutputBuffer: pointer to the output IFFT buffer after
*        running the IFFT. This output buffer contains time domain data.

  In BM6.1, input buffer and output buffer are the same as FFT / IFFT use in-place computation
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WhichIFFTBuffers(uint32 *pul_IFFTInputBuffer, uint32 *pul_IFFTOutputBuffer)
{
   uint32 ul_TxBufferStat,  ul_TxIFFTInputBuffer;

   // Determine the Tx Strymon buffer status

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_TxBufferStat);
   ul_TxIFFTInputBuffer = (ul_TxBufferStat & IRI_FTB_REG_TX_IFFT_BUF_STAT_MASK)>>3;

   switch(ul_TxIFFTInputBuffer)
   {
    case 0:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
        *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_A_ADDR;
      break;

    case 1:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
        *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_B_ADDR;
      break;

    case 2:
      *pul_IFFTInputBuffer = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
        *pul_IFFTOutputBuffer = (uint32)IRI_FTB_IFFT_RAM_C_ADDR;
      break;
   }

}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WhichFFTBuffers(uint32 *pul_FFTInputBuffer,
*     uint32 *pul_FFTOutputBuffer)
*
*  This function identifies which FFT input/output buffers can be used by DSP.
*
*  Input Arguments:
*
*  Output Arguments:
*     pul_FFTInputBuffer: pointer to the input FFT buffer prior to
*        running the FFT. This input buffer contains time domain data.
*     pul_FFTOutputBuffer: pointer to the output FFT buffer after
*        running the FFT. This output buffer contains frequency domain data.

  In BM6.1, input buffer and output buffer are the same as FFT / IFFT use in-place computation

*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WhichFFTBuffers(uint32 *pul_FFTInputBuffer, uint32 *pul_FFTOutputBuffer)
{
   uint32 ul_RxBufferStat, ul_RxFFTOutputBuffer;


   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_RxBufferStat);

   ul_RxFFTOutputBuffer = (ul_RxBufferStat & IRI_FTB_REG_RX_FFT_BUF_STAT_MASK)>>3;

   switch(ul_RxFFTOutputBuffer)
   {
    case 0:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
        *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
      break;

    case 1:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
        *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
      break;

    case 2:
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
        *pul_FFTOutputBuffer = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
      break;
   }


}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void WhichFFTBuffers2(uint32 *pul_FFTInputBuffer,
*     uint32 *pul_FFTOutputBuffer)
*
*  This function identifies which FFT input buffers can be access by DSP
*   when FT engine is not triggered by buffer swap
*   In time domain process, FT is disabled when we access the fft input buffer.
*   Accroding to the spec: When the FT is processing, the FT buffer pointer indicates
*   the buffer currently being accessed by the Rx FT. When the FT is idle,
*   the pointer indicates the buffer last accessed by the Rx FT. The pointer is updated on
*   the Rx IFFT go strobe
*
*
*  Input Arguments:
*
*  Output Arguments:
*     pul_FFTInputBuffer: pointer to the input FFT buffer prior to
*        running the FFT. This input buffer contains time domain data.
*     pul_FFTOutputBuffer: pointer to the output FFT buffer after
*        running the FFT. This output buffer contains frequency domain data.
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void WhichFFTBuffers2(uint32 *pul_FFTInputBuffer, uint32 *pul_FFTOutputBuffer)
{
   uint32 ul_RxBufferStat, ul_RxStrymonBuffer,  ul_RxFFTBufferIndex, ul_RxQTBufferIndex;

   // Determine the Rx Strymon buffer status
   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_RxBufferStat);
   ul_RxStrymonBuffer = (ul_RxBufferStat & IRI_FTB_REG_RX_STR_BUF_STAT_MASK) >> 6;


   // If Strymon is using FFT Buffer A, then the FFT output buffer is either C or B.
   // The FFT input buffer is always B.
   if (ul_RxStrymonBuffer == 0)
   {
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_B_ADDR;
        ul_RxFFTBufferIndex  =  1;
        ul_RxQTBufferIndex  =  2;
   }

   // If Strymon is using FFT Buffer B, then the FFT output buffer is either A or C.
   // The FFT input buffer is always C.
   else if (ul_RxStrymonBuffer == 1)
   {
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_C_ADDR;
        ul_RxFFTBufferIndex  =  2;
        ul_RxQTBufferIndex  =  0;
    }

   // If Strymon is using FFT Buffer C, then the FFT output buffer is either B or A.
   // The FFT input buffer is always A.
   else
   {
      *pul_FFTInputBuffer = (uint32)IRI_FTB_FFT_RAM_A_ADDR;
        ul_RxFFTBufferIndex  =  0;
        ul_RxQTBufferIndex  =  1;
   }
}

#endif //TARGET_HW

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    WhichCPBuffers
 *
 *  Abstract:
 *    This function identifies which Cyclic Prefix (CP) buffer can be used by
 *              the f/w
 *
 *  Returns:
 *
 *  Global Variables Used:
 *      None
 *------------------------------------------------------------------------
 */
#ifdef ISI_ANALYSIS_ON
void WhichCPBuffers(uint16 *buffer0, uint16 *buffer1)
{
//empty function for adsl_62
#endif

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Trigger_QAM
 *
 * Prototype:
 *    void Trigger_QAM(void);
 *
 *  Abstract:
 *    Triggers the QAM functionality in the Iridia core
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *------------------------------------------------------------------------
 */

void Trigger_QAM(void)
{
   //empty function for adsl_62
}

/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Disable_FFT_Reordering
 *
 * Prototype:
 *    void Disable_FFT_Reordering(void);
 *
 *  Abstract:
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */

void Disable_FFT_Reordering(void)
{
   SetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT3);
}
/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Enable_FFT_Reordering
 *
 * Prototype:
 *    void Enable_FFT_Reordering(void);
 *
 *  Abstract:
 *    Enable_FFT_Reordering() -
 *
 *  Returns:
 *    None
 *
 *  Global Variables Used:
 *
 *------------------------------------------------------------------------
 */

void Enable_FFT_Reordering(void)
{
   ResetCoreReg(IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT3);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Enable_MTE_Tx
 *
 *  Description:    Set the register/cascade tx path block settings for the
 *             showtime data (i.e. non sync frames)
 *
 *  Prototype:  void Enable_MTE_Tx(void)
 *
 *
 *  Input Arguments: None
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

void Enable_MTE_Tx()
{
   //empty function for ADSL_62
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Enable_MTE_TxDT
 *
 *  Description:    Set the register/cascade tx path block settings for the
 *             showtime data (i.e. non sync frames)
 *
 *  Prototype:  void Enable_MTE_TxDT(void)
 *
 *
 *  Input Arguments: None
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

void Enable_MTE_TxDT()
{
   //empty function for ADSL_62
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name: ChangeCapturedToneIdx
 *
 *  Description:  Change the index of the physical tone (to be captured in
 *             IR_PILOTR and IR_PILOTI registers after gain scaling)
 *             to that of the aux-pilot tone.
 *
 *  Prototype: void ChangeCapturedToneIdx(void)
 *
 *  Input Arguments: None
 *
 *  Output Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ChangeCapturedToneIdx(void)
{
   //empty function for adsl_62
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void EnableLatchPilot(void)
*
*  Enable latching of pilot tone at QT startup
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*-------------------------------------------------------------------------------
*/
void EnableLatchPilot(void)
{
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, gs_PilotToneIdx);
   SetCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, MASK_BIT13);
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DisableLatchPilot(void)
*
*  Enable latching of pilot tone at QT startup
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*-------------------------------------------------------------------------------
*/
void DisableLatchPilot(void)
{
   ResetCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, MASK_BIT13);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Enable_MTE_Rx
 *
 *  Description:    Dummy function for swengine compatibility
 *
 *  Prototype:  void Enable_MTE_Rx()
 *
 *
 *  Input Arguments: None
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */

void Enable_MTE_Rx()
{
}


/*
 *------------------------------------------------------------------------
 *
 *  Name:
 *    Trigger_EngineFFT
 *
 * Prototype:
 *    void Trigger_EngineFFT(void);
 *
 *  Abstract:
 *    Triggers the FFT execution in the Iridia core
 *
 *  Returns:
 *    None
 *------------------------------------------------------------------------
 */

void Trigger_EngineFFT(void)
{
   SetCoreReg(CRI_RX_FFT_CTL_ADDR, (uint32)REGISTER_START_RX_FFT_START);
}


#ifndef TARGET_HW
/****************************************************************************
; Name: UpdateTxParameters
;
; Prototype:
;  void UpdateTxParameters(void)
;
; Description:
;  Force immediate update of all of Iridia's Tx sampled registers.
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
void UpdateTxParameters(void)
{
   //empty function for ADSL_62
}



/****************************************************************************
; Name: UpdateRxParameters
;
; Prototype:
;  void UpdateRxParameters(void)
;
; Description:
;  Force immediate update of all of Iridia's Rx sampled registers.
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
void UpdateRxParameters(void)
{
   //empty function for ADSL_62
}

#endif //TARGET_HW


#define UNITY_FDQ_MANTISSA (0x4000)
#define UNITY_FDQ_EXPONENT (1)

/*****************************************************************************
;  Prototype:
;     void LoadFDQPilot(void)
;
;  Input Arguments: None
;  Output Arguments: None
;
;  Time Critical function to load the FDQ coefficients and their shifts from the values
;  computed during training to the values used in the actual FDQ
;
;  Global Variables:
;     Inputs:
;        gs_RxFirstChannel
;        gs_RxLastChannel
;        gsa_pre_FDQ_coef - FDQ coefficients computed during training
;        gsa_pre_FDQ_exp - shifts values for FDQ coefficients computed during training
;
;
;     Outputs:
;        gsa_FDQ_coef - FDQ coefficients used in the actual FDQ
;
;****************************************************************************/

void LoadFDQPilot(void)
{
   // write FDQ mantissa for pilot tone
   WriteCoreBuf32((uint32)(IRI_QT_RAM_FDQ_MANT_ADDR+4*gs_PilotToneIdx), &(gsa_pre_FDQ_coef[2*gs_PilotToneIdx]), 1);
      // write FDQ exponent for pilot tone
    WriteCoreBuf8((uint32)(IRI_QT_RAM_FDQ_EXP_ADDR + 4*gs_PilotToneIdx), &(guca_pre_FDQ_exp[gs_PilotToneIdx]), 1);

}

/*****************************************************************************
;  Prototype:
;     void DisableFDQ(void)
;
;  Input Arguments: None
;  Output Arguments: None
;
;  Time Critical function to disable/bypass the FDQ calculation on Rx data.
;  In this HW Engine this is done by loading Iridia's FDQ coefficient table with
;  mantissa and exponent values equivalent to a value of 1.0.
;  Note this has no effect on the task-layer array of FDQ coefficients.
;
;  Disabling FDQ is needed, e.g., for the Downstream Loop Attenuation calculation.

;  The format of the FDQ coefficient is:

;  Mantissa has fixed pt format [S0.FDQ_MANTISSA_FRAC_BITS]
;  Exponent has format S3.0.

;  Representation of 1.0 is:
;        mantissa = 0.5 = (1 << (FDQ_MANTISSA_FRAC_BITS - 1))
;        exponent = 1

;
;  Global Variables:
;     Inputs:
;        gs_RxFirstChannel
;        gs_RxLastChannel
;
;     Outputs:
;        gsa_FDQ_coef - FDQ coefficients used in the actual FDQ calculation
;
;****************************************************************************/

void DisableFDQ(void)
{
   int16 i, j, s_length;

   i = 0;
   j = gs_RxLastChannel;
   s_length = j - i + 1;

    // write FDQ mantissa for all tones (this is required as some places we look at upstream tones as well)
   FillCoreBuf32((uint32)IRI_QT_RAM_FDQ_MANT_ADDR, (uint32)UNITY_FDQ_MANTISSA, s_length);
   // write FDQ exponent for all tones
   FillCoreBuf32((uint32)IRI_QT_RAM_FDQ_EXP_ADDR,(uint32)UNITY_FDQ_EXPONENT, s_length);

   /* If DD Pilot is active, do not disable fdq on the pilot tone */
   if (gft_DDPilot == DD_PILOT_ON)
   {
      int16 s_save_PilotToneIdx = gs_PilotToneIdx;
      gs_PilotToneIdx = gs_CPilotTone;
      LoadFDQPilot();
      gs_PilotToneIdx = gs_AuxPilotToneIdx;
      LoadFDQPilot();
      gs_PilotToneIdx = s_save_PilotToneIdx;
   }

   gft_fdqState = FDQ_DISABLED;

}


#undef UNITY_FDQ_MANTISSA
#undef UNITY_FDQ_EXPONENT


