/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_Ini.C
 *
 *   Iridia Initialization functions
 *
 *
 *----------------------------------------------------------------------------
 */
//*******************************************************************
// IRI_Ini.c
//
// History
//
// 25/03/2013 Kannan:
//          1. Initialize the Uninitialized Iridia registers with their reset
//             values.
//             Grep for "XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues "
//*****************************************************************************

#include <string.h>
#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "iri_ini.h"

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitIridiaFT(void)
*
*  This function initializes Iridia FT core.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

extern uint8 guc_ftb_rx_qt, guc_ftb_tx_qt;

void InitIridiaFT(void)
{
   uint32 ul_data;

    // Clear FT_TX_CTRL register
   WriteCoreReg(IRI_FT_REG_TX_CTRL_ADDR, 0);
   WriteCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, 0);
   WriteCoreReg(IRI_FTB_CTRL_ADDR, 0);

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_data);
   guc_ftb_tx_qt = ul_data & 3;


   // Enable IFFT process and pre-processing
   SetCoreReg(IRI_FT_REG_TX_CTRL_ADDR, (MASK_BIT0|MASK_BIT1));
   SetCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, (MASK_BIT0|MASK_BIT1));

   //==========================================================================
   // TX path
   //==========================================================================

   // set mode, IFFT size, enable IFFT
   // Set IFFT transform size to 256 tones
   ReadCoreReg(IRI_FT_REG_TX_CTRL_ADDR, &ul_data);
   ul_data |=(2<<3); // IFFT size = 256,
   WriteCoreReg(IRI_FT_REG_TX_CTRL_ADDR, ul_data);

   //Following register need to be set using shadow register mechanism. this is temporary
   ReadCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, &ul_data);
   ul_data |=(2<<3); // IFFT size = 256
   WriteCoreReg(IRI_FT_REG_TX_CTRL_A_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_FT_REG_TX_CTRL = ul_data;

   SetUpTxIfftScaling();

   // clear FFT & IFFT overflow bit
   WriteCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, (uint32)(MASK_BIT3|MASK_BIT1));

   // clean IFFT buffers
   FillCoreBuf32(IRI_FTB_IFFT_RAM_A_ADDR, 0, IRI_FTB_IFFT_RAM_A_SIZE/4);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_B_ADDR, 0, IRI_FTB_IFFT_RAM_B_SIZE/4);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_C_ADDR, 0, IRI_FTB_IFFT_RAM_C_SIZE/4);

   //==========================================================================
   // RX path
   //==========================================================================

    // Clear FT_RX_CTRL register
   WriteCoreReg(IRI_FT_REG_RX_CTRL_ADDR, 0);
   WriteCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, 0);

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_data);
   guc_ftb_rx_qt = ul_data & 3;

   // Enable FFT process and post-processing
   SetCoreReg(IRI_FT_REG_RX_CTRL_ADDR, (MASK_BIT0|MASK_BIT1));
   SetCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, (MASK_BIT0|MASK_BIT1));


    //Following register need to be set using shadow register mechanism. this is temporary
   ReadCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, &ul_data);
    ul_data |=(2<<2); // FFT Tansform size = 256
   WriteCoreReg(IRI_FT_REG_RX_CTRL_A_ADDR, ul_data);

   // set FFT scaleback
   ul_data =
      ((uint32)0x0 << 0) // PP_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x1 << 2) // BP1_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x1 << 4) // BP2_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x1 << 6) // BP3_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x2 << 8) // BP4_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x0 << 10) // BP5_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
      | ((uint32)0x0 << 12); // BP6_SB: 0x0:off, 0x1:1/2, 0x2:1/4, 0x3:1/4
   gs_RxLog2FftScaling = 5;
   WriteCoreReg((uint32)IRI_FT_REG_RX_SCALE_ADDR, ul_data);


    //Iridia FTB
   //IFFT sizes for DSP, shadow IFFT buffers
    //Default setting is for 256 tones
   WriteCoreReg((uint32)IRI_FTB_IFFT_TSIZE_ADDR, 0x2222);
   gt_vrx5dfe_dsl_config.ul_FTB_IFFT_TSIZE = 0x2222;

   // FFT size in FTB CTRL
   ul_data=(2<<4);
    ul_data|= (MASK_BIT15|MASK_BIT8| MASK_BIT0); //tx fdf enable, rx fdf enable, TxFDFReadClear
   WriteCoreReg((uint32)IRI_FTB_CTRL_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_FTB_CTRL = ul_data;
   //Initialize TX Status register (to default value 010000001b: QT 1, FT 0, FDF 2)
   //(Note set it to 0 does not work for COCOMO)
   WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0081 | 0x124));

   //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
   WriteCoreReg(IRI_FTB_RX_STATUS_ADDR, (0x0080 | 0x124));
#ifndef TARGET_HW
   // Clear FT status register (write 1 to clear)
   WriteCoreReg(IRI_FT_REG_STATUS_ADDR, 0xF);


   //Initialize TX Status register (to default value 010000001b: QT 1, FT 0, FDF 2)
   //(Note set it to 0 does not work for COCOMO)
   WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0081 | 0x124));

   //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
   WriteCoreReg(IRI_FTB_RX_STATUS_ADDR, (0x0080 | 0x124));

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_data);
   guc_ftb_tx_qt = ul_data & 3;

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_data);
   guc_ftb_rx_qt = ul_data & 3;
#endif //TARGET_HW
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void InitIridiaQT(void)
*
*  This function initializes Iridia QT core.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void InitIridiaQT(void)
{
   int16 i;
   int16 sa_QamEncGainExponent[16] = {
      0,ENCGAINEXP1, ENCGAINEXP2, ENCGAINEXP3,
      ENCGAINEXP4, ENCGAINEXP5, ENCGAINEXP6, ENCGAINEXP7,
      ENCGAINEXP8, ENCGAINEXP9, ENCGAINEXP10, ENCGAINEXP11,
      ENCGAINEXP12, ENCGAINEXP13, ENCGAINEXP14, ENCGAINEXP15
   };
   int16 sa_QamDecGainExponent[16] = {
      0,DECGAINEXP1, DECGAINEXP2, DECGAINEXP3,
      DECGAINEXP4, DECGAINEXP5, DECGAINEXP6, DECGAINEXP7,
      DECGAINEXP8, DECGAINEXP9, DECGAINEXP10, DECGAINEXP11,
      DECGAINEXP12, DECGAINEXP13, DECGAINEXP14, DECGAINEXP15
   };

   uint32 ul_data;
   uint32 ula_QamGain[16];
   uint8 uc_port_num;


    //==========================================================================
   // Global registers
   //==========================================================================
    //Clock enable signals
   WriteCoreReg(IRI_QT_REG_RX_ENABLE_ADDR, 0x01);
   WriteCoreReg(IRI_QT_REG_TX_ENABLE_ADDR, 0x01);

    // Number of Rx Payload Subcarriers (NSC_RX)
   // MAX(NSC_TX, NSC_RX)
   // Program Nsc = 512 always, and keep this value even if RxNumTones is later
   // switched to 256.

   ul_data = (uint32)QT_I_CONFIG_I_NSC_256;
   WriteCoreReg((uint32)IRI_QT_REG_RX_NSC_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_QT_REG_RX_NSC = ul_data;
   /*
   //Observed some time link drop in 17.5kft BT loops, G.DMT TR067 test cases if we change QT global registers
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //Initialize with default values
   WriteCoreReg((uint32)IRI_QT_REG_RX_PRBS_CTRL_ADDR, (uint32)0x0);
   WriteCoreReg((uint32)IRI_QT_REG_RX_PRBS0_ADDR, (uint32)0x0);
   WriteCoreReg((uint32)IRI_QT_REG_RX_PRBS1_ADDR, (uint32)0x0);
   //I_ABGT_OFFSET
   WriteCoreReg((uint32)IRI_QT_REG_ABGT_OFFSET_ADDR, (uint32)0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   */
   //==========================================================================
   // QT TX path
   //==========================================================================

   // IT_CONFIG
   ul_data  =
      ((uint32)0x0 << 0)   // Num of TX payload subcarriers (N_sc) = 32
      | ((uint32)0x3 << 4) ; // Num of transmit tones (IFFT_size) = 512
   WriteCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_QT_REG_TX_CNFG = ul_data;

   /*
   //Already initialized through
   //"FillCoreBuf32((uint32)QT_TX_PRAM_ADDR, (uint32)0, QT_TX_PRAM_SIZE);"
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   ul_data = 0;
   WriteCoreReg((uint32)IRI_QT_REG_TX_TCM_CTRL_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
   //IT_ACT_ADDR
   WriteCoreReg((uint32)IRI_QT_REG_TX_ACTIVE_ADDR, ul_data);
   //IT_LP0_BITS
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP0_BITS_ADDR, ul_data);
   //IT_LP1_BITS
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP1_BITS_ADDR, ul_data);
   //IT_LP2_BITS
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP2_BITS_ADDR, ul_data);
   //IT_LP0_DUMMY
   WriteCoreReg((uint32)IRI_QT_REG_TX_DUMMY_ADDR, ul_data);
   //IT_LP0_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR, ul_data);
   //IT_LP1_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, ul_data);
   //IT_LP2_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP2_BIT_FIFO_ADDR, ul_data);
   //IT_PILOT
   WriteCoreReg((uint32)IRI_QT_REG_TX_PILOT_ADDR, ul_data);
   //IT_PTINDEX
   WriteCoreReg(IRI_QT_REG_TX_PTINDEX_ADDR, ul_data);    //disable TX pilot tone
   //IT_PRBS
   WriteCoreReg(IRI_QT_REG_TX_PRBS_ADDR, ul_data);
   //IT_PRBS_MISC
   WriteCoreReg(IRI_QT_REG_TX_PRBS_MISC_ADDR, ul_data);
   //IT_PRBS_POLY
   WriteCoreReg(IRI_QT_REG_TX_PRBS_POLY_ADDR, ul_data);
   //IT_PRBS_DATAx x=0,1,2,3,4,5,6,7
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA0_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA1_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA2_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA3_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA4_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA5_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA6_ADDR, ul_data);
   WriteCoreReg(IRI_QT_REG_TX_PRBS_DATA7_ADDR, ul_data);
   //IT_REF_GAIN
   WriteCoreReg(IRI_QT_REG_TX_REF_GAIN_ADDR, ul_data);
   //IT_NYQ_TONE_DATA
   WriteCoreReg(IRI_QT_REG_TX_NYQ_TONE_DATA_ADDR, ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   */

    // IT_TXCG_x, x=0,1,...,15
    // with x=[0,15] for tx Constellation gain and shift
   for (i=0;i<16;i++)
    {
//    ula_QamGain[i] = ((uint32) sa_QamEncGainExponent[i]<< 16) | gsa_QAMEncGainTab[i];
      ula_QamGain[i] = ((uint32) sa_QamEncGainExponent[i]<< 16 | 0x2000) ;
      WriteCoreReg((uint32)IRI_QT_REG_TX_CG0_ADDR + (i<<2), ula_QamGain[i]);
    }

   //IT_IFFZ_RNGx, x=0,1,2,...,5
   // enable Range 0 of tones to zero-out in IFFT buffer
   // During the initialization, zero out the whole band.
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG0_ADDR, 0 );
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG1_ADDR, 0 );
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG2_ADDR, 0 );
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG3_ADDR, 0 );
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG4_ADDR, 0 );
   WriteCoreReg( IRI_QT_REG_TX_IFFTZ_RNG5_ADDR, 0 );

    //IT_TONE0_DATA
   WriteCoreReg(IRI_QT_REG_TX_TONEZERO_ADDR, 0);

   //IT_DCI_CTRL
   WriteCoreReg(IRI_QT_REG_TX_DCI_CTRL_ADDR, (uint32) 0 ); //Disable Direct Copy to IFFT buffer.



   //==========================================================================
   // QT RX path
   //==========================================================================

   //IR_CONFIG
   WriteCoreReg(IRI_QT_REG_RX_CNFG_ADDR, 0);

   //IR_TCM_CTRL
   //disable TCM
   WriteCoreReg(IRI_QT_REG_RX_TCM_CTRL_ADDR, 0);


    //IR_MISC
   ul_data =  (0 << 30)    // disable dual FFT
            | (0 << 28)    // size of error of 16 bits
            | (0 << 26)    // accumulate every tone
            | (0 << 24)    // no shift of noise/vector power accumulation
            | (0 << 23)    // disable accumulation of Re and Im
            | (0 << 22)    // disable accumulation of power
            | (0 << 21)    // disable accumulation of vector power
            | (0 << 17)    // RX_LP_ORDER, always set to 0 in ADSL
            | (1 << 16)    // disable MFDQ
            | (1 << 15)    // disable use of bit-stuffer
            | (0 << 14)    // do not bypass SFDQ
            | (1 << 13)    // disable feed forward part of SFDQ
            | (1 << 12)    // disable gain scale calculation
            | (1 << 11)    // disable MFDQ feedback calculation
            | (1 << 6)     // disable TOT
            | (0 << 5);    // RX_INIT, always set to 0 for VDSL

   WriteCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);

   /*
   //Already initialized through
   //"FillCoreBuf32((uint32)QT_RX_PRAM_ADDR, (uint32)0, QT_RX_PRAM_SIZE);"
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   //IR_ACT_ADDR
   ul_data = 0;
   WriteCoreReg((uint32)IRI_QT_REG_RX_ACTIVE_ADDR, ul_data);
   //IR_LPx_BITS, x =  0, 1, 2
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP0_BITS_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP1_BITS_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP2_BITS_ADDR, ul_data);
   //IR_DUMMY
   WriteCoreReg((uint32)IRI_QT_REG_RX_DUMMY_ADDR, ul_data);
   //IR_LPx_BIT_FIFO, x = 0, 1, 2
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP2_BIT_FIFO_ADDR, ul_data);
   //IR_DEROT_MISC
   WriteCoreReg((uint32)IRI_QT_REG_RX_DPRBS_MISC_ADDR, ul_data);
   //IR_DEROT_POLY
   WriteCoreReg((uint32)IRI_QT_REG_RX_DPRBS_POLY_ADDR, ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   */

   //IR_FD_RNG0
   // IR_RTV0
   gs_RtvSelect = (int16) SFDQ_OUTPUT;
   ConfigRTVBuf0_train();

   //IR_FD_RNG1
   //disable RTV capture
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_ADDR, 0);

   //IR_FD_RNG1_BASE ????
   WriteCoreReg(IRI_QT_REG_RX_FD_RNG1_BASE_ADDR, 512);

   //IR_NPR_IIBRAM
   //(not write to IIBRAM)
   WriteCoreReg(IRI_QT_REG_RX_NPR_IIBRAM_ADDR, 0);

   //IR_QUAD0
   WriteCoreReg(IRI_QT_REG_RX_QUAD0_ADDR, 0);

   //IR_QUAD1
   WriteCoreReg(IRI_QT_REG_RX_QUAD1_ADDR, 0);

   //IR_SLOWDOWN
   WriteCoreReg(IRI_QT_REG_RX_SLOWDOWN_ADDR, 0);

   //IP_PTINDEX
   //disable pilot tone
   WriteCoreReg(IRI_QT_REG_RX_PTINDEX_ADDR, 0);

   //IR_PILOT
   WriteCoreReg(IRI_QT_REG_RX_PILOT_ADDR, 0);

   //IR_FDQADAPT
   //Disable FDQ adaptation
   WriteCoreReg(IRI_QT_REG_RX_FDQADAPT_ADDR, 0);

   //IR_VECTOR_L
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_L_ADDR, 0);

   //IR_VECTOR_H
   WriteCoreReg(IRI_QT_REG_RX_VECPOW_H_ADDR, 0);

   //IR_REMETRIC_CTL
   WriteCoreReg(IRI_QT_REG_RX_RMETRIC_CTL_ADDR, 0);

   //IR_REMETRIC_VAL
   WriteCoreReg(IRI_QT_REG_RX_RMETRIC_VAL_ADDR, 0);



   // IR_RXCG_x with x=[0,15] for rx Constellation gain and shift
   for (i=0;i<16;i++)
   {
      //       ula_QamGain[i] = ((uint32)sa_QamDecGainExponent[i] << 16) | gsa_QAMDecGainTab[i];
      ula_QamGain[i] = ((uint32)sa_QamDecGainExponent[i] << 16) | 0x2000;
      WriteCoreReg((uint32)IRI_QT_REG_RX_CG0_ADDR + (i<<2), ula_QamGain[i]);
   }


   //==========================================================================
   // QTP TX/RX path
   //==========================================================================
   //QTP_CONFIG
   WriteCoreReg(IRI_QTP_REG_CONFIG_ADDR, 0x4); //sizeof each table segment = 512 tones
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   //Some times observed link drop in 17.5kft BT loops, G.DMT TR067 test cases if we change QTP global registers
   /*
   WriteCoreReg((uint32)IRI_QTP_REG_STATUS_ADDR, 0x3); //Clear QTP Tx & Rx Processing Error
   ul_data = 0;
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA0_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA1_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA2_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA3_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA4_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA5_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA6_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_DATA7_ADDR, ul_data);
   */
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)


   //QTP_TX_CTRL
   WriteCoreReg(IRI_QTP_REG_TX_CTRL_ADDR, (gs_TxNumTones-1)<<2);//disable PRBS_GEN in QTP

   /*
   //Already initialized through
   //"FillCoreBuf32((uint32)QTP_TX_PRAM_ADDR, (uint32)0, QTP_TX_PRAM_SIZE)"
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   ul_data = 0;
   WriteCoreReg((uint32)IRI_QTP_REG_TXTC_CTRL_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TXTC_TOT_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TXTC_ACTIVE_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_POLY_ADDR, ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   */

   // QTP_RX_CTRL
   ul_data = ((uint32)0<<1 )                         // Disable PRBS in QTP
    | (((gs_RxNumTones-1) & 0x1FFF) << 2);          //MAX_RX_TONE
   WriteCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, ul_data);

   /*
   //Already initialized through
   //"   FillCoreBuf32((uint32)QTP_RX_PRAM_ADDR, (uint32)0, QTP_RX_PRAM_SIZE);"
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   ul_data = 0;
   WriteCoreReg((uint32)IRI_QTP_REG_RXTC_CTRL_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RXTC_TOT_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RXTC_ACTIVE_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RX_PRBS_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RX_PRBS_MISC_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RX_PRBS_POLY_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_QTP_REG_RX_PRBS_OFFSET_ADDR, ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   */
#if 0
    /* ==========================================================================
    QT/QTP TX PRBS
    ADSL uses software to genearte the Pseudo random sequences during training.
    The QTP (PRBS configurations) may be used later in showtime
    ===========================================================================*/
    //disable TOT in QTP CTRL register
   WriteCoreReg(IRI_QTP_REG_TXTC_CTRL_ADDR, (1<<5));//disable TOT in QTP

   // IT_PRBS and QTP_TX_PRBS state register
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_ADDR, (uint32)0x1FF); // initial PRBS LFSR state.
    WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_ADDR, (uint32)0x1FF); // initial PRBS LFSR state.

   // IT_PRBS_MISC and QTP_TX_PRBS_MISC
    // The default setup below is for reverb/segue/G.dmt medley
    // Need to notice ADSL cpe uses SW to generate reverb/segue sequence
   ul_data  =
      ((uint32)8 <<  4) // d[n] = d[n-4] xor d[n-9] -> LFSR length = 9-1 = 8
      | ((uint32)1 << 11) // Resets PRBS generator each frame.
      | ((uint32)0 << 12) // Skip 0 bits at end of each symbol.
      | ((uint32)0 << 16) // Pick PRBS output from tail of LFSR (adsl mode)
      | ((uint32)0 << 20) // 1 less than the modulo number (8) of tones for each tone set.
      | ((uint32)0 << 24) // PRBS scrambling when 2 bit PRBS output is "00"
      | ((uint32)1 << 26) // PRBS scrambling when 2 bit PRBS output is "01"
      | ((uint32)2 << 28) // PRBS scrambling when 2 bit PRBS output is "10"
      | ((uint32)3 << 30); // PRBS scrambling when 2 bit PRBS output is "11"
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_MISC_ADDR, ul_data);
    WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_MISC_ADDR, ul_data);

   // IT_PRBS_POLY and QTP_TX_PRBS_POLY
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_POLY_ADDR, (uint32)0x8); // d[n] = d[n-4] xor d[n-9]
    WriteCoreReg((uint32)IRI_QTP_REG_TX_PRBS_POLY_ADDR, (uint32)0x8); // d[n] = d[n-4] xor d[n-9]


    /* ==========================================================================
    QT/QTP RX PRBS
    ADSL uses software to genearte the Pseudo random sequences during training.
    The QTP (PRBS configurations) may be used later in showtime
    ===========================================================================*/
    // QTP_RXTC_CTRL
    WriteCoreReg(IRI_QTP_REG_RXTC_CTRL_ADDR, (1<<5)); //TRT bypass in QTP

   // QTP_RX_PRBS state
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_ADDR, (uint32)0x1FF); // Initial Rx PRBS state generator state
   // IR_PRBS state registers are in global registers
    WriteCoreReg(IRI_QT_REG_RX_PRBS0_ADDR, (uint32)0x1FF); // initial PRBS LFSR state in FD RNG0
   WriteCoreReg(IRI_QT_REG_RX_PRBS1_ADDR, (uint32)0x1FF); // initial PRBS LFSR state in FD RND1

    //IR_PRBS_CTRL
   WriteCoreReg(IRI_QT_REG_RX_PRBS_CTRL_ADDR, (uint32)0x3); //Latch RTV0 and RTV1

    // IR_DEROT_MISC
   ul_data =   ((uint32)8 << 0) // d[n] = d[n-4] xor d[n-9] -> LFSR length = 9-1 = 8
      | ((uint32)0 << 6) // Pick PRBS output from tail of LFSR (adsl mode)
      | ((uint32)0 << 7) // PRBS descrambling when 2 bit PRBS output is "00"
      | ((uint32)1 << 9) // PRBS descrambling when 2 bit PRBS output is "01"
      | ((uint32)2 << 11) // PRBS descrambling when 2 bit PRBS output is "10"
      | ((uint32)3 << 13); // PRBS descrambling when 2 bit PRBS output is "11"
    WriteCoreReg((uint32)IRI_QT_REG_RX_DPRBS_MISC_ADDR, ul_data);

    //QTP_PRBS_MISC
   ul_data = (8 <<  4)  // d[n] = d[n-4] xor d[n-9] -> LFSR length = 9-1 = 8
             | ( 1 << 10)  // Resets PRBS generator each frame.
            | ( 0 << 11);  // Skip 0 bits at end of each symbol.
    WriteCoreReg(IRI_QTP_REG_RX_PRBS_MISC_ADDR, ul_data);


   // IR_DEROT_POLY
   WriteCoreReg((uint32)IRI_QT_REG_RX_DPRBS_POLY_ADDR, (uint32)0x8); // d[n] = d[n-4] xor d[n-9]
   // QTP_RX_PRBS_POLY
   WriteCoreReg(IRI_QTP_REG_RX_PRBS_POLY_ADDR, (uint32)0x8); // d[n] = d[n-4] xor d[n-9]
#endif

   // Initialize pointers for TX side:
#define TX_PATH   (1)
#define RX_PATH   (0)

#ifdef TARGET_HW
   //In the ARC the bank select is used to provide the data which will be at the same address for each port.
   uc_port_num = 0;
#else
   // In cocomo - the BMs have two port memories which are at different addresses in the PC .
   //So we need to specify  0 for the PORT  when calling the BM functions
   uc_port_num = guc_ch_id;
#endif //TARGET_COCOMO


    ghpuca_TxBat_Active =     (uint8* )GetActiveBGTNTableAddress(TX_PATH, uc_port_num);
#if 0
   ghpsa_TxFineGains_Active = (uint16*)GetActiveBGTNTableAddress(TX_PATH, uc_port_num);
   ghpuca_TxExtGains_Active = (uint8*)GetActiveEGTTableAddress(uc_port_num);
   ghpsa_TxToneOrder_Active = (uint16*)GetActiveBGTNTableAddress(TX_PATH, uc_port_num);

   ghpuca_TxBat_Inactive = GetBitAllocationTableAddress(uc_port_num);
   ghpsa_TxFineGains_Inactive = GetGainScaleTableAddress(uc_port_num);
   ghpuca_TxExtGains_Inactive = GetExtendedGainTableAddress(uc_port_num);
   ghpsa_TxToneOrder_Inactive = GetToneReorderingTableAddress(uc_port_num);


   // Initialize pointers for RX side:
   ghpuca_RxBat_Active = (uint8*)GetActiveBGTNTableAddress(RX_PATH, uc_port_num);
   ghpsa_RxFineGains_Active = (uint16*)GetActiveBGTNTableAddress(RX_PATH, uc_port_num);
   ghpuca_RxExtGains_Active = (uint8*)GetSFDQExponentTableAddress(uc_port_num);
   ghpsa_RxToneOrder_Active = (uint16*)GetActiveBGTNTableAddress(RX_PATH,uc_port_num);

   ghpuca_RxBat_Inactive = GetBitAllocationTableAddress(uc_port_num);
   ghpsa_RxFineGains_Inactive = GetGainScaleTableAddress(uc_port_num);
   ghpuca_RxExtGains_Inactive = GetExtendedGainTableAddress(uc_port_num);
   ghpsa_RxToneOrder_Inactive = GetToneReorderingTableAddress(uc_port_num);

   // set pointers for other HW buffers
   ghpsa_SFDQMantissa = GetSFDQMantissaTableAddress(uc_port_num);
   ghpuca_SFDQExponet = GetSFDQExponentTableAddress(uc_port_num);
#endif
   //fill inactive tables
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_GAIN_SCALE_ADDR, (uint32)0x20002000, (uint16)((IRI_QT_RAM_INACTIVE_GAIN_SCALE_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_BAT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_BAT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_EGT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_EGT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_INACTIVE_TOT_ADDR, 0, (uint16)((IRI_QT_RAM_INACTIVE_TOT_SIZE>>2)>>guc_PortMode));

   //Clear active BGT tables
   FillCoreBuf32(IRI_QT_RAM_ACTIVE_BGTN_ADDR, 0, (uint16)((IRI_QT_RAM_ACTIVE_BGTN_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_TX_ACTIVE_EGT_ADDR, 0, (uint16)((IRI_QT_RAM_TX_ACTIVE_EGT_SIZE>>2)>>guc_PortMode));

   // Clear SFDQ mantissas
   FillCoreBuf32(IRI_QT_RAM_FDQ_MANT_ADDR, 0, (uint16)((IRI_QT_RAM_FDQ_MANT_SIZE>>2)>>guc_PortMode));
   FillCoreBuf32(IRI_QT_RAM_FDQ_EXP_ADDR, 0, (uint16)((IRI_QT_RAM_FDQ_EXP_SIZE>>2)>>guc_PortMode));

   // clear MFDQ feedback tone table
   FillCoreBuf32(IRI_QT_RAM_RX_FEEDBACK_TONE_ADDR, 0, IRI_QT_RAM_RX_FEEDBACK_TONE_SIZE/4);

   // clear MFDQ coefficient table
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE/4);
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE/4);
   FillCoreBuf32(IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ADDR, 0, IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE/4);

}

/***************************************************************************************
;  Subroutine Name: InitIridia()
;
;  Description:
;
;  Initializes Iridia registers and FDQ coefficients.
;  Most registers are set to their reset values.  Notably, both Tx and Rx are disabled.
;
;
;  Prototype:
;     void InitIridia()
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/


void InitIridia(void)
{

   // Clear Iridia-QT Tx/RxPram
   #define QT_TX_PRAM_ADDR  (IRI_QT_REG_TX_CNFG_ADDR)
   #define QT_TX_PRAM_SIZE  (64) //in long words
    #define QT_RX_PRAM_ADDR  (IRI_QT_REG_RX_CNFG_ADDR)
    #define QT_RX_PRAM_SIZE  (64) //in long words

   FillCoreBuf32((uint32)QT_TX_PRAM_ADDR, (uint32)0, QT_TX_PRAM_SIZE);
   FillCoreBuf32((uint32)QT_RX_PRAM_ADDR, (uint32)0, QT_RX_PRAM_SIZE);

   // Clear Iridia-QTP Tx/RxPram
   #define QTP_TX_PRAM_ADDR  (IRI_QTP_REG_TX_CTRL_ADDR)
    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START_END)
   #define QTP_TX_PRAM_SIZE  (8) //in long words
    #define QTP_RX_PRAM_ADDR  (IRI_QTP_REG_RX_CTRL_ADDR)
    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START_END)
    #define QTP_RX_PRAM_SIZE  (8) //in long words

   FillCoreBuf32((uint32)QTP_TX_PRAM_ADDR, (uint32)0, QTP_TX_PRAM_SIZE);
   FillCoreBuf32((uint32)QTP_RX_PRAM_ADDR, (uint32)0, QTP_RX_PRAM_SIZE);


   InitIridiaFT();
   InitIridiaQT();
}


/***************************************************************************************
;  Subroutine Name: void Enable_MTEtoDFE_TxRx()
;
;  Description:
;
;     enable Tx and Rx paths
;
;  Prototype:
;           void Enable_MTEtoDFE_TxRx()
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/

void Enable_MTEtoDFE_TxRx()
{
   // Enable Tx/Rx interface logic between Strymon and Iridia-FTB
   SetCoreReg((uint32)IRI_FTB_CTRL_ADDR, (uint32)MASK_BIT8|MASK_BIT0);
}


/****************************************************************************
; Name: SetAutoRxTimer
;
; Prototype:
;  void SetAutoRxTimer(uint16 timerdelay)
;
; Description:
;  sets the Rx timer to start at Rx frame start and decrement from timerdelay
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
void SetAutoRxTimer(uint16 timerdelay)
{
// not used in Hercules build
// RX timer is set in InitCRI()
}


/****************************************************************************
; Name: SetAutoTxTimer
;
; Prototype:
;  void SetAutoTxTimer(uint16 timerdelay)
;
; Description:
;  sets the Tx timer to start at Tx frame start and decrement from timerdelay
;
; Arguments:
;  None.
;
;  Return Value:
;  N/A
*****************************************************************************/
void SetAutoTxTimer(uint16 timerdelay)
{
// not used in Hercules build
// TX timer is set in InitCRI()
}

