/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   iri_overflow.c
 *
 *   CPE interface layer functions to read and clear the Iridia
 *    and Strymon overflow registers.
 *
 *
 *
 *----------------------------------------------------------------------------
 */

//#include "iridia.h"
#include "const.h"
#include "gdata.h"
#include "LL_Iof.h"
#include "memrymap.h"
#include "IRI_Iof.h"

//=========================================================
// Global variables
//=========================================================

//=========================================================
// Static variables
//=========================================================

//=========================================================
// Functions
//=========================================================

/****************************************************************************
; Name: ReadAndClearHWOverflow
;
; Prototype:
;  void ReadAndClearHWOverflow(uint16 clear_value)
;
; Description:
;  Read and reset overflow indicators for Iridia and Strymon processing.
;
; Output Arguments:
;  pus_IRI_Tx_Ovflw - Contents of Iridia's Tx overflow register
;  pus_IRI_Rx_Ovflw - Contents of Iridia's Rx overflow register
;  pus_STR_Ovflw -  Contents of Strymon's overflow register
;  Return Value:
;  N/A
*****************************************************************************/

#define IFFT_OVERFLOW      (2)      // To match corresponding bit (Butterfly 1) in variable for HWE3.x
#define PARR_OVERFLOW      (8)      // No respective bit in HWE3.x
#define TXGS_OVERFLOW      (0)      // To match corresponding bit in variable for HWE3.x

#define FFT_OVERFLOW    (2)      // To match corresponding bit (Butterfly 1) in variable for HWE3.x
#define RXGS_OVERFLOW      (0)      // To match corresponding bit in variable for HWE3.x
#define FFMAC_OVERFLOW     (1)      // To match ~corresponding (FDQ) bit in variable for HWE3.x
#define FBMAC_OVERFLOW     (1)

void ReadAndClearHWOverflow(uint16 *pus_IRI_Tx_Ovflw, uint16 *pus_IRI_Rx_Ovflw, uint16 *pus_STR_Ovflw)
{
   uint32 ul_data;

   ReadCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, &ul_data);
   *pus_IRI_Tx_Ovflw |= ((uint16)(ul_data >> 3) & 0x1) << IFFT_OVERFLOW; // IFFT overflow
    *pus_IRI_Rx_Ovflw |= ((uint16)(ul_data >> 1) & 0x1) << FFT_OVERFLOW; // FFT overflow
   SetCoreReg((uint32)IRI_FT_REG_STATUS_ADDR, (uint32)(MASK_BIT1|MASK_BIT3)); // write 1's to clear all bits

   ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
   *pus_IRI_Tx_Ovflw |= ((uint16)(ul_data >> 8) & 0x1) << TXGS_OVERFLOW; // TX GS overflow
   ResetCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, (uint32)MASK_BIT8); // write 0's to clear all bits

   ReadCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, &ul_data);
   *pus_IRI_Rx_Ovflw |= ((uint16)(ul_data >> 7) & 0x1) << RXGS_OVERFLOW; // RX GS overflow
   ResetCoreReg((uint32)IRI_QT_REG_RX_MISC_ADDR, (uint32)(MASK_BIT7)); // write 0's to clear all bits

   ReadCoreReg((uint32)V_OVERFLOW_ADDR, &ul_data);
   *pus_STR_Ovflw |= (uint16)ul_data;
   // also reset the hbf overflow indication bit- bit16- mahesh
   WriteCoreReg((uint32)V_OVERFLOW_ADDR, 0x1FFFF); // write 1's to clear all bits
}

#undef IFFT_OVERFLOW
#undef PARR_OVERFLOW
#undef TXGS_OVERFLOW
#undef FFT_OVERFLOW
#undef RXGS_OVERFLOW
#undef FFMAC_OVERFLOW
#undef FBMAC_OVERFLOW
