/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_sleep.C
 *
 *   Iridia functions used only during the sleep/test state.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "const.h"
#include "gdata.h"
#include "LL_Iof.h"
#include "memrymap.h"

 /***************************************************************************************
 ; Subroutine Name: SetFFTScaling()
 ;
 ; Description:
 ;
 ; Set Iridia FFT scaling register based on current value of
 ; gs_RxLog2FftScaling, which should be set to the desired number of scalebacks.
 ;
 ; Prototype:
 ;    void SetFFTScaling()
 ;
 ; Input Arguments:
 ;    none
 ;
 ; Return Value:
 ;    none
 ;
;**********************************************************************************************/

void SetFFTScaling(void)
{
#ifndef HERCULES_ADSL_CPE
   int16 s_RegisterSettingsForNScalebacks[10] = {
      // Stages chosen for scalebacks
      // may not be optimal in terms of minimizing quantization noise.
         0x0000, // No scalebacks
         0x0010,  // 1 scaleback
         0x0014,
         0x0054,
         0x0055,
         0x00d5, // 5 scalebacks (same settings as modem code).
         0x00d7, // 6 scalebacks
         0x00f7,
         0x00ff,
         0x01ff   // 9 scalebacks
   };

   if (gs_RxLog2FftScaling > 9)
      gs_RxLog2FftScaling = 9;
   if (gs_RxLog2FftScaling < 0)
      gs_RxLog2FftScaling = 0;

   WriteCoreReg(IRI_REG_IR_SCALE_ADDR, s_RegisterSettingsForNScalebacks[gs_RxLog2FftScaling]);
#endif // HERCULES_ADSL_CPE
}

 /***************************************************************************************
 ; Subroutine Name: SetIFFTScaling()
 ;
 ; Description:
 ;
 ; Set Iridia IFFT scaling register based on current value of
 ; gs_TxLog2FftScaling, which should be set to the desired number of scalebacks.
 ;
 ; Prototype:
 ;    void SetIFFTScaling()
 ;
 ; Input Arguments:
 ;    none
 ;
 ; Return Value:
 ;    none
 ;
;**********************************************************************************************/

void SetIFFTScaling(void)
{
#ifndef HERCULES_ADSL_CPE
   int16 s_RegisterSettingsForNScalebacks[8] = {
      // Stages chosen for scalebacks
      // may not be optimal in terms of minimizing quantization noise.
         0x0000,     // No scalebacks
         0x0002,  // 1 scaleback
         0x000a,
         0x002a,
         0x002b,  // 4 scalebacks (same settings as modem code).
         0x002f, // 5 scalebacks
         0x003f, // 6 scalebacks
         0x007f,
   };

   if (gs_TxLog2FftScaling > 7)
      gs_TxLog2FftScaling = 7;
   if (gs_TxLog2FftScaling < 0)
      gs_TxLog2FftScaling = 0;

   WriteCoreReg(IRI_REG_IT_SCALE_ADDR, s_RegisterSettingsForNScalebacks[gs_TxLog2FftScaling]);
#endif // HERCULES_ADSL_CPE
}

