/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_IOf.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "DSLEngin.h"


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : AdjustAlignmentForward
 *
 *  Description:    Adjusts the Alignment forward by gs_AlignmentOffset samples
 *
 *  Prototype:  void AdjustAlignmentForward(void)
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *    gs_AlignmentOffset - the number of samples to move forward
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

C_SCOPE void AdjustAlignmentForward(void)
{
    uint32 ul_RxFftRate;
    ul_RxFftRate = (gs_RxLog2FftLength1-6)<<16; //FFT_RATE<<16
   // set to gs_AlignmentOffset in TD samples
   WriteCoreReg((uint32)V_RX_FSIZE_ADDR, (uint32)(gs_RxSamplesPerFrame + gs_AlignmentOffset)|ul_RxFftRate);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name :  MedleyAdjustAlignment
 *
 *  Description:
 *       Used to adjust frame alignment.  Assumes that cyclic prefix is being inserted.
 *
 *  Prototype:  void MedleyAdjustAlignment(void)
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *    gs_AlignmentOffset - Desired shift in alignment.
 *
 *  Notes:
 *    1) It is expected that the adjustment is less than half a frame, i.e. that gs_AlignmentOffset is in the range:
 *    -(gs_RxSamplesPerFrame + gs_RxCPLength)/2 <= gs_AlignmentOffset <= (gs_RxSamplesPerFrame + gs_RxCPLength)/2
 *
 *    If gs_AlignmentOffset is in the range
 *          -(gs_RxSamplesPerFrame + gs_RxCPLength)/2 <= gs_AlignmentOffset < -gs_RxCPLength
 *
 *    then a Rx frame will be discarded, and the calling function should take that into account.
 *--------------------------------------------------------------------------------------------------
 *^^^
 */
C_SCOPE void MedleyAdjustAlignment(void)
{
   uint32 ul_RxFftRate;
    ul_RxFftRate = (gs_RxLog2FftLength1-6)<<16; //FFT_RATE<<16

    gs_CumulativeAlignmentOffset += gs_AlignmentOffset;

   // if gs_AlignmentOffset is negative, we can shorten # frames per sample
   WriteCoreReg((uint32)V_RX_FSIZE_ADDR, (uint32)(gs_RxSamplesPerFrame + gs_AlignmentOffset)|ul_RxFftRate);
}

/***************************************************************************************
;  Subroutine Name: ResetRxAlign
;
;  Description:
;     This routine resets the Iridia to normal operation following adjustment
;     of the synch point.  Must be called on the frame immediately after synch
;       adjust.
;
;  Prototype:
;     void ResetRxAlign()
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
C_SCOPE void ResetRxAlign()
{

    uint32 ul_RxFftRate;
    ul_RxFftRate = (gs_RxLog2FftLength1-6)<<16; //FFT_RATE<<16


   // restore to Rx frame size in TD samples
   WriteCoreReg((uint32)V_RX_FSIZE_ADDR, (uint32)gs_RxSamplesPerFrame|ul_RxFftRate);

   /* reset alignment offset */
   gs_AlignmentOffset = 0;
}
