/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cri_iof.c
 *
 *   Clock, Reset, Interrupt (CRI) block core interface functions
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "LL_IOf.h"
#include "gdata.h"
#include "cri_memmap.h"
#include "mtkernel.h"
#include "memrymap.h"
#include "STR_IOf.h"
#include "STR_Ini.h"
//#include "dsp_op.h"
//#include "cmv.h"
//#include "cmv_Data.h"
#include "cri_iof.h"
extern FlagT gft_stallcontroldisable;

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void Reconfig_CRI(void)
*
*  This function reconfigures CRI (called at the end of GHS)
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

// This function should be called at the end of G.hs
C_SCOPE void Reconfig_CRI(void)
{
   uint32 ul_data;

   //Disable TX/RX timer
   WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, 0);

   //Clear TX/RX timer
   WriteCoreReg(CRI_TX_TIMER_ADDR, 0);
   WriteCoreReg(CRI_RX_TIMER_ADDR, 0);

   //Enable TX timer counter
   #define TX_TIM_RLVR     (0)   //set roll over on TX buffer swap
   #define TX_TIM_ENB      (1) //Enable TX timer counter
   #define TX_TIM_START (1) //Start timer at the first rollover

   WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, (TX_TIM_RLVR<<21)|(TX_TIM_ENB<<20)|(TX_TIM_START<<28));

   // Enable RX timer counter and set roll over on RX buffer swap
   #define RX_TIM_RLVR     (0)   //set roll over on TX buffer swap
   #define RX_TIM_ENB      (1) //Enable TX timer counter
   #define RX_TIM_START (1) //Start timer at the first rollover

   WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, (RX_TIM_RLVR<<21)|(RX_TIM_ENB<<20)|(RX_TIM_START<<28));

#define TX_QTP_TS_PORT0_4K (0)
#define TX_PMS_TS_PORT0_4K (0)
#define TX_QT_TS_PORT0_4K  (1)
#define TX_IFFT_TS_PORT0_4K   (0x1F)   //inactive
#define TX_PAR_TS_PORT0_4K (0x1F)   //inactive
#define TX_DSP_TS_PORT0_4K (3)

      WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, (TX_QTP_TS_PORT0_4K    |(TX_PMS_TS_PORT0_4K<<5)|
                                 (TX_QT_TS_PORT0_4K<<10)|(TX_IFFT_TS_PORT0_4K<<15)|
                                 (TX_PAR_TS_PORT0_4K<<20)|(TX_DSP_TS_PORT0_4K<<25)));
#define RX_QTP_TS_PORT0_4K (1)
#define RX_FFT_TS_PORT0_4K (0x1F)   //inactive
#define RX_QT_TS_PORT0_4K  (2)
#define RX_PMS_TS_PORT0_4K (0)
#define RX_DSP_TS_PORT0_4K (3)

      WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ((RX_QTP_TS_PORT0_4K<<0)|(RX_FFT_TS_PORT0_4K<<5)|
                                 (RX_QT_TS_PORT0_4K<<10)|(RX_PMS_TS_PORT0_4K<<15)|(RX_DSP_TS_PORT0_4K<<25)));
   //Configure TX PMS
   //It has been disabled in InitCRI() and will be enabled (and configured) EnableTxPms() later;

   //Configure TX QTP to tx time-slot start
   //TX_QTP_REG_START = 0
   //TX_QTP_START_SEL = 4
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, TX_TSC_START_TX_QTP_SEL);

   //Configure TX QT to tx time-slot start
   //TX_QT_REG_START = 0
   //TX_QT_START_SEL = 4
   WriteCoreReg(CRI_TX_QT_CTL_ADDR,  TX_TSC_START_TX_QT_SEL);

   //Program IFFT to be triggered by timer-based method
   //TX_IFFT_REG_START = 0
   //TX_IFFT_START_SEL = 2 (timer-based)
   //TX_IFFT_GO_CNT = Predefined timer
   if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_IFFT)
      WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   else
      WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (uint32)(TX_TIMER_START_TX_IFFT_SEL|TX_IFFT_START_TIMER_4K));

   //Program FFT to be triggered by the RX buffer-swap
   if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_FFT)
   {
      //Configure RX FFT to disabled
      WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   }
   else
   {
      //Configure RX FFT to rx buffer swap
      WriteCoreReg(CRI_RX_FFT_CTL_ADDR, RX_BUFFER_SWAP_START_RX_FFT_SEL);
   }

   //Configure RX QT to rx time-slot start
   //RX_QT_REG_START = 0
   //RX_QT_START_SEL = 4
   if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_RXQT)
      WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   else
      WriteCoreReg(CRI_RX_QT_CTL_ADDR, ( RX_TSC_START_RX_QT_SEL));

   //Configure RX QTP to rx time-slot start
   //RX_QTP_REG_START = 0
   //RX_QTP_START_SEL = 4
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, ( RX_TSC_START_RX_QTP_SEL));

   //Configure RX PMS
   //It is disabled in InitCRI() and will be enabled (and configured) in EnableRxPms() later

   //First reset QT stall registers to the power-on state
   WriteCoreReg(CRI_TX_QT_STALL_ADDR, 0xE0000);
   WriteCoreReg(CRI_RX_QT_STALL_ADDR, 0xE0000);

   //Configure QT_STALL register and enable it

   #define QT_STALL_ENA (1) //enable QT stall
   WriteCoreReg(CRI_TX_QT_STALL_ADDR, (QT_STALL_ENA<<16));
   WriteCoreReg(CRI_RX_QT_STALL_ADDR, (QT_STALL_ENA<<16));

   //By doing this, clear CRI_TSC_STATUS_ADDR register
   //(Note: this reset must be done, otherwise the 30a fdconn COCOMO test won't work)
   ResetCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_ENABLE<<31));

   //Reconfigure the time slot control (2 slots per frame)
   ul_data = (CRI_TSC_CTRL_NUM_TS_4K)|((CRI_TSC_CTRL_NUM_CLKS-1)<<5)|(CRI_TSC_CTRL_CLKS_LAST<<22)|
         (CRI_TSC_CTRL_ENABLE<<31);
   WriteCoreReg(CRI_TSC_CTRL_ADDR, ul_data);


} //Reconfig_CRI()

