/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   Reconfig_fft.C
 *
 *
 *
 *----------------------------------------------------------------------------
 */
//*******************************************************************
// Reconfig_fft.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
//*****************************************************************************

//#include "iridia_dsp_interface.h"
#include "const.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "cmv.h"
#include "iri_ini.h"
#include "LL_Iof.h"
#include "memrymap.h"
#include "IRI_Iof.h"
#include "ft_memmap.h"


/****************************************************************************
; Name: Reconfig_RxFftLength
;
; Prototype:
;  void Reconfig_RxFftLength(void)
;
; Description:
;  This function is used in the HWE engine to set the rx fft length
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
*****************************************************************************/

C_SCOPE void Reconfig_RxFftLength(int16 s_FftLength)
{
   uint32 ul_data;


   // set FT_RX_CTRL_A register
   ReadCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, &ul_data);
   ul_data &= ~((uint32)FT_RX_CTRL_FFT_TSIZE_MASK);
   if (s_FftLength == 1024)
      ul_data |= (uint32)FT_RX_CTRL_FFT_TSIZE_512;
   else
      ul_data |= (uint32)FT_RX_CTRL_FFT_TSIZE_256;
   WriteCoreReg((uint32)IRI_FT_REG_RX_CTRL_A_ADDR, ul_data);
   WriteCoreReg((uint32)IRI_FT_REG_RX_CTRL_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_FT_REG_RX_CTRL = ul_data;

    //set FTB_CTRL register
    ReadCoreReg(IRI_FTB_CTRL_ADDR, &ul_data);
    ul_data &=~((uint32) FTB_RX_CTRL_FFT_TSIZE_MASK);
    if (s_FftLength == 1024)
        ul_data |= (uint32)(3<<4);  //FFT_TSIZE = 512
    else
        ul_data |= (uint32)(2<<4);   //FFT_TSIZE = 256
    WriteCoreReg((uint32)IRI_FTB_CTRL_ADDR, ul_data);
    gt_vrx5dfe_dsl_config.ul_FTB_CTRL = ul_data;
}


/****************************************************************************
; Name: Reconfig_IRI
;
; Prototype:
;  void Reconfig_IRI(void)
;
; Description:
;  This function is used in the HWE engine to reconfigure Iridia based on
;  new IFFT and FFT lengths
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
*****************************************************************************/


C_SCOPE void Reconfig_IRI(void)
{
    uint32 ul_data;

    //QT IR_CONFIG register, NSC_RX bits

    if (gs_RxNumTones == 256)
       ul_data =  (uint32)QT_I_CONFIG_I_NSC_256;
    else
       ul_data =  (uint32)QT_I_CONFIG_I_NSC_512;
    WriteCoreReg((uint32)IRI_QT_REG_RX_NSC_ADDR, ul_data);
    gt_vrx5dfe_dsl_config.ul_QT_REG_RX_NSC = ul_data;

    /*reconfig the number of tones to store in IR_FD_RNG0.RTV_cnt */
    gs_RtvSelect = (int16) SFDQ_OUTPUT;
    ConfigRTVBuf0_train();

    /* configure fft length based on recently found value */
   Reconfig_RxFftLength(gs_RxFftLength);

    // During training(TRT_DISABLE=1), the Rx_MinToneIndx and Rx_MaxToneIndx
    // are modified and equal to RTVx_OFFSET and RTVx_OFFSET+RTV_COUNT/Decim_Rate
    // We don't need to set IR_ACT_ADDR address
   // SetUpRxTonesRegister(gus_Rx_MinToneIndx, gus_Rx_MaxToneIndx);
    /* set up rx tones register, for the first and last channel */

    // During training(TRT_DISABLE=1),
    // we load tones directly to IFFT buffer and therefore don't need to set IT_ACT_ADDR register

   /* Reconfigure the registers in Iridia to allow IFFT size change */
   Reconfig_IRI_IFFT_Size();

    // IT_CONFIG register, NSC_TX BITS
    ReadCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, &ul_data);
    //mask out the NSC_TX bits(0:2)
    ul_data &= ~0x7;
    //if gs_TxNumTones =64
    if (gs_TxNumTones == TX_NUM_TONES)
        ul_data |= 1; //set Nsc =64

   //set Nsc=256 for ADSL 2/2+ mode oPOTs in insert OOB
   //This is do-able because no tx images are sent in ADSL2/2+ oPOTS
#ifndef ISDN

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   if (OPTNArray[OPTN_TXPathControl] & 0x01)    // if US performance fix: on
   {
      if (gus_TxPathControl & 0x40) // Images turned on
         ul_data |= 3;  //set Nsc =256
   }
   else
   {
      if (!gft_TxImages)
         ul_data |= 3;  //set Nsc =256
   }
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)

#endif //#ifndef ISDN

   WriteCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_QT_REG_TX_CNFG = ul_data;

}
