/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   RxFFTBufSTrans.C
 *
 *   Iridia CPE core interface layer.
 *
 *
 *----------------------------------------------------------------------------
 */
//****************************************************************************
//RxFFTBufSTrans.C
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/06/2012 Kannan:
//          1. FIFO3 may be used to capture the RxData at the TC Layer Input
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 21/11/2012 Kannan:
//          1. Added a function to notify the Rx Data status to the PPE. Indicated at
//             1st symbol of showtime
//             Grep for "XDSLRTFW-541: Platform_VRX318"
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
///
// 25-04-2013 Prashant: Merged the following fix for SES defect with Margin Verification test (TR100:B.2.1.2)
//       Anantha: Fix for SES defect found with high noise margin test cases. Root cause for the issue is
//       Reverb segue detection tones are first 10 loaded bins. In high noise cases like FB noise first 5-6 tones are loaded with
//       1-bit and reverb or segue sequence is 2 bit (4-QAM) psuedo random sequence. Changing the logic to select tones with
//       highest bitloading in same order. it is seen that if order of the tones is changed port drops
//    grep for XDSLRTFW-601: BugFix_DS_All_All_SESFail
//
//*****************************************************************************************

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "states.h"
#include "cmv.h"
#include "fifo.h"
#include "showtime_bis.h"
#include "IRI_Iof.h"
#include "RxFFTBufSTrans.h"

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
//XDSLRTFW-541: Platform_VRX318 (START_END)
#include "ppe_memmap.h"

//=========================================================
// Note on the functionality of this file
//=========================================================
// The initial revisions (upto 1.2) of this file in the MKS
// corresponds to having the functions working for all valid
// train to showtime scenario transitions
// Henceforth (from revision 1.3), the functionalities
// provided in this file would only gurantee a transition
// from train scenario 1 to showtime scenario 3 given we
// process two interrupts in showtime namely FDQ and QAM
//=========================================================

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VRX318 (START)
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DFE_PPE_RxDataStatus_EnterShow()
*
*  This function notifies PPE that RX direction is about to entering showtime.
*   Set to 1 on first RxShowtimeSymbol
*
*  Input Arguments:
*
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void DFE_PPE_RxDataStatus_EnterShow(void)
{
   uint32 ul_addr, ul_data;

   // Bit defintion of DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF
   ul_addr = DREG_MISCRAM0_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   ul_data |=MASK_BIT1;
   WritePpeReg(ul_addr, ul_data);
}
//XDSLRTFW-541: Platform_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

/*****************************************************************************
;  Subroutine Name: UpdateNumBuffersToRotate(void)
;
;  Updates the number of buffers to rotate based on the next scenario
;
;  Prototype:
;     void UpdateNumBuffersToRotate(void)
;
;  Input Arguments:
;     gt_nextRxFFTBufferScenario -  Next Scenario
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
C_SCOPE void UpdateNumBuffersToRotate(void)
{
   // not used in Hercules build
}

/*****************************************************************************
;  Subroutine Name: UpdateLogicalBuffer1ProcBlocks(void)
;
;  Updates the proc blocks assigned to logical buffer based on the next scenario
;
;  Prototype:
;     void UpdateLogicalBuffer1ProcBlocks(void)
;
;  Input Arguments:
;     gt_nextRxFFTBufferScenario -  Next Scenario
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
C_SCOPE void UpdateLogicalBuffer1ProcBlocks(void)
{
   // not used in Hercules build
}

/*****************************************************************************
;  Subroutine Name: UpdateLogicalBuffer2ProcBlocks(void)
;
;  Updates the proc blocks assigned to logical buffer based on the next scenario
;
;  Prototype:
;     void UpdateLogicalBuffer2ProcBlocks(void)
;
;  Input Arguments:
;     gt_nextRxFFTBufferScenario -  Next Scenario
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
C_SCOPE void UpdateLogicalBuffer2ProcBlocks(void)
{
   // not used in Hercules build
}

/*****************************************************************************
;  Subroutine Name: TriggerShowtimeScenarioTransition(void)
;
;  Non-time critical task to trigger showtime scenatio transition
;
;  Prototype:
;     void TriggerShowtimeScenarioTransition(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
C_SCOPE void TriggerShowtimeScenarioTransition(void)
{
   // not used in Hercules build
}

/*****************************************************************************
;  Subroutine Name: DoRxFFTBufferScenarioTransition(int16 s_currStateSymbolCount,
;                          int16 s_currStateLen)
;
;  Non-time critical task for transition to train/showtime fft buffer usage scenario.
;
;  Prototype:
;     void DoRxFFTBufferScenarioTransition(int16 s_currStateSymbolCount,
;                          int16 s_currStateLen)
;
;  Input Arguments:
;        s_currStateSymbolCount  - Current State Symbol Count
;        s_currStateLen       - Current State Length
;
;  Output Arguments:
;
;  Return:
;
;****************************************************************************/
C_SCOPE void DoRxFFTBufferScenarioTransition(int16 s_currStateSymbolCount, int16 s_currStateLen)
{
   // no need to modify FFT buffer usage for Hercules build
   // this function is used for transition to showtime only
   if (s_currStateSymbolCount == s_currStateLen-1) {
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, StartRxDataPath);

      //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
      //Indicate to PPE that CPE is in a state to Rx the data
      AddFunctionToFifo(gp_RxLoadingFunctionFifo, DFE_PPE_RxDataStatus_EnterShow);

   }
   else if (s_currStateSymbolCount == s_currStateLen) {
      gs_RxNextState = R_C_SHOWTIME_RX;
      if (( gl_SelectedMode & (MODE_ADSL2)  ))
      {
         gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RShowtimeRxTC_BIS_A;
#ifdef VR9_FIXME
            gt_TaskArray[RX_AAI_DONE].TimeCriticalTask = RShowtimeRxTC_BIS_B;
#endif
         gpF_RxStateFunc = (PtrToFunc)RShowtimeRxF_BIS;
      }
      else
      {
         gt_TaskArray[RX_TSC_INT].TimeCriticalTask = RShowtimeRxTC_DMT;
         gpF_RxStateFunc = (PtrToFunc)RShowtimeRxF_DMT;
      }
   }
}


/*^^^
*-------------------------------------------------------------------
*
*  Prototype: void RShowtimeRxDummyInterruptTC
*
*   Description:
*
*  Time-critical task associated with dummy interrupt for transition
*  to S3/S4 scenario
*
*  Arguments:
*     none
*
*  Global Variables:
*
*-------------------------------------------------------------------
*^^^
*/
C_SCOPE void RShowtimeRxDummyInterruptTC(void)
{
   // not used in Hercules build
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void StartRxDataPath(void)
*
*  This function initiates RX data pump for showtime RX path processing.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

C_SCOPE void StartRxDataPath(void)
{
   uint32 ul_data;

   // update PMD frame counter. this counter goes from 0 to 68

   // configure RTV0 to store constellation decode output
   ConfigRTVBuf0_RCD_OUT();
    // configure RTV1 to store SFDQ output
   ConfigRTVBuf1_SFDQ_OUT();

   // set PRBS_DEC, RX_TRT_DIS, GS_BYP, SFDQ_BYP, BS_DIS for showtime mode
   ul_data = MASK_BIT4 | MASK_BIT6 | MASK_BIT12 | MASK_BIT14 | MASK_BIT15;
   ResetCoreReg(IRI_QT_REG_RX_MISC_ADDR, ul_data);

   // disable PRBS
   ResetCoreReg(IRI_QTP_REG_RX_CTRL_ADDR, MASK_BIT1);

   // setup reverb segue detector
#ifndef ISDN
   PreSelectReverbSegueDetector();
   ReverbSegueDetectorSetup();
#else
    //XDSLRTFW-601: BugFix_DS_All_All_SESFail (start)
    AddFunctionToBkgdFifo((PtrToBkgdFunc)PreSelectReverbSegueDetector);
   AddFunctionToBkgdFifo((PtrToBkgdFunc)ReverbSegueDetectorSetup);
   //XDSLRTFW-601: BugFix_DS_All_All_SESFail (end)
#endif

   // setup Iridia Reverb Segue Detector to do a Segue detection
   ReverbSegueDetectorSelect(R_SEGUE);

   Configure_TCM_Bits(gus_Rx_Tcm_Num1bits, (uint16)(gs_RxNumTones - gus_Rx_Tcm_Num1bits));
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      // Enable latch DT_SIZES from QT.
      ReadCoreReg(ZEP_PRAM_ZR_DTB_CTRL_LP0_ADDR, &ul_data);
      //ZEP_REG_ZR_QTDTB_CONFIG_ADDR  *note* This reg is not pram.
      ul_data |= (0x4000 << 16); // 30:Latch Bits for DT_SIZE, PMS_SIZE is not latached
      WriteCoreReg(ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR, ul_data);

      // Enable latch DT_SIZES from QT.
      ReadCoreReg(ZEP_PRAM_ZR_DTB_CTRL_LP1_ADDR, &ul_data);
      //ZEP_REG_ZR_QTDTB_CONFIG_ADDR  *note* This reg is not pram.
      ul_data |= (0x4000 << 16); // 30:Latch Bits for DT_SIZE, PMS_SIZE is not latached
      WriteCoreReg(ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR, ul_data);

   }
   else
   {
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
      if (gt_rx_config.s_Lp[LP0_DATA_PATH]) // ADSL2 framing mode or g.dmt.interleave
      {
         // Enable latch DT_SIZES from QT.
         ReadCoreReg(ZEP_PRAM_ZR_DTB_CTRL_LP0_ADDR, &ul_data);
         //ZEP_REG_ZR_QTDTB_CONFIG_ADDR  *note* This reg is not pram.
         if (( gl_SelectedMode & (MODE_ADSL2)  ))
            ul_data |= (0x4000 << 16); // 30:Latch Bits for DT_SIZE, PMS_SIZE is not latached
         else
            ul_data |= (0xC000 << 16); // 30:31 Latch Bits for DT_SIZE, PMS_SIZE
         WriteCoreReg(ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR, ul_data);
      }
      else //g.dmt.fast
      {
         // Enable latch DT_SIZES from QT.
         ReadCoreReg(ZEP_PRAM_ZR_DTB_CTRL_LP0_ADDR, &ul_data);

         //ZEP_REG_ZR_QTDTB_CONFIG_ADDR  *note* This reg is not pram.
         ul_data |= (0xC000 << 16); // 30:31 Latch Bits for DT_SIZE, PMS_SIZE
         WriteCoreReg(ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR, ul_data);
      }
   } //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)

#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
   //Use the FIFO3 to capture the RX DeScrambler output data
   if((gft_EnableFifo3Capture) && (guc_PortMode == SINGLE_PORT_MODE))
      EnableRxFifo3Capture();
#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)



}
