/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Aec.c
;
;  Strymon CPE functions related to the AEC.
;
*****************************************************************************/

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "STR_IOf.h"
#include "platform.h"
#include "afe.h"
#include "delay.h"

/* Global variables */

uint16 gus_SMODE1, gus_SMODE2;

uint16 gus_SCONTROL, gus_SE_DECTRAIN;

/****************************************************************************
; Name: Strymon_ClearResetState
;
; Prototype:
;  void Strymon_ClearResetState(void)
;
; Description:
;  Clear reset_state bit in V_STR_BLOCK_RESET
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
*****************************************************************************/
void Strymon_ClearResetState(void)
{
    WriteCoreReg((uint32)V_BLOCK_RSTN_ADDR, 0x77);
}

/****************************************************************************
; Name: Strymon_DisableAECPath
;
; Prototype:
;  void Strymon_DisableAECPath(void)
;
; Description:
;  Disable AEC Path
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
*****************************************************************************/
void Strymon_DisableAECPath(void)
{
#ifdef VR9_FIXME
   uint32 ul_data = 0;

   gus_SMODE2 |= (1 << 8);

   ul_data = ((((uint32)gus_SMODE2 << 4)&0xFFE0) | ((uint32)(gus_SMODE1&0x1F)));
   WriteCoreReg((uint32)SMODE_ADDR, ul_data);
#endif
}


