/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Dec.c
;
;  Strymon CPE functions related to the DEC.
;
*****************************************************************************/

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_iof.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "dec_adap.h"
#include "ec_data.h"


/****************************************************************************
; Name: LoadDECDelay
;
; Prototype:
;  void LoadDECDelay(void)
;
; Description:
;  This function loads the DEC impulse response coefficients
;  into the Strymon CPE. It also updates the output scaling
;  field and the length field, and clears the overflow
;  indicator bit, all in the DEC filter control register.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gs_pre_dec_h_delay   (I) DEC input delay
*****************************************************************************/
C_SCOPE void LoadDECDelay(void)
{

   uint32 ul_data;
   uint16 us_temp;
   int32 la_pre_dec_h_temp[256/2];
   int16* sa_pre_dec_h_temp = (int16 *)(void *)&la_pre_dec_h_temp[0];

      // Update filter control register.
   ReadCoreReg((uint32)V_DEC_CFG_ADDR, &ul_data);


    //(bits 21-16) DEC delay
    us_temp = (gs_pre_dec_h_delay>>3);
    ul_data &= ~(0x3F<<16) ;
    ul_data |= (us_temp << 16);
    WriteCoreReg((uint32)V_DEC_CFG_ADDR, ul_data);


   //Reset dec bypass mode and unmask dec output
   //Reset DEC_BYPASS
    ResetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT6);
    //Unmask DEC Output
    ResetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT0);

    /* reset ReorderDEC flag */
   gft_ReorderDEC = FALSE;


}

/****************************************************************************
; Name: LoadUnityDEC
;
; Prototype:
;  void LoadUnityDEC(void)
;
; Description:
;  This function loads a unit impulse DEC into the Strymon CPE.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gus_SMODE1,gus_SMODE2   (I)   setting of the Strymon CPE SMODE register
;  gsa_pre_dec_h     (I) array of DEC impulse response coefficients
;  gs_pre_dec_h_exp  (I) right shift applied to DEC output samples
;  gs_pre_dec_h_delay   (I) DEC input delay
*****************************************************************************/
C_SCOPE void LoadUnityDEC(void)
{
   ResetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT0);
}




