/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_DecAdapt.c
;
;  Strymon CPE functions related to DEC Adaptation.
;
*****************************************************************************/
// ******************************************************************
// STR_DecAdapt.c
//
// History
//
// 15/09/2011 Kannan: DS Performance improvement in DEC training.
//    Increase of DEC length from 400 to 480 causes link drop
//      in showtime(Plus mode) due the MIPS contraints while downloading
//      the DEC & TDQ coefficients into the DEC adaptation memory in one symbol.
//      Hence downloading of DEC & TDQ coefficients into the DEC adaptation
//      RAM is spread across 3 symbols(Plus mode),
//      i.e 1symbol (TDQ coefficient) + 1 symbol(DEC_Phase_1) + 1symbol(DEC_Phase_0)
//      But in DMT/Bis mode DEC coefficient downloading is done in 2 symbols.
//      i.e 1symbol (TDQ coefficient) + 1 symbol(DEC_Phase_1).
//      Note: DEC Upsampling factor = 2 (Plus Mode),
//            DEC Upsampling factor = 1 (DMT/BIS Mode)
//      Grep for XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining
//
// 25/06/2013 Kannan: Added counter to count DEC HW non idle state
//      Grep for "XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest"
// ******************************************************************

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "str_const.h"
#include "dec_adap_Data.h"
//XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
extern uint32 gul_DecHW_WaitCount;
/***************************************************************************************
;  Subroutine Name: DownloadDECCoef
;
;  Description:
;     This function downloads the DEC coefficients, one by one, from the
;     task layer to the Strymon core via the SE_DECADDR and SE_DECCOEFF
;     registers.
;
;  Prototype:
;     void DownloadDECCoef(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/
C_SCOPE void DownloadDECCoef(void)
{
   uint32 ul_BaseAddr, ul_data;
   uint16 us_OS;
   int32 la_pre_dec_h_temp[256/2];
   int16* sa_pre_dec_h_temp = (int16 *)(void *)&la_pre_dec_h_temp[0];
   int i;

   // Check if a capture cycle has been completed.
   ReadCoreReg((uint32)V_DEC_CAPTURE_ADDR, &ul_data);


   if(((ul_data >> 11) & 0x3) == 0x3)
    {
      // Wait for signal to start downloading coefficients.
      if(guc_DECCoefDnloadFlag == START)
      {
         //XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (START)
         //guc_DECCoefDnloadState related changes.
         if (guc_DECCoefDnloadState == LOAD_TDQ)
         {
            //copy TDQ coefficients in adapt memory
            ul_BaseAddr= V_DEC_ADAPT_ADDR ;
            WriteCoreBuf32(ul_BaseAddr, gsa_pre_tdq_h, (uint16)(gs_TDQLen>>1));
            guc_DECCoefDnloadState = LOAD_DEC_PHASE_1;   //=1
         } else if (guc_DECCoefDnloadState >= LOAD_DEC_PHASE_1)
         {
            //copy DEC coefficients in adapt memory
            if ( gs_DECUpsamplingFactor == 1 )  //one phase only
            {
               ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER*2 ;
               WriteCoreBuf32(ul_BaseAddr, gsa_pre_dec_h, gs_DEC_ORDER>>1);
               guc_DECCoefDnloadState = DEC_COEF_WR_EN;
            }
            else //two phases
            {
               if (guc_DECCoefDnloadState == LOAD_DEC_PHASE_1)
               {
                  //load dec phase 1
                  ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER ;
                  for ( i=0; i< gs_DEC_ORDER>>1; i++)
                     sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i+1];
                  WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));
                  guc_DECCoefDnloadState = LOAD_DEC_PHASE_0; // = 2
               } else if (guc_DECCoefDnloadState == LOAD_DEC_PHASE_0)
               {
                  //load dec phase 0
                  ul_BaseAddr= V_DEC_ADAPT_ADDR + DEC_INTERP_PHASE_MEM_OFFSET-gs_DEC_ORDER;
                  //byte address
                  for ( i=0; i< gs_DEC_ORDER>>1; i++)
                     sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i];
                  WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));
                  guc_DECCoefDnloadState = DEC_COEF_WR_EN; // = 3
               }
            }
         }
         if (guc_DECCoefDnloadState == DEC_COEF_WR_EN)
         {
            //congigure the tdq_exp and dec-exp filed
            ReadCoreReg((uint32)V_ADAPT_CTRL_ADDR, &ul_data);
            ul_data &= ~(7<<5) ; //mask tdq exp field
            ul_data &= ~(7<<9) ; //mask dec exp field
            us_OS = (uint8)(15-gs_pre_tdq_h_exp)&0x7;
            ul_data |= (((uint8)gs_pre_dec_h_exp &0x7)<<9)| (us_OS<<5);
            //copy dec and tdq exponents to v_adapt_ctrl register
            ul_data &= ~7;
            ul_data |= 5;
            // Wait until previous download is completed.
            WriteCoreReg((uint32)V_ADAPT_CTRL_ADDR, ul_data);

            guc_DECCoefDnloadFlag = DONE;
            guc_DECCoefDnloadState = LOAD_TDQ;
         }
         //XDSLRTFW-251 PERF_DS_PlusBisDmt_ALL_DECTraining (END)
      } //if(guc_DECCoefDnloadFlag == START)
   } //if(((ul_data >> 11) & 0x3) == 0x3)
   else
   {
      //XDSLRTFW-959 BugFix_DS_ALL_ALL_DecStruck_In_TempChamberTest (Start_End)
      gul_DecHW_WaitCount++;
   }
} //DownloadDECCoef()
