/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Filt.c
;
;  Contains data  defining Strymon CPE Filter parameters.
;
*****************************************************************************/
//*******************************************************************
// STR_Filt.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 22/11/2011 Hanyu:  Ported MFD code to VR9. Added code to initialize Rx IIR filter
//                    in G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//*****************************************************************************
#include "STR_Filt.h"
#include "data_alloc.h"
#include "cmv.h"
#include "afe.h"

/*****************************************************************************
;  coefficients, and the output scaling. Since all the filters are
;  symmetric, only the first half (plus one if the length is odd)
;  of the filter coefficients is listed in the table. The exceptions
;  are the Tx Interpolator 2/3, for which all the filter coefficients
;  are listed.
;
;  With the exception of the Tx POTS high-pass filter, the set of
;  filter parameters to be used for each filter is determined by
*****************************************************************************/

/***************************************
 Set of IIR Filter Tables.
 gula_Strymon_RxIir_Pots_Plus Used for Plus and Bypass<pass thru>
 gula_Strymon_RxIir_Pots_Bis Used for Bis/DMT initially
            Array gets overwritten with lpf by STR_ReconfigDecim2_HPF.c
*****************************************/
#ifndef ISDN
#if 1
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): Use new 5 section Rx filter for VR9 5A
//uint32  gula_Strymon_RxIir_Pots_Plus[RX_IIR_SIZE] = {
//// RX POTS 2.2MHz profile fs: 4.4MHz
//// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
//   11,       // number of coefs.
//   0x310010, 0x50000 ,      //IIR_CFG1, 2  registers
//   1403,              // in_scale
//    105660,    -42921,     41562,    -83123,     41562, // section  1
//     58770,    -27557,     55998,   -111994,     55998, // section  2
//};

//uint32  gula_Strymon_RxIir_Pots_Plus[29] = {
//// RX POTS 2.2MHz profile fs: 4.4MHz
//// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
//   26,       // number of coefs.
//   0x340010, 0x50000 ,      //IIR_CFG1, 2  registers
//   1403,              // in_scale
//    105660,    -42921,     41562,    -83123,     41562, // section  1
//     58770,    -27557,     55998,   -111994,     55998, // section  2
//     0,    0,     65536,    0,     0, // section  3
//     0,    0,     65536,    0,     0, // section  4
//     0,    0,     65536,    0,     0, // section  5
//};
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): new plus, bis, dmt AnxA bypass filter
uint32  gula_Strymon_RxIir_Pots_Plus[34] = {
// RX POTS 2.2MHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   31,      // number of coefs.
   0x350000, 0x0 ,      //IIR_CFG1, 2  registers
   65536,               // in_scale
   0,    0,     65536,    0,     0, // section  1
   0,    0,     65536,    0,     0, // section  2
   0,    0,     65536,    0,     0, // section  3
   0,    0,     65536,    0,     0, // section  4
   0,    0,     65536,    0,     0, // section  5
   0,    0,     65536,    0,     0, // section  6
};

//uint32  gula_Strymon_RxIir_Pots_Bis[RX_IIR_SIZE] = {
//// RX POTS 1.1MHz profile fs: 2.2MHz
//// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
//    11,      // number of coefs.
//   0x210010, 0x30000 ,      //IIR_CFG1, 2  registers
//      4759,              // in_scale
//     83711,    -27669,     35705,    -71408,     35705, // section  1
//     50382,    -23328,     56765,   -113529,     56765, // section  2
//};
uint32  gula_Strymon_RxIir_Pots_Bis[34] = {
// RX POTS 1.1MHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   31,      // number of coefs.
   0x250000, 0x0 ,      //IIR_CFG1, 2  registers
   65536,               // in_scale
   0,    0,     65536,    0,     0, // section  1
   0,    0,     65536,    0,     0, // section  2
   0,    0,     65536,    0,     0, // section  3
   0,    0,     65536,    0,     0, // section  4
   0,    0,     65536,    0,     0, // section  5
   0,    0,     65536,    0,     0, // section  6
};
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End): new plus,bis,dmt AnxA bypass filter

#else

// The following filter settings are from Zukunft Roland (LQDE AN ST DSL C) on 8th dec 2010
// This is to remove the DC & ISI from the Rx Path instead of using RxIIR filter in Bypass mode.
uint32  gula_Strymon_RxIir_Pots_Plus[RX_IIR_SIZE] = {
// RX DC BLOCK 2.2MHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   11,                                          // number of coefs
   0x310010, 0x20000,                           // IIR_CFG1, 2  registers
   5890,                   // in_scale
   53784,        0,    40402,   -80805,    40403, // section  1
   58564,   -26943,   121457,  -121456,        0, // section  2
};


uint32  gula_Strymon_RxIir_Pots_Bis[RX_IIR_SIZE] = {
// RX POTS 1.1MHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   11,                                          // number of coefs
   0x210010, 0x10000,                           // IIR_CFG1, 2  registers
   10899,                  // in_scale
   43790,        0,    35488,   -70977,    35489, // section  1
   50823,   -22242,   122527,  -122526,        0, // section  2
};
#endif //#if 0

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
uint32  gula_Strymon_RxIir_Nlnf_Bis[RX_IIR_SIZE] = {
// NLNF RX 1.1MHz profile fs: 2.2MHz
// same as ARx modified Rx IIR filter for Micro Filter Detection
// ellip(4,3,60,64/256,'high') for NLNF in ADSL1 Annex A mode
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   11,                                                    // number of coefs
   0x210000, 0x20000,                                  // IIR_CFG1, 2  registers
   20261,                                     // in_scale
      10915,   -24734,    12536,   -24761,    12536, // section  1
      84751,   -58321,    62642,  -117211,    62642, // section  2
};
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

#else
uint32  gula_Strymon_RxIir_Isdn_Plus[RX_IIR_SIZE] = {
// RX ISDN 2.2MHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   11,      // number of coefs.
   0x310010, 0x30000 ,     //IIR_CFG1, 2  registers
     4759,              // in_scale
     83711,    -27669,     35705,    -71408,     35705, // section  1
     50382,    -23328,     56765,   -113529,     56765, // section  2
};

uint32  gula_Strymon_RxIir_Isdn_Bis[RX_IIR_SIZE] = {
// RX ISDN 1.1MHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   11,      // number of coefs.
   0x210000, 0x10000 ,     //IIR_CFG1, 2  registers
     14688,                // in_scale
     46471,    -10239,     45836,    -91670,     45836, // section  1
     61725,    -35112,     60387,   -120773,     60387, // section  2
};
#endif


// TX filters
// Interp1_3 Is a  2:1 filter IIR from 552 too 1.1 MHsuperz for all modes and annexes.
// THe coefs are found in these files.
#ifdef ISDN
#include "STR_Filt_Txint1_isdn.c"
#else
#include "STR_Filt_TxInt1.c"
#endif


// ------------------------------------------------------------- //

//  TX POTS/ISDN 276kHz profile fs: 4.4MHz

// interp factor[TX.INTERP.FACTOR]=   8
// phase length for interp[TX.INTERP.LEN]=  19
 //interp output scaling[Tx.INTERP.X]=   0
#ifdef ISDN
#if 0
int16  gsa_StrymonFir_Filter_TxInterp_Plus[MAX_LENGTH_TXINTERP_DIV_2] = {
      1,  -1070, -13893, -19226, -10694,  -2003,   5673,  11858,  16162,  18310,  18165,  15737,  11181,   4786,  -3044, -11827, -19831, -11794,   -586,      0,      0,      0,      0,      0,
      2,  -1793, -15828, -18404,  -9570,   -977,   6536,  12505,  16552,  18418,  17985,  15279,  10474,   3876,  -4101, -12967, -20145,  -9654,   -288,      0,      0,      0,      0,      0,
      2,  -2799, -17485, -17432,  -8455,     31,   7376,  13123,  16908,  18491,  17768,  14788,   9740,   2945,  -5171, -14110, -20103,  -7596,   -122,      0,      0,      0,      0,      0,
     -8,  -4110, -18777, -16365,  -7349,   1022,   8190,  13709,  17230,  18527,  17517,  14265,   8979,   1993,  -6254, -15249, -19654,  -5723,    -40,      0,      0,      0,      0,      0,

    -40,  -5723, -19654, -15249,  -6254,   1993,   8979,  14265,  17517,  18527,  17230,  13709,   8190,   1022,  -7349, -16365, -18777,  -4110,     -8,      0,      0,      0,      0,      0,
   -122,  -7596, -20103, -14110,  -5171,   2945,   9740,  14788,  17768,  18491,  16908,  13123,   7376,     31,  -8455, -17432, -17485,  -2799,      2,      0,      0,      0,      0,      0,
   -288,  -9654, -20145, -12967,  -4101,   3876,  10474,  15279,  17985,  18418,  16552,  12505,   6536,   -977,  -9570, -18404, -15828,  -1793,      2,      0,      0,      0,      0,      0,
   -586, -11794, -19831, -11827,  -3044,   4786,  11181,  15737,  18165,  18310,  16162,  11858,   5673,  -2003, -10694, -19226, -13893,  -1070,      1,      0,      0,      0,      0,      0,
};
#else
 int16  gsa_StrymonFir_Filter_TxInterp_Plus[MAX_LENGTH_TXINTERP_DIV_2] = {
      0,      5,    -38,    154,   -433,    955,  -1792,   3395,  31013,   -319,   -408,    396,   -233,     97,    -27,      4,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      6,    -47,    204,   -619,   1497,  -3222,   7882,  29498,  -3069,    757,    -99,    -50,     43,    -16,      3,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      6,    -51,    235,   -752,   1926,  -4477,  12841,  26612,  -4776,   1591,   -476,     94,      0,     -7,      2,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      4,    -47,    234,   -792,   2139,  -5310,  17894,  22623,  -5478,   2048,   -707,    189,    -30,      0,      1,      0,      0,      0,      0,      0,      0,      0,      0,
      1,      0,    -30,    189,   -707,   2048,  -5478,  22623,  17894,  -5310,   2139,   -792,    234,    -47,      4,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      2,     -7,      0,     94,   -476,   1591,  -4776,  26612,  12841,  -4477,   1926,   -752,    235,    -51,      6,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      3,    -16,     43,    -50,    -99,    757,  -3069,  29498,   7882,  -3222,   1497,   -619,    204,    -47,      6,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      4,    -27,     97,   -233,    396,   -408,   -319,  31013,   3395,  -1792,    955,   -433,    154,    -38,      5,      0,      0,      0,      0,      0,      0,      0,      0,      0,
};
#endif
#else

 int16  gsa_StrymonFir_Filter_TxInterp_Plus[MAX_LENGTH_TXINTERP_DIV_2] = {
      0,      5,    -38,    154,   -433,    955,  -1792,   3395,  31013,   -319,   -408,    396,   -233,     97,    -27,      4,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      6,    -47,    204,   -619,   1497,  -3222,   7882,  29498,  -3069,    757,    -99,    -50,     43,    -16,      3,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      6,    -51,    235,   -752,   1926,  -4477,  12841,  26612,  -4776,   1591,   -476,     94,      0,     -7,      2,      0,      0,      0,      0,      0,      0,      0,      0,
      0,      4,    -47,    234,   -792,   2139,  -5310,  17894,  22623,  -5478,   2048,   -707,    189,    -30,      0,      1,      0,      0,      0,      0,      0,      0,      0,      0,
      1,      0,    -30,    189,   -707,   2048,  -5478,  22623,  17894,  -5310,   2139,   -792,    234,    -47,      4,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      2,     -7,      0,     94,   -476,   1591,  -4776,  26612,  12841,  -4477,   1926,   -752,    235,    -51,      6,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      3,    -16,     43,    -50,    -99,    757,  -3069,  29498,   7882,  -3222,   1497,   -619,    204,    -47,      6,      0,      0,      0,      0,      0,      0,      0,      0,      0,
      4,    -27,     97,   -233,    396,   -408,   -319,  31013,   3395,  -1792,    955,   -433,    154,    -38,      5,      0,      0,      0,      0,      0,      0,      0,      0,      0,
};

#endif
// ------------------------------------------------------------- //

//  TX POTS/ISDN 276kHz profile fs: 2.2MHz

// interp factor[TX.INTERP.FACTOR]=  16
// phase length for interp[TX.INTERP.LEN]=  16
 //interp output scaling[Tx.INTERP.X]=   0
#ifdef ISDN
#if 0
 int16  gsa_StrymonFir_Filter_TxInterp_Bis[MAX_LENGTH_TXINTERP_DIV_2] = {
         0,         -2,        -28,        -91,         18,        672,       1118,      -1426,      -7901,     -11705,      -3672,      13022,      21513,      12026,      -4555,     -11751,      -7466,      -1131,       1144,        617,         -4,        -88,        -25,         -2,
         0,         -3,        -32,        -94,         40,        726,       1081,      -1740,      -8327,     -11608,      -2749,      13984,      21434,      10999,      -5395,     -11748,      -7025,       -854,       1159,        564,        -22,        -85,        -23,         -2,
         0,         -4,        -35,        -96,         65,        780,       1030,      -2072,      -8741,     -11458,      -1791,      14907,      21277,       9948,      -6190,     -11698,      -6580,       -596,       1163,        511,        -38,        -81,        -20,         -1,
         0,         -4,        -39,        -97,         93,        833,        965,      -2421,      -9141,     -11255,       -799,      15785,      21043,       8878,      -6937,     -11602,      -6134,       -357,       1158,        460,        -51,        -77,        -18,         -1,
         0,         -5,        -43,        -97,        124,        884,        886,      -2786,      -9524,     -10997,        221,      16614,      20733,       7793,      -7634,     -11464,      -5689,       -138,       1144,        410,        -63,        -73,        -15,         -1,
         0,         -6,        -47,        -96,        157,        933,        791,      -3166,      -9886,     -10683,       1266,      17390,      20348,       6698,      -8278,     -11286,      -5248,         62,       1123,        362,        -72,        -69,        -13,         -1,
         0,         -7,        -51,        -94,        193,        980,        680,      -3560,     -10224,     -10314,       2331,      18110,      19890,       5600,      -8870,     -11070,      -4813,        244,       1095,        317,        -80,        -64,        -12,          0,
         0,         -9,        -55,        -91,        232,       1023,        553,      -3967,     -10536,      -9888,       3411,      18769,      19363,       4503,      -9407,     -10819,      -4385,        407,       1062,        273,        -86,        -60,        -10,          0,
};
#else
int16  gsa_StrymonFir_Filter_TxInterp_Bis[MAX_LENGTH_TXINTERP_DIV_2] = {
    0, 5, -34, 136, -375, 797, -1407, 2350, 31195, 490, -712, 516, -274, 108, -29, 4, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -40, 164, -475, 1080, -2128, 4422, 30809, -1136, -65, 247, -177, 80, -23, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -45, 190, -569, 1354, -2849, 6672, 30047, -2509, 518, 0, -85, 53, -18, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -48, 212, -653, 1607, -3542, 9064, 28926, -3621, 1021, -220, -3, 28, -12, 2, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -51, 229, -721, 1826, -4178, 11555, 27474, -4470, 1436, -406, 68, 7, -8, 2, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -51, 238, -770, 1997, -4724, 14096, 25724, -5060, 1756, -557, 128, -11, -4, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -49, 239, -793, 2109, -5150, 16636, 23717, -5403, 1980, -670, 174, -26, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 3, -45, 229, -786, 2150, -5424, 19121, 21499, -5517, 2109, -746, 208, -37, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif
#else

#if 0
 int16  gsa_StrymonFir_Filter_TxInterp_Bis[MAX_LENGTH_TXINTERP_DIV_2] = {
         0,         -1,         -8,        -20,        100,        583,        784,      -1514,      -6974,      -9999,      -2894,      11534,      18844,      10676,      -3662,     -10054,      -6613,      -1259,        817,        545,         83,        -21,         -7,          0,
         0,         -1,         -9,        -20,        119,        620,        740,      -1784,      -7327,      -9900,      -2093,      12363,      18776,       9791,      -4394,     -10067,      -6245,      -1019,        842,        508,         68,        -21,         -7,          0,
         0,         -1,        -10,        -18,        139,        656,        685,      -2068,      -7670,      -9756,      -1261,      13157,      18641,       8885,      -5087,     -10040,      -5874,       -794,        857,        471,         54,        -21,         -6,          0,
         0,         -1,        -11,        -16,        161,        691,        619,      -2366,      -7999,      -9566,       -401,      13914,      18440,       7961,      -5739,      -9974,      -5501,       -586,        865,        434,         42,        -21,         -5,          0,
         0,         -1,        -13,        -13,        185,        724,        541,      -2677,      -8313,      -9330,        482,      14628,      18173,       7025,      -6349,      -9872,      -5129,       -392,        866,        398,         31,        -20,         -4,          0,
         0,         -2,        -14,        -10,        211,        756,        450,      -3001,      -8609,      -9046,       1387,      15296,      17841,       6081,      -6915,      -9735,      -4759,       -215,        860,        363,         21,        -19,         -4,          0,
         0,         -2,        -15,         -6,        238,        784,        346,      -3335,      -8885,      -8715,       2308,      15916,      17448,       5133,      -7435,      -9565,      -4393,        -52,        848,        330,         13,        -18,         -3,          0,
         0,         -2,        -16,         -1,        267,        810,        228,      -3679,      -9138,      -8336,       3242,      16483,      16994,       4185,      -7909,      -9365,      -4032,         95,        831,        298,          6,        -17,         -3,          0,
};
#endif
 int16  gsa_StrymonFir_Filter_TxInterp_Bis[MAX_LENGTH_TXINTERP_DIV_2] = {
    0, 5, -34, 136, -375, 797, -1407, 2350, 31195, 490, -712, 516, -274, 108, -29, 4, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -40, 164, -475, 1080, -2128, 4422, 30809, -1136, -65, 247, -177, 80, -23, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -45, 190, -569, 1354, -2849, 6672, 30047, -2509, 518, 0, -85, 53, -18, 3, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -48, 212, -653, 1607, -3542, 9064, 28926, -3621, 1021, -220, -3, 28, -12, 2, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, -51, 229, -721, 1826, -4178, 11555, 27474, -4470, 1436, -406, 68, 7, -8, 2, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -51, 238, -770, 1997, -4724, 14096, 25724, -5060, 1756, -557, 128, -11, -4, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, -49, 239, -793, 2109, -5150, 16636, 23717, -5403, 1980, -670, 174, -26, -1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 3, -45, 229, -786, 2150, -5424, 19121, 21499, -5517, 2109, -746, 208, -37, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif

// ------------------------------------------------------------- //

#ifndef ISDN
// interp factor[TX.INTERP.FACTOR]=   8
// phase length for interp[TX.INTERP.LEN]=  16
 //interp output scaling[Tx.INTERP.X]=   0
/* -----------------------------------------------------------------------------------------------------
   //Matlab code to generate the following FIR filter:
   phaselength = 16;    up = 8; %interpolation factor
   fs = 72e6;    fname = 'VRx518_Adsl2p_AnnexA_FIR.txt';
   i1fac = up;
   interp_fir = firls(phaselength*i1fac-1,[0 .0425/(i1fac) 0.54/(i1fac) 1],[1 1 0 0],[1 1000]).';
   interp_fir = i1fac*interp_fir;
   shft = 1+floor(log2(max(abs(interp_fir))));
   interp_fir = 2^-(15)*round(2^(15-shft)*interp_fir);
   b = interp_fir;      b = round(b*power(2,15));

   %%% for BIS only 1/2 of coefficients is stored!
   % column format,
   fir = zeros(8,24);
   for I=1:8
      idx = I+(0:8:(phaselength-1)*up);
      fir(I,1:phaselength) = b(idx);
   end
   % regenerate original fir
   f = fir(1:8,1:phaselength);
   %f = [f;fliplr(flipud(f))];
   b_ = f(:);
   --------------------------------------------------------------------------------------------------------
*/
int16 gsa_StrymonFir_Filter_TxInterp_AnxM[MAX_LENGTH_TXINTERP_DIV_2] = {
   -9, -191, -718, -1006, 910, 7263, 17736, 27909, 31804, 26871, 16318, 6197, 461, -1039, -640, -150, 0, 0, 0, 0, 0, 0, 0, 0,
   -17, -239, -794, -940, 1431, 8399, 19151, 28844, 31658, 25742, 14911, 5206, 82, -1042, -563, -115, 0, 0, 0, 0, 0, 0, 0, 0,
   -28, -293, -866, -835, 2028, 9601, 20551, 29666, 31367, 24532, 13525, 4292, -232, -1023, -489, -86, 0, 0, 0, 0, 0, 0, 0, 0,
   -43, -353, -930, -686, 2703, 10861, 21924, 30365, 30934, 23255, 12172, 3457, -487, -984, -418, -62, 0, 0, 0, 0, 0, 0, 0, 0,
   -62, -418, -984, -487, 3457, 12172, 23255, 30934, 30365, 21924, 10861, 2703, -686, -930, -353, -43, 0, 0, 0, 0, 0, 0, 0, 0,
   -86, -489, -1023, -232, 4292, 13525, 24532, 31367, 29666, 20551, 9601, 2028, -835, -866, -293, -28, 0, 0, 0, 0, 0, 0, 0, 0,
   -115, -563, -1042, 82, 5206, 14911, 25742, 31658, 28844, 19151, 8399, 1431, -940, -794, -239, -17, 0, 0, 0, 0, 0, 0, 0, 0,
    -150, -640, -1039, 461, 6197, 16318, 26871, 31804, 27909, 17736, 7263, 910, -1006, -718, -191, -9, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif

#ifdef ISDN
//Previous filter: interp_fir = firls(phaselength*i1fac-1,[0 .0425/(i1fac) 0.50/(i1fac) 1],[1 1 0 0],[1 1000]).'; decrease 6dB
//New filter: interp_fir = firls(phaselength*i1fac-1,[0 .0425/(i1fac) 0.50/(i1fac) 1],[0.8 1 1/10000 0],[1 1000]).';Increase 0.65dB
// Tx FIR is modified now the T/F is ~0.3 dB ramp up in the upstream Pass band
int16  gsa_StrymonFir_Filter_TxInterp_AnxJ[MAX_LENGTH_TXINTERP_DIV_2] = {
     -23, -356, -1267, -2266, -1666, 2353, 9557, 16684, 19446, 15954, 8570, 1641, -1901, -2185, -1126, -284, 0, 0, 0, 0, 0, 0, 0, 0,
     -40, -437, -1411, -2323, -1374, 3119, 10544, 17341, 19321, 15161, 7592, 987, -2083, -2084, -991, -223, 0, 0, 0, 0, 0, 0, 0, 0,
     -63, -528, -1556, -2351, -1024, 3935, 11523, 17918, 19115, 14312, 6632, 392, -2215, -1966, -862, -171, 0, 0, 0, 0, 0, 0, 0, 0,
     -91, -630, -1699, -2345, -613, 4797, 12484, 18410, 18810, 13417, 5698, -141, -2301, -1837, -741, -127, 0, 0, 0, 0, 0, 0, 0, 0,
     -127, -741, -1837, -2301, -141, 5698, 13417, 18810, 18410, 12484, 4797, -613, -2345, -1699, -630, -91, 0, 0, 0, 0, 0, 0, 0, 0,
     -171, -862, -1966, -2215, 392, 6632, 14312, 19115, 17918, 11523, 3935, -1024, -2351, -1556, -528, -63, 0, 0, 0, 0, 0, 0, 0, 0,
     -223, -991, -2084, -2083, 987, 7592, 15161, 19321, 17341, 10544, 3119, -1374, -2323, -1411, -437, -40, 0, 0, 0, 0, 0, 0, 0, 0,
     -284, -1126, -2185, -1901, 1641, 8570, 15954, 19446, 16684, 9557, 2353, -1666, -2266, -1267, -356, -23, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif

//TX FIR :0x304400-0x3045FF  mr 0x304400 200
//Phase length: 16, 8 phases total, each phase has 24 coefficients.
/*
  -----------------------------------------------------------------------------------------------------
  //Matlab code to generate the folloing FIR filter:
  phaselength = 16;    up = 16; %interpolation factor
  fs = 72e6;   fname = 'VRx518_Adsl2_AnnexA_FIR.txt';
  i1fac = up;
  interp_fir = firls(phaselength*i1fac-1,[0 .0375/(i1fac) 0.6/(i1fac) 1],[1 1 1/10000 0],[1 1000]).';
  interp_fir = i1fac*interp_fir;
  shft = 1+floor(log2(max(abs(interp_fir))));
  interp_fir = 2^-(15)*round(2^(15-shft)*interp_fir);
  b = interp_fir;     b = round(b*power(2,15));
  fir = zeros(8,24);
  for I=1:8
   idx = I+(0:16:(phaselength-1)*16);
   fir(I,1:phaselength) = b(idx);
  end
  f = fir(1:8,1:phaselength);    f = [f;fliplr(flipud(f))];   b_ = f(:);
  -------------------------------------------------------------------------------------------------------
*/
#ifndef ISDN
int16  gsa_StrymonFir_Filter_TxInterp_AnxM_bis[MAX_LENGTH_TXINTERP_DIV_2] = {
   -2, -78, -437, -1032, -784, 2221, 8593, 15594, 18598, 15229, 8131, 1926, -861, -1002, -404, -67, 0, 0, 0, 0, 0, 0, 0, 0,
   -3, -90, -472, -1060, -696, 2531, 9059, 15942, 18532, 14848, 7673, 1646, -927, -969, -371, -58, 0, 0, 0, 0, 0, 0, 0, 0,
   -4, -103, -508, -1084, -596, 2855, 9526, 16272, 18477, 14453, 7221, 1380, -984, -934, -341, -49, 0, 0, 0, 0, 0, 0, 0, 0,
   -5, -117, -545, -1104, -484, 3192, 9995, 16584, 18397, 14045, 6775, 1129, -1030, -898, -311, -42, 0, 0, 0, 0, 0, 0, 0, 0,
   -7, -133, -583, -1120, -360, 3543, 10463, 16876, 18292, 13626, 6336, 893, -1067, -860, -284, -35, 0, 0, 0, 0, 0, 0, 0, 0,
   -10, -150, -622, -1131, -222, 3908, 10930, 17147, 18162, 13195, 5906, 671, -1096, -821, -257, -29, 0, 0, 0, 0, 0, 0, 0, 0,
   -12, -168, -662, -1137, -71, 4284, 11394, 17396, 18007, 12756, 5485, 464, -1117, -781, -233, -24, 0, 0, 0, 0, 0, 0, 0, 0,
   -16, -188, -702, -1137, 93, 4673, 11853, 17623, 17827, 12308, 5074, 271, -1130, -742, -210, -19, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif
// ------------------------------------------------------------- //

//  RX POTS/ISDN 2.2MHz profile fs: 4.4MHz

// decim factor[RX.DECIM.FACTOR]=  16
// decim length [RX.DECIM.LEN]=  15
// decim output scaling[RX.DECIM.X]=  -4
 int16  gsa_StrymonFir_Filter_RxDecim_Plus[MAX_LENGTH_RXDECIM_DIV_2] = {
      0,       2,       5,      10,      18,      30,      46,      68,
     96,     132,     174,     224,     280,     343,     410,     480,
    549,     613,     669,     711,     733,     732,     700,     632,
    524,     371,     172,     -75,    -369,    -706,   -1081,   -1485,
  -1906,   -2330,   -2742,   -3121,   -3447,   -3698,   -3851,   -3883,
  -3773,   -3500,   -3047,   -2399,   -1547,    -486,     784,    2256,
   3917,    5748,    7725,    9817,   11987,   14198,   16404,   18562,
  20626,   22550,   24292,   25811,   27073,   28046,   28708,   29043,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
      0,       0,       0,       0,       0,       0,       0,       0,
};

// ------------------------------------------------------------- //

//  RX POTS/ISDN 1.1MHz profile fs: 2.2MHz

// decim factor[RX.DECIM.FACTOR]=  32
// decim length [RX.DECIM.LEN]=  29
// decim output scaling[RX.DECIM.X]=  -4
 int16  gsa_StrymonFir_Filter_RxDecim_Bis[MAX_LENGTH_RXDECIM_DIV_2] = {
      2,       3,       5,       7,      10,      13,      17,      22,
     27,      33,      40,      48,      57,      67,      78,      90,
    103,     117,     132,     148,     164,     181,     199,     217,
    235,     254,     272,     289,     306,     321,     335,     348,
    358,     365,     370,     372,     369,     363,     352,     337,
    316,     291,     259,     221,     178,     128,      71,       9,
    -60,    -135,    -216,    -302,    -394,    -491,    -591,    -695,
   -802,    -911,   -1021,   -1131,   -1239,   -1346,   -1448,   -1545,
  -1637,   -1720,   -1794,   -1857,   -1907,   -1944,   -1965,   -1969,
  -1955,   -1922,   -1867,   -1790,   -1689,   -1564,   -1413,   -1237,
  -1033,    -803,    -545,    -260,      53,     393,     759,    1151,
   1567,    2008,    2470,    2953,    3456,    3974,    4508,    5054,
   5611,    6174,    6743,    7313,    7882,    8447,    9005,    9554,
  10089,   10607,   11107,   11585,   12038,   12464,   12860,   13223,
  13552,   13844,   14098,   14313,   14486,   14616,   14704,   14748,
};

//Feature_US_BisPlus_ALL_Bringup_Annex_M  Start
// XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)

struct StrymonCPE_FilterTable gt_StrymonCPE_FilterTable = {
   PHASE_LENGTH_TXINTERP_PLUS,
   PHASE_LENGTH_TXINTERP_BIS,
   PHASE_LENGTH_RXDECIM_PLUS,
   PHASE_LENGTH_RXDECIM_BIS,
   gsa_StrymonFir_Filter_TxInterp_Plus,
   gsa_StrymonFir_Filter_TxInterp_Bis,
   gsa_StrymonFir_Filter_RxDecim_Plus,
   gsa_StrymonFir_Filter_RxDecim_Bis,
   0,    //s_OS_TxInterp_Plus_AB;
#ifdef ISDN
   1, //s_OS_TxInterp_Bis_AB;
#else
   1,  //s_OS_TxInterp_Bis_AB;
#endif
    0,  //s_OS_TxInterp_Plus_M;
    -1, //s_OS_TxInterp_Bis_M;    // ADSL2 Annex M filter has a gain of 24dB in pass band
   -4,   //s_OS_RxDecim_Plus;
   -4,   //s_OS_RxDecim_Bis;
   };

// XDSLRTFW-407 Enhancement_USDS_Bis_Annex_M  (START)
//Feature_US_BisPlus_ALL_Bringup_Annex_M End


