/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//*******************************************************************
// STR_Filt_TxInt1.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 23/02/2012 Kannan : Merged AnxL (Mask1 & Mask2) filters and AnxM (Mask 1 to 4 & Mask 5 to 9)
//                     Filters from Roland.
//                     Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_AnxL_Anx5M_Masks
//
// 29/02/2012 Stefan/Kannan : AnxM filter Mask 1 - 4, output gain is increased by 18dB;
//                            AnxM filter Mask 5 - 9 Input Gain is reduced by 2dB and output gain
//                            increased by 18dB. This is changed after TxPSD measurement.
//                            Grep for XDSLRTFW-212 Enhancement_US_Plus_ALL_Anx5M_Masks
//
// 29/02/2012 Stefan/Kannan : AnxL Mask 1 filter, Input gain +6.5dB and output gain is +6dB;
//                            AnxL Mask 2 filter, Input Gain +9dB and output gain is +12dB
//                            This is changed after TxPSD measurement.
//                            Grep for Enhancement_US_Bis_ALL_AnxL_Masks
//
// 07/03/2012 Stefan/Sriram : Modified Anx-L Filter coefficients with preshaping included
//                      Anx-L Mask1 Filter Input gain +19.9dB and Output gain 0dB
//                      Anx-L Mask2 Filter Input gain +4.9 and Output gain +5dB
//       Grep for Enhc_US_Bis_ALL_Annex_L_filter
//*****************************************************************************

// #define IIR_BYPASS
#include "STR_Filt.h"
#include "data_alloc.h"
#include "cmv.h"
#include "afe.h"

//uint32 gula_Strymon_TxIir_anxa_poco8dB_Plus[TX_IIR_SIZE]=
// anxa_poco8dB TX 2.2MHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
uint32 gula_AnnexA_TXIIR_Plus[TX_IIR_SIZE] =
{
//XDSLRTFW-3674 New_ShapedTxIIRFilter_changes (start)
#if 1
   26,                                          // number of coefs
   0x342060, 0x20000,                           // IIR_CFG1, 2  registers
   1749,                   // in_scale
   1946613,  -901526,   591334, -1182749,   591415, // section  1
   24309,    -9665,    29202,   -54050,    29202, // section  2
   2065851, -1018171,   553106, -1054623,   501524, // section  3
   504886,  -252296,   791183, -1527316,   791183, // section  4
   1926995,  -903853,  1397826,   545144,  -852682, // section  5
#else
  /* VRX518/adsl/VRX518_Adsl2P_anxa_poco8dB_TX.txt
    * generated 16-Jan-2018 by ger\zukunft */
  // anxa_poco8dB TX 2.2MHz profile fs: 4.4MHz
  // filter includes POFI+Trafo precompensation
  // gain set to 4.28dB; POFI+Trafo has a gain of -4.28dB
  // Target gain at line interface: 0dB up to 80kHz; 3dB at 138kHz
  // Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   31,                                           // number of coefs
   0x350010, 0x70001,                           // IIR_CFG1, 2  registers
   5795,                    // in_scale
   1922335,  -885321,   660304, -1320615,   660311, // section  1
   1022365,  -498405,   268657,  -514530,   246943, // section  2
   2069788, -1021900,   252971,  -468223,   252971, // section  3
   2019543, -1009184,   930335, -1730294,   799960, // section  4
   963497,  -451926,    89412,   174229,    84818, // section  5
   311647,   546217,   747370, -1442738,   747370, // section  6
#endif
//XDSLRTFW-3674 New_ShapedTxIIRFilter_changes (end)
};

#if 0
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
uint32 gula_AnnexA_TXIIR_Plus_2[TX_IIR_SIZE] =
{
   31,      // number of coefs.
   0x352000, 0x80006 ,     //IIR_CFG1, 2  registers
      3769,                // in_scale
   2019540,  -1009182,     76911,        -5,    -76917, // section  1
   1926992,   -903849,    165212,   -305787,    165212, // section  2
   2065825,  -1018145,    555461,  -1110882,    555421, // section  3
    486661,   -225388,    881507,  -1701674,    881507, // section  4
         0,         0,         0,         0,     26771, // section  5
   1756572,   -762160,    921946,  -1724613,    811045, // section  6
};
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
#endif

// TX POTS 276kHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
// uint32 gula_Strymon_TxIir_anxa_poco8dB_Bis[TX_IIR_SIZE]={// anxa_poco8dB TX 1.1MHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
//Refer Matlab file for generating this filter: getVR9Interp_bis.m
uint32 gula_AnnexA_TXIIR_Bis[TX_IIR_SIZE] =
{
//XDSLRTFW-3674 New_ShapedTxIIRFilter_changes (start)
#if 0
   26,                                 // number of coefs
   0x240000, 0x80002,                     // IIR_CFG1, 2 registers
   5002,//3541,//5002,//7065,//9813,                     // in_scale
   1879658,  -999151,   97250,    20623,  -76627, // section   1
   1787740, -863513, 44955,   -20478,  44955, // section  2
   2020752,  -974863,   499447,  -811381,   499447, // section  3
   1519459,  -658387,   971944, -1943889,    971944, // section  4
   420170,  -172741, 774369, -1354813, 774369, // section   5
#else
   /* VRX518/adsl/VRX518_Adsl2_anxa_poco8dB_TX.txt
    * generated 18-Jan-2018 by ger\zukunft */
   // anxa_poco8dB TX 1.1MHz profile fs: 2.2MHz
   // filter includes POFI+Trafo precompensation
   // overall gain = 9.59dB; output boosted by 5.3dB
   // Target PSD at line interface is flat up to 80kHz and has an attenuation of 3dB at 138kHz
   // Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
   31,                                          // number of coefs
   0x252000, 0x10080,                           // IIR_CFG1, 2  registers
   20793,                  // in_scale
   1819303,  -946949,   910132, -1593839,   683709, // section  1
   1759206,  -752399,    38886,   -37220,    38886, // section  2
   2041772,  -995911,  1048428, -1917164,   884908, // section  3
   425078,  -187791,    13996,   -20781,    13996, // section  4
   1994021,  -947980,   581205, -1162416,   581211, // section  5
   0,     2532,   855757,  1694609,   838851, // section  6


#endif
//XDSLRTFW-3674 New_ShapedTxIIRFilter_changes (end)
};

// TX POTS 276kHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
// uint32 gula_Strymon_TxIir_anxa_poco8dB_Bis[TX_IIR_SIZE]={// anxa_poco8dB TX 1.1MHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
//Refer Matlab file for generating this filter: getVR9Interp_bis.m
// IOP issues observed with new filter against E67 DSLAM so using the original filter with CNXT
//http://trex.lantiq.com/results/folder/200364/flexit2/
//XDSLRTFW-3674 CNXT_E67_IOP_Txfilter_changes (start)
uint32 gula_AnnexA_TXIIR_Bis_CNXT[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x240000, 0x80002,                     // IIR_CFG1, 2 registers
   5002,//3541,//5002,//7065,//9813,                     // in_scale
   1879658,  -999151,   97250,    20623,  -76627, // section   1
   1787740, -863513, 44955,   -20478,  44955, // section  2
   2020752,  -974863,   499447,  -811381,   499447, // section  3
   1519459,  -658387,   971944, -1943889,    971944, // section  4
   420170,  -172741, 774369, -1354813, 774369, // section   5

};
//XDSLRTFW-3674 CNXT_E67_IOP_Txfilter_changes (end)
//XDSLRTFW-212 Feature_US_BisPlus_ALL_AnxL_Anx5M_Masks (START)
//Enhancement_US_Bis_ALL_AnxL_Masks (START)
//"uint32 gula_AnnexL_TXIIR[TX_IIR_SIZE]" is being replaced
//with Mask1 & Mask2 filters.
//Annex-L Mask 1:
//TxIIR-Input:    +19.9dB; Done at in_scale; 20*log10(28902/2929) = +19.9dB
//                        Note: 2929 was there earlier, from this, input gain
//                        is increased to 19.9dB.
//TxIIR-Output:      +0dB; Done at IIR_CFG2, changed val from 0xC0000 to 0x00000
//Each left shift in bits (19:16) at IIR_CFG2 gives 6dB

// VR9_anxl1_comp80Trafo_bis_Adsl2_TX.txt
// generated 05-Mar-2012 by zukunft
// Enhc_US_Bis_ALL_Annex_L_filter(Start)
uint32 gula_AnnexL_TXIIR_Mask1[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x241000, 0x70002,                  // IIR_CFG1, 2  registers
   5374, //5693,                       // in_scale
   1963653, -1010820,    48992,   -47200,     48992, // section  1
   1882344,  -905474,    97439,    20663,    -76776, // section  2
   2009849,  -964765,   735693, -1471386,    735693, // section  3
    891057,  -383990,   733138, -1361255,    733138, // section  4
    379865,  -164597,   944252, -1682783,    944252, // section  5
 };
// Enhc_US_Bis_ALL_Annex_L_filter(End)

//Annex-L Mask 2:
//TxIIR-Input:    +4.9dB; Done at in_scale; 20*log10(13239/7445) = +4.9dB
//                        Note: 7445 was there earlier, from this, input gain
//                        is increased by 4.9dB.
//TxIIR-Output:      +5dB; Done at IIR_CFG2, changed val from 0xA0010 to 0x50010
//Each left shift in bits (19:16) at IIR_CFG2 gives 6dB
// Enhc_US_Bis_ALL_Annex_L_filter(Start)
uint32 gula_AnnexL_TXIIR_Mask2[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x240010, 0x50000,                  // IIR_CFG1, 2 registers
   6199,                               // in_scale
   1911197,  -874991,   702652, -1405304,    702652, // section  1
   1004925,  -482383,   412825,    87545,   -325280, // section  2
   1519459,  -658387,   356998,  -696342,    356998, // section  3
   2041708, -1026149,   337599,  -649480,    337599, // section  4
   1985445,  -962042,  1277557, -2016207,   1277557, // section  5
};
// Enhc_US_Bis_ALL_Annex_L_filter(End)
//Enhancement_US_Bis_ALL_AnxL_Masks (START)
//XDSLRTFW-212 Feature_US_BisPlus_ALL_AnxL_Anx5M_Masks (END)

//************** 5M filter from Roland *******************************
/*
------------------------------------------------------------------------
Inverse Hpoco T/F: cpe_adsl2p_anxa_poco8dB.m, POFI: 80KHz, 8dB
fom = 0.0460169855;
b = [3.003477885682, -4.555889324312,  1.661503703196];
a = [1.000000000000, -1.483695380561, 0.589929110446];

[bhp,ahp]=butter(2, 0.8*6/512,'high');
[blp,alp]=ellip(6,.01,60, 36*0.92/512);
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));
b = b*(10^(6/20));

M=1024; direction='TX'; name1 = 'Adsl2pAnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_A');
------------------------------------------------------------------------
*/
uint32 gula_Strymon_TxIir_5M_Low[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x343000, 0x50001,                     // IIR_CFG1, 2 registers
   6089, //4091, //4186,   //6089                  // in_scale
   1989363,  -995292,   381283,  -578357, 210923, // section   1
   1891286, -883223,    9725,    -7789,   9725, // section  2
   2053483, -1005798,   717233, -1434466,   717233, // section  3
   226284,   -98250,    649510, -1209003,    649510, // section  4
   777884,  -309293, 866951, -1531222, 866951, // section   5
};
/*
------------------------------------------------------------------------
Inverse Hpoco T/F: cpe_adsl2p_anxa_poco8dB.m, POFI: 160KHz, 8dB
fom = 0.1795855949;
b = [0.764575899760,   0.136363230093,   -0.628212670030];
a = [1.000000000000,     -1.217007707974,      0.485497861806];

[bhp,ahp]=butter(2, 0.8*6/512,'high');
[blp,alp]=ellip(6,.01,70, 44*0.92/512);
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

b = b*(10^(10/20));
M=1024; direction='TX'; name1 = 'Adsl2pAnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_A');
------------------------------------------------------------------------
*/
uint32 gula_Strymon_TxIir_5M_Medium[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x340000, 0x50008,                     // IIR_CFG1, 2 registers
   7330, //7500,  //9843,                    // in_scale
   1945029,  -978243,   95352,    17006,  -78346, // section   1
   1835014, -844238,    3254,    -204,    3254, // section  2
   2053483, -1005798,   118125,  -203288,   118125, // section  3
   1760277,  -744652,   636764, -1273527,    636764, // section  4
   4985,    -1989,   890689, -1363744, 890689, // section   5
};

/*
---------------------------------------------------------------------------
POFI: 160KHz, 8dB

b = [0.764575899760,  0.136363230093, -0.628212670030];
a = [1.000000000000, -1.217007707974, 0.485497861806];

[bhp,ahp]=butter(2, 0.8*6/512,'high');
[blp,alp]=ellip(6,.1,70, 54*0.92/512);
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

b = b*(10^(10/20));

M=1024; direction='TX'; name1 = 'Adsl2pAnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_A');
---------------------------------------------------------------------------
*/

uint32 gula_Strymon_TxIir_5M_Medium2[TX_IIR_SIZE] = {
   26,                                 // number of coefs
   0x340000, 0x60004,                     // IIR_CFG1, 2  registers
   5890,                   // in_scale
   1936764,  -992292,   89862,   16027,   -73835, // section  1
   1859667,  -878881,   5629,    -172,    5629, // section  2
   2053483, -1005798,   570770,  -860001,   570770, // section  3
   1276125,  -509081,   712772, -1425543,   712772, // section  4
   113059,   -49250,    963575, -1637223,    963575, // section  5
};


/*
---------------------------------------------------------------------------
cpe_adsl2p_anxm59_poco8dB_pofi160.m: POFI: 160KHz, 8dB

b = [0.764575899760,  0.136363230093, -0.628212670030];
a = [1.000000000000, -1.217007707974, 0.485497861806];

[bhp,ahp]=butter(2, 0.8*6/512,'high');
[blp,alp]=ellip(6,.1,70, 60*0.92/512);
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

b = b*(10^(10/20));

M=1024; direction='TX'; name1 = 'Adsl2pAnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_A');
---------------------------------------------------------------------------
*/
uint32 gula_Strymon_TxIir_5M_High[TX_IIR_SIZE] = {
   26,                                 // number of coefs
   0x344000, 0x50000,                     // IIR_CFG1, 2 registers
   7268, //7438, //10820,                    // in_scale
   1907206,  -986480,   101496,    18102, -83394, // section   1
   1827763, -862107,    5533,    1014,    5533, // section  2
   2053483, -1005798,   686860, -1373719,   686860, // section  3
   111115,   -47686, 1051383, -1717701,   1051383, // section  4
   1276125,  -509081,   904003, -1271296, 904003, // section   5
};

/*
-------------------------------------------------------------------------
AFE POCO: 80KHz, 8dB
fom = 0.1679541075;
//Refer file: cpe_adsl2_anxa_poco8db.m shared by Roland for the following b, a of inverse Hpoco
b = [0.443458679627,  0.094041328560,  -0.349417350452];
a = [1.000000000000,      -1.449068693004,     0.627886934404];

[bhp,ahp]=butter(2,.8*6/256,'high');
[blp,alp]=ellip(6,.1,55, 36/256); % 55 dB because of mirror frequencies; tone 42 as a good compromise -> 32
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

%13dB more
b = b*10^(10/20);

M=512; direction='TX'; name1 = 'Adsl2AnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_M');
-------------------------------------------------------------------------
*/
//Stored in the HW at: 0x304000-0x30407B mrd 0x304000 100
uint32 gula_Strymon_TxIir_3M_Low[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x240000, 0x60002,                     // IIR_CFG1, 2 registers
   12987, //14843,                     // in_scale
   1817984,  -981938,   122139,    25901, -96238, // section   1
   1729902, -827566, 87899,   13940,   87899, // section  2
   1519459,  -658387,   113898,  -158043,   113898, // section  3
   2009849,  -964765,   1042624, -2085248,   1042624, // section  4
   414560,  -168299,  1188344, -1904023,  1188344, // section  5
};

/*
-------------------------------------------------------------------------
AFE POCO: 80KHz, 8dB
fom = 0.1679541075;
//Refer file: cpe_adsl2_anxa_poco8db.m shared by Roland for the following b, a of inverse Hpoco
b = [0.443458679627,  0.094041328560,  -0.349417350452];
a = [1.000000000000,      -1.449068693004,     0.627886934404];

[bhp,ahp]=butter(2,.8*6/256,'high');
[blp,alp]=ellip(6,.1,55, 44/256); % 55 dB because of mirror frequencies; tone 42 as a good compromise -> 32
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

b = b*10^(16/20);  //6dB more as compared to above because IFFT shift cutback from mask3 onwards

M=512; direction='TX'; name1 = 'Adsl2AnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_M');
-------------------------------------------------------------------------
*/
//Stored in the HW at: 0x304000-0x30407B mrd 0x304000 100
uint32 gula_Strymon_TxIir_3M_Medium[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x240000, 0x70003,                        // IIR_CFG1, 2  registers
   16368, //21237,                     // in_scale
   1705443, -969128,   149833,   31774,  -118059, // section  1
   1622880,  -787333,    95670,  53702,    95670, // section  2
   1519459,  -658387,   76479,   -87058,     76479, // section  3
   2009849,  -964765,   787611, -1575221, 787611, // section   4
   195551,  -75971,   785827, -1120239,   785827, // section  5
};

/*
-------------------------------------------------------------------------
AFE POCO: 320KHz, 8dB
fom = 0.1700032158;
//Refer cpe_adsl2_anxm59_poco8dB_pofi320.m (shared by Roland) for the following b, a inverse of Hpoco
b = [0.450997129173     0.343404272465      -0.107592856533];
a = [1.000000000000      -0.744515404002      0.423260567257];


[bhp,ahp]=butter(2,.8*6/256,'high');
[blp,alp]=ellip(6,.1,55, 56/256); %
b=conv(b,conv(blp,bhp));
a=conv(a,conv(alp,ahp));

%13dB more
b = b*10^(16/20);

M=512; direction='TX'; name1 = 'Adsl2AnnexA_preshape.txt';
quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_M');
-------------------------------------------------------------------------
*/
uint32 gula_Strymon_TxIir_3M_High[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x240000, 0x50004,                     // IIR_CFG1, 2 registers
   22030, //31817,                     // in_scale
   1508398,  -951769,   145744,   110975, -34770, // section   1
   1449021, -733080, 13544,   13462,   13544, // section  2
   2009849,  -964765,   565588,  -419455,   565588, // section  3
   780681,  -443821,    900358, -1800716,    900358, // section  4
   89051,   -32440,  1345369, -1512440,  1345369, // section   5
};

// 2x interp: Ellip 11 th order 8th order LPF passband Tone 26 , 78dB stopband + 3th order HPF
// Format: inScale, [a2,a1,b2,b1,b0],,,[a2,a1,b2,b1,b0],outScale
// TX POTS 276kHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
uint32 *gula_Strymon_TxIir_Pots_Plus = gula_AnnexA_TXIIR_Plus;


// TX POTS 276kHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
uint32 *gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis;

