/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*  Aware DMT Technology. Proprietary and Confidential.
*
*  40 Middlesex Turnpike, Bedford, MA 01730-1413
*  Phone (781) 276 - 4000
*  Fax   (781) 276 - 4001
*
*  filename: STR_Filt_TxInt1_isdn.c
*   Description: This file is INCLUDED by STR_FILT.c it holds the txinterpolator for Annex B mode.
*
*  14/06/2013 Naveen: New Strymon Tx IIR filter designed for Annex 5J Mask 1 to 4
*                    PSD is also tuned appropriately.
*            Grep for XDSLRTFW-803 Perf_DS_Plus_ALL_NewTxIIR_5JMask1to4_PSD
*
*-------------------------------------------------------------------------------
*/

#include "STR_Filt.h"
#include "data_alloc.h"
#include "cmv.h"
#include "afe.h"


/* Filters/VRX518/VRX518_Adsl2P_anxb_poco8dB_TX.txt
* generated 05-Jan-2017 by zukunft */
uint32 gula_AnnexB_TXIIR_Plus[TX_IIR_SIZE] =
{
// anxb_poco8dB TX 2.2MHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
    31,// number of coefs
    0x350100, 0x70001,                          // IIR_CFG1, 2  registers
    11716, //16735                  // in_scale
    1875681,  -850668,   727892, -1446602,   727892, // section  1
    2026993, -1004150,   921596, -1840689,   921596, // section  2
    896096,  -390890,    44530,    14321,   -30209, // section  3
    1935383, -1016346,   924155, -1510507,   924155, // section  4
    478653,  -189140,    37526,   -16723,    37526, // section  5
    1900479,  -936482,   785270, -1385000,   785270, // section  6
};


// ------------------------------------------------------------- //
// TX ISDN 276kHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
uint32 gula_AnnexB_TXIIR_Bis[TX_IIR_SIZE] =
{
   31,   // number of coefs
#if 0 //Given by Roland
   0x250000, 0x20000,      // IIR_CFG1, 2  registers
   251466,              // in_scale
#else //modified for the required PSD level
    0x250000, 0x30000,     // IIR_CFG1, 2 registers
    251466,             // in_scale
#endif
   756047,  -446686,    424649,  -845524,    424649, // section  1
   1852540,  -936599,   152767,   120316, -32450, // section   2
   1425694, -711552,   133268,   -50357,   133268, // section  3
   1435148,  -523503,   952162, -1861681,   952162, // section  4
   1466125,  -936743,   146233,   188495,    146233, // section  5
   1334952,  -490011,  1114763,  -954268,  1114763, // section 6
};


uint32 gula_AnnexJ_TXIIR_512[TX_IIR_SIZE] =
{
    21,         // number of coefs.
    0x233020, 0x0 ,         //IIR_CFG1, 2  registers
    59060,                     // in_scale
    1519934,   -589197,    866455,  -1691611,    866455, // section  1
    271156,    -88727,     42706,    -13192,     42706, // section  2
    1900508,   -950496,    565326,  -1125009,    565326, // section  3
    146035,    -98062,    799807,    937301,    799807, // section  4
    0, 0, 0, 0, 0,
    0, 0, 0, 0, 0,
};

//ADSL2+ Annex J mask 1 to 9 filters info.:
  //Note: POFI filter transfer fucntion changes w.r.to cutoff (80, 160, 320,..),
  //      but not changes with the POCO gain
  //Mask 1 to 3: For these masks filter designed with fc@160KHz, POFI@160kHz
  //Mask 4: For this mask filter designed with fc@190KHz, POFI@320kHz
  //Mask 5: For this mask filter designed with fc@207KHz, POFI@320kHz
  //Mask 6 to 7: For these masks filter designed with fc@241.5KHz, POFI@320kHz
  //Mask 8 to 9: For this mask filter designed with fc@259KHz, POFI@320kHz

//ADSL2+ Filter design info.:
//  Get inverse of POFI transfer function represented as IIR filter: b,a
//    -refer b, a for 160kHz annex J/B: cpe_adsl2p_anxj9_poco8dB_pofi160.m
//    -refer b, a for 320kHz annex J/B: cpe_adsl2p_anxb_poco8dB.m
//    Design LPF with the required cutoff:
//      [blp,alp]=ellip(Nth order,passband ripple,stop band attn,cutoff/(Fs/2));
//      Ex.: [blp,alp]=ellip(8,0.1,80, (160e3)/(4.408e6/2));
//  Make the above 2 filters to one by doing the convolution as follows:
//         b=conv(b,blp);   a=conv(a,alp);
//  Get the final filter in the required HW form by calling the following:
//    -quantize_strymon_iir_coefs(b,a,M,'vrx518',name1,direction,'anx_j');
//  Note:
//    After designing the filter the gain of the filter can be adjusted as follows:
//       -bit shift in IIR CFG2 register bit 16 to bit 19 (shift done on o/p of the filter)
//       -the inscale value (this one is filter input level)

//Adsl2+ POFI@320KHz, IIR Fc= 259e3 annexJ Mask 8 and 9
//    -AnnexJMask8_9Adsl2p_preshape.txt * generated 09-Mar-2017 by gar\amaramad
uint32 gula_AnnexJ_TXIIR_1024[TX_IIR_SIZE] =
{
   26,                              // number of coefs
   0x340000, 0x60000,                     // IIR_CFG1, 2  registers
   6481,                // in_scale
   1877122,  -945554,   119439,  -207404,   119439, // section  1
   1919649, -1016814,   473934,  -791310,    473934, // section  2
   1839381,  -859833,   62957,    16591,  62957, // section 3
   1812156, -790174,   514316,   165406,  -348909, // section  4
   957305,  -378279,   792077, -1107333,   792077, // section  5
};

//Adsl2+ POFI@320KHz, IIR Fc= 160e3 Mask 1, 2 and 3
//  -AnnexJMask1_2_3Adsl2p_preshape.txt  * generated 09-Mar-2017 by gar\amaramad
uint32 gula_Strymon_TxIir_5J_Low[TX_IIR_SIZE] =
{
   26,                                          // number of coefs
   0x340010, 0x40000,                           // IIR_CFG1, 2  registers
   5288,                   // in_scale
   1919479,  -881453,  1084975, -2027777,  1084975, // section  1
   638354,  -256240,   205074,  -358888,   205074, // section  2
   2020732, -1028542,   289344,  -548770,   289344, // section  3
   1948720,  -927340,    32899,   -22495,    32899, // section  4
   1985886,  -982997,  1542165,   278470, -1263695, // section  5
};

//Adsl2+ POFI@320KHz, IIR Fc= 190e3 Mask 4
//  -AnnexJMask4_Adsl2p_preshape.txt  * generated 09-Mar-2017 by gar\amaramad
uint32 gula_AnnexJ4_TXIIR_1024[TX_IIR_SIZE] =
{
   26,                              // number of coefs
   0x340000, 0x70000,                     // IIR_CFG1, 2  registers
   13023,                  // in_scale
   1916898,  -906293,   189964,  -352426,   189964, // section  1
   1994280, -1024918,   179374,  -296900,    179374, // section  2
   1886805,  -852923,   23455,    -8471,  23455, // section   3
   1955957, -971368,   587029,   188791,  -398238, // section 4
   957305,  -378279,   733380, -1332581,   733380, // section  5
};

//Adsl2+ POFI@320KHz, IIR Fc= 207e3 Mask 5
//  -AnnexJMask5_Adsl2p_preshape.txt  * generated 09-Mar-2017 by gar\amaramad
uint32 gula_AnnexJ5_TXIIR_1024[TX_IIR_SIZE] =
{
   26,                              // number of coefs
   0x340000, 0x30001,                     // IIR_CFG1, 2  registers
   7529,                // in_scale
   1937807,  -964885,   270189,  -482072,   270189, // section  1
   1868355,  -837102,   14997,   -2863,   14997, // section  2
   1977658, -1022890,   707764, -1294457, 707764, // section   3
   1898351, -894596,   709214, -1132183,   709214, // section  4
   478653,  -189140,  1692652,   544365, -1148287, // section  5
};

//Adsl2+ POFI@320KHz, IIR Fc= 241.5e3 Mask 6 and 7
//  -AnnexJMask6_7Adsl2p_preshape.txt  * generated 09-Mar-2017 by gar\amaramad
uint32 gula_AnnexJ6_7_TXIIR_1024[TX_IIR_SIZE] =
{
   26,                                 // number of coefs
   0x340000, 0x20000,                     // IIR_CFG1, 2 registers
   10099,                     // in_scale
   1898399,  -951974,   119174,  -210886, 119174, // section   1
   1940361, -1018836,   472632,  -808424,   472632, // section  2
   1859597,  -871362,   282485,  -414551,   282485, // section  3
   1831034,  -805728,   533022,   171423, -361600, // section  4
   957305,  -378279,  1431366,   174607,  1431366, // section  5
};


// XDSLRTFW-803 Perf_DS_Plus_ALL_NewTxIIR_5JMask1to4_PSD (End)

// 2x interp for annex B: 11th order ->6 LPf + 5 HPF + .75 dB preemphasis
//    [b1,a1]=ellip(5,.1,58,.9*32/128,'high');
//    [b2,a2]=ellip(6,.1,63,.5*.92);
//    b_inverse_droop =   [12 -1]';
// Format: inScale, [a2,a1,b2,b1,b0],,,[a2,a1,b2,b1,b0],outScale

// ------------------------------------------------------------- //
// TX ISDN 276kHz profile fs: 4.4MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]
uint32 *gula_Strymon_TxIir_Isdn_Plus = gula_AnnexB_TXIIR_Plus;


// ------------------------------------------------------------- //
// TX ISDN 276kHz profile fs: 2.2MHz
// Format: _IIR1_CFG  _IIR2_CFG ,inScale, [a1,a2,b0,b1,b2],,,[a1,a2,b0,b1,b2]

uint32  *gula_Strymon_TxIir_Isdn_Bis = gula_AnnexB_TXIIR_Bis;
