/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Ini.c
;
;  Strymon CPE core Initialization
;
*****************************************************************************/

//*******************************************************************
// STR_Ini.c
//
// History
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline. Use Annex-B filters in oISDN binary.
//          Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
//
// 24/01/2013 Kannan:
//          Initialize the V_SRC_CFG_ADDR before configuring the Tx Interpolator, since
//          Tx Interpolation filter configuration uses the SRC configuration
//          as one of the input. This issue was noticed while verifying the
//          AFE & DFE configrations before giving CNTL 0 0 2,
//          FW expects all the HW registers & FW variables must be initialized as
//          per Bis mode before CNTL 0 0 2. But observed that interpolation filter loaded(before
//          giving CNTL 0 0 2) was Plus mode instead of Bis mode. This is due to
//          SRC was not configured before interpolator configuration.
//   Grep for "XDSLRTFW-558: Bug_US_ALL_ALL_TxInterpolatorConfiguration_BeforeLinkStart"
//
//
// 25/03/2013 Kannan:
//          1. Initialize the Uninitialized Strymon registers with their reset
//             values.
//             Grep for "XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues "
//*****************************************************************************

#include "common.h"
#include "gdata.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_ini.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "ec_data.h"
#include "pll.h"

//#define STR_BYPASS

// Constant SRC FR offset value. crystal @ 36 MHz. CPE @ 35.328 MHz;
#define VR9_SRC_FREQ_OFFSET_FOR36MHz   (0x4C756)  // 20 bit field.


#ifndef TARGET_HW
extern uint32 gula_PackedSRCCoeffs_4KHz[3072];
#endif

//int16 gs_SERDESLOOP = 1<<8 ;
int16 gs_SERDESLOOP = 0 ;
/****************************************************************************
; Name: Config_StrymonCPE
;
; Prototype:
;  void Config_StrymonCPE(void)
;
; Description:
;  This function configures the Strymon CPE by performing the
;  following steps:
;
;  1) the processing mode of the core is specified by setting the
;     sample rate field for each strymon block;
;  2) the Tx IIR and Interp FIR
;     Rx IIR and Decim FIR filter are initialized appropriately
;     for the selected sample rates;
;  3) the impulse response of the TDQ is set to a unit impulse;
;  4) the outputs of the DEC and AEC are masked to zero;
;  5) the SRC output scaling is initialized appropriately for the selected sample rates;
;  6) the Rx SRC phase offset is initialized to zero.
;  7) the SRC is set to operate at the nominal sample rates.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gt_StrymonCPE_FilterTable  (I)   data structure of filter parameters
*****************************************************************************/

void Config_StrymonCPE(void)
{
   uint32 ul_data = 0, ul_TxIfftRate, ul_RxFftRate;
   int i;

   //Strymon common control
   //-----------------------------------------------------------------------------------------------------------
   // Hold Strymon in Reset until the configuration is complete
   //-----------------------------------------------------------------------------------------------------------
   WriteCoreReg((uint32) V_CONTROL_ADDR, 0);

    //VControl  enable LPBK
   //Configure DAC sampling rate to 144 MSPS (this actually doesn't matter for lpbk mode)
   //Configure ADC sampling rate to 144 MSPS (this actually doesn't matter for lpbk mode)
   if(gft_StrymonLpbkMode == STR_TX_RX_LPBK)
      ul_data = (STR_LPBK_ENA|RX_ADC_RATE|TX_DAC_RATE|TX_UPD_SEL|RX_UPD_SEL);
   else
      ul_data = (RX_ADC_RATE|TX_DAC_RATE|FIFO_FORCE);

   WriteCoreReg((uint32)(V_CONTROL_ADDR), ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //skip V_BLOCK_RSTN
   //V_BLOCK_RSTN is being reset & set in different block initialization like Tx IIR filter loading.

   //V_OVERFLOW
   WriteCoreReg((uint32)(V_OVERFLOW_ADDR), 0x1FFFF);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)

   /****************************************************************************/
   /* Initialize  TXIIR                                        */
   /****************************************************************************/
   //Clear TX IIR coefficient memory
   FillCoreBuf32((uint32)V_TXIIR_CO_ADDR, (int32)0, (uint16)(V_TXIIR_CO_SIZE/4));

#ifdef ISDN
   if (gs_RxFftLength ==512)
      gs_TxIIRFilterSelect = TXIIR_ISDN_BIS;
   else
        gs_TxIIRFilterSelect = TXIIR_ISDN_PLUS;
#else
   if (gs_RxFftLength ==512)
      gs_TxIIRFilterSelect = TXIIR_POTS_BIS;
   else
      gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
#endif


   LoadTxIir();


   /****************************************************************************/
   /* Initialize  RXIIR                                        */
   /****************************************************************************/
   //Clear RX IIR coefficient memory
   FillCoreBuf32((uint32)V_RXIIR_CO_ADDR, (int32)0, (uint16)(V_RXIIR_CO_SIZE/4));

#ifdef ISDN
   if (gs_RxFftLength == 512)
      gs_RxIIRFilterSelect = RXIIR_ISDN_BIS;
   else
      gs_RxIIRFilterSelect = RXIIR_ISDN_PLUS;
#else
   if (gs_RxFftLength ==512)
      gs_RxIIRFilterSelect = RXIIR_POTS_BIS;
   else
      gs_RxIIRFilterSelect = RXIIR_POTS_PLUS;
#endif


   LoadRxIir();

   /****************************************************************************/
   /* Initialize Interp_FIR                                       */
   /****************************************************************************/
   // Set the input sampling rate (= 144/(8-IN_RATE))
   ul_data = (gs_RxLog2FftLength1 - 5)<<20; //=IN_RATE<<20
   // Set interolation factor (= (1<<INTERP_FACTOR))
   ul_data |= (12-gs_RxLog2FftLength1);   //= INTERP_FACTOR
   WriteCoreReg((uint32)(V_INTERP_CFG_ADDR), ul_data);

   //XDSLRTFW-558 Bug_US_ALL_ALL_TxInterpolatorConfiguration_BeforeLinkStart (Start)
   //Initialize the V_SRC_CFG_ADDR before configuring the Tx Interpolator, since
   //Tx Interpolation filter configuration uses the SRC configuration
   //as one of the input. This issue was noticed while verifying the
   //AFE & DFE configrations before giving CNTL 0 0 2,
   //FW expects all the HW registers & FW variables must be initialized as
   //per Bis mode. But observed that interpolation filter loaded(before
   //giving CNTL 0 0 2) was Plus mode instead of Bis mode. This is due to
   //SRC was not configured before interpolator configuration.
   /****************************************************************************/
   /* Initialize SRC  Output Scale factor.                              */
   /****************************************************************************/
   //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
   ul_data = (gs_RxLog2FftLength1-6)<<20; //= IN_RATE<<20
   //Set TX and RX in bypass mode and set the SRC interp and decim factor
   //SRC_FACTOR is 2 for all the mode, but 30a profile
   //Fixme; SRC now in bypass mode
   ul_data |= SRC_FACTOR;

   ul_data |= (0x7 << 4); //set Rx scaling to 1/2 for overall gain of 1.
   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);
   //XDSLRTFW-558 Bug_US_ALL_ALL_TxInterpolatorConfiguration_BeforeLinkStart (END)


   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // this part of the code is called only in LinkStartForTest.c
   Config_Interp1(gl_SelectedMode);

   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

   /****************************************************************************/
   /* Initialize Decim_LPF                                        */
   /****************************************************************************/
    // set the sampling rate and decimation factor
   if(gft_StrymonLpbkMode == STR_TX_RX_LPBK)
   {
      // Set the output sampling rate = input sampling rate/(1<<RX_DECIM_FACTOR)
      ul_data = (12 - gs_RxLog2FftLength1) << 24; //RX_DECIM_FACTOR <<24
      // Set the decimation filter input sample rate and
      // the input sample rate is fixed at 72 MSPS in the lpbk mode
      ul_data |= (RX_DECIM_IN_RATE_72);
   }
   else
   {
      // Set the output sampling rate = input sampling rate/(1<<RX_DECIM_FACTOR)
      ul_data = (13 - gs_RxLog2FftLength1) << 24; //RX_DECIM_FACTOR <<24
      // Set the decimation filter input sample rate and bypass mode
      // the input sample rate is fixed at 72 MSPS in the lpbk mode
      ul_data |= (RX_DECIM_IN_RATE_144);
   }
   WriteCoreReg((uint32)(V_DECIM_CFG_ADDR), ul_data);
   LoadDecim();


   /****************************************************************************/
   /* Initialize DEC - initial coefficient values are arbitrary.           */
   /****************************************************************************/
    //first detect the chip version (v1.4 interpdec)
   SetCoreReg((uint32)V_DEC_CFG_ADDR, MASK_BIT7);
   ReadCoreReg((uint32)V_DEC_CFG_ADDR, &ul_data);
   gft_V14 = (ul_data&MASK_BIT7)>>7;
   ResetCoreReg((uint32)V_DEC_CFG_ADDR, MASK_BIT7);

   // The DEC input rate is 2.2MHz or 4.4MHz
   // The DEC upsampling rate is 1x for CPE
   // The DEC Length Field (bits 7-0) are programmed to (dec length/8 - 1)
   // Set DEC input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
    ul_data = (gs_TxLog2FftLength1_Oversample - 6) << 24;   //DEC_IN_RATE<<24
    WriteCoreReg((uint32)V_DEC_CFG_ADDR, ul_data);
   //clear dec-tdq coefficients
   FillCoreBuf32(V_DEC_TDQ_CO_ADDR, 0, (V_DEC_TDQ_CO_SIZE>>2));
   //load unity DEC
   gs_pre_dec_h_exp = 1;
   gs_pre_dec_h_delay  = 0;
   gsa_pre_dec_h[0] = 0x4000;
   for(i=1; i<gs_DEC_ORDER; i++)
      gsa_pre_dec_h[i] = 0;
   LoadDEC();

   /****************************************************************************/
   /* Initialize TDQ - initialize to unit impulse.                      */
   /* NOTE: The offset in Strymon memory where the TDQ coefficients are stored   */
   /* depends on the length and the upsampling factor of the DEC. If either of */
   /* those parameters change the TDQ coefficients may have to be reloaded.   */
   /****************************************************************************/
    /* Set TDQ to UnityTdq. */
   gsa_pre_tdq_h[0] = 0x4000;
   for (i=1; i<gs_TDQLen; i++)
   gsa_pre_tdq_h[i] = 0;
   gs_pre_tdq_h_exp = 14;
   LoadTDQ();
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //V_DEC_CAPTURE
   WriteCoreReg((uint32)(V_DEC_CAPTURE_ADDR), 0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)

   //skip V_ADAPT_CTRL
    //This is being initialized as a prt of TDQ init
   /****************************************************************************/
   /* Initialize Tx Gain.                                         */
   /****************************************************************************/
   LoadTxSineGain();

   /****************************************************************************/
   /* Initialize Rx Variable Gain to unity (coef = 0x4000, scale = 1)         */
   /****************************************************************************/
// ul_data = 0x4000;
   ul_data = 0x4000;
   ul_data |= (1<<16);
   WriteCoreReg((uint32)(V_RX_VARGAIN_ADDR), ul_data);
   gt_vrx5dfe_dsl_config.ul_RxVarGain = ul_data;
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //V_ADC_ADJUST
   WriteCoreReg((uint32)(V_ADC_ADJUST_ADDR), 0x1000);

   //V_FRAME_SKEW
   WriteCoreReg((uint32)(V_FRAME_SKEW_ADDR), 0x0);

   //V_TX_EXTEN_ADDR
   WriteCoreReg((uint32)(V_TX_EXTEN_ADDR), 0x0);

   //V_TX_EXTEN_A_ADDR
   WriteCoreReg((uint32)(V_TX_EXTEN_A_ADDR), 0x0);

   //V_TX_BETA_ADDR
   WriteCoreReg((uint32)(V_TX_BETA_ADDR), 0x0);

   //V_TX_BETA_A_ADDR
   WriteCoreReg((uint32)(V_TX_BETA_A_ADDR), 0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   /****************************************************************************/
    /*   set IFFT size and sampling rate
   ****************************************************************************/
   //Set IFFT size
   ul_data = gs_TxFftLength_Oversample;

   //Set IFFT sampling rate (= 141.312/(1<<(8-IFFT_RATE)
   ul_TxIfftRate = (gs_TxLog2FftLength1_Oversample - 6)<<16;   //= IFFT_RATE << 16
   ul_data |= ul_TxIfftRate;

    WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
    WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //V_FSOFFSET_IN
   WriteCoreReg((uint32)(V_FSADDR_IN_ADDR), 0x0);

   //V_FSOFFSET_ER
   WriteCoreReg((uint32)(V_FSADDR_ER_ADDR), 0x0);

   //V_RX_EXTEN_ADDR
   WriteCoreReg((uint32)(V_RX_EXTEN_ADDR), 0x0);

   //V_RX_EXTEN_A_ADDR
   WriteCoreReg((uint32)(V_RX_EXTEN_A_ADDR), 0x0);

   // ------------- Configure RX window length  --------------------

   WriteCoreReg((uint32)(V_RX_WSIZE_ADDR), (uint32)RX_WINDOW_LEN);
   WriteCoreReg((uint32)(V_RX_WSIZE_A_ADDR), (uint32)0x0);  //Initialization
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   //------------ set FFT size and sampling rate ------------------
   //Set FFT size
   ul_data = gs_RxFftLength;

   //Set FFT sampling rate (=141.312/(1<<(8-FFT_RATE))
   ul_RxFftRate = (gs_RxLog2FftLength1-6)<<16; //FFT_RATE<<16
   ul_data |= ul_RxFftRate;

    WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
    WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);

   //Configure Strymon/AFE interface register
   WriteCoreReg((uint32)(V_SERDES_XBAR_ADDR), (uint32)guc_ch_id);




#ifndef TARGET_HW
   {

   WriteCoreBuf32(V_RXSRC_B00_ADDR, (int16 *)&gula_PackedSRCCoeffs_4KHz[0], 3072);
   WriteCoreBuf32(V_TXSRC_B00_ADDR, (int16 *)&gula_PackedSRCCoeffs_4KHz[0], 3072);

   }
#else
   // In The Target HW the coefs:
   // The boot loader will use the XDMA to directly move the coefs from the offchip
   // page to the Strymon memory as a data boot page.
   // Then the coefficients are DMAed to Strymon memory for TX SRC
   WriteCoreBuf32(V_TXSRC_B00_ADDR, (int16*)V_RXSRC_B00_ADDR, (uint32)3072);

#endif
   /****************************************************************************/
   /* Initialize Rx SRC.V_SRCFR amd V_SRCCTL                                     */
   /****************************************************************************/
#ifdef TARGET_HW
   ul_data = VR9_SRC_FREQ_OFFSET_FOR36MHz; //
#else
    ul_data = 0; // no freq offset when running in cocomo.
#endif
   WriteCoreReg(V_SRCFR_ADDR, ul_data);

   WriteCoreReg(V_SRCCTL_ADDR, 0); // no phase offset.

   // ----------- Configure HB Filter ---------------------------------------
   //Input sampling rate is fixed at 72 MSPS
   //the sampling rate = 144/(1<<(8-TX_HBFILT_IN_RATE))
   //WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), (uint32)(TX_HBFILT_IN_RATE));
   WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), (uint32)((TX_HBFILT_IN_RATE) |(1<<28)));

   //Configured in AFE in VR9_SSC_init()
   //skip V_AFE_SERIAL_CFG
   //skip V_AFE_SERIAL_ADDR
   //skip V_AFE_SERIAL_WDATA
   //skip V_AFE_SERIAL_RDATA

#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_TXIIR1_CFG_ADDR), TXIIR_BYPASS);
   SetCoreReg((uint32)(V_INTERP_CFG_ADDR), TX_INTERP_BYPASS);
   SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
   SetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);
#endif
   // Don't BYPASS RXIIR for Handshake
   // SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);

   LoadRxWinFilter();

   //Will take the strymon out of reset in EnableCores_ForLinkStart
// SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);
}


void LoadRxWinFilter(void)
{

   int16 s_i;
   uint16 usa_window[RX_WINDOW_LEN/2] = {79, 705, 1935, 3719, 5990, 8661, 11628, 14778};

   // Create data for Strymon. Write [w : 1-w].
   for (s_i = 0; s_i < (RX_WINDOW_LEN>>1); s_i++)
   {
      usa_window[s_i] = 32768 - usa_window[s_i];
   }

   // Only write the first half of the coeffs since
   // the HW constrains the window to be anti-symmetric
   // Note 1: we write two coefficients at a time
   // Note 2: since this is a background task, we do not use DMA to load the coefficients.
   WriteCoreBuf32NoDMA((uint32)(V_RXWIN_CO_PS_ADDR), (int16 *)(void *)usa_window, (uint16) (RX_WINDOW_LEN>>2));

}


// this function needs to be in IRAM because by the time it is called by LinkStart,
// INIT_2 page is no longer in the memory.
void EnableStrymon(void)
{
    // jg
   // For testing before AFE is providing a clock this bit needs to be set for strymon to work.
   WriteCoreReg((uint32)(V_SERDES_XBAR_ADDR), (uint32)gs_SERDESLOOP);
   //Take the strymon out of reset
   SetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);
}

//Hold the strymon at the reset state
void DisableStrymon(void)
{
   //Take the strymon out of reset
   ResetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);
}
