/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_INITFILTER.c
;
;  General function used to initialize a Strymon Filters
;
*****************************************************************************/

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "tdq_init.h"
#include "config.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_Filt.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "cmv.h"


/* Function definitions */
/****************************************************************************
; Name: Init_StrymonCPE_Filter
;
; Prototype:
;  int16 Init_StrymonCPE_Filter(uint16 us_FilterID, uint32 ul_CntlReg, uint16 us_NCo, uint16 us_offset, uint16 *pusa_Co)
;
; Description:
;  This function initializes the filter control register and the impulse
;  response coefficients of one of the filters of the Strymon CPE.
;  If the pointer to the array of coefficients pusa_Co is NULL, only
;  the filter control register is initialized. The overflow indicator
;  bit of the filter control register is automatically cleared.
;
; Arguments:
;  us_FilterID (I)      Filter label
;  ul_CntlReg  (I)      setting of the filter control register
;  us_NCo      (I)      number of impulse response coefficients stored
;  us_offset   (I)      offset from the top of the memory block at which
;                 the coefficients are to be stored
;  pusa_Co     (I)      pointer to array of impulse response coefficients
;
;  Return Value:
;  0  normal termination
;  1  unknown filter label
*****************************************************************************/
C_SCOPE int16 Init_StrymonCPE_Filter(uint16 us_FilterID, uint32 ul_CntlReg, uint16 us_NCo, uint16 us_offset, uint16 *pusa_Co)
{
   int16 s_ReturnValue;
   uint32 ul_addr1, ul_addr2;
   uint32 ul_outputmask;
    uint32 ul_overflowmask;

   switch(us_FilterID) {

      case TXINTERPFIR:
         ul_addr1 = V_INTERP_CFG_ADDR;
         ul_addr2 = STR_MEM_BASE_ADDR + V_INTERP_CO_OFFSET;
         ul_outputmask = MASK_BIT5;
         ul_overflowmask = MASK_BIT9;
         s_ReturnValue = 0;
         break;

      case RXDECIMFIR:
         ul_addr1 = V_DECIM_CFG_ADDR;
         ul_addr2 = STR_MEM_BASE_ADDR + V_DECIM_CO_OFFSET;
         ul_outputmask = MASK_BIT0;
         ul_overflowmask = MASK_BIT7;
         s_ReturnValue = 0;
         break;

      default:
         return(1);
   }

   // Zeros the current block output
   ResetCoreReg((uint32)V_BLOCK_RSTN_ADDR, ul_outputmask);

   // Zeros the overflow bit.
   SetCoreReg((uint32)V_OVERFLOW_ADDR, ul_overflowmask);

   if(pusa_Co != (uint16*) NULL)
   {
      // FIR Filter coefficients.
      if((us_FilterID == TXINTERPFIR) || (us_FilterID == RXDECIMFIR))
      {
         WriteCoreReg(ul_addr1, ul_CntlReg); //write control reg for INTERPFIR and DECMFIR
         WriteCoreBuf32(ul_addr2, (int16*)(void *)pusa_Co, (uint16)(us_NCo>>1));
      }
   }

   //Enable the current block output
   SetCoreReg((uint32)V_BLOCK_RSTN_ADDR, ul_outputmask);

   return(0);
}




