/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_LoadHPF.c
;
;  Strymon rx filters Initialization
;
*****************************************************************************/
//*******************************************************************
// STR_LoadHPF.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 22/11/2011 Hanyu:  Ported MFD code to VR9. Added code to initialize Rx IIR filter
//                    in G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
//*****************************************************************************

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"


C_SCOPE void LoadIir(void *p_filter, uint32 pul_register , uint32 ul_coefs_addr)
{
   iirLoad_Struc_t *p_iir = p_filter;
   WriteCoreReg( pul_register ,  p_iir->cfg_regs[0]); //V_xXIIR1_CFG_ADDR
   WriteCoreReg( pul_register+4, p_iir->cfg_regs[1]); //V_xXIIR2_CFG_ADDR
   WriteCoreBuf32(ul_coefs_addr, (int16*)(void *)&(p_iir->coefs[0]), (uint16)p_iir->n);
}
C_SCOPE void TxLoadIir(void *p_filter )
{
   LoadIir(p_filter , V_TXIIR1_CFG_ADDR , V_TXIIR_CO_ADDR );
}
C_SCOPE void RxLoadIir(void *p_filter )
{
   LoadIir(p_filter , V_RXIIR1_CFG_ADDR , V_RXIIR_CO_ADDR );
}


/****************************************************************************
; Name: LoadDecim
;
; Prototype:
;  void LoadDecim(void)
;
; Description:
;  This function loads the Decimator impulse response coefficients
;  into the Strymon CPE. It also updates the output scaling
;  field and the length field, and clears the overflow
;  indicator bit, and updates the filter control register.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gt_StrymonCPE_FilterTable
*****************************************************************************/
C_SCOPE void LoadDecim(void)
{
   uint32 ul_CntlReg1;
    uint16 us_NCo;
    uint16  *pusa_Co ;

   //g.bis or g.dmt
    if(gs_RxLog2FftLength1  == 8)
   {
      //update filter coefficients
      pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_RxDecim_Bis;

      //update filter length = acutal length/2 due to symmetric filter constraint
      us_NCo  = MAX_LENGTH_RXDECIM_DIV_2;

      //read V_DECIM_CFG register and update decim filter output scaling
      ReadCoreReg(V_DECIM_CFG_ADDR, &ul_CntlReg1);

      //clear bits other than RX.DECIM.IN_RATE amd RX.DECIM.FACTOR
      ul_CntlReg1 &= (0xFF<<20);

      //Set output scaling
      ul_CntlReg1 |= ((gt_StrymonCPE_FilterTable.s_OS_RxDecim_Bis &0x7) <<28);

      //Set RX.DECIM.LEN= us_Length_RxDecim_Bis/4-1
      //Actual length = (RX.DECIM.LEN+1) * 8,
        ul_CntlReg1 |= gt_StrymonCPE_FilterTable.us_Length_RxDecim_Bis; //RX.DECIM.LEN
   }
   else /* default value g.plus */
   {
      //update filter coefficients
      pusa_Co = (uint16 *)(void *)gsa_StrymonFir_Filter_RxDecim_Plus;

      //update filter length = acutal length/2 due to symmetric filter constraint
      us_NCo  = MAX_LENGTH_RXDECIM_DIV_2;

      //read V_DECIM_CFG register and update decim filter output scaling
      ReadCoreReg(V_DECIM_CFG_ADDR, &ul_CntlReg1);

      //clear bits other than RX.DECIM.IN_RATE amd RX.DECIM.FACTOR
      ul_CntlReg1 &= (0xFF<<20);

      //Set output scaling
      ul_CntlReg1 |= ((gt_StrymonCPE_FilterTable.s_OS_RxDecim_Plus&0x7) <<28);

      //Set RX.DECIM.LEN= us_Length_RxDecim_Plus
        ul_CntlReg1 |= gt_StrymonCPE_FilterTable.us_Length_RxDecim_Plus; //RX.DECIM.LEN
   }

   Init_StrymonCPE_Filter(RXDECIMFIR, ul_CntlReg1, us_NCo, 0, pusa_Co);
}

/****************************************************************************
; Name: LoadDecim2_Bypass
;
; Prototype:
;  void LoadDecim2_Bypass(void)
;
; Description:
;  This function loads the Decimator with the bypass setting. Used in plus mode
;   and dmt/bis mode hybrid/agc training.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  N/A
*****************************************************************************/

C_SCOPE  void LoadDecim2_Bypass(void)
{
   SetCoreReg((uint32)(V_DECIM_CFG_ADDR), MASK_BIT16);
}



/****************************************************************************
; Name: LoadRxIir
;
; Prototype:
;  void LoadRxIir(void)
;
; Description:
;; This function picks TxIIR filter and loads the coefficients and
;   scales and modifies the corresponding registers
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gs_RxIIRFilterSelect,
;  gula_Strymon_RxIir_Pots_Plus, gula_Strymon_RxIir_Pots_Bis
;  gula_Strymon_RxIir_Isdn_Plus, gula_Strymon_RxIir_Isdn_Bis
*****************************************************************************/

C_SCOPE void LoadRxIir(void)
{

   // Reset RX.IIR_RSTN bit in V_BLOCK_RSTN
    // Zeros the current rx iir output amd resets the itnernal states machine
    ResetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT1);

   //clear RX.IIR.OVERFLOW bit in V_OVERFLOW
   SetCoreReg((uint32)V_OVERFLOW_ADDR, MASK_BIT10);

   switch (gs_RxIIRFilterSelect)
    {
#ifndef ISDN
      case RXIIR_POTS_PLUS:
         //all pass filter
         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)
         if(gs_NotchFilterEnable)
         RxLoadIir(p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch);
         else
         RxLoadIir(gula_Strymon_RxIir_Pots_Plus);
         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
         break;

      case RXIIR_POTS_BIS:
         //all pass filter
         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start)

         if(gs_NotchFilterEnable)
         RxLoadIir(p_QLNInfo->gula_StrymonIir_Filter_DecimHpf_2_with_Notch);
         else
         RxLoadIir(gula_Strymon_RxIir_Pots_Bis);
         //XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
         break;

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
      case RXIIR_NLNF_BIS:
         //hpf
         RxLoadIir(gula_Strymon_RxIir_Nlnf_Bis);
         break;
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
#else
      case RXIIR_ISDN_PLUS:
         //hpf
         RxLoadIir(gula_Strymon_RxIir_Isdn_Plus);
         break;

      case RXIIR_ISDN_BIS:
         //bpf
         RxLoadIir(gula_Strymon_RxIir_Isdn_Bis);
         break;
#endif
      default:
         SetCoreReg(V_RXIIR1_CFG_ADDR,RXIIR_BYPASS);
            break;
   }
   // Program RXIIR_BYPASS after the the LoadRxIir fn call as it is called pre & post HSK.
   // SetCoreReg(V_RXIIR1_CFG_ADDR,RXIIR_BYPASS);

   //Unmask the RXIIR output
   SetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT1);
}

/****************************************************************************
; Name: LoadTxIir
;
; Prototype:
;  void LoadTxIir(void)
;
; Description:
;  This function picks TxIIR filter and loads the coefficients and
;   scales and modifies the corresponding registers
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gs_TxIIRFilterSelect
;  gula_Strymon_TxIir_Pots_Plus, gula_Strymon_TxIir_Pots_Bis,
;  gula_Strymon_TxIir_Isdn_Plus, gula_Strymon_TxIir_Isdn_Bis
*****************************************************************************/


C_SCOPE void LoadTxIir(void)
{
   // Reset TX.IIR_RSTN bit in V_BLOCK_RSTN
    // Zeros the current tx iir output amd resets the internal states machine
    ResetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT4);

   //clear TX.IIR.OVERFLOW bit in V_OVERFLOW
   SetCoreReg((uint32)V_OVERFLOW_ADDR, MASK_BIT11);

    switch (gs_TxIIRFilterSelect)
    {
#ifndef ISDN
      case TXIIR_POTS_PLUS:
         //bpf
         TxLoadIir(gula_Strymon_TxIir_Pots_Plus);
         break;

      case TXIIR_POTS_BIS:
         //bpf
         TxLoadIir(gula_Strymon_TxIir_Pots_Bis);
         break;
#else
      case TXIIR_ISDN_PLUS:
         //bpf
         TxLoadIir(gula_Strymon_TxIir_Isdn_Plus);
         break;

      case TXIIR_ISDN_BIS:
         //bpf
         TxLoadIir(gula_Strymon_TxIir_Isdn_Bis);
         break;
#endif
      default:
         SetCoreReg(V_TXIIR1_CFG_ADDR,TXIIR_BYPASS);
            break;
   }

   //Unmask the TXIIR output
   SetCoreReg((uint32)V_BLOCK_RSTN_ADDR, MASK_BIT4);
}






