/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_ReconfigDecim2_HPF.c
;
;  Reconfiguration and load of Decim2_HPF filter.
;
*****************************************************************************/
// ******************************************************************************
// STR_ReconfigDecim2_HPF.c
//
// History
//
// 22/11/2011 Hanyu:  Ported MFD code to VR9. Added code to initialize Rx IIR filter
//                    in G.dmt Annex A for NLNF measurement.
//                    This can be enabled by CMV bit-15 (default "0" means enabled)
//                    of INFO 121 0 in persistent memory
//                    and "cw test 7 0 0x0D" without SW API support
//                    or enabaled by cw cntl 0 0 0x09 with SW API support.
//                    Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 01/06/2012 Shakil: Merge all FT EMC fixes from ARx platform to VR9. Important changes are
//             --> 512 point QLN implemmentation for PLUS mode only because in VR9 platform Rx Strymon IIR runs in 2.2Mhz
//                in BIS/DMT mode and in 4.4Mhz in PLUS mode
//             --> Remove all Rx bypass filters with unity pass
//             --> Since in BIS/DMT mode Rx IIR runs in half of the frequency as in ARx platform modify the detection of
//                RFI notch filter (double the input RFI frequency) only in BIS/DMT mode
//             --> Added CMV control to enable/disable the RFI notching and enabled by default.
//                INFO 103 28 bitmask 0x100-> 0 Enabled(default), 1(disabled)
//             --> Remove the code for VR9 where we reset the noisy pilot flag if more than 17 frames are disturbed at
//                every 40 frames. This reduces the possibility of a bad DEC update for long impulse burst.
//             --> Improve detection of corrupted Sync Symbol by adding the noisy pilot flag as well in the condition
//             --> Merge the change from ARx platform where we update the DEC coeffs if the Average margin is more than 3dB
//    Grep for: XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES
//
// ******************************************************************************

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_Ini.h"
#include "STR_Filt.h"
//#define STR_BYPASS
/****************************************************************************
; Name: ReconfigDecim2_HPF
;
; Prototype:
;  void ReconfigDecim2_HPF(void)
;
; Description:
;  This function reconfigures
;   (1). Decim1 coefficients and loads them to Strymon.
;   (2). Rx IIR
; as the result of sample rate/decimation rate change.
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gt_StrymonCPE_FilterTable (O):      Structure holding Strymon filter settings
;   gs_RxIIRFilterSelect: global variable to select Rx IIR filter
;
; Functions Called:
;  LoadDecim()
;   LoadRxIir();
*****************************************************************************/
C_SCOPE void ReconfigDecim2_HPF(void)
{

//Reconfigure Decimation FIR filter
   LoadDecim();

//Reconfigure RxIIR filter
#ifdef ISDN
   if (gs_RxFftLength ==512)
      gs_RxIIRFilterSelect = RXIIR_ISDN_BIS;
   else
      gs_RxIIRFilterSelect = RXIIR_ISDN_PLUS;
#else
   if (gs_RxFftLength ==512)
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
     {
         if (guc_NLNF_Enable == 2)
          gs_RxIIRFilterSelect = RXIIR_NLNF_BIS;
         else
#endif
      gs_RxIIRFilterSelect = RXIIR_POTS_BIS;
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
     }
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
   else
      gs_RxIIRFilterSelect = RXIIR_POTS_PLUS;
#endif

   LoadRxIir();

#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
   SetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);
#endif

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
 #ifndef ISDN
   if (guc_NLNF_Enable == 2)
      ResetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
   else
   {
#endif  //#ifndef ISDN
#endif  //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
   //   if( (gl_SelectedMode & (MODE_G992_3|MODE_G992_5)) )

//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (Start): disable the Bypass bit in the HW to implement the new
// FW Bypass filter to all  modes
//         SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
  ResetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
 // ResetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);

//       if(gs_NotchFilterEnable)
//          ResetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
//       else SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
//XDSLRTFW-427 Enhance_DS_ALL_ANNEXAB_FT_EMC_FIXES (End)
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
 #ifndef ISDN
   }
#endif  //#ifndef ISDN
#endif  //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
}
