/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_ReconfigRx.c
;
;  Function to Reconfigure the Strymon based on LITE vs. FULL and selected TDQ
;  sampling rate.
;
*****************************************************************************/
//*******************************************************************
// STR_ReconfigRx.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
//*****************************************************************************

#include "common.h"
#include "gdata.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_Ini.h"
#include "STR_Filt.h"
#include "platform.h"
#include "cmv.h"
#include "ec_data.h"

extern FlagT gft_stallcontroldisable;
extern uint8 guc_ftb_rx_qt, guc_ftb_tx_qt;


//#define STR_BYPASS
void Strmon_RxIIR_Bypass(void)
{
// SetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);
   SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
}

void Strmon_RxIIR_Inplace(void)
{
// ResetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);

#ifndef ISDN
 //  if(!(gl_SelectedMode & (MODE_G992_3|MODE_G992_5)) )
#endif
//      ResetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS); //for DMT

}
/****************************************************************************
; Name: Reconfig_DFE_Rx
;
; Prototype:
;  void Reconfig_DFE_Rx(void)
;
; Description:
;  This function reconfigures the Strymon CPE in order to support a
;  change in the selected ADSL mode.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  N/A
*****************************************************************************/
#define FFT_LEN_1024 1024

C_SCOPE void Reconfig_DFE_Rx(void)
{

    ResetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x77);

   // Decim_HPF
   LoadDecim();

#ifdef ISDN
   if (gs_RxFftLength ==512)
      gs_RxIIRFilterSelect = RXIIR_ISDN_BIS;
   else
      gs_RxIIRFilterSelect = RXIIR_ISDN_PLUS;
#else
   if (gs_RxFftLength ==512)
      gs_RxIIRFilterSelect = RXIIR_POTS_BIS;
   else
      gs_RxIIRFilterSelect = RXIIR_POTS_PLUS;
#endif
   //IIR HPF
   LoadRxIir();

#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);
   SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
#endif

#ifndef ISDN
   if((STATArray[STAT_Mode] != 0) || (STATArray[STAT_Mode1] != 0))
   {
      SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
   }
#endif
    SetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x77);

}

/****************************************************************************
; Name: Reconfig_DFE_SampleRate(void)
;
; Prototype:
;  void Reconfig_DFE_SampleRate(void)
;
; Description:
;  This function reconfigures Tx/Rx Sample Rate due to the mode change
;
; Arguments:
;  s_FftLength
;
; Return Value:
;  N/A
;
; Globals:
;
*****************************************************************************/

C_SCOPE void Reconfig_DFE_SampleRate(void)
{
   uint32 ul_data;
   uint32 ul_TxIfftRate,ul_RxFftRate;

   // ===============================================
   // Configure Strymon
   // ===============================================
   //Strymon common control

   //V_BLOCK_RSTN
   //TX.HBTILT_RSTN, TX.INTERP_RSTN, TX.IIR_RSTN
   //RX.DECTDQ_RSTN, RX.IIR_RSTN, RX.DECIM_RSTN
    ResetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x77);


   //skip V_BLOCK_RSTN
   //skip V_OVERFLOW

#ifdef ISDN
   if (gs_RxFftLength ==512)
      gs_TxIIRFilterSelect = TXIIR_ISDN_BIS;
   else
        gs_TxIIRFilterSelect = TXIIR_ISDN_PLUS;
#else
   if (gs_RxFftLength ==512)
      gs_TxIIRFilterSelect = TXIIR_POTS_BIS;
   else
      gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
#endif


   LoadTxIir();


   // ---------- Configure TX interp ------------------------------
    ReadCoreReg((uint32)(V_INTERP_CFG_ADDR), &ul_data);
    ul_data &= ~(0xF<<20);   //mask out IN_RATE field
    ul_data &= ~0x7;   //mask out interpolation factor field
   // Set the input sampling rate (= 144/(8-IN_RATE))
   ul_data |= (gs_RxLog2FftLength1 - 5)<<20; //=IN_RATE<<20
   // Set interpolation factor (= (1<<INTERP_FACTOR))
   ul_data |= (12-gs_RxLog2FftLength1);   //= INTERP_FACTOR
   WriteCoreReg((uint32)(V_INTERP_CFG_ADDR), ul_data);

   // -------- Configure RX DECIM -------------------------
    // Set the output sampling rate = input sampling rate/(1<<RX_DECIM_FACTOR)
    ReadCoreReg((uint32)(V_DECIM_CFG_ADDR), &ul_data);
    ul_data &= ~(0xF<<24);   //mask out RX_DECIM_FACTOR field
   ul_data |= (13 - gs_RxLog2FftLength1) << 24; //RX_DECIM_FACTOR <<24
   WriteCoreReg((uint32)(V_DECIM_CFG_ADDR), ul_data);

   // ------- Configure DEC_CFG --------------------------
    // Set DEC/TDQ in bypass and set sampling rate, disable dec
    ReadCoreReg((uint32)(V_DEC_CFG_ADDR), &ul_data);
    ul_data &= ~(0xF<<24);   //mask out IN_RATE field
   //Set TDQ input sampling rate (= 141.312/(1<<(8-TDQ_IN_RATE))
    ul_data |= (gs_TxLog2FftLength1_Oversample - 6) << 24;  //TDQ_IN_RATE<<24
   WriteCoreReg((uint32)V_DEC_CFG_ADDR, ul_data);

   LoadDEC();
   //skip V_DEC_CAPTURE
   //skip V_ADAPT_CTRL

    //----------------------Skip Tx/Rx variable gain-------------------

   //skip V_ADC_ADJUST
   //skip V_FRAME_SKEW

    //skip V_TX_EXTEN_ADDR
    //skip V_TX_EXTEN_A_ADDR

    //skip V_TX_BETA_ADDR
    //skip V_TX_BETA_A_ADDR

      //---------- set IFFT size and sampling rate -----------------------

   //Set IFFT size
   ul_data = gs_TxFftLength_Oversample;

   //Set IFFT sampling rate (= 141.312/(1<<(8-IFFT_RATE)
   ul_TxIfftRate = (gs_TxLog2FftLength1_Oversample - 6)<<16;   //= IFFT_RATE << 16
   ul_data |= ul_TxIfftRate;

    WriteCoreReg((uint32)(V_TX_FSIZE_ADDR), ul_data);
    WriteCoreReg((uint32)(V_TX_FSIZE_A_ADDR), ul_data);

   //skip V_FSOFFSET_IN
   //skip V_FSOFFSET_ER

    //skip V_RX_EXTEN_ADDR
    //skip V_RX_EXTEN_A_ADDR
    //skip V_RX_WSIZE_ADDR
    //skip V_RX_WSIZE_A_ADDR


   //------------ set FFT size and sampling rate ------------------
   //Set FFT size
   ul_data = gs_RxFftLength;

   //Set FFT sampling rate (=141.312/(1<<(8-FFT_RATE))
   ul_RxFftRate = (gs_RxLog2FftLength1-6)<<16; //FFT_RATE<<16
   ul_data |= ul_RxFftRate;


   WriteCoreReg((uint32)(V_RX_FSIZE_ADDR), ul_data);
    WriteCoreReg((uint32)(V_RX_FSIZE_A_ADDR), ul_data);


   //Mei fixme: how to set these values
   //skip V_SERDES_XBAR
   //skip V_SRCFR
   //skip V_SRCCTL

    //------------ set Tx/Rx SRC sampling rate  --------------
    ReadCoreReg((uint32)(V_SRC_CFG_ADDR), &ul_data);


   ul_data &= ~(0xF<<20);   //mask out IN_RATE field
   //Set SRC TX input sample rate (=144/(1<<(8-INRATE))
   ul_data |= (gs_RxLog2FftLength1-6)<<20;   //= IN_RATE<<20
   //SRC_FACTOR is 2 for all the mode,
   WriteCoreReg((uint32)(V_SRC_CFG_ADDR), ul_data);

      // ---------Skip HB Filter ---------------------------------------
   //Input sampling rate is fixed at 72 MSPS
   //the sampling rate = 144/(1<<(8-TX_HBFILT_IN_RATE))
   //WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), (uint32)(TX_HBFILT_IN_RATE));

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   if (OPTNArray[OPTN_TXPathControl] & 0x1)
      WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), (uint32)((TX_HBFILT_IN_RATE) |(3<<28)));
   else
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
   WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), (uint32)((TX_HBFILT_IN_RATE) |(1<<28)));

   //Mei fixme: how to configure the following registers
   //skip V_AFE_SERIAL_CFG
   //skip V_AFE_SERIAL_ADDR
   //skip V_AFE_SERIAL_WDATA
   //skip V_AFE_SERIAL_RDATA

#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_DECIM_CFG_ADDR), RX_DECIM_BYPASS);
   SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
#endif
#ifndef TARGET_HW
// SetCoreReg((uint32)(V_SRC_CFG_ADDR), RX_SRC_BYPASS);
#endif

#ifndef ISDN
   //ByPass after mode selection in non ISDN modes
   if(STATArray[STAT_Mode] != 0)
   {
      SetCoreReg((uint32)(V_RXIIR1_CFG_ADDR), RXIIR_BYPASS);
   }
#endif



   //V_BLOCK_RSTN
   //TX.HBTILT_RSTN, TX.INTERP_RSTN, TX.IIR_RSTN
   //RX.DECTDQ_RSTN, RX.IIR_RSTN, RX.DECIM_RSTN
   //take strymon blocks outof reset
    SetCoreReg((uint32)(V_BLOCK_RSTN_ADDR), 0x77);

} //Reconfig_DFE_SampleRate

C_SCOPE void Reconfig_PostGHS(void)
{
   uint32 ul_tmpWord;
   //In this function, the strymon will be held at reset mode
   //so QT will always stall,so we disable QT stall check
   gft_stallcontroldisable=1;

   // Reset Strymon
   ResetCoreReg((uint32)(V_CONTROL_ADDR), RESET_STATEN);

   //Disable all the cores and they will be enabled at LinkStart by function Reconfig_CRI()
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0);

   // re-initialize the strymon block

   Reconfig_DFE_SampleRate();
   Reconfig_DFE_Rx();
   Reconfig_DFE_Tx();
   Reconfig_STR_FW(gl_SelectedMode);

   // reconfigure FFT/IFFT size
   Reconfig_IRI();

   //re-Initialize TX Status register (to default value 010000001b: QT 1, FT 0, FDF 2)
   WriteCoreReg(IRI_FTB_TX_STATUS_ADDR, (0x0081 | 0x124));

   //Initialize RX Status register (to default value 010000000b, QT 0, FT 0, FDF 2)
   WriteCoreReg(IRI_FTB_RX_STATUS_ADDR, (0x0080 | 0x124));

   ReadCoreReg(IRI_FTB_TX_STATUS_ADDR, &ul_tmpWord);
   guc_ftb_tx_qt = ul_tmpWord & 3;

   ReadCoreReg(IRI_FTB_RX_STATUS_ADDR, &ul_tmpWord);
   guc_ftb_rx_qt = ul_tmpWord & 3;

   // clean IFFT buffers
   // clean IFFT buffers
   FillCoreBuf32(IRI_FTB_IFFT_RAM_A_ADDR, 0, IRI_FTB_IFFT_RAM_A_SIZE/4);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_B_ADDR, 0, IRI_FTB_IFFT_RAM_B_SIZE/4);
   FillCoreBuf32(IRI_FTB_IFFT_RAM_C_ADDR, 0, IRI_FTB_IFFT_RAM_C_SIZE/4);


   // reconfigure CRI
   Reconfig_CRI();

    //By enabling this causing the run2run variations expecially more than
    //50% at 2km, 2.5km.
    //WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00050005);
    //WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00070007);

   EnableCores_ForLinkStart();

   //The strymon is enabled in the above function
   //so we turn on QT stall check
   gft_stallcontroldisable =0;

}


#undef FFT_LEN_1024
