/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_ReconfigTx.c
;
;  Function to reconfigure Strymon TxIIR filter
;
*****************************************************************************/
//*******************************************************************
// STR_ReconfigTx.c
//
// History
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
// 23/02/2012 Kannan : Merged AnxL (Mask1 & Mask2) filters and AnxM (Mask 1 to 4 & Mask 5 to 9)
//                     Filters from Roland.
//                     Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_AnxL_Anx5M_Masks
//
// 26/12/2012 Stefan/Vinjam: Integrated R3.5 fix to R5.2 Mainline. Use Annex-B filters in oISDN binary.
//          Reconfigure them post-handshake again based on selected mode.
//          PSD violation in ADSL G.Hs if Annex-J mode is enabled
//          In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
//          in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
//          tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
//          PSDs because of the reconfiguration of the tx-path after G.Hs
//          As Annex-J activation tones are currently not used in any field deployment the activation
//          tones and G.Hs filter configurations are hard-coded to Annex-B.
//          this part of the code is called only in LinkStartForTest.c
//          Grep for XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs
//
// 14/06/2013 Naveen: New Strymon Tx IIR filter designed for Annex 5J Mask 1 to 4
//                    PSD is also tuned appropriately.
//            Grep for XDSLRTFW-803 Perf_DS_Plus_ALL_NewTxIIR_5JMask1to4_PSD
//
// 24/07/2019 Stefan XDSLRTFW-4207 CTL, ADSL2-Annex-L: Tx Filter is not correct (initial workaround)
//             US performance is lower with Annex-L filters than with default Annex-A ones.
//             Initial workaround: use Annex-A filters instead of Annex-L ones (Annex-A CNXT filter)
//             Open point:
//             - correct Annex-L filter (=> Roland)
//             - correct Annex-L PSD    (currently we use Annex-A gain)
//
// 24/07/2019 Stefan XDSLRTFW-4207 CTL, ADSL2-Annex-L: Tx Filter is not correct (initial workaround)
//             US performance is lower with Annex-L filters than with default Annex-A ones.
//             Initial workaround: use Annex-A filters instead of Annex-L ones (Annex-A CNXT filter)
//             Open point:
//             - correct Annex-L filter (=> Roland)
//             - correct Annex-L PSD    (currently we use Annex-A gain)
//
// 24/07/2019 Stefan XDSLRTFW-4212 CTL, ADSL2-Annex-A: Tx Filter is not correct (initial workaround)
//             US performance is lower with default Annex-A filter than with CNXT-Annex-A one.
//             Initial workaround: use Annex-A filters instead of Annex-L ones (Annex-A CNXT filter)
//             Open point:
//             - correct Annex-A filter (=> Roland)
//             - correct Annex-A PSD    (currently we use Annex-A gain)
//*****************************************************************************

#include <string.h>
#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Ini.h"
#include "STR_Filt.h"
#include "platform.h"
#include "cmv.h"
#include "gdata_bis.h"
#include "ifft_cutback.h"
#include "AFED_Functions.h"
#include "AFED_Data.h"


// note only store reg setting, inscale and 4 biquads.
#define LENGTH_ANNEXM_TXIIR (2+2+6*5)
#define LENGTH_MAX_TXIIR (2+2+6*5)

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)
//extern uint32 gula_AnnexA_TXIIR_Plus_2[];

extern uint32 gula_AnnexJ_TXIIR_512[];
extern uint32 gula_AnnexJ_TXIIR_1024[];
extern uint32 gula_AnnexB_TXIIR_Bis[];
extern uint32 gula_AnnexB_TXIIR_Plus[];

// XDSLRTFW-803 Perf_DS_Plus_ALL_NewTxIIR_5JMask1to4_PSD (Start)
#ifdef ISDN
//extern uint32 gula_Strymon_TxIir_AnxJ_mask_1to4_Plus[];
extern uint32 gula_Strymon_TxIir_5J_Low[];       // XDSLRTFW-1850 : Cleanup of Tx path configuration(Start_End)
extern uint32 gula_AnnexJ4_TXIIR_1024[];
extern uint32 gula_AnnexJ5_TXIIR_1024[];
extern uint32 gula_AnnexJ6_7_TXIIR_1024[];

#endif
// XDSLRTFW-803 Perf_DS_Plus_ALL_NewTxIIR_5JMask1to4_PSD (End)

#ifndef ISDN
extern uint32 gula_AnnexL_TXIIR_Mask1[TX_IIR_SIZE];
extern uint32 gula_AnnexL_TXIIR_Mask2[TX_IIR_SIZE];

//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)
//extern uint32 gula_Strymon_TxIir_5M_Low[];
//extern uint32 gula_Strymon_TxIir_5M_High[];
extern uint32 gula_Strymon_TxIir_3M_Low[];
extern uint32 gula_Strymon_TxIir_anxm14_comp160Trafo_bis_Bis[];
extern uint32 gula_Strymon_TxIir_anxm59_comp160Trafo_bis_Bis[];
extern uint32 gula_Strymon_TxIir_3M_High[];
extern uint32 gula_AnnexA_TXIIR_Plus[];
extern uint32 gula_AnnexA_TXIIR_Bis[];
extern uint32 gula_AnnexA_TXIIR_Bis_CNXT[];

extern uint32 gula_Strymon_TxIir_3M_Medium[];
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)
#endif

#define FFT_LEN_512 512
extern uint32 gula_Strymon_TxIir_5M_Low[];
extern uint32 gula_Strymon_TxIir_5M_Medium[];
extern uint32 gula_Strymon_TxIir_5M_Medium2[];
extern uint32 gula_Strymon_TxIir_5M_High[];
//#define  STR_BYPASS
extern void vrx5afe_c_tune(uint16 us_ctune_poco_bin);

C_SCOPE void Reconfig_STR_FW(uint32 ul_mode)
{
    //Different annexes on tx filtering:
    //At lower-edge: 3 situations(different starting tones).
    //          I/J(1), A/L/M(6--default), B(33)
    //At higher-edge: 2 situations(different ending tones).
    //          L-Mask2(), A/L-Mask1/I(31--default), B/M/J(up to 63).
    //lower edge is controlled by HPF selection, higher edge is
    //controlled by LPF selection. So the following will
    //select the combinations according to the selected annex.
   int16 RxFftLength = gs_RxFftLength;


#ifdef ISDN
   if (RxFftLength == FFT_LEN_512)
   {
      //BIS Mode - Fft length 512
      gs_TxIIRFilterSelect = TXIIR_ISDN_BIS;
      if(ul_mode & ANNEX_J)
      {
         gula_Strymon_TxIir_Isdn_Bis = gula_AnnexJ_TXIIR_512;
      }
      else
      {
         gula_Strymon_TxIir_Isdn_Bis = gula_AnnexB_TXIIR_Bis;
         gus_TxGain_NoCutBack = 2600;
      }
   }
   else
   {
      //PLUS Mode - Fft length 1024
      gs_TxIIRFilterSelect = TXIIR_ISDN_PLUS;
      if(ul_mode & ANNEX_J)
      {
          //Configure the following Tx Path settings based on the selected mask:
          //   -vargain, -POFI Fc, -POFI Gain, -IIR preshaping filter based on the mask
          switch(gs_AnnexBMJPSDMaskIdx)
          {
              case EU32_ANNEX_J_PSDMASK:
            //8A1212 binary has 1370, observed more PSD and hence decreased vargain now
            gus_TxGain_NoCutBack = 1350;
            gula_Strymon_TxIir_Isdn_Plus =  gula_Strymon_TxIir_5J_Low;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 160);
            break;

              case EU36_ANNEX_J_PSDMASK:
            gus_TxGain_NoCutBack = 1200;
            gula_Strymon_TxIir_Isdn_Plus =  gula_Strymon_TxIir_5J_Low;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 160);
            break;

              case EU40_ANNEX_J_PSDMASK:
            //Mask3 onwards IFFT left shift reduced by 1, so increase var gain
            gus_TxGain_NoCutBack = 2368;
            gula_Strymon_TxIir_Isdn_Plus =  gula_Strymon_TxIir_5J_Low;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 160);
            break;

              case EU44_ANNEX_J_PSDMASK:
            //Mask3 onwards IFFT left shift reduced by 1, so increase var gain
            gus_TxGain_NoCutBack = 2160;
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ4_TXIIR_1024;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 320);
            break;

              case EU48_ANNEX_J_PSDMASK:
            //8A1212 binary has 2937, increased 0.3dB to meet DTAG US data rate requirement
            gus_TxGain_NoCutBack = 3093; //3040; //2937;
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ5_TXIIR_1024;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 9, 320);
            break;

              case EU52_ANNEX_J_PSDMASK:
              case EU56_ANNEX_J_PSDMASK:
            gus_TxGain_NoCutBack = 2837;
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ6_7_TXIIR_1024;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 9, 320);
            break;

              case EU60_ANNEX_J_PSDMASK:
            //Increased IIR filter gain by 1dB and decrease the var gain by 1dB 2648*10^(-1/20)
            //to make same TxPSD as earlier. Tx FIR filter also modified.
            //8A1212 binary has 2648, increased 0.35dB to meet DTAG US data rate/Margin requirement
            //Total power increased is ~1.35dB
            gus_TxGain_NoCutBack = 2757; //2710; //2648;
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ_TXIIR_1024;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 9, 320);
            break;

         case EU64_ANNEX_J_PSDMASK:
            //Increased IIR filter gain by 1dB and decrease the var gain by 1dB 2648*10^(-1/20)
            //to make same TxPSD as earlier. var gain modifications because Tx FIR filter modifications.
            gus_TxGain_NoCutBack = 2293;
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ_TXIIR_1024;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 9, 320);
            break;

         default:
            gula_Strymon_TxIir_Isdn_Plus = gula_AnnexJ_TXIIR_1024;
            break;

         }
      }
      else
      {
         gus_TxGain_NoCutBack = 2750;
         gula_Strymon_TxIir_Isdn_Plus = gula_AnnexB_TXIIR_Plus;
      }
      gus_TxSineGain = gus_TxGain_NoCutBack;
      LoadTxSineGain();
   }
   #else
   if(RxFftLength == FFT_LEN_512)
   {
      //BIS Mode - Fft length 512
      gs_TxIIRFilterSelect = TXIIR_POTS_BIS;

      /* Reconfig f/w copy of INTERP1 for Annex L-Mask2 */
      if (ul_mode & ANNEX_L)
      {
         // mask2 , AnxL
         if (STATArray[STAT_Misc] & STAT_AnnexL_US_Mask2_PSD)
         {
            // Debug code:
            // gus_TxGain_NoCutBack_3L = 0:        Force "default ADSL2-Annex A filter:      gula_AnnexA_TXIIR_Bis
            // gus_TxGain_NoCutBack_3A = 0:        Force "default ADSL2-Annex L filter:      gula_AnnexL_TXIIR_Mask1
            // gus_TxGain_NoCutBack_3L > 1:        new default setting, use CNXT filter:     gula_AnnexA_TXIIR_Bis_CNXT
            // gula_AnnexA_TXIIR_Bis_CNXT seems to be the right transmit filter for G992.3 Annex-L
            //    - no precompensation for trafo
            //    - precompensation for AFE lowpass-filter (80kHz POFI-POCO setting)
            if ( gus_TxGain_NoCutBack_3L == 0 )
            {
               gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3A;
               gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis;
            }
            else if ( gus_TxGain_NoCutBack_3A == 0)
            {
               gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3L;
               gula_Strymon_TxIir_Pots_Bis = gula_AnnexL_TXIIR_Mask2;
            }
            else
            {
               if (gs_CurrentCoChipset == BDCM_CO_CHIPSET)
               {
                  gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3L;
                  gula_Strymon_TxIir_Pots_Bis = gula_AnnexL_TXIIR_Mask2;
               }
               else
               {
                  gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3A;
                  gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis_CNXT;
               }
            }

            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
            gus_TxSineGain = gus_TxGain_NoCutBack;
            LoadTxSineGain();
         }
         //mask1, AnxL
         else //if (STATArray[STAT_Misc] & STAT_AnnexL_US_Mask1_PSD)
         {
            // XDSLRTFW-4207 CTL, ADSL2-Annex-L: Tx Filter is not correct
            // US performance is lower with Annex-L filters than with default Annex-A ones.
            // Initial workaround: use Annex-A filters instead of Annex-L ones (Annex-A CNXT filter)
            // Open point:
            // - correct Annex-L filter (=> Roland)
            // - correct Annex-L PSD    (currently we use Annex-A gain)

            // Debug code:
            // gus_TxGain_NoCutBack_3L = 0:        Force "default ADSL2-Annex A filter:      gula_AnnexA_TXIIR_Bis
            // gus_TxGain_NoCutBack_3A = 0:        Force "default ADSL2-Annex L filter:      gula_AnnexL_TXIIR_Mask1
            // gus_TxGain_NoCutBack_3L > 1:        new default setting, use CNXT filter:     gula_AnnexA_TXIIR_Bis_CNXT
            // gula_AnnexA_TXIIR_Bis_CNXT seems to be the right transmit filter for G992.3 Annex-L
            //    - no precompensation for trafo
            //    - precompensation for AFE lowpass-filter (80kHz POFI-POCO setting)
            if ( gus_TxGain_NoCutBack_3L == 0 )
            {
               gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3A;
               gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis;
            }
            else if ( gus_TxGain_NoCutBack_3A == 0)
            {
               gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3L;
               gula_Strymon_TxIir_Pots_Bis = gula_AnnexL_TXIIR_Mask1;
            }
            else
            {
               if (gs_CurrentCoChipset == BDCM_CO_CHIPSET)
               {
                  gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3L;
                  gula_Strymon_TxIir_Pots_Bis = gula_AnnexL_TXIIR_Mask1;
               }
               else
               {
                  gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3A;
                  gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis_CNXT;
               }
            }

            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
            gus_TxSineGain = gus_TxGain_NoCutBack;
            LoadTxSineGain();
         }
      //Feature_US_BisPlus_ALL_AnxL_Anx5M_Masks (END)
      }

      else if(ul_mode & ANNEX_M)
      {
         uint16 us_POFI_CutOff_Frequency_kHz;

         gula_Strymon_TxIir_Pots_Bis = gula_Strymon_TxIir_3M_High;
         //POFI Fc: 320kHz with Poco gain: 8dB
         us_POFI_CutOff_Frequency_kHz = 320;

         if(gs_AnnexBMJPSDMaskIdx == EU32_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Bis = gula_Strymon_TxIir_3M_Low;
            gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3M;             //                  4096     "24.08 dB" in 8.8 format, NomPSD = -38.0 dBm/Hz
            //POFI Fc: 80kHz with Poco gain: 8dB
            us_POFI_CutOff_Frequency_kHz = 80;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU36_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Bis = gula_Strymon_TxIir_3M_Low;
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M- 96);       //                  4000     "23.88 dB" in 8.8 format, NomPSD = -38.2 dBm/Hz
            //POFI Fc: 80kHz with Poco gain: 8dB                        // BUG! Should be:  3867     "23.38 dB" in 8.8 format, NomPSD = -38.5 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 80;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU40_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Bis = gula_Strymon_TxIir_3M_Medium;
            gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3M;             //                   4096     "24.08 dB" in 8.8 format, NomPSD = -39.0 dBm/Hz
            //POFI Fc: 80kHz with Poco gain: 8dB
            us_POFI_CutOff_Frequency_kHz = 80;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU44_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Bis = gula_Strymon_TxIir_3M_Medium;
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M- 96);        //                  4000     "23.88 dB" in 8.8 format, NomPSD = -39.2 dBm/Hz
            //POFI Fc: 80kHz with Poco gain: 8dB                         // BUG! Should be:  3912     "23.48 dB" in 8.8 format, NomPSD = -39.4 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 80;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU48_PSDMASK)
         {
            gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3M;             //                   4096     "24.08 dB" in 8.8 format, NomPSD = -39.8 dBm/Hz
            //POFI Fc: 320kHz with Poco gain: 8dB
            us_POFI_CutOff_Frequency_kHz = 320;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU52_PSDMASK)
         {
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M- 96);        //                  4000     "23.88 dB" in 8.8 format, NomPSD = -40.0 dBm/Hz
            //POFI Fc: 320kHz with Poco gain: 8dB                        // BUG! Should be:  3957     "23.78 dB" in 8.8 format, NomPSD = -40.1 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 320;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU56_PSDMASK)
         {
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M-186);        //                  3910     "23.68 dB" in 8.8 format, NomPSD = -40.2 dBm/Hz
            //POFI Fc: 320kHz with Poco gain: 8dB                        // BUG! Should be:  3823     "23.48 dB" in 8.8 format, NomPSD = -40.4 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 320;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU60_PSDMASK)
         {
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M-276);        //                  3820     "23.47 dB" in 8.8 format, NomPSD = -40.4 dBm/Hz
            //POFI Fc: 320kHz with Poco gain: 8dB                        // BUG! Should be:  3693     "22.18 dB" in 8.8 format, NomPSD = -40.7 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 320;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU64_PSDMASK)
         {
            gus_TxGain_NoCutBack = (gus_TxGain_NoCutBack_3M-366);        //                  3730     "23.27 dB" in 8.8 format, NomPSD = -41.6 dBm/Hz
            //POFI Fc: 320kHz with Poco gain: 8dB                        // BUG! Should be:  3567     "22.88 dB" in 8.8 format, NomPSD = -41.0 dBm/Hz
            us_POFI_CutOff_Frequency_kHz = 320;
         }

         //Configure HW
         vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, us_POFI_CutOff_Frequency_kHz);
         gus_TxSineGain = gus_TxGain_NoCutBack;
         LoadTxSineGain();
      }
      else  //if(ul_mode & ANNEX_A)
      {
         // 24/07/2019 Stefan XDSLRTFW-4212 CTL, ADSL2-Annex-A: Tx Filter is not correct (initial workaround)
         //             US performance is lower with default Annex-A filter than with CNXT-Annex-A one.
         //             Initial workaround: use Annex-A filters instead of Annex-L ones (Annex-A CNXT filter)
         //             Open point:
         //             - correct Annex-A filter (=> Roland)
         //             - correct Annex-A PSD    (currently we use Annex-A gain)

         // add default for DMT/BIS Mode: Annex-A

         // Debug code:
         // gus_TxGain_NoCutBack_3L = 0:        Force "default ADSL2-Annex A filter:      gula_AnnexA_TXIIR_Bis
         // gus_TxGain_NoCutBack_3A = 0:        Force "default ADSL2-Annex L filter:      gula_AnnexL_TXIIR_Mask1
         // gus_TxGain_NoCutBack_3L > 1:        new default setting, use CNXT filter:     gula_AnnexA_TXIIR_Bis_CNXT
         // gula_AnnexA_TXIIR_Bis_CNXT seems to be the right transmit filter for G992.3 Annex-A
         //    - no precompensation for trafo
         //    - precompensation for AFE lowpass-filter (80kHz POFI-POCO setting)

         // XDSLRTFW-3674 CNXT_E67_IOP_Txfilter_changes (end)
         if ( gus_TxGain_NoCutBack_3L == 0 )
         {
            gus_TxGain_NoCutBack        = gus_TxGain_NoCutBack_3A;
            gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis;
         }
         else if ( gus_TxGain_NoCutBack_3A == 0)
         {
            gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3L;
            gula_Strymon_TxIir_Pots_Bis = gula_AnnexL_TXIIR_Mask1;
         }
         else
         {
            gus_TxGain_NoCutBack = gus_TxGain_NoCutBack_3A;
            gula_Strymon_TxIir_Pots_Bis = gula_AnnexA_TXIIR_Bis_CNXT;
         }

         //XDSLRTFW-3393 XDSLRTFW-3394 VRx518: oPOTS: Annex A TR067A: AVINAX DSLAM: Lower DS rates in ANSI13 loops (START)
         if ( (gl_SelectedMode & MODE_ADSL1) &&
               (gs_CurrentCoChipset == IFTN_CO_CHIPSET) &&
               ((guca_fe_G9941_VendorID[6] & 0xF0) == AVINAX_PLATFORM_8) &&
               (gs_hsk_tone_power_dB <= MINIMUM_GHS_TONE_PWR_AT_11000F) &&
               (gs_hsk_tone_power_dB >= MINIMUM_GHS_TONE_PWR_AT_15000F) )
            // reduce power by 2dB
            // Simplified calculation of linear 2dB :  (x-x/8-x/16-x/64) ~ 1.97dB
            gus_TxGain_NoCutBack = (    gus_TxGain_NoCutBack
                                     - (gus_TxGain_NoCutBack>>3)
                                     - (gus_TxGain_NoCutBack>>4)
                                     - (gus_TxGain_NoCutBack>>6) );
         //XDSLRTFW-3393 XDSLRTFW-3394 (END)

         //POFI Fc: 80kHz with Poco gain: 8dB
         vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
         gus_TxSineGain = gus_TxGain_NoCutBack;
         LoadTxSineGain();
      }
   }
   else
   {
      //if gs_RxFftLength == 1024 - plus mode
      gs_TxIIRFilterSelect = TXIIR_POTS_PLUS;
      if(ul_mode & ANNEX_M)
      {
         gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_High;
         vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 160);

         if(gs_AnnexBMJPSDMaskIdx == EU32_PSDMASK)
         {
               gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Low;
            gus_TxGain_NoCutBack = 5493; //4096;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU36_PSDMASK)
         {
               gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Low;
            gus_TxGain_NoCutBack = 5364; //4000;
            vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU40_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Medium;
            gus_TxGain_NoCutBack = 4096;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU44_PSDMASK)
         {
            gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Medium;
            gus_TxGain_NoCutBack = 4000;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU48_PSDMASK)
         {
            gus_TxGain_NoCutBack = 4000;
            gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Medium2;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU52_PSDMASK)
         {
            gus_TxGain_NoCutBack = 4000;
            gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_Medium2;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU56_PSDMASK)
         {
            gus_TxGain_NoCutBack = 4000;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU60_PSDMASK)
         {
            gus_TxGain_NoCutBack = 3820;
         }
         else if(gs_AnnexBMJPSDMaskIdx == EU64_PSDMASK)
         {
            gus_TxGain_NoCutBack = 3690;
         }
         else
         {
               gula_Strymon_TxIir_Pots_Plus = gula_Strymon_TxIir_5M_High;
         }
         gus_TxSineGain = gus_TxGain_NoCutBack;
         LoadTxSineGain();
      }
      else
      //if(ul_mode & ANNEX_A)
      {
         // 1. add default for Plus Mode: Annex-A
         gus_TxGain_NoCutBack = 2816;
         gula_Strymon_TxIir_Pots_Plus = gula_AnnexA_TXIIR_Plus;
         //POFI Fc: 80kHz with Poco gain: 8dB
         vrx5afe_dsl_pofi_gainfc_set(ADSL2_CPE, 8, 80);
         gus_TxSineGain = gus_TxGain_NoCutBack;
         LoadTxSineGain();
      }
      //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
      //if ((OPTNArray[OPTN_TXPathControl] & 0x01) && (gs_RxFftLength == 1024))
      if (OPTNArray[OPTN_TXPathControl] & 0x01)
      {
         //gula_Strymon_TxIir_Pots_Plus = gula_AnnexA_TXIIR_Plus_2;
         gula_Strymon_TxIir_Pots_Plus = gula_AnnexA_TXIIR_Plus;  //TBD: check later
      }
   //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
   }
#if 0 // moved after QLN and noise Flags update XDSLRTFW-3602 /XDSLRTFW-3603 (start)
   //Only for Annex A ADS2 modes/ADSL1 modes fien tune Ctune values
   if(    (ul_mode & ANNEX_A) && !(ul_mode & MODE_G992_5))
   {
      // Ctune 14 for HSK power < 3000
      if (gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_CTune14)
      {
         gus_ctune_poco_bin = 0xE;
         if (gusa_AfeChipId[1] == 2) //A21 chip
         {
            gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A_17kft[0][0];
         }
      }
      // Ctune 12 for HSK power < 8600
      else if(gs_hsk_tone_power_dB < MINIMUM_GHS_TONE_PWR_CTune12)
      {
         gus_ctune_poco_bin = 0xC;
      }
   }
   if(gs_ctune_poco_bin_force >=0)
   {
      gus_ctune_poco_bin = (uint16)(gs_ctune_poco_bin_force & 0x000F);
   }

   vrx5afe_c_tune(gus_ctune_poco_bin & 0x000F);
#endif //XDSLRTFW-3602 /XDSLRTFW-3603  (end)
#endif //endif ISDN

#ifdef ISDN
#ifndef TARGET_HW
   if (ul_mode & (ANNEX_B | ANNEX_M | ANNEX_J))
   {    // placeholder for annex B cocomo
      gs_TxIIRFilterSelect = 0;
   }
#endif
#endif
   LoadTxIir();

   //Fixme:Yang Hack code to bring up anxJ
   if (gul_ModeControl == (OPTN_ConfigMode_G992_3_J<<16))
      SetCoreReg((uint32)(V_TXIIR1_CFG_ADDR), TXIIR_BYPASS);


#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_TXIIR1_CFG_ADDR), TXIIR_BYPASS);
   SetCoreReg((uint32)(V_INTERP_CFG_ADDR), TX_INTERP_BYPASS);
#endif
}



/****************************************************************************
; Name: Reconfig_DFE_Tx
;
; Prototype:
;  void Reconfig_DFE_Tx(void)
;
; Description:
;  This function loads corresponding INTERP 1 filters based on TX SRC input rate
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gus_SMODE1,gus_SMODE2   (I/O) setting of the Strymon CPE SMODE resister
*****************************************************************************/
C_SCOPE void Reconfig_DFE_Tx(void)
{
   /****************************************************************************/
   /* Re-Initialize Interp1                                       */
   /****************************************************************************/
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (Start)
   // PSD violation in ADSL G.Hs if Annex-J mode is enabled - Jira XDSLRTFW-258
   // In Annex-B binary the configuration of the tx-path was not correct if Annex-J codepoints
   // in G.Hs were enabled. In this case the Tx-IIR filter was configured for Annex-J, but the
   // tx-interpolator for Annex-B tx signals. This was not seen in the final Annex-J or Annex-B
   // PSDs because of the reconfiguration of the tx-path after G.Hs
   // As Annex-J activation tones are currently not used in any field deployment the activation
   // tones and G.Hs filter configurations are hard-coded to Annex-B.
   // this part of the code is called only in LinkStartForTest.c
   //
   // tbd: instead of using a global variable it would be better to parse an argument to the calling
   // function Reconfig_DFE_Tx and use it here
   // gl_SelectedMode is initialized at linkstart to "0"
   Config_Interp1(gl_SelectedMode);
   //XDSLRTFW-653 XDSLRTFW-258 Bug_US_BisPlus_ALL_UseAnxBFiltForAnxJ_BeforeGHs (End)

#ifndef ADSL_62
   /****************************************************************************/
   /* Re-Initialize PotsHPF                                       */
   /****************************************************************************/
   // Re-initialize POTSHPF.
   // NOTE: Location of the POTSHPF Filter coefs in Strymon memory may change
   Config_Potshpf();


   /****************************************************************************/
   /* Re-Initialize Interp3.                                      */
   /****************************************************************************/
   Config_Interp3();

   /****************************************************************************/
   /* Re-Initialize Interp4.                                      */
   /****************************************************************************/
   Config_Interp4();
#endif

#ifdef STR_BYPASS
   SetCoreReg((uint32)(V_TXIIR1_CFG_ADDR), TXIIR_BYPASS);
   SetCoreReg((uint32)(V_INTERP_CFG_ADDR), TX_INTERP_BYPASS);
#endif
}


