/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_RxTxAlign.c
;
;  Strymon CPE functions related to DEC Adaptation.
;
*****************************************************************************/

#include "common.h"
#include "gdata.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "str_const.h"

/***************************************************************************************
;  Subroutine Name: GetDECAdaptationRxOffset
;
;  Description:
;     This function polls the DEC RX data capture status and records the RX offset
;     once data capture is completed. The RX offset is the sample count measured
;     from the beginning of the RX frame to the starting point of RX data capture.
;     If TX offset was set to zero, this count represents the RX-TX alignment.
;     The main purpose of this function is in fact RX-TX alignment measurement.
;
;  Prototype:
;     void GetDECAdaptationRxOffset(void)
;
;  Input Arguments:
;     none
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;**********************************************************************************************/
C_SCOPE void GetDECAdaptationRxOffset(void)
{

    uint32 ul_data;

   // Check if a capture cycle has been completed.
   ReadCoreReg((uint32)V_DEC_CAPTURE_ADDR, &ul_data);
   if (((ul_data >> 11) & 0x3) == 0x3)
   {
      // Record capture offset in RX samples.
      gs_DECAdaptationRxOffset = (int16)((ul_data >> 13) & 0x3FFF);
   }

}
