/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_Tdq.c
;
;  Strymon CPE functions related to the TDQ
;
*****************************************************************************/
//*******************************************************************
// STR_Tdq.c
//
// History
//
//
// 30/09/2011 Stefan : Upsteam performance fixes from Stefan.
//                     Vinjam integrated them to Vr9 R4.3 ADSL mainline
//                     Grep for XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl
//
//*****************************************************************************

#include "common.h"
#include "gdata.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_iof.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "platform.h"
#include "ec_data.h"

C_SCOPE void LoadTDQUtil(int16 *psa_pre_tdq_h, int16 s_pre_tdq_h_exp, int16 s_TDQLen)
{
   uint32 ul_data;
   uint16 us_temp;

    // Update tdq filter control register.
   ReadCoreReg((uint32)V_TDQ_CFG_ADDR, &ul_data);

    // (bits 27-21) TDQ Length
    us_temp =  (s_TDQLen>>3) - 1;
   ul_data &= ~(0x7F<<21) ;
    ul_data |= (us_temp << 21);

    WriteCoreReg((uint32)V_TDQ_CFG_ADDR, ul_data);

   //Reset tdq bypass mode and enable tdq output
   //TDQ_BYPASS
    ResetCoreReg((uint32)V_TDQ_CFG_ADDR, MASK_BIT8);

   //Load TDQ coefficients and exponents
   LoadDECTDQ();
}


/****************************************************************************
; Name: LoadDECTDQ
;
; Prototype:
;  void LoadDECTDQ(void)
;
; Description:
;  This function loads the TDQ impulse response coefficients
;  into the DECTDQ adaptation memory. It also updates the output scaling
;  field in V_ADAPT CTRL register, and configures to adpatation write mode and enable
;  coefficients update.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gsa_pre_tdq_h     (I) array of TDQ impulse response coefficients
;  gs_pre_tdq_h_exp  (I) right shift applied to TDQ output samples
*****************************************************************************/
C_SCOPE void LoadDECTDQ(void)
{
   uint32 ul_BaseAddr, ul_data;
   uint16 us_OS;
   int32 la_pre_dec_h_temp[256/2];
   int16* sa_pre_dec_h_temp = (int16 *)(void *)&la_pre_dec_h_temp[0];
   int i = 0;

   //copy TDQ coefficients in adapt memory
   ul_BaseAddr= V_DEC_ADAPT_ADDR ;
   WriteCoreBuf32(ul_BaseAddr, gsa_pre_tdq_h, (uint16)(gs_TDQLen>>1));

//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start)
   if (OPTNArray[OPTN_TXPathControl] & 0x01)       // if US performance fix: on
   {
      //copy DEC coefficients in adapt memory
      if ( gs_DECUpsamplingFactor == 1 )  //one phase only
      {
         ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER*2 ;
         if (gsa_pre_tdq_h[0] > 0x1000)
            WriteCoreBuf32(ul_BaseAddr, gsa_pre_dec_h, gs_DEC_ORDER>>1);
         else
         {
            sa_pre_dec_h_temp[0] = gsa_pre_dec_h[0];
            for ( i=1; i<(gs_DEC_ORDER-1-gs_DEC_SHIFT); i++)
            {
               sa_pre_dec_h_temp[i] = gsa_pre_dec_h[i+gs_DEC_SHIFT];
            }
            for ( i=(gs_DEC_ORDER-1-gs_DEC_SHIFT); i<(gs_DEC_ORDER-1); i++)
            {
               sa_pre_dec_h_temp[i] = 0;
            }
            WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, gs_DEC_ORDER>>1);
         }
      }
      else //two phases
      {
            if (gft_interpdec_phase_align ==0)
               sa_pre_dec_h_temp[0] = gsa_pre_dec_h[2*0+1];
            else
               sa_pre_dec_h_temp[0] = gsa_pre_dec_h[0*i];
         sa_pre_dec_h_temp[(gs_DEC_ORDER/2)-1] = 0;
         //load dec phase 1
         ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER ;
         for ( i=1; i<((gs_DEC_ORDER/2)-1); i++)
         {
            if (gft_interpdec_phase_align ==0)
               sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i+1+gs_DEC_SHIFT];
            else
               sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i  +gs_DEC_SHIFT];
         }

         WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));

            if (gft_interpdec_phase_align ==0)
               sa_pre_dec_h_temp[0] = gsa_pre_dec_h[0*i];
            else
               sa_pre_dec_h_temp[0] = gsa_pre_dec_h[2*0 +1];

         sa_pre_dec_h_temp[(gs_DEC_ORDER/2)-1] = 0;

         //load dec phase 0
         ul_BaseAddr= V_DEC_ADAPT_ADDR + DEC_INTERP_PHASE_MEM_OFFSET-gs_DEC_ORDER;
         //byte address
         for ( i=1; i<((gs_DEC_ORDER/2)-1); i++)
         {
            if (gft_interpdec_phase_align ==0)
               sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i  +gs_DEC_SHIFT];
            else
               sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i+1+gs_DEC_SHIFT];
         }
         WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));
      }
   }
   else
   {
//XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (End)
   //copy DEC coefficients in adapt memory
   if ( gs_DECUpsamplingFactor == 1 )  //one phase only
   {
      ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER*2 ;
      WriteCoreBuf32(ul_BaseAddr, gsa_pre_dec_h, gs_DEC_ORDER>>1);
   }
   else //two phases
   {
      //load dec phase 1
      ul_BaseAddr= V_DEC_ADAPT_ADDR + V_DEC_TDQ_CO_SIZE - gs_DEC_ORDER ;
      for ( i=0; i< gs_DEC_ORDER/2; i++)
      {
         if (gft_interpdec_phase_align ==0)
            sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i+1];
         else
            sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i];

      }
      WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));


      //load dec phase 0
      ul_BaseAddr= V_DEC_ADAPT_ADDR + DEC_INTERP_PHASE_MEM_OFFSET-gs_DEC_ORDER;
      //byte address
      for ( i=0; i< gs_DEC_ORDER/2; i++)
      {
         if (gft_interpdec_phase_align ==0)
            sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i];
         else
            sa_pre_dec_h_temp[i] = gsa_pre_dec_h[2*i +1];
      }
      WriteCoreBuf32(ul_BaseAddr, sa_pre_dec_h_temp, (gs_DEC_ORDER>>2));
      }     //XDSLRTFW-336 PERF_US_Plus_ALL_ShortLoops_AnxA_NonStdCompl (Start_End)
   }
   //congigure the tdq_exp and dec-exp filed
   ReadCoreReg((uint32)V_ADAPT_CTRL_ADDR, &ul_data);
   ul_data &= ~(7<<5) ; //mask tdq exp field
   ul_data &= ~(7<<9) ; //mask dec exp field
   us_OS = (uint8)(15-gs_pre_tdq_h_exp)&0x7;
   ul_data |= (((uint8)gs_pre_dec_h_exp &0x7)<<9)| (us_OS<<5);

   //copy dec and tdq exponents to v_adapt_ctrl register
   WriteCoreReg(V_ADAPT_CTRL_ADDR, ul_data);


    //programming the dec/tdq ram writting mode and enable writing
   ReadCoreReg((uint32)V_ADAPT_CTRL_ADDR, &ul_data);
   ul_data &= ~7;
   ul_data |= 5;
   // Wait until previous download is completed.
   WriteCoreReg((uint32)V_ADAPT_CTRL_ADDR, ul_data);
}

/****************************************************************************
; Name: LoadTDQ
;
; Prototype:
;  void LoadTDQ(void)
;
; Description:
;  This function loads the TDQ impulse response coefficients
;  into the Strymon CPE. It also updates the output scaling
;  field and the length field, all in the TDQ filter control register.
;   This function should only be called when strymon is held in
;   synchronous reset mode.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gus_SMODE1,gus_SMODE2   (I)   setting of the Strymon CPE SMODE register
;  gs_TDQLen         (I) length of TDQ impulse response
;  gsa_pre_tdq_h     (I) array of TDQ impulse response coefficients
;  gs_pre_tdq_h_exp  (I) right shift applied to TDQ output samples
*****************************************************************************/
C_SCOPE void LoadTDQ(void)
{
   LoadTDQUtil(gsa_pre_tdq_h, gs_pre_tdq_h_exp, gs_TDQLen);
}

/****************************************************************************
; Name: UnityTDQ
;
; Prototype:
;  void UnityTDQ(void)
;
; Description:
;  This function sets the TDQ impulse response to a unit impulse.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;  gus_SMODE1,gus_SMODE2   (I)   setting of the Strymon CPE SMODE register
;  gs_TDQLen         (0) saved length of TDQ impulse response
;  gsa_pre_tdq_h     (0) saved array of TDQ impulse response coefficients
;  gs_pre_tdq_h_exp  (0) saved right shift applied to TDQ output samples
*****************************************************************************/
C_SCOPE void UnityTDQ(void)
{
   int16 i;
   gs_pre_tdq_h_exp =14;

   // Init us_Co to impulse response for loading into
   // TDQ coefficients
   gsa_pre_tdq_h[0]=0x4000;
   for (i=1; i<(TDQ_LENGTH); i++){
      gsa_pre_tdq_h[i]=0;
   }

   LoadDECTDQ();
}

