/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_cleardec.c
;
;  Strymon CPE core interface layer.
;
*****************************************************************************/

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "tdq_init.h"
#include "config.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "cmv.h"


/***************************************************************************************
;  Subroutine Name: ClearDEC
;
;  Description:
;     This function zeroes the output of the DEC.
;
;  Prototype:
;     void ClearDEC(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;**********************************************************************************************/
C_SCOPE void ClearDEC(void)
{
   //Mask DEC Output to zero
    SetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT0);
}

/***************************************************************************************
;  Subroutine Name: UnmaskDECOutput
;
;  Description:
;     This function unmask the output of the DEC.
;
;  Prototype:
;     void ClearDEC(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;**********************************************************************************************/
C_SCOPE void UnmaskDECOutput(void)
{
   //Enable DEC Output
    ResetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT0);
}

/***************************************************************************************
;  Subroutine Name: LoadDEC
;
;  Description:
;     This function Load unity DEC with DEC_LENGTH =gs_DEC_ORDER
;
;  Prototype:
;     void LoadDEC(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;**********************************************************************************************/
C_SCOPE void LoadDEC(void)
{
   uint32 ul_data;
   int16  us_temp = 0;

   ReadCoreReg((uint32)(V_DEC_CFG_ADDR), &ul_data);

   //program interpDEC bit
   if (gs_DECUpsamplingFactor == 2)
      ul_data |= MASK_BIT7;
   else if (gs_DECUpsamplingFactor == 1)
       ul_data &= ~MASK_BIT7;

   // (bits 14-8) DEC Length
   if ( gs_DECUpsamplingFactor == 2 )  //two phase
      us_temp = (gs_DEC_ORDER>>4) - 1; //per phase length
   else if ( gs_DECUpsamplingFactor == 1 )  //one phase only
      us_temp =  (gs_DEC_ORDER>>3) - 1;
   ul_data &= ~(0x7FF<<8) ;
    ul_data |= (us_temp << 8);
   WriteCoreReg((uint32)(V_DEC_CFG_ADDR), ul_data);

   //reset dec bypass mode
    ResetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT6);

    //Enable DEC
    SetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT5);

   //Disable DEC Output
   SetCoreReg((uint32)(V_DEC_CFG_ADDR), MASK_BIT0);

   //load dec coefficinets
   LoadDECTDQ();
}
