/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_decimphase.c
;
;  Strymon CPE core interface layer.
;
*****************************************************************************/

#include "typedef.h"
#include "gdata.h"
#include "const.h"
#include "tdq_init.h"
#include "config.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "cmv.h"


/* Function definitions */

/***************************************************************************************
;  Subroutine Name: SetDecimatorPhase
;
;  Description:
;     Set the phase offset register in the SRC.  Maps gs_DecimatorPhaseIdx to
;     four equally spaced phase offsets for the Rx SRC.
;
;  Prototype:
;     void SetDecimatorPhase(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;   Globals:
;     gs_DecimatorPhaseIdx
;  Return Value:
;     none
;
;**********************************************************************************************/
C_SCOPE void SetDecimatorPhase(void)
{

    uint32 ul_CntlReg;

   ReadCoreReg((uint32)V_DECIM_CFG_ADDR, &ul_CntlReg);
   ul_CntlReg &= ~(0x3F<<8);
   ul_CntlReg |= (gs_DecimatorPhaseIdx  << 8); /* set bits 22 and 23 to desired phase */
   WriteCoreReg((uint32)V_DECIM_CFG_ADDR, ul_CntlReg);
}
