/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: STR_show.c
;
;  Strymon CPE core interface layer.
;
*****************************************************************************/
// ******************************************************************
// STR_show.c
//
// History
// 14/03/2014 Anantha Ramu: Added function to modify TX HB filter output scaling.
//            Grep for: XDSLRTFW-1611
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "tdq_init.h"
#include "config.h"
#include "memrymap.h"
#include "LL_IOf.h"
#include "STR_IOf.h"
#include "STR_InitFilter.h"
#include "STR_Filt.h"
#include "dec_adap.h"
#include "ec_data.h"
#include "cmv.h"


/***************************************************************************************
;  Subroutine Name: LoadTxSineGain
;
;  Description:
;     This function sets the Tx Variable Gain in Strymon.
;
;  Prototype:
;     void LoadTxSineGain(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/
void LoadTxSineGain(void)
{
   uint32 ul_data;
   uint32 ul_exp = 0;

   uint32 temp = (uint32)gus_TxSineGain;
   if (temp >=(uint32)0x8000)
   {
      gus_TxSineGain >>= 1;
      ul_exp = 1;
   }

   /* gus_TxSineGain has 4.12 format. ST_GAINVAL register has 1.15 format. */
    ul_data = (uint32) gus_TxSineGain;

   // Add in shift by 3 to account for change in value from 4.12 to 1.15
   ul_data |= ((ul_exp +3) <<16);
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_TxVarGain = ul_data;
}

/***************************************************************************************
;  Subroutine Name: LoadTxSineGainUnity
;
;  Description:
;     This function sets the Tx Variable Gain to unity in Strymon.
;       It is used in Dec train when calculating the dec path delay
;  Prototype:
;     void SetTxSineGainUnity(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/

void SetTxSineGainUnity(void)
{
   uint32 ul_data;
   // COMMENT_STEFAN: Why are we waisting LSBs?
   // #define UNITY_TX_VAR_GAIN        (0x1000)      //  = 1/8 in Q1.15
   // #define UNITY_TX_VAR_GAIN_EXP    (3)           //  =   8

   ul_data  = UNITY_TX_VAR_GAIN;
   ul_data |= (UNITY_TX_VAR_GAIN_EXP<<16);
   WriteCoreReg((uint32)V_TX_VARGAIN_ADDR, ul_data);
   gt_vrx5dfe_dsl_config.ul_TxVarGain = ul_data;
}
/***************************************************************************************
;  Subroutine Name: Reconfig_HBFILT_scaling
;
;  Description:
;     This function alters the output scaling of HB filter.
;
;  Prototype:
;     void Reconfig_HBFILT_scaling(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/
void Reconfig_HBFILT_scaling(void)
{
   uint32 ul_data;

   ReadCoreReg((uint32)(V_HBFILT_CFG_ADDR),&ul_data);
   ul_data &= (uint32)(~(0x7<<28));//bits 28:30 HB Filt output scaling
   ul_data |= (uint32)(0x2<<28);
   WriteCoreReg((uint32)(V_HBFILT_CFG_ADDR), ul_data);

}
