/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   IRI_Ini1_2.0.C
 *
 *   Iridia Initialization functions
 *
 *
 *----------------------------------------------------------------------------
 */


#include "common.h"
#include "LL_Iof.h"
#include "memrymap.h"


/***************************************************************************************
;  Subroutine Name: void SetUpRxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
;
;  Description:
;
;  Initializes Iridia IR_MIN_TONES and IR_MAX_TONES registers
;
;  Prototype:
;     void SetUpRxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/


C_SCOPE void SetUpRxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
{

    uint32 ul_data;

   ul_data =
      ((uint32)(us_MinToneIndex & 0x01FFF)) |
      ((uint32)(us_MaxToneIndex & 0x01FFF) << 16);
   WriteCoreReg((uint32)IRI_QT_REG_RX_ACTIVE_ADDR, ul_data);
}

/***************************************************************************************
;  Subroutine Name: void SetUpTxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
;
;  Description:
;
;  Initializes Iridia IT_MIN_TONES and IT_MAX_TONES registers
;
;  Prototype:
;     void SetUpTxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
;
;  Input Arguments:
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;**********************************************************************************************/


C_SCOPE void SetUpTxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex)
{

    uint32 ul_data;

   ul_data =
      ((uint32)(us_MinToneIndex & 0x01FFF)) |
      ((uint32)(us_MaxToneIndex & 0x01FFF) << 16);
   WriteCoreReg((uint32)IRI_QT_REG_TX_ACTIVE_ADDR, ul_data);
}
