/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   StartTxDataPump_BIS.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */
// ******************************************************************
// StartTxDataPump_BIS.c
//
// History
//
// 26/08/2011 Sriram Shastry : Function Calculate_DiscardFrame_Threshold() is moved (Show2_PMSwap page from Show1_PMSwap) to optimize Showtime program memory.
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
// 18/06/2012 Raghu M :Calculate_DiscardFrame_Threshold() is modified so that disscard frame threshold/flag is updated based on PDF of metric values. This PDF is updated every frame.
// Grep for XDSLRTFW-284 Enhancement_ALL_BisPLus_ALL_L2
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 24/12/2012 ChihWen/Vinjam: Integration of R3.5 dying Gasp code changes to R5.2.
//            Overwrite one time the Tx IB FIFO with LPR indication when dying gasp event is happening (GPIO pin 15), so that the LPR will be indicated
//       in the next US OHC frame. The reason for doing so was that there could be one OHC frame delay between the dying gasp event and
//       the time when Tx IB FIFO was empty. This delay would cause one OHC frame later for indicating LPR.
//             Grep for XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR
// ******************************************************************

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "zep_memmap_cnfg.h" // mem map for buffers in iibram.
#include "tx_plam.h"
#include "cmv.h"
#include "tx_ovrhd_bis.h"
#include "ZPH_IOf.h"
#include "pll.h"

//used in GetTxFramingByteCnts
#define USE_TX_FIFO  (1)
#define TX_SEQP_DONE (1)
#define IBITS_FIFO   (2)
#define IBITS_FIFO_WRITE  ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<10))
#define IBITS_FIFO_UPDATE ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<16))

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
void WriteRrcToLp1TxDTB(uint32 ul_PrevRrc);
void InsertDsRRCToDTB(void);

#ifdef TARGET_HW
   uint32 GolayCoding(uint32 ul_LpRcc);
#else
    uint32 GolayCoding(uint32 ul_LpRcc) { return 0; }
#endif
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
extern FlagT gft_debug_LPR;
extern int32 gl_debug_cnt1;
extern int32 gl_debug_cnt2;
//XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)

/*****************************************************************************
;  Subroutine Name: LoadTxFramingByte_BIS(void)
;
;  This subroutine writes framing byte info for next AZ run
;
;  Prototype:
;     void LoadTxFramingByte_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
FlagT LoadTxFramingByte_BIS(void)
{
   int16 i, s_TxFramingByteCount;

   // Dual latency case is also considered here
   for (i = 0; i < gt_tx_config.s_Nlp; i++)
   {
      // Send overhead bytes only when the TxFramingByteCount for that latency path changes from the previous call
      s_TxFramingByteCount = GetTxFramingByteCnts(i); /* this counter goes from 0 to (MSGc+5) */

      // If new CRC overhead superframe started,
      // write the indicator bits based on previous superframe
      // Note: the indicator bits need to be set at Frame0, i.e, before the
      // actual send framing byte.
      // Tx Indicator bit can only be sent on the lowest latency path
      if((i == guc_US_lowest_latency_LP) &&( s_TxFramingByteCount == 0))
      {
         WriteIndicatorBits_bis();
      }

      // If required, send corrupt CRC for the next PMS superframe
      if(s_TxFramingByteCount == 1)
      {


         SendCorruptCRC_BIS(i);
      }

      if (i == gt_tx_config.s_MSGlp)
      {
         TransmitHDLCByte(&gt_TxHDLCMsgFifo);
      }
   }
   return(FALSE); // return value unused
}

/*****************************************************************************
;  Subroutine Name: StartTxDataPump_BIS(void)
;
;  This subroutine kicks off one Zephyr Tx path frame for g.dmt.bis
;
;  Prototype:
;     void StartTxDataPump_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/
void StartTxDataPump_BIS(void)
{

    uint32 ul_data;
   int16 s_lp_bits, s_fifo_bits, s_num_bytes0;

   LoadTxFramingByte_BIS();

   // compute # of bytes needed for QT to process for the next frame
   ReadCoreReg(IRI_QT_REG_TX_LP0_BITS_ADDR, &ul_data);
   s_lp_bits = (int16)(ul_data & 0x0000FFFF);
   ReadCoreReg(IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR, &ul_data);
   s_fifo_bits = (int16)(ul_data >> 8) & 0x7;
   s_num_bytes0 = (s_lp_bits - s_fifo_bits + 7) >> 3;

#ifdef VR9_FIXME

   // compute # of bytes needed for QT to process for the next frame
   ReadCoreReg(IRI_QT_REG_TX_LP1_BITS_ADDR, &ul_data);
   s_lp_bits = (int16)(ul_data & 0x0000FFFF);
   ReadCoreReg(IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, &ul_data);
   s_fifo_bits = (int16)(ul_data >> 8) & 0x7;
   s_num_bytes1 = (s_lp_bits - s_fifo_bits + 7) >> 3;

      ul_data = ((uint32)s_num_bytes0 | (uint32)(s_num_bytes1<< 16));
#endif


//this is for Lp0 only
   WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR,(uint32) s_num_bytes0); //Per port register
   WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR,(uint32) s_num_bytes0);

#ifdef ZEP_DEBUG_BLD
   UpdateTxFifo3Stat();
#endif

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
    if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
    {
        InsertDsRRCToDTB();
    }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

}



/***************************************************************************************
;  Subroutine Name: GetTxFramingByteCnts(int16 s_LatencyPath)
;
;  Description:
;     This function gets, from Zephyr, current tx framing byte count for LP0
;     and LP1 paths codeword.
;
;  Prototype:
;     int16 GetTxFramingByteCnts(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     s_TxFramingByteCount
;
;***************************************************************************************/

int16 GetTxFramingByteCnts(int16 s_LatencyPath)
{

   uint32 ul_addr, ul_data ;
   uint8 uc_NumValidBytes ;
   int16 s_TxFramingByteCount;

   // this function returns a certain framing byte count number
   // to trigger appropriate task in TC layer
   // this is done so to share TC task code with Socrates
   s_TxFramingByteCount = -2;

   // return count = 1 to trigger corrupt CRC transmission
   // at the end of each SEQp period

   if    (s_LatencyPath == LP0_DATA_PATH)
      ul_addr = ZEP_PRAM_ZT_R0_LP0_ADDR ;
   else
      ul_addr = ZEP_PRAM_ZT_R0_LP1_ADDR ;

   // check if this frame is the end of superframe for INLV path
   ReadCoreReg(ul_addr, &ul_data);

   if (ul_data & TX_SEQP_DONE)
   {
      s_TxFramingByteCount = 1;

      // clear superframe done bit
      ResetCoreReg(ul_addr, TX_SEQP_DONE);

   }

   // return count = 0 to trigger IB bytes insertion
   // when FIFO has consumed all 4 IB bytes
   if (s_LatencyPath == gt_tx_config.s_IBITSlp) {

    uc_NumValidBytes = getNumValidBytes( s_LatencyPath , IBITS_FIFO , USE_TX_FIFO );

   if (uc_NumValidBytes == 0)
         s_TxFramingByteCount = 0;
   }

   return (s_TxFramingByteCount);

}

/***************************************************************************************
;  Subroutine Name: SendCorruptCRC_BIS(int16 s_LatencyPath)
;
;  Description:
;     This function corrupt Zephyr transmit CRC octet per PERp
;
;  Prototype:
;     void SendCorruptCRC_BIS(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
void SendCorruptCRC_BIS(int16 s_LatencyPath)
{

   uint32 ul_addr = 0;

    if (STATArray[STAT_ACTIVEBCLP_US] & LP0_ACTIVE)   /* if interleave CRC calculation is enabled */
    {
        ul_addr = (uint32)(ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR );
    }
    else if (STATArray[STAT_ACTIVEBCLP_US] & LP1_ACTIVE)
    {
        ul_addr = (uint32)(ZEP_PRAM_ZT_CRC_CTRL0_LP1_ADDR );/* if fast CRC calculation is enabled */
    }

    if (gft_send_crc_corrupt_bits_flag)
    {
        SetCoreReg(ul_addr, (uint32)MASK_BIT8);
    }
    else
    {
        ResetCoreReg(ul_addr, (uint32)MASK_BIT8);
    }
}

/*****************************************************************************
;  Subroutine Name: WriteIndicatorBits_bis()
;
;  This function writes indicator bits into zephyr IB register
;
;  Prototype:
;     void WriteIndicatorBits_bis(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void WriteIndicatorBits_bis(void)
{
   uint32  ul_error = 0;
   uint8 uc_NumValidBytes;

   // IB #1 (NTR) - upstream NTR will never be valid
   guc_ibits[0] = (uint8)0xFF;

   // IB #2 (PMD)
   guc_ibits[1] = (uint8)0xFF;

   // update bit7 - LOS defect
   if ((gt_tx_Anomaly.uc_los_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressLosIbToCO))
      guc_ibits[1] &= LOS_IB;

   // update bit6 - RDI defect
   if ((gt_tx_Anomaly.uc_sef_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressSefIbToCO))
      guc_ibits[1] &= SEF_IB;

   // update bit5 - LPR defect
   if (gs_IB_lpr_cnt > 0) {
      gs_IB_lpr_cnt--;
      if (!(TESTArray[TEST_Control3] & TEST_SuppressLprIbToCO))
         guc_ibits[1] &= LPR_IB;
   }

   // IB #3 (PMS-TC) - reserved
   guc_ibits[2] = (uint8)0xFF;

   // IB #4 (TPS-TC)
   guc_ibits[3] = (uint8)0xFF;

   if (!(TESTArray[TEST_Control3] & TEST_SuppressCdIbToCO)) {
      if ((gt_tx_Anomaly.uc_lcd_def[0] == PRESENT) || (gt_tx_Anomaly.uc_ocd_anom[0] == PRESENT)
         ||(gt_tx_Anomaly.uc_ncd_anom[0] == PRESENT))
         guc_ibits[3] &= LCD_BC0_IB;

      if ((gt_tx_Anomaly.uc_lcd_def[1] == PRESENT) || (gt_tx_Anomaly.uc_ocd_anom[1] == PRESENT)
         ||(gt_tx_Anomaly.uc_ncd_anom[1] == PRESENT))
         guc_ibits[3] &= LCD_BC1_IB;
   }

   // read FIFO2 (LP0:IBITS FIFO) valid bytes counter
    uc_NumValidBytes = getNumValidBytes( LP0_DATA_PATH , IBITS_FIFO, USE_TX_FIFO);

   // if there is any IB byte left in FIFO
   if (uc_NumValidBytes == 0)
    //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (START)
   {
      //if (gft_debug_LPR == 1)
      //{
      // if (gl_debug_cnt1 != 0)
      // {
      //    guc_ibits[2] = (uint8)((gl_debug_cnt1 & 0x0000ff00) >> 8);
      //    guc_ibits[3] = (uint8)(gl_debug_cnt1 & 0x000000ff);
      //    gl_debug_cnt1 = 0;
      // }
      // else if (gl_debug_cnt2 != 0)
      // {
      //    guc_ibits[2] = (uint8)((gl_debug_cnt2 & 0x0000ff00) >> 8);
      //    guc_ibits[3] = (uint8)(gl_debug_cnt2 & 0x000000ff);
      // }
      //}
      gl_TxIbFiFoWriteCnt++;

      WriteHwFifo(LP0_DATA_PATH , IBITS_FIFO , USE_TX_FIFO , 4, guc_ibits);
   }
    //XDSLRTFW-652 XDSLRTFW-463 IOP_US_BisPlus_ALL_OverwriteTxIbFiFoForLPR (END)
   else
      ul_error = 1;


}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
/*****************************************************************************
;  Subroutine Name: Calculate_DiscardFrame_Threshold()
;
;  This subroutine evaluates the metric of each DMT symbol and set the frame
;   discard flag for DD adaptation.
;
;  Prototype:
;     void Erasure_Reconfig(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

// Below function is moved to Show2_PMSwap page from Show1_PMSwap ,functional call is from Show2Page
// this is done to optimize the PM crunch

// Below function is moved to Show2_PMSwap page from Show1_PMSwap ,functional call is from Show2Page
// this is done to optimize the PM crunch

// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (START)

#define NUM_BITS_METRIC  (8)
#define METRIC_SHIFT     (5)
#define NUM_BIN_HIST     (1 << (NUM_BITS_METRIC-METRIC_SHIFT))
#define NUM_FRAMES_TRACK (1 << 14) // should be power of 2
#define MAX_IMPULSE_LEN  (16)


extern uint16 gusa_HistMetric[NUM_BIN_HIST];
extern uint8  guca_HistImp[MAX_IMPULSE_LEN];
extern uint8 guc_MetricShift;

int16 gus_FrmCnt;
int16 gus_PrevFrmCnt;
int16 gus_ImpPrd;
int8 guc_MaxImp=0;
int8 guc_CurImp=0;
//uint8 guc_CurFrameMetric;
int8 gft_ResetTrelMetricHist;

void Calculate_DiscardFrame_Flag(void)
{

    uint32 ul_metric_value;
   uint8 uc_metric_value;
   int i,max,max_index;
   int shift = guc_MetricShift;
   int threshold;

   ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &ul_metric_value);



   uc_metric_value = (uint8)(ul_metric_value & 0xFF);
   //guc_CurFrameMetric = uc_metric_value;
    // Store ED Metric value in a global variable
    guc_metric_value =  uc_metric_value;  // XDSLRTFW-2579

    uc_metric_value = uc_metric_value >> METRIC_SHIFT;

   // Genrate histogram on metric values
    gusa_HistMetric[uc_metric_value]++;

   if (gusa_HistMetric[uc_metric_value] == 0xFFFF)
   {
        for (i=0;i<NUM_BIN_HIST;i++)
         gusa_HistMetric[i] = gusa_HistMetric[i]>>8;
   }

    max = 0;
   max_index = NUM_BIN_HIST;

   for (i=0;i<NUM_BIN_HIST;i++)
   {
      if ( max < gusa_HistMetric[i])
      {
         max = gusa_HistMetric[i];
         max_index = i;
      }
   }

    if ( max_index > 3)
    {
      threshold = max_index-2;
    }
   else
   {
      threshold = 1 ;
   }

   if (gusa_HistMetric[NUM_BIN_HIST-1])
   {
      shift++;
   }
   else if(max_index < ((NUM_BIN_HIST/2)-1))
   {
      shift--;
   }

   if (shift < 0)
      shift = 0;
   else if (shift > 0xf)
      shift = 0xf;


   if ((shift != guc_MetricShift) || (gft_ResetTrelMetricHist))
   {
      WriteCoreReg (IRI_QT_REG_RX_RMETRIC_CTL_ADDR,  (0x10 + shift));
      guc_MetricShift = shift;

        for (i=0;i<NUM_BIN_HIST;i++)
         gusa_HistMetric[i] = 0;

      guc_MaxImp = 0;
      gus_ImpPrd = 0;
      gus_PrevFrmCnt = 0;
      gft_ResetTrelMetricHist = 0;
   }


    if (uc_metric_value < threshold)
        gft_frame_with_lowmetric = 1;
     else
        gft_frame_with_lowmetric = 0;


}
// XDSLRTFW-416: Enhancement_ALL_BisPLus_ALL_L2 (END)


void Calculate_DiscardFrame_Threshold(void)
{

    //read the metric of most recent DMT symbol.
    uint32 ul_metric_value;
   uint8 uc_metric_value;

   ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &ul_metric_value);

   uc_metric_value = (ul_metric_value & 0xFF);
   //guc_CurFrameMetric = uc_metric_value;
    // Store ED Metric value in a global variable
    //guc_metric_value =  uc_metric_value;  // XDSLRTFW-2579

    if (gft_cal_discard_metric_threshold)
     //check flag to (re)calculate the threshold from discarding frame
     {
         //reset the max_metric and min_metric during the first frame of the evaluation period
        if (gus_metric_eval_cnt == 0)
        {
            guc_max_metric = 0;
            guc_min_metric = 0xFF;
            gus_metric_eval_cnt ++;
        }
        // find the max metric  over gus_metric_eval_period
        else if (gus_metric_eval_cnt < gus_metric_eval_period)
        {
            gus_metric_eval_cnt ++;

            if (uc_metric_value > guc_max_metric)
                guc_max_metric = uc_metric_value;
            else if (uc_metric_value < guc_min_metric)
                guc_min_metric = uc_metric_value;

        }
        else // if (gus_metric_eval_cnt == gus_metric_eval_period)
        {
            gus_metric_eval_cnt = 0;
            //case of impulse noise is present when entering showtime
            if (guc_max_metric - guc_min_metric > 32 || guc_max_metric >2* guc_min_metric)
                guc_metric_discard_threshold = guc_min_metric + (guc_max_metric - guc_min_metric)/4;
            else // case of FT type of impulse noise: set the discard threshold = 0.5*(guc_max_metric)
                guc_metric_discard_threshold = guc_max_metric/2;
            //reset the discard threshold calculation flag
            gft_cal_discard_metric_threshold =0;
        }
     }
     // if the metric of current frame is lower than the threshold for discarding
     // set the frame with lowmetric and disable DD
     if (uc_metric_value < guc_metric_discard_threshold)
        gft_frame_with_lowmetric = 1;
     else
        gft_frame_with_lowmetric = 0;
}
//Sriram : Moved to Show2_PMSwap
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
// initialization of RRC_Stat_t
// ....

//
// Each time we send out RRC for just num_of_dtus_per_frame
// if there's no new coming RRC info, we'll resend the previous RRC
// to simplify our RRC processing.
//
// Initially, ul_PrevRrc will be set to 0 <=> first DTU is correct.
//
void InsertDsRRCToDTB(void)
{
    uint32 ul_PrevRrc;
    uint64 ull_64MostRecentDtuStats;
    uint32 ul_2MostRecentDtuStats;
    uint32 ul_31MostRecentDtuStats;
    uint32 ul_CurrAbsDtuNum;
    int32  i;


    i = gt_RrcStat.ft_RrcStatUpdated;
    ull_64MostRecentDtuStats = gt_RrcStat.ull_64MostRecentDtuStats;

    if (i)  // need to generate new RRC
    {
        ul_2MostRecentDtuStats = (uint32)(ull_64MostRecentDtuStats & 0x3);
        ul_31MostRecentDtuStats = (uint32)(ull_64MostRecentDtuStats >> 1);

        ul_CurrAbsDtuNum = gt_RrcStat.uc_AbsDtuNum & 0x1F;
        ul_PrevRrc = 0;

        if (ul_2MostRecentDtuStats & MASK_BIT1)
        {
            uint32 ul_LookBackMask;
            uint32 ul_LookBackCount;

            ul_LookBackCount = gt_ReTxConfigInfo.us_Lb_val;
            ul_LookBackMask = 1 << ul_LookBackCount;

            // look for NACK==1 starting from 31st DTU
            for (i = ul_LookBackCount; i > 0; i--)
            {
                if ((ul_31MostRecentDtuStats & ul_LookBackMask) != 0)
                {
                    break;
                }

                // ul_PrevRrc = consecutive count
                ul_PrevRrc++;
                ul_31MostRecentDtuStats <<= 1;
            }
        }
        else
        {
            // look for NACK==1 starting from 1st DTU
            for (i = 31; i > 0; i--)
            {
                if ((ul_31MostRecentDtuStats & MASK_BIT1) != 0)
                {
                    break;
                }

                // ul_PrevRrc = consecutive count
                ul_PrevRrc++;
                ul_31MostRecentDtuStats >>= 1;
            }
        }

        ul_PrevRrc <<= 7;                                   // consecutive count starts at bit 7
        ul_PrevRrc |= (ul_2MostRecentDtuStats << 5);        // two most recent NACKs starts at bit 5
        ul_PrevRrc |= ul_CurrAbsDtuNum;

        #ifdef EXTRA_RETX_LOG
        // log 2 most recent RRCs (without golay bits)
        gt_ReTXStats.ul_LastRrcs = (gt_ReTXStats.ul_LastRrcs << 16) | ul_PrevRrc;
        #endif
        ul_PrevRrc = GolayCoding(ul_PrevRrc);

        gt_RrcStat.ul_PrevRrc = ul_PrevRrc;
        gt_RrcStat.ft_RrcStatUpdated = 0;

    }
    else
    {
        ul_PrevRrc = gt_RrcStat.ul_PrevRrc;
    }

    WriteRrcToLp1TxDTB(ul_PrevRrc);

    return;
}



//SMS01435825: Golay bits generation for Universal Retransmission Begin
uint32 GolayCoding(uint32 ul_LpRcc)
{
   uint16 us_GolayMask[12] = {0x1ED,0x6E3,0xDC6,0x7B4,0xAB9,0x93E,0x49F,0xA4F,0xF68,0xF13,0x3DA,0xC75};
   uint16 us_GolayCode = 0;
   uint16 us_parity = 0;
   uint16 i,j,us_temp;

   us_GolayCode = 0;
   for(i=0; i < 12;i++ )
   {
      us_temp = (uint32)(us_GolayMask[i]) & (ul_LpRcc & 0xfff);
      us_parity = 0;
      us_GolayCode = us_GolayCode << 1;

      for(j=0;j < 12; j++)
      {
         if(us_temp & (1 << j))
         {
         us_parity++;
         }//if

      }//for j
      if(us_parity & 0x1)
      {
         us_GolayCode = (us_GolayCode | 0x1);
      }

   }//for i

   ul_LpRcc = (int32)(us_GolayCode << 12) | ul_LpRcc;
   return(ul_LpRcc);
}
//SMS01435825: Golay bits generation for Universal Retransmission End


void WriteRrcToLp1TxDTB(uint32 ul_PrevRrc)
{
   WriteCoreReg((uint32)(ZEP_ILV_RAM_DTB_ADDR + (ZEP_ILV_RAM_RETX_TXDTB_LP1_BASE << 2)), ul_PrevRrc);
}
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
