/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */
//------------------------------------------------------------------------------
//
// ZPH_IOf.C
//
// History
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//--------------------------------------------------------------------------------


#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "cmv.h"
#include "ALP_IOf.h"
#include "bert.h"
#include "tx_plam.h"
#include "rx_ib.h"
#include "delay.h"
#include "ZPH_Iof.h"
#include "zep_memmap_cnfg.h"

extern uint16 gus_TxEocRegister;

extern MessageFifo_t gt_TxEocFifo;

/* Global variables for BERT */              // ADR into gdata.c
extern uint8 guc_Start_BERT_Rx ;
extern uint8 guc_Start_BERT_Tx ;

uint8   getNumValidBytes( uint16 s_LatencyPath , uint8 fifoNum , uint16 us_Tx_Rx)
{
   uint32 ul_data , ul_loopCount = 0;
   uint8 uc_NumValidBytes = 0, uc_done=0;
   uint32 ul_addr;

   if (us_Tx_Rx)
      ul_addr = ZEP_REG_ZT_FIFO_ACCESS_ADDR;
   else
      ul_addr = ZEP_REG_ZR_FIFO_ACCESS_ADDR;

   ul_data =  (((s_LatencyPath&3) << 12)|((fifoNum&3)<<8)|(1<<16));
   WriteCoreReg(ul_addr, ul_data);

   while (!uc_done)
   {
      // ReadCoreReg(ZEP_REG_ZT_FIFO2_CTRL_ADDR, &ul_data);
      // uc_NumValidBytes = (uint8)(ul_data & TX_FIFO2_VALID_BYTES_MASK);
      ReadCoreReg(ul_addr, &ul_data);
      if ( (ul_data>>11) & 0x1 ) //FIFO_RDY = 1
      {
         uc_done = 1;
         uc_NumValidBytes = (uint8)((ul_data >> 17) & 0x3F);
      }
      if (ul_loopCount++ > 4096)
      // Fifo read error  // FIXME Should handle this error
      return(0xFF);
   };

   return(uc_NumValidBytes);
}

/* copy contents of Zep_IB_Reg into 32-bit global (TC) */
C_SCOPE void GetIndicatorBits(void)
{

// int32 idx ;
   uint8 uc_NumValidBytes, uc_NumIBBytes;
   int16 s_fifoLP;

#ifdef DUAL_LATENCY
   s_fifoLP = gt_rx_config.s_IBITSlp;
#else
   s_fifoLP = LP0_DATA_PATH;
#endif

   // read FIFO2 valid bytes counter;
    uc_NumValidBytes = getNumValidBytes( s_fifoLP , IBITS_FIFO , USE_RX_FIFO);


   if (( gl_SelectedMode & (MODE_ADSL2)  )) // ADSL2 framing mode
      uc_NumIBBytes = 4;
   else // ADSL framing mode
      uc_NumIBBytes = 3;


   if (uc_NumValidBytes >= uc_NumIBBytes) {
      gul_RxIbInfo = 0 ;

      // ZR_FIFO2_BYTE
      // read 3 or 4 bytes  from FIFO into longword.gul_RxIbInfo

      ReadHwFifo(s_fifoLP , IBITS_FIFO , USE_RX_FIFO, uc_NumIBBytes, (void *) &gul_RxIbInfo);

/* prior code
      for (idx=0 ; idx<uc_NumIBBytes ; idx++) {
         ReadCoreReg(ZEP_REG_ZR_FIFO2_BYTE_ADDR, &ul_data);

         // decrement valid byte count
         uc_NumValidBytes--;
         WriteCoreReg((uint32)ZEP_REG_ZR_FIFO2_CTRL_ADDR, (uint32)uc_NumValidBytes);
         // Some byte overlap was observed, when no further processing was done
         // between the above WriteCoreReg and the next ReadCoreReg.
         // Add a delay etc to avoid this...
         delay(10) ;

         gul_RxIbInfo |= (ul_data & 0xFF) << 8*idx ;
      }
*/

   } // if (uc_NumValidBytes >= uc_NumIBBytes)

}

/****************************************************************************
; Name: ReadHwFifo
;
; Prototype:
;  void ReadHwFifo()
;
; Description:
;  This function reads Rx overhead bytes from a FIFO of the Zephyr core.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;
*****************************************************************************/
C_SCOPE void ReadHwFifo(uint16 fifoLP , uint16 fifoNum , uint16 us_Tx_Rx , uint16 us_numReqBytes, uint8 *puc_outbuf)
{

   uint32 ul_data, ul_dataRead;
   uint8 i;
   uint32 ul_addr;

   if (us_Tx_Rx)
      ul_addr = ZEP_REG_ZT_FIFO_ACCESS_ADDR;
   else
      ul_addr = ZEP_REG_ZR_FIFO_ACCESS_ADDR;

   ul_data = ((fifoNum &3) << 8);      //FIFO_NUM
   ul_data |= ((fifoLP & 3) << 12); //FIFO_LP


   do {
      ReadCoreReg(ul_addr, &ul_dataRead);

   } while ((ul_dataRead & (1<<11)) == 0); //until FIFO_RDY(bit 11) = 1

   // Empty out the HW fifo based on valid bytes to read value
   for (i = 0; i < us_numReqBytes; i++)
   {
      //ul_data |= 0 << 10; //10 FIFO_Read
      WriteCoreReg(ul_addr, ul_data);

      do {
         ReadCoreReg(ul_addr, &ul_dataRead);

      } while ((ul_dataRead & (1<<11)) == 0); //until FIFO_RDY(bit 11) = 1

      *puc_outbuf++ = (uint8)(ul_dataRead & 0xFF);
   }
}
/****************************************************************************
; Name: writeHwFifo
;
; Prototype:
;  void WriteHwFifo()
;
; Description:
;  This function writes overhead bytes to a FIFO of the Zephyr core.
;
; Arguments:
;  N/A
;
; Return Value:
;  N/A
;
; Globals:
;
*****************************************************************************/
C_SCOPE void WriteHwFifo(uint16 fifoLP , uint16 fifoNum , uint16 us_Tx_Rx , uint16 us_numReqBytes, uint8 *puc_inbuf)
{

   uint32 ul_data, ul_dataWrite;
   uint8 i;
   uint32 ul_addr;

   if (us_Tx_Rx)
      ul_addr = ZEP_REG_ZT_FIFO_ACCESS_ADDR;
   else
      ul_addr = ZEP_REG_ZR_FIFO_ACCESS_ADDR;

   ul_dataWrite = ((fifoNum &3) << 8);    //FIFO_NUM
   ul_dataWrite |= ((fifoLP & 3) << 12);  //FIFO_LP
   ul_dataWrite |= (1<<10); // FIFO_WRITE CNTRL


   // Fill the HW fifo based on valid bytes to read value
   // Fill the HW fifo based on valid bytes to read value
   for (i = 0; i < us_numReqBytes; i++)
   {
      do {
         ReadCoreReg(ul_addr, &ul_data);
      } while ((ul_data & (1<<11)) == 0); //until FIFO_RDY(bit 11) = 1

      ul_data = ul_dataWrite | (*puc_inbuf++ & 0xFF);
      WriteCoreReg(ul_addr, ul_data);
   }//for
}


//Zephyr debug code
#ifdef ZEP_DEBUG_BLD

void EnableTxFifo3Capture(void)
{
   uint32 ul_data;

   // Use FIFO3 to capture the input data to the scrambler
   ul_data = ZEP_RAM_TX_OHFIFO3_DBG0_OFFSET;
   ul_data |= (ZEP_RAM_TX_OHFIFO3_DBG0_SIZE-1) << 19;
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE3_LP0_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_CNST3_LP0_ADDR, 0);

   //Compute the maximum number of bytes per symbol to transmit
   //To be conservative, we use this number to estimate the number
   //of symbols that can be stored in FIFO3
   //(the actual number of scrambler input bytes could be less than this number
   // if we count the RS overhead)
   gs_TxScamNumBytesPerSym = gt_tx_config.s_Lp[LP0_DATA_PATH]>>3;

   //Double this size to prevent the variation between frames, causing buffer wrap around
   gs_TxScamNumBytesPerSym <<= 1;

   gs_TxPreWRPTR = 0;
   gs_CapturedTxScamSyms = 0;
   gs_TxCapBufFullness = ZEP_RAM_TX_OHFIFO3_DBG0_SIZE;

   if(gs_TxScamNumBytesPerSym <= gs_TxCapBufFullness)
   {
      //Enable capture
      gft_TxFifo3Capture = FIFO3_CAPTURE_ENABLE;
   }
   else
   {
      //Indicate the buffer is not big enough to store one symbol of bytes
      gft_TxFifo3Capture = FIFO3_CAPTURE_ERROR;
   }

} //void EnableTxFifo3Capture(void)

void DisableTxFifo3Capture(void)
{
   uint32 ul_data;

   //Move the FIFO2 point to a dummy buffer
   ul_data = ZEP_RAM_TX_OHFIFO3_DBG1_OFFSET;
   ul_data |= (ZEP_RAM_TX_OHFIFO3_DBG1_SIZE-1) << 18;
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE3_LP0_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_CNST3_LP0_ADDR, 0);

} //void DisableTxFifo3Capture(void)

void UpdateTxFifo3Stat(void)
{
   uint32 ul_data;
   int16 s_WritePtr, s_NumBytes;

   if(gft_TxFifo3Capture == FIFO3_CAPTURE_ENABLE)
   {
      ReadCoreReg(ZEP_PRAM_ZT_FIFO_PTRS3_LP0_ADDR, &ul_data);

      //Get the write pointer value
      s_WritePtr = ul_data & 0xFFF;

      if(s_WritePtr > gs_TxPreWRPTR)
      {
         //Updata symbol count
         gs_CapturedTxScamSyms++;

         //Update the buffer fullness
         s_NumBytes = s_WritePtr - gs_TxPreWRPTR;
         gs_TxCapBufFullness -= s_NumBytes;

         //Update the previous write pointer
         gs_TxPreWRPTR = s_WritePtr;

         if(gs_TxCapBufFullness < gs_TxScamNumBytesPerSym)
            gft_TxFifo3Capture = FIFO3_CAPTURE_GETDATA;
      }
      else if(s_WritePtr < gs_TxPreWRPTR)
      {
         //Indicate that wrap around occurs
         gft_TxFifo3Capture = FIFO3_CAPTURE_ERROR;
      }
      //else if(s_WritePtr == gs_TxPreWRPTR)
      //no capture has happened

      if((gft_TxFifo3Capture == FIFO3_CAPTURE_GETDATA) || (gft_TxFifo3Capture == FIFO3_CAPTURE_ERROR))
      {
         //Disable TX FIFO3 capture
         DisableTxFifo3Capture();
      }

#ifndef TARGET_HW
      if(gft_TxFifo3Capture == FIFO3_CAPTURE_GETDATA)
      {
         ReadFifo3Data(TX, (int16)(ZEP_RAM_TX_OHFIFO3_DBG0_SIZE-gs_TxCapBufFullness), guca_TxFifo3CapBuf);
      }
#endif //#ifdef TARGET_COCOMO

   } //if(gft_TxFifo3Capture == FIFO3_CAPTURE_ENABLE)

} //void UpdateTxFifo3Stat(void)
#endif //#ifdef ZEP_DEBUG_BLD
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
void EnableRxFifo3Capture(void)
{
   uint32 ul_data;

   // Use FIFO3 to capture the output data from the DeScrambler
   ul_data = ZEP_RAM_RX_OHFIFO3_DBG0_OFFSET;
   ul_data |= (ZEP_RAM_RX_OHFIFO3_DBG0_SIZE-1) << 18;
#ifdef FIFO3_FOR_RETX
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP1_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP1_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST3_LP1_ADDR, 0);
#else
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP0_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST3_LP0_ADDR, 0);
#endif

   //Compute the maximum number of bytes per symbol to transmit
   //To be conservative, we use this number to estimate the number
   //of symbols that can be stored in FIFO3
   //(the actual number of scrambler input bytes could be less than this number
   // if we count the RS overhead)
#ifdef   FIFO3_FOR_RETX
   gs_RxScamNumBytesPerSym = gt_rx_config.s_Lp[LP1_DATA_PATH]>>3;
#else
   gs_RxScamNumBytesPerSym = gt_rx_config.s_Lp[LP0_DATA_PATH]>>3;
#endif

   //Double this size to prevent the variation between frames, causing buffer wrap around
   gs_RxScamNumBytesPerSym <<= 1;

   gs_RxPreWRPTR = 0;
   gs_CapturedRxScamSyms = 0;
   gs_RxCapBufFullness = ZEP_RAM_RX_OHFIFO3_DBG0_SIZE;

   if(gs_RxScamNumBytesPerSym <= gs_RxCapBufFullness)
   {
      //Enable capture
      gft_RxFifo3Capture = FIFO3_CAPTURE_ENABLE;
   }
   else
   {
      //Indicate the buffer is not big enough to store one symbol of bytes
      gft_RxFifo3Capture = FIFO3_CAPTURE_ERROR;
   }

} //void EnableRxFifo3Capture(void)


void DisableRxFifo3Capture(void)
{
   uint32 ul_data;

   // Use FIFO3 to capture the output data from the DeScrambler
   ul_data = ZEP_RAM_RX_OHFIFO3_DBG1_OFFSET;
   ul_data |= (ZEP_RAM_RX_OHFIFO3_DBG1_SIZE-1) << 19;
#ifdef FIFO3_FOR_RETX
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP1_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP1_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST3_LP1_ADDR, 0);
#else
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE3_LP0_ADDR, ul_data);

   WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR, 0);
   WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST3_LP0_ADDR, 0);
#endif

} //void DisableRxFifo3Capture(void)

void UpdateRxFifo3Stat(void)
{
   uint32 ul_data;
   int16 s_WritePtr, s_NumBytes;

   if(gft_RxFifo3Capture == FIFO3_CAPTURE_ENABLE)
   {
#ifdef FIFO3_FOR_RETX
      ReadCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP1_ADDR, &ul_data);
#else
      ReadCoreReg(ZEP_PRAM_ZR_FIFO_PTRS3_LP0_ADDR, &ul_data);
#endif
      //Get the write pointer value
      s_WritePtr = ul_data & 0xFFF;

      if(s_WritePtr > gs_RxPreWRPTR)
      {

         //Updata symbol count
         gs_CapturedRxScamSyms++;

         //Update the buffer fullness
         s_NumBytes = s_WritePtr - gs_RxPreWRPTR;
         gs_RxCapBufFullness -= s_NumBytes;

         //Update the previous write pointer
         gs_RxPreWRPTR = s_WritePtr;

         if(gs_RxCapBufFullness < gs_RxScamNumBytesPerSym)
            gft_RxFifo3Capture = FIFO3_CAPTURE_GETDATA;
      }
      else if(s_WritePtr < gs_RxPreWRPTR)
      {
         //Indicate that wrap around occurs
         gft_RxFifo3Capture = FIFO3_CAPTURE_ERROR;
      }
      //else if(s_WritePtr == gs_RxPreWRPTR)
      //no capture has happened

      if((gft_RxFifo3Capture == FIFO3_CAPTURE_GETDATA) || (gft_RxFifo3Capture == FIFO3_CAPTURE_ERROR))
      {
         //Disable RX FIFO3 capture
         DisableRxFifo3Capture();
      }

#ifndef TARGET_HW
      if(gft_RxFifo3Capture == FIFO3_CAPTURE_GETDATA)
      {
         ReadFifo3Data(RX, (int16)(ZEP_RAM_RX_OHFIFO3_DBG0_SIZE-gs_RxCapBufFullness), guca_RxFifo3CapBuf);

//Mei test code
/*
         {
            FILE *fpTx, *fpRx;
            int16 s_MisMatchs, i;

            fpTx = fopen("fscram_tx.txt", "w");
            fpRx = fopen("fscram_rx.txt", "w");

            s_MisMatchs = 0;
            for(i=0; i<MIN(ZEP_RAM_RX_OHFIFO3_DBG0_SIZE, ZEP_RAM_TX_OHFIFO3_DBG0_SIZE); i++)
            {
               fprintf(fpTx, "0x%x\n", guca_TxFifo3CapBuf[i]);
               fprintf(fpRx, "0x%x\n", guca_RxFifo3CapBuf[i]);

               if(guca_RxFifo3CapBuf[i] != guca_RxFifo3CapBuf[i])
                  s_MisMatchs++;
            }

            fclose(fpTx);
            fclose(fpRx);
         }
*/
      }
#endif //#ifdef TARGET_COCOMO

   } //if(gft_RxFifo3Capture == FIFO3_CAPTURE_ENABLE)

} //void UpdateRxFifo3Stat(void)

#ifndef TARGET_HW

//s_NumBytes: number of bytes to read (should be integer of 4)
//puc_buf: pointer to the output byte buffer
void ReadFifo3Data(FlagT gft_TxRxFlag, int16 s_NumBytes, uint8 *puc_buf)
{
   uint32 ul_addr;
   int16 i;

   //Init. the address
   if(gft_TxRxFlag == TX)
      ul_addr = ZEP_RAM_TX_OHFIFO3_DBG0_ADDR;
   else
      ul_addr = ZEP_RAM_RX_OHFIFO3_DBG0_ADDR;

   //Convert the byte count to 32-bit word count
   for(i=0; i< (s_NumBytes>>2); i++)
   {
      ReadCoreReg(ul_addr, (int32 *)puc_buf);

      ul_addr += 4;
      puc_buf += 4;
   }

} //void GetZepDbgData(void)

#endif //#ifdef TARGET_COCOMO


#endif //#if   defined (ZEP_DEBUG_BLD) || defined (ZEP_DEBUG_BLD_RX)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

