/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf_hdlc_bis.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "fifo.h"
#include "rx_ovrhd_bis.h"
#include "delay.h"
#include "ZPH_Iof.h"
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : GetHDLCByte(MessageOvhdFifo_t *Fifo)
 *
 *  Description:  This subroutine extracts the received overhead byte and stores
 *          in the gt_RxHDLCMsgFifo
 *
 *  Prototype:
 *      void  GetHDLCByte(MessageOvhdFifo_t *Fifo)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *          gt_RxHDLCMsgFifo
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */


void GetHDLCByte(MessageOvhdFifo_t *Fifo)
{
   uint32 ul_ovhd_word=0;
   uint8 uc_NumValidBytes;

   // read FIFO0 valid bytes counter
// ReadCoreReg(ZEP_REG_ZR_FIFO0_CTRL_ADDR, &ul_data);
// uc_NumValidBytes = (uint8)(ul_data & RX_FIFO0_VALID_BYTES_MASK);
   uc_NumValidBytes =  getNumValidBytes( 0 , 0 , USE_RX_FIFO); // Lp0 , fifo0 , rx.

   while (uc_NumValidBytes > 0) {

      // read one byte
      //ReadCoreReg((uint32)ZEP_REG_ZR_FIFO0_BYTE_ADDR, &ul_ovhd_word);
      ReadHwFifo(LP0_DATA_PATH, HDLC_FIFO, USE_RX_FIFO, 1, (void *) &ul_ovhd_word);
      // decrement valid byte count
      uc_NumValidBytes--;

      switch (guc_HDLC_RxState) {

      case MONITOR:
         // non-opening flag byte received; implies message started
         if (ul_ovhd_word != OPENING_FLAG) {
            AddMessageToOvhdFifo(Fifo, (uint8)ul_ovhd_word);
            guc_HDLC_RxState = ADD_TO_FIFO;
         }
         break;

      case ADD_TO_FIFO:
         // HDLC message being received, add to FIFO
         AddMessageToOvhdFifo(Fifo, (uint8)ul_ovhd_word);
         // if closing flag received, add to FIFO and come out
         if (ul_ovhd_word == OPENING_FLAG)
            guc_HDLC_RxState = MONITOR;
         break;
      }
   }

}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : int16 GetReservedByte(void)
 *
 *  Description:  This subroutine reads the received reserved byte.
 *          As we don't need the reserved byte for any processing, it is
 *          here just for debug check
 *
 *  Prototype:
 *      int16 GetReservedByte(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
#if 0
int16 GetReservedByte(void)
{
   int16 us_regData =0;
   int16 us_ovhd_byte =0;


   /* Check if a Reserved byte received */
   ReadCoreReg(ZEP_REG_ZR_STATUS_ADDR, &us_regData);

   /* read the AOC register when reserved byte received for both latency paths */
   if((us_regData & 0x3) == 0x03)
   {
      /* Clear the bit to detect next reception */
      us_regData &= 0xFFFC;
      WriteCoreReg(ZEP_REG_ZR_STATUS_ADDR, us_regData);

      ReadCoreReg(ZEP_REG_ZR_AOC_ADDR, &us_ovhd_byte);

   }

   return(us_ovhd_byte);
}

#endif
