/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf_bis2.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "fifo.h"
#include "ZPH_Iof.h"
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : TransmitHDLCByte(MessageOvhdFifo_t *Fifo)
 *
 *  Description:  This subroutine transmits the overhead byte stored in the fifo
 *
 *  Prototype:
 *      void  TransmitHDLCByte(MessageOvhdFifo_t *Fifo)
 *
 *  Input Arguments:
 *      The FIFO containing the bytes to be transmitted
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *          gt_TxHDLCMsgFifo
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

#define MAX_NUM_TX_HDLC_BYTES (10)

void TransmitHDLCByte(MessageOvhdFifo_t *Fifo)
{
   uint8 uc_NumValidBytes, uc_tx_ovhd_byte;

   // read FIFO0 valid bytes counter
   //ReadCoreReg(ZEP_REG_ZT_FIFO0_CTRL_ADDR, &ul_data);
   //uc_NumValidBytes = (uint8)(ul_data & TX_FIFO0_VALID_BYTES_MASK);
     uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH , HDLC_FIFO , USE_TX_FIFO); // Lp0 , fifo0 , tx.

   // If we've finished transmitting the last whole msg,
   // stop transmitting HDLC byte even if there might be some new HDLC
   // ovhd byte existing in the FIFO. We don't want to start transmitting
   // the new msg right away without knowing whether the new msg is completed
   // in the FIFO yet. This is to avoid the possible starving problem in the
   // HDLC ovhd fifo.

   // if there is message in the FIFO to be transmitted
   if (gft_Start_Transmit_HDLC) {
      // fill in FIFO so that it always has at least MAX_NUM_TX_HDLC_BYTES
      // HDLC bytes. once FIFO is emptied out, default value (e.g., OPENING_FLAG)
      // will be transmitted automatically
      while (uc_NumValidBytes < MAX_NUM_TX_HDLC_BYTES) {
         if (RemoveMessageFromOvhdFifo(Fifo, &uc_tx_ovhd_byte))
            //WriteCoreReg(ZEP_REG_ZT_FIFO0_BYTE_ADDR, (uint32)uc_tx_ovhd_byte);
            WriteHwFifo(LP0_DATA_PATH, HDLC_FIFO, USE_TX_FIFO , 1, &uc_tx_ovhd_byte);

         uc_NumValidBytes++;
      }
   }


}


