/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf_bis.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */
//------------------------------------------------------------------------------
//
// ZPH_IOf_bis.c
//
// History
//
// 26/08/2011 Sriram Shastry : Function Calculate_DiscardFrame_Threshold() is moved (Show2_PMSwap page from Show1_PMSwap) to optimize Showtime program memory.
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 10/01/2012 Shakil/Bhadra:: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//             due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//             requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//             the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//             than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//             the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//             trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//             did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//             compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//             correct place to be compiled and incremented correctly.
//             Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//          the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//          erasure decoding feature and also make some small modification in the logic to easily
//          understand the code.
//          Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/06/2012 Kannan:
//          1. FIFO3 can be used to get the debug data in Rx Path
//       2. ReTx Queue overflow indication register changed to ZR_R4
//             since ZR_R4 is not being used in LP1 as dummy byte insertion
//          when ReTx is enabled, because when ReTx is enabled LP1
//          is allowed to operate in D=1.
//       3. We need to use the TS which is available in the Book keeping table
//             while delivering DTU's to the TC layer, which was commented by the
//          "#ifdef EXTRA_RETX_LOG"
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 07/9/2012 Vinjam: Code modified to get CRC errors per link (useful for debugging purpose)
//                   Grep for Fix_DS_All_All_ModifiedToGetCRCPerLink
//
// 07/01/2013 Ram: Fix added for JIRA 575. Attach "FEC uncorrectable CW count" to CMV
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 07/12/2012  Bhadra:XDSLRTFW-437: Change the delay reporting from ms to (1/100) ms
//             This is required for precision in delay reporting.
//             For code changes Grep for "XDSLRTFW-437:Enh_BisPlus_ALL_ALL_IntlvDelayIn1By100ms "
//
// 06/12/2013 Sriram Shastry :Implementation standard compliant actual delay in DS ReTx mode.Calculate actual delay using
// Tdmt (time of a DMT symbol in ms), Q (number of FEC CWs per DTU), NFEC (FEC CW size in bytes on latency path 1),
// LSYMB (number of bits per symbol used for latency path 1):
//
//                   Tdmt = 0.25*68/69 for ADSL2/ADSL2P
//                   Tdtu = Q*8*NFEC/LSYMB
//                   delay_act_RTX = round(Tdtu*Tdmt)
//              Grep for :XDSLRTFW-1410: BugFix_DS_ADSL_ALL_ReTX_Delay
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223
//--------------------------------------------------------------------------------


#include "common.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "bert.h"
#include "tx_plam.h"
#include "rx_ovrhd_bis.h"
#include "ZPH_IOf.h"
#include "cmv.h"

extern uint8 guc_Start_BERT_Rx;
extern void DisableRxPms(void);

// Defien used here. Add in a .h
#define RX_SEQP_DONE (1)
#define IBITS_FIFO   (2)
#define IBITS_FIFO_WRITE  ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<10))
#define IBITS_FIFO_UPDATE ((LP0_DATA_PATH << 12)|(IBITS_FIFO<<8)|(1<<16))
#define USE_RX_FIFO (0)


//#define ENABLE_RETX_DS_DEBUG (1)

#ifdef LEAVE_TRAIL
   extern TRAILFILE crc_fid;
#endif

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
// we only support LP0/LP1 and 4 FIFO instances
#define FIFO_READY_MASK             (1 << 11)
#define FIFO_UPDATE_STATUS_MASK     (1 << 16)
#define FIFO_WRITE_MASK             (1 << 10)

#define FIFO_VALID_BYTES_MASK       ((2<<(29 - 17 + 1)) - 1)

void UpdateDsRrcStat(void);
uint32 SetUpZrFifo(int32 l_Fifo_n, int32 l_LP_n);
uint32 ReadZRFifo(int32 l_Fifo_n, int32 l_LP_n, int8 *pc_DataByte);
uint8 ModXIncrY(uint16 us_Input, uint16 us_Y, uint16 us_Modulo_X);
FlagT InModZRange(uint16 us_Point, uint16 us_LowerBound, uint16 us_UpperBound, uint16 us_Modulo);
//XDSLRTFW-1634 (Start_End)
uint8 CalcSIDidx(uint16 us_RefSID_idx, uint16 us_RefSID, uint16 us_NewSID);
uint16 CalcRetxDelay(uint8 uc_OrigTS, uint8 uc_CorrectedTS);
uint8 UpdateQretxTable(uint8 uc_DtuStat, uint8 uc_NewSID, uint8 uc_TS, uint8 uc_DtuIndex);
void ForwardDtusToPPE(void);
void SetUpDtuForwarding(void);
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

FlagT gft_L0_to_L2=0, gft_L2_to_L0=0;

int16 gs_prebuf_cnt =0;

uint16 gus_DTB_rdptr_old, gus_DTB_rdptr_new, gus_DTB_wrptr_old, gus_DTB_wrptr_new;

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
uint32 gul_DTSize_old, gul_DTSize_new;
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)




/*****************************************************************************
;  Subroutine Name: GetRxDataPump_BIS()
;
;  This subroutine collects framing byte info
;
;  Prototype:
;     void GetRxDataPump_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
void GetRxDataPump_BIS(void)
{
   int16 i, s_RxFramingByteCount;
   int16 s_Nlp = gt_rx_config.s_Nlp;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      //If ReTx is ON, overhead data is available only on DS Latency Path 0
      //DS Latency path 1 does not carry the overhead info when ReTx is ON.
      s_Nlp = 1;
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   // Dual latency case is also considered here
   for (i = 0; i < s_Nlp; i++)
   {
      if (isRxLatencyPathEnabled(i))
      {
         /*  ===========================================================================  */
         /* Get the count of RS errors for fast path and interleaver path      */
         /*  ===========================================================================  */
         GetRSErrorCnt_BIS(i);



         s_RxFramingByteCount = GetRxFramingByteCnts(i); /* this counter goes from 0 to (MSGc+5) */

         // Get CRC info after 1 byte delay (CRC resides in the received frame byte 0)
         if(s_RxFramingByteCount == 1)
         {
            /*=========================================================================== */
            /* Count CRC errors once per PERp.                                       */
            /*=========================================================================== */
            GetCRCErrorCnt_BIS(i);
         }

         /* Read back the received IBs (frame byte 1~4) once per CRC superframe */
         if((i == gt_rx_config.s_IBITSlp) &&( s_RxFramingByteCount == 5))
         {
            /* Load received indicator bits into 4-byte global variable */
            GetIndicatorBits();

         }
      }
   }

   // Read back the HDLC overhead byte if i==MSGlp
   GetHDLCByte(&gt_RxHDLCMsgFifo);
}

/*****************************************************************************
;  Subroutine Name: StartRxDataPump_BIS()
;
;  This subroutine kicks off one Zephyr Rx path frame
;
;  Prototype:
;     void StartRxDataPump_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
void EnableRxPms(void);
void StartRxDataPump_BIS()
{
   uint32 ul_data;

   //obtain DTB read pointer from(PRAMS) register
    //for debugging L2 only
   gus_DTB_rdptr_old = gus_DTB_rdptr_new;
   ReadCoreReg(ZEP_PRAM_ZR_DTB_PTRS_LP0_ADDR,  &ul_data);
   gus_DTB_rdptr_new =(uint16) (ul_data& 0xFFFF);

   //obtain DTB write pointer global register
   //current Lp0 address in the DTB, offset from RXDTB_WR_BASE_0, in long words
   gus_DTB_wrptr_old = gus_DTB_wrptr_new;
   ReadCoreReg(ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR, &ul_data);
   gus_DTB_wrptr_new =(uint16) (ul_data& 0xFFFF);

   //PMS_SIZE(n)=DT_SIZE(n-1)
   //need to keep DT_SIZE(n-1)
   ReadCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR, &gul_DTSize_new);
   WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, gul_DTSize_old);
   gul_DTSize_old = gul_DTSize_new;


   //EnableRX PMS
   if (gs_prebuf_cnt < 1)
   {
      DisableRxPms();
      gs_prebuf_cnt++;
   }
   else if (gs_prebuf_cnt == 1)
   {

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         UpdateDsRrcStat();
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

      EnableRxPms();
   }


   //decide s_state
   switch(gt_RxOLRPMVars.uc_l2ProcState)
   {

      case PM_L2_STATE:
      case PM_L2_EXIT_SEQ_REVERB_DETECTED: //Misdetected reverbs should bring us to s_state 2.

         if    (gft_L0_to_L2 == 0)
         {
            gft_L0_to_L2 =1;
            gft_L2_to_L0 =0;
         }
         else if(gft_L0_to_L2 ==1)
         {
            gft_L0_to_L2 = 2;
         }
         break;

      case PM_L2_EXIT_SEQ_SEGUE_DETECTED:

            gft_L0_to_L2 =0;
         DisableRxPms(); //dont write "exiting reverb" into dilv
         WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, 0);

         gus_DTB_rdptr_new = gus_DTB_wrptr_new*4; //at this time, DTB contains "L2 exiting reverb and segue" frames
         WriteCoreReg(ZEP_PRAM_ZR_DTB_PTRS_LP0_ADDR,  gus_DTB_rdptr_new); //move the DTB read pointer to the real data frame after Segue symbol

         /* update l2 processing state m/c */
         gt_RxOLRPMVars.uc_l2ProcState = PM_L2_EXIT_POSTPROCESS;
         /* Restore bat and gain tables to L0 values in foreground state m/c */
         gt_RxOLRPMVars.s_rxOLRPMEvent = (READ_BAT | READ_GAIN);
         gt_RxOLRPMVars.uc_rxOLRPMState = L2_READ_TABLES;
         break;

      case PM_L2_EXIT_POSTPROCESS:
         if    (gft_L2_to_L0 == 0)
         {
            gft_L2_to_L0 =1;
            DisableRxPms(); //This is to delay the data symbol by one frame after L2.
            WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, 0);
         }
         else if (gft_L2_to_L0 == 1)
         {
            gft_L2_to_L0 =2;

         }
         break;
   }

    // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2. (START)
   // To reduce the cycle consumption and
   // also there is no data exchanged during the l2 exit.
   if ((gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_REVERB_DETECTED) &&
      (gt_RxOLRPMVars.uc_l2ProcState != PM_L2_EXIT_SEQ_SEGUE_DETECTED))
      GetRxDataPump_BIS();
   // XDSLRTFW-416 : Enhancement_ALL_BisPLus_ALL_L2 (END)

}

/***************************************************************************************
;  Subroutine Name: isRxLatencyPathEnabled(int16 s_LatencyPath)
;
;  Description:
;     This function checks if a latency path was enabled.
;
;
;  Prototype:
;     int16 isRxLatencyPathEnabled(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     s_RxFramingByteCount
;
;***************************************************************************************/
int16 isRxLatencyPathEnabled(int16 s_LatencyPath)
{

   uint32 ul_addr, ul_data;

   ul_addr = ZEP_RAM_IIBRAM_ADDR + ZEP_PRAM_TX_START_ADDR;
// ul_addr = (uint32)(ZEP_REG_ZR_LP0_CFG_ADDR + s_LatencyPath);
   ReadCoreReg(ul_addr, &ul_data);

   if ((uint32)s_LatencyPath < (ul_data & 0x3) )
      return (TRUE);
   else
      return (FALSE);

}

/***************************************************************************************
;  Subroutine Name: GetRxFramingByteCnts(int16 s_LatencyPath)
;
;  Description:
;     This function gets, from Zephyr, current tx framing byte count for LP0
;     and LP1 paths codeword.
;
;  Prototype:
;     int16 GetRxFramingByteCnts(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     s_RxFramingByteCount
;
;***************************************************************************************/
int16 GetRxFramingByteCnts(int16 s_LatencyPath)
{

   uint32 ul_addr, ul_data;
   uint8 uc_NumValidBytes;
   int16 s_RxFramingByteCount;

   // this function returns a certain framing byte count number
   // to trigger appropriate task in TC layer
   // this is done so to share TC task code with Socrates
   s_RxFramingByteCount = -2;

   // return count = 1 to trigger CRC error counts collection
   // at the end of each SEQp period
   if    (s_LatencyPath == LP0_DATA_PATH)
      ul_addr = ZEP_PRAM_ZR_R0_LP0_ADDR ;
   else
      ul_addr = ZEP_PRAM_ZR_R0_LP1_ADDR ;

// ul_addr = (uint32)(ZEP_REG_ZR_LP0_CFG_ADDR + s_LatencyPath);
   ReadCoreReg(ul_addr, &ul_data);

   if (ul_data & RX_SEQP_DONE) {
      s_RxFramingByteCount = 1;
      ResetCoreReg(ul_addr, RX_SEQP_DONE);
   }

   // return count = 5 to trigger IB bytes collection
   // when FIFO has all 4 IB bytes
   if (s_LatencyPath == gt_rx_config.s_IBITSlp) {

    uc_NumValidBytes = getNumValidBytes( s_LatencyPath , IBITS_FIFO , USE_RX_FIFO);
   //ReadCoreReg(ZEP_REG_ZR_FIFO2_CTRL_ADDR, &ul_data);
   // uc_NumValidBytes = (uint8)(ul_data & RX_FIFO2_VALID_BYTES_MASK);
      if (uc_NumValidBytes >= 4)
         s_RxFramingByteCount = 5;
   }

   return (s_RxFramingByteCount);

}

/***************************************************************************************
;  Subroutine Name: GetRSErrorCnt_BIS(int16 s_LatencyPath)
;
;  Description:
;     This function gets, from Zephyr, current FEC per codeword
;
;  Prototype:
;     void GetRSErrorCnt_BIS(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/

void GetRSErrorCnt_BIS(int16 s_LatencyPath)
{

   int16 us_fec_corr, us_fec_uncorr;
   uint32  ul_fec_addr, ul_fec_data;

   // if latency path requested is being processed.
   if (s_LatencyPath < gt_rx_config.s_Nlp ) {

   // ZR_FEC_CNT accumulate # of CWs (not bytes) corrected/uncorrected

   if (s_LatencyPath == LP0_DATA_PATH)
      ul_fec_addr = ZEP_PRAM_ZR_FEC_CNT_LP0_ADDR;
   else
      ul_fec_addr = ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR;


      // read RS errors
      ReadCoreReg(ul_fec_addr, &ul_fec_data);

      us_fec_corr = (uint16)(ul_fec_data >> 16);
   us_fec_uncorr = (uint16)ul_fec_data & 0xFFFF;

      // clear counters
      WriteCoreReg(ul_fec_addr, 0);


      if (us_fec_corr > 0) {

         // counter of no. of FEC anomalies per second
         gs_fec_ecs_cnt++;
      }

      gula_CorrectedRSErrors[s_LatencyPath] += us_fec_corr;
      gsa_CorrectedRSErrors[s_LatencyPath]  = (int16) gula_CorrectedRSErrors[s_LatencyPath];

      // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
      #ifdef ADSL_62
      gula_UncorrectableRSCodewordCnt[s_LatencyPath] += us_fec_uncorr;
      #else
      gs_UncorrectableRSCodewordCnt[s_LatencyPath] += us_fec_uncorr;
      #endif
      // XDSLRTFW-575: Counter Write back in ADSL mode (End)

   } // if lp active
   }
/***************************************************************************************
;  Subroutine Name: GetCRCErrorCnt_BIS(int16 s_LatencyPath)
;
;  Description:
;     This function gets, from Zephyr, current CRC per PERp
;
;  Prototype:
;     void GetCRCErrorCnt_BIS(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/


void GetCRCErrorCnt_BIS(int16 s_LatencyPath)
{
   uint32 ul_data , ul_crc_addr;
   uint16 us_crc_error;

   if (s_LatencyPath == LP0_DATA_PATH)
      ul_crc_addr = ZEP_PRAM_ZR_CRC_CTRL0_LP0_ADDR;
   else
      ul_crc_addr = ZEP_PRAM_ZR_CRC_CTRL0_LP1_ADDR;


   // read CRC errors
   ReadCoreReg(ul_crc_addr, &ul_data);


   us_crc_error = (int16)(ul_data >> 16) & 0xFFFF;
   ul_data &= 0x0000FFFF;

   // clear counter
   WriteCoreReg(ul_crc_addr, ul_data);

   if ((us_crc_error > 0) )
   {
      gula_CRC_count[s_LatencyPath]++;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (Start)
      //gusa_CRC_count[s_LatencyPath] = (int16) gula_CRC_count[s_LatencyPath];   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      gusa_CRC_count[s_LatencyPath]++;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (End)


        gs_norm_crc_1sec += gsa_CRCincrement[s_LatencyPath];

#ifdef LEAVE_TRAIL
      fprintf(crc_fid,"\n There is a CRC error in SuperFrame %ld of LP%d data path", gl_rx_sframe_count, s_LatencyPath);
#endif

      /* Counter of no. of CRC anomalies per PERp */
      // Don't consider the LP0 CRC's during  ReTx ON
      // As per  G.998.4 G.INP Standard Section: 11.3.1   Near-end anomalies  are defined  only  for #LP1.
      // XDSLRTFW-1981(Start)
      if(gt_ReTxConfigInfo.ft_ReTxOn == 0)
      {
         gs_crc_cnt++;
      }
      // XDSLRTFW-1981(End)


   }
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
   else
   {
      gusa_good_count[s_LatencyPath]++;
   }
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)



}


/*****************************************************************************
;  Subroutine Name: RxDataPumpMisc_TCA_BIS()
;
;  This subroutine implements misc functionalaties of RX Path in TC A
;
;  Prototype:
;     void RxDataPumpMisc_TCA_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void RxDataPumpMisc_TCA_BIS(void)
{
#ifndef DISABLE_BERT
   if (guc_Start_BERT_Rx) {
      RxBERTSetup();
   }
#endif
}

/*****************************************************************************
;  Subroutine Name: RxDataPumpMisc_TCB_BIS()
;
;  This subroutine implements misc functionalaties of RX Path in TC B
;
;  Prototype:
;     void RxDataPumpMisc_TCB_BIS(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void RxDataPumpMisc_TCB_BIS(void)
{
#ifndef DISABLE_BERT
   if (guc_Start_BERT_Rx) {
      /* Get the contents of Rx Frame Buffer */
      RxPNSequenceSetup();
   }
#endif
}







#ifdef VR9_ERASURE
/*****************************************************************************
;  Subroutine Name: Erasure_Reconfig()
;
;  This subroutine reconifgures the erasure-related zephyre registers
;
;  Prototype:
;     void Erasure_Reconfig(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
//Don't triger this function as the logic is not fully tested. I.e. Erasure decoding on/off on the fly
void Erasure_Reconfig(void)
{

   uint32 ul_data;
   Config_t *pt_Config;
   // map the RX parameter structure
   pt_Config = &gt_rx_config;

   //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
//    if (gft_erasure_on ^ (gs_DSL_EDcontrol & MASK_BIT0))
    {
         //erasure "on the fly" on/off
      //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
        //gft_erasure_on = gs_DSL_EDcontrol & MASK_BIT0;

      //Reset the global flag, so that this function is caled only once when the flag is enabled
      gft_allow_reset_erasure = 0;

// XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start_End)
// Remove old complex condition to easily understand the code
       // if (!(gs_DSL_EDcontrol & MASK_BIT0)) // Turn off Erasure Decoding
         if (gft_erasure_hw_on == 0)
        {
         // Configuration of WB registers
         ul_data =  0x4040000;
         ul_data |= 1 << 14; //14 NO_WB_SCORE
         ul_data |= 1 << 12; //12 Bypass_Metric

#define  WB_SCORE1 (0)
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR, ul_data|WB_SCORE1);
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data|WB_SCORE1);

            if (pt_Config->s_Rp[LP0_DATA_PATH]>0)
         {
            ul_data = (uint32) (255* pt_Config->s_Rp[LP0_DATA_PATH]/2)+1; //(use for HD emulation)
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR , ul_data);
         }
         else
                WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR , 0xFFFF);

            if (pt_Config->s_Rp[LP1_DATA_PATH]>0)
         {
            ul_data = (uint32) (255* pt_Config->s_Rp[LP1_DATA_PATH]/2)+1; //(use for HD emulation)
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR , ul_data);
         }
         else
                WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, 0xFFFF);
          }
          else // Turn on Erasure Decoding
          {
         // Configuration of WB registers
         ul_data =  0x4040000;

         //ZEP_PRAM_ZR_WB_SCORE_CTL
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR, ul_data|WB_SCORE1);
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data|WB_SCORE1);

              if (pt_Config->s_Rp[LP0_DATA_PATH]>0)
         {
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR, gs_wb_maxscore);
            TESTArray[TEST_ERASURE_EFFECTIVE_INP_LP0] =
                      (uint16)((uint32) (8 * pt_Config->s_Dp[LP0_DATA_PATH]<<8)*
                      pt_Config->s_Rp[LP0_DATA_PATH] /
                      pt_Config->s_Lp[LP0_DATA_PATH]) ;
              }
              else
                  WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR, 0xFFFF);

              if (pt_Config->s_Rp[LP1_DATA_PATH]>0)
              {
                  WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, gs_wb_maxscore);
                  TESTArray[TEST_ERASURE_EFFECTIVE_INP_LP1] =
                      (uint16)((uint32) (8 * pt_Config->s_Dp[LP1_DATA_PATH]<<8)*
                      pt_Config->s_Rp[LP1_DATA_PATH]/
                      pt_Config->s_Lp[LP1_DATA_PATH]) ;
              }
              else
                  WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, 0xFFFF);
           }
    }
}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
#if 0
/*****************************************************************************
;  Subroutine Name: Calculate_DiscardFrame_Threshold()
;
;  This subroutine evaluates the metric of each DMT symbol and set the frame
;   discard flag for DD adaptation.
;
;  Prototype:
;     void Erasure_Reconfig(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void Calculate_DiscardFrame_Threshold(void)
{

    //read the metric of most recent DMT symbol.
    uint32 ul_metric_value;
   uint8 uc_metric_value;

   ReadCoreReg (IRI_QT_REG_RX_RMETRIC_VAL_ADDR, &ul_metric_value);

   uc_metric_value = ul_metric_value &0xFF;

    if (gft_cal_discard_metric_threshold)
     //check flag to (re)calculate the threshold from discarding frame
     {
         //reset the max_metric and min_metric during the first frame of the evaluation period
        if (gus_metric_eval_cnt == 0)
        {
            guc_max_metric = 0;
            guc_min_metric = 0xFF;
            gus_metric_eval_cnt ++;
        }
        // find the max metric  over gus_metric_eval_period
        else if (gus_metric_eval_cnt < gus_metric_eval_period)
        {
            gus_metric_eval_cnt ++;

            if (uc_metric_value > guc_max_metric)
                guc_max_metric = uc_metric_value;
            else if (uc_metric_value < guc_min_metric)
                guc_min_metric = uc_metric_value;

        }
        else // if (gus_metric_eval_cnt == gus_metric_eval_period)
        {
            gus_metric_eval_cnt = 0;
            //case of impulse noise is present when entering showtime
            if (guc_max_metric - guc_min_metric > 32 || guc_max_metric >2* guc_min_metric)
                guc_metric_discard_threshold = guc_min_metric + (guc_max_metric - guc_min_metric)/4;
            else // case of FT type of impulse noise: set the discard threshold = 0.5*(guc_max_metric)
                guc_metric_discard_threshold = guc_max_metric/2;
            //reset the discard threshold calculation flag
            gft_cal_discard_metric_threshold =0;
        }
     }
     // if the metric of current frame is lower than the threshold for discarding
     // set the frame with lowmetric and disable DD
     if (uc_metric_value < guc_metric_discard_threshold)
        gft_frame_with_lowmetric = 1;
     else
        gft_frame_with_lowmetric = 0;
}
#endif   // #if 0
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
#endif


//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)

// this function will set up the access to the ZepRx FIFO_n
// it will return the number of valid bytes currently in the FIFO; this returned value
// is relavent if the access setup is for a FIFO READ.
uint32 SetUpZrFifo(int32 l_Fifo_n, int32 l_LP_n)
{
   int32 l_ZrFifoAccess;


   l_ZrFifoAccess = ((l_Fifo_n & 0x3) << 8) | ((l_LP_n & 0x1) << 12);

   // send UPDATE_STATUS command
   WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, l_ZrFifoAccess | FIFO_UPDATE_STATUS_MASK);

   do {
      gul_ZrFifoSetupWait++;
      ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &l_ZrFifoAccess);
   } while (!(l_ZrFifoAccess & FIFO_READY_MASK));

   return(gul_ZrFifoValidBytes = (l_ZrFifoAccess >> 17) & FIFO_VALID_BYTES_MASK);
}


// SetUpZrFifo() must have been called prior to this function to make sure FIFO was ready for access
// and that there's at least one data byte in the FIFO.
uint32 ReadZRFifo(int32 l_Fifo_n, int32 l_LP_n, int8 *pc_DataByte)
{
   int32 l_ZrFifoAccess;

   l_ZrFifoAccess = ((l_Fifo_n & 0x3) << 8) | ((l_LP_n & 0x1) << 12);

   // send READ command
   WriteCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, l_ZrFifoAccess);

   do {
      gul_ZrFifoReadWait++;
      ReadCoreReg(ZEP_REG_ZR_FIFO_ACCESS_ADDR, &l_ZrFifoAccess);
   } while (!(l_ZrFifoAccess & FIFO_READY_MASK));

   *pc_DataByte = l_ZrFifoAccess & 0xFF;

   return(gul_ZrFifoValidBytes = (l_ZrFifoAccess >> 17) & FIFO_VALID_BYTES_MASK);
}



//Input  uc_OrigTS - Time stamp of the retransmitted DTU.
//    uc_CorrectedTS - Time Stamp of locally generated
uint16 CalcRetxDelay(uint8 uc_OrigTS, uint8 uc_CorrectedTS)
{
   uint16 us_Temp;

   us_Temp = uc_CorrectedTS;
   if (us_Temp < uc_OrigTS)
   {
      us_Temp += TS_MODULO;
   }

   us_Temp = us_Temp - uc_OrigTS + 2;      // plus 2 to round-off 4 symbols/sec

   us_Temp >>= 2;

   return(us_Temp);

}


//Input: us_Point   - For Eg: Newly reveived DTU SID
//    us_LowerBound - For Eg: SID of last read DTU from Queue and forwarded to PPE
//    us_UpperBound - For Eg: SID of DTU which is written in to the Queue earlier.
//    us_Modulo - For Eg: To do the wrap around.
//Output: returns (1) if the us_Point is within lower and upper bounds
FlagT InModZRange(uint16 us_Point, uint16 us_LowerBound, uint16 us_UpperBound, uint16 us_Modulo)
{
   if (us_LowerBound >= us_Modulo)
   {
      us_LowerBound -= us_Modulo;
   }

   if (us_UpperBound >= us_Modulo)
   {
      us_UpperBound -= us_Modulo;
   }

   if (us_UpperBound >= us_LowerBound)
   {
      if ((us_LowerBound <= us_Point) && (us_Point <= us_UpperBound))
      {
         return(1);
      }
   }
   else
   {
      if ((us_LowerBound <= us_Point) || (us_Point <= us_UpperBound))
      {
         return(1);
      }
   }

   return(0);
}

uint8 ModXIncrY(uint16 us_Input, uint16 us_Y, uint16 us_Modulo_X)
{
   uint16 us_Output;

   us_Output = us_Input + us_Y;

   while (us_Output >= us_Modulo_X)
   {
      us_Output -= us_Modulo_X;
   }

   return((uint8)us_Output);
}
//XDSLRTFW-1223 Qrx Full Fix (Start)
void push_node (uint8 *puc_Head, uint8 uc_NodeIndx, uint8 *puc_NumNodes)
{

   #ifdef ENABLE_RETX_DS_DEBUG
   if (*puc_Head != 0xFF) {
      if (*puc_Head != gt_NodeList[*puc_Head].uc_Indx) {
         gft_PauseOff = 0;
         Pause(0x1101);
      }
   }
   #endif

   if (*puc_NumNodes < guc_DsQRx)
   {
      if (*puc_Head != 0xFF) {
         gt_NodeList[uc_NodeIndx].uc_NextNode = gt_NodeList[*puc_Head].uc_Indx;
      }
      *puc_Head = gt_NodeList[uc_NodeIndx].uc_Indx;

      (*puc_NumNodes)++;
   }
   #ifdef ENABLE_RETX_DS_DEBUG
   else
   {
      //Max size exceeded. Remove this Pause after testing.
      gft_PauseOff = 0;
      Pause(0x1111);
   }
   #endif

   return;
}

uint8 pop_node (uint8 *puc_Head, uint8 *puc_NumNodes)
{
   uint8 u_TmpIndx = 0xFF;

   #ifdef ENABLE_RETX_DS_DEBUG
   if (*puc_Head != 0xFF) {
      if (*puc_Head != gt_NodeList[*puc_Head].uc_Indx) {
         gft_PauseOff = 0;
         Pause(0x2202);
      }
   }
   #endif

   if ((*puc_NumNodes > 0) && (*puc_Head != 0xFF))
   {
      u_TmpIndx = *puc_Head;

      *puc_Head = gt_NodeList[u_TmpIndx].uc_NextNode;
      gt_NodeList[u_TmpIndx].uc_NextNode = 0xFF;

      (*puc_NumNodes)--;
   }
   #ifdef ENABLE_RETX_DS_DEBUG
   else
   {
      //No more nodes to Pop. Remove this Pause after testing.
      gft_PauseOff = 0;
      Pause(0x2222);
   }
   #endif

   return(u_TmpIndx);
}
//XDSLRTFW-1223 Qrx Full Fix (End)

// calculate the index of the entry corresponding to the NewSID using
// a referenced entry and its SID.
//XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start)
uint8 CalcSIDidx(uint16 us_RefSID_idx, uint16 us_RefSID, uint16 us_NewSID)
{
   int16  s_Offset;

   s_Offset = us_NewSID - us_RefSID;
   if (s_Offset < 0)
   {
      s_Offset += SID_MODULO;
   }

   return(ModXIncrY(us_RefSID_idx, (uint16)s_Offset, QRETX_TRANS_TABLE_SIZE));
}
//XDSLRTFW-1223 Qrx Full Fix (Start)
void SetUpDtuForwarding(void)
{
   uint32 ul_data;
   // ZEP_PRAM_ZR_R12_LP1_ADDR
   ul_data = gus_DTUPayloadSizeDS << 16; //31:16 DTU_PAYLOAD_SIZE = Q.H - V - 2
   ul_data |= (ILVB_WRPTR_TABLE_SIZE_LW << 8); //Write pointer table size
   ul_data |= guc_XDTUs; // XDTUs
   WriteCoreReg(ZEP_PRAM_ZR_R12_LP1_ADDR, ul_data);

   // reset ILVB_RDPTR
   WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR, DTU_POINTERS_LW_BASE_ADDR);
}

//Input: uc_DtuStat (Received DTU status; Good DTU = 0; Bad DTU = 1;)
//    uc_NewSID (SID of the received DTU)
//    uc_TS(Time stamp of the received DTU)
//    uc_DtuIndex (DTU index to be saved in translation table)
//Output: Returns DTU status
uint8 UpdateQretxTable(uint8 uc_DtuStat, uint8 uc_NewSID, uint8 uc_TS, uint8 uc_DtuIndex)
{
   uint8 uc_TempSID_idx = 0, uc_TempSID;
   uint8 uc_Wr_SID_idx;
   FlagT ft_DTUAccepted;

   uc_Wr_SID_idx = guc_Wr_SID_idx;

   ft_DTUAccepted = TRUE;

   uc_TempSID = gta_QretxTable[uc_Wr_SID_idx].uc_SID;

   if (uc_DtuStat == GOOD_DTU)
   {
      gul_cons_bad_dtu = 0;
      gul_cons_good_dtu++;
      if (ModXIncrY(uc_TempSID, 1, SID_MODULO) == uc_NewSID)
      {
         // new DTU (not a retransmitted one) because it gets the expected SID
         // in between this good DTU and previously good DTU, there might be incorrect DTUs.
         uc_TempSID_idx = ModXIncrY(guc_Wr_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);

         guc_Wr_SID_idx = uc_TempSID_idx;
      }
      else if ((InModZRange(uc_NewSID, gta_QretxTable[guc_Rd_SID_idx].uc_SID, uc_TempSID, SID_MODULO)) &&
               (uc_TempSID != gta_QretxTable[guc_Rd_SID_idx].uc_SID))
      {
         // initial condition or retransmitted DTU

         uc_TempSID_idx = CalcSIDidx(guc_Prev_Rd_SID_idx, guc_Prev_Rd_SID, uc_NewSID);

         gt_ReTXStats.ul_RetransmittedDtuCnt++;

         if (gta_QretxTable[uc_TempSID_idx].uc_Stat == BAD_DTU)
         {
            gt_ReTXStats.ul_CorrectedDtuCnt++;
         }
         //Drop the packet if it has been received before and not yet forwarded to PPE
         else
         {
            ft_DTUAccepted = FALSE;

            // unexpected DTU
            gt_ReTXStats.ul_UnexpectedDtuCnt++;
         }
      }
      else
      {
         // unexpected DTU
         gt_ReTXStats.ul_UnexpectedDtuCnt++;

         // gotta be "unexpected" retransmitted DTU
         gt_ReTXStats.ul_RetransmittedDtuCnt++;

         ft_DTUAccepted = FALSE;
         uc_TempSID_idx = 0;
      }

   }
   else
   {
      // throw away.
      // this could be a new DTU that is incorrect
      // this could be a retransmitted DTU that is incorrect again.

      ft_DTUAccepted = FALSE;

      // to prevent any Q overflow, we ensure that our RD & WR pointers won't over run.
      if ((uc_Wr_SID_idx = ModXIncrY(guc_Wr_SID_idx, 1, QRETX_TRANS_TABLE_SIZE)) != guc_Rd_SID_idx)
      {
         guc_Wr_SID_idx = uc_Wr_SID_idx;
      }
      else
      {
         gus_QFullCntr++;
      }

      // estimated bad SID
      uc_TempSID = ModXIncrY(uc_TempSID, 1, SID_MODULO);
      if (gta_QretxTable[guc_Wr_SID_idx].uc_DTU_idx != EMPTY_DTU) {
         //guc_Rd_SID_idx has not yet cleared the DTU; We have no choice, but
         //to drop the packet. This condition is seen when GHS tones are added as
         //RFI in showtime (This noise results in lots of consecutive BAD DTUs and
         //occasional GOOD DTUs)
         push_node(&gt_FreeBufList.uc_Head, gta_QretxTable[guc_Wr_SID_idx].uc_DTU_idx,
                   &gt_FreeBufList.uc_NumNodes);

         gta_QretxTable[guc_Wr_SID_idx].uc_DTU_idx = EMPTY_DTU;
         gus_DropPktCntr++;
         //gft_PauseOff = 0;
         //Pause(0x7777);
      }

      gta_QretxTable[guc_Wr_SID_idx].uc_TS = guc_EstimatedTS;
      gta_QretxTable[guc_Wr_SID_idx].uc_Stat = BAD_DTU;
      gta_QretxTable[guc_Wr_SID_idx].uc_SID = uc_TempSID;

   gul_cons_bad_dtu++;
   gul_cons_good_dtu = 0;
   if(gul_cons_bad_dtu > gul_max_cons_bad_dtu)
   {
      gul_max_cons_bad_dtu = gul_cons_bad_dtu;
   }

      gt_ReTXStats.ul_BadDtuCnt++;
   }

   //XDSLRTFW-1571 (Start)
   if (ft_DTUAccepted == TRUE)
   {
      gta_QretxTable[uc_TempSID_idx].uc_DTU_idx = uc_DtuIndex;
      gta_QretxTable[uc_TempSID_idx].uc_TS = uc_TS;
      gta_QretxTable[uc_TempSID_idx].uc_SID = uc_NewSID;
      gta_QretxTable[uc_TempSID_idx].uc_Stat = GOOD_DTU;

      gt_ReTXStats.ul_GoodDtuCnt++;
   }
   //XDSLRTFW-1571 (End)

   return (ft_DTUAccepted);
}


void ForwardDtusToPPE(void)
{
   uint8 uc_RdTS, uc_RdMinDelayTS, uc_RdMaxDelayTS, uc_Temp_Rd_SID_idx;
   uint16 us_DelayMinFrames, us_DelayMaxFrames;
   int32 l_DtuCnt;
   uint8 uc_Xdtus;
   uint32 *pul_DtuAddr;
   int16 s_DtuSize;
   int32 ul_ReTXQueue_BaseAddress;

   uint8 uc_SID;

   pul_DtuAddr = (uint32*)(ZEP_RAM_IIBRAM_ADDR + (DTU_POINTERS_LW_BASE_ADDR << 2));
   ul_ReTXQueue_BaseAddress = gt_ReTXParams.ul_ReTXQueue_BaseAddress;
   uc_Xdtus = 0;

   // delay min and max in term of frames/TS
   us_DelayMinFrames = (gt_ReTxConfigInfo.us_delay_min << 2);
   us_DelayMaxFrames = (gt_ReTxConfigInfo.us_delay_max << 2);

   //XDSLRTFW-2213 (Start_End)
   s_DtuSize = (gus_DTUPayloadSizeDS + gt_ReTXParams.uc_NumPaddingBytes);

   // from 2-4 Dtus out rate
   //Limit No of DTUs forwared to PPE to guc_maxdtuout, but also process all the DTUs that are getting "Timedout"
   for (l_DtuCnt = 0; uc_Xdtus < guc_maxdtuout; l_DtuCnt++)
   {
      //if (guc_Wr_SID_idx == guc_Rd_SID_idx) break;

      uc_Temp_Rd_SID_idx = ModXIncrY(guc_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);

      uc_RdTS = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_TS;
      uc_SID = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_SID;

      if (gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat == GOOD_DTU)
      {
         // need to check against MIN_DELAY
         uc_RdMinDelayTS = ModXIncrY(uc_RdTS, us_DelayMinFrames, TS_MODULO);

         if (!InModZRange(guc_EstimatedTS, uc_RdTS, uc_RdMinDelayTS, TS_MODULO))
         {
            uc_Xdtus++;
            *pul_DtuAddr++ = ul_ReTXQueue_BaseAddress + gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx*s_DtuSize;

            push_node(&gt_FreeBufList.uc_Head, gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx,
                      &gt_FreeBufList.uc_NumNodes);

            guc_Prev_Rd_SID_idx = uc_Temp_Rd_SID_idx;
            //XDSLRTFW-1209: BugFix_DS_VDSL2_ALL_PacketLoss_In_ReTX_Mode (Start_End)
            //Store the SID as well, as gta_QretxTable[guc_Prev_Rd_SID_idx] can get corrupted/over-written by
            //guc_Wr_SID_idx. When we get lots of DTUs in error (continuously), guc_Wr_SID_idx would keep
            //moving ahead and then wraps around and would eventually over write the node pointed by
            //guc_Prev_Rd_SID. guc_Prev_Rd_SID wouldn't have moved ahead due to Q-Full condition.
            guc_Prev_Rd_SID = uc_SID;
            guc_Prev_Rd_DTU_idx = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx;

            gt_ReTXStats.ul_ForwardedDtuCnt++;

         }
         else
         {
            break;
         }
      }
      else if (gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat == BAD_DTU)
      {
         uc_RdMaxDelayTS = ModXIncrY(uc_RdTS, (us_DelayMaxFrames+8), TS_MODULO);
         if (!InModZRange(guc_EstimatedTS, uc_RdTS, uc_RdMaxDelayTS, TS_MODULO))
         {
            gt_ReTXStats.ul_UncorrectedDtuCnt++;
         }
         else
         {
            break;
         }
      }
      else
      {
         break;
      }

      gta_QretxTable[uc_Temp_Rd_SID_idx].uc_DTU_idx = EMPTY_DTU;
      gta_QretxTable[uc_Temp_Rd_SID_idx].uc_Stat = EMPTY_DTU;
      guc_Rd_SID_idx = uc_Temp_Rd_SID_idx;
   }

   {
      guc_XDTUs = uc_Xdtus;
   }

   SetUpDtuForwarding();

}


void UpdateDsRrcStat(void)
{
   uint64 ull_64MostRecentDtuStats;
   uint32 ul_Temp1;
   uint8  uc_QretxSize;
   uint8  uc_AbsDtuNum, uc_DtuIndex;
   uint8 uc_TS, uc_SID, uc_DtuStat, uc_Temp_Rd_SID_idx, uc_Temp2_Rd_SID_idx; //uc_ILVBWrptrTableIndx;
   uint8 i, uc_NumDTUsInThisSymbol = 0, uc_InpBufListIndx;
   FlagT ft_Qrx_Full, ft_DTUAccepted;
   int16 s_NumFreeBufs;


   // Read from HW if a new DTU info is availabe in FIFO1 of LP1
   // Read the no of bytes available in FIFO1 in LP1 to know the
   // availability of new DTU. Minimum bytes expected would be SID, TS & the status of
   // the DTU, i.e GOOD DTU or BAD DTU.
   // SID, TS, DTU_STAT (GOOD_DTU = 0; BAD_DTU = 1)
   ul_Temp1 = SetUpZrFifo(RETX_FIFO1, RETX_LP1);

   if (ul_Temp1 >= DTU_INFO_BYTES_IN_FIFO1)
   {
      if (!gft_NotFirstDTU)
      {
         // synchronize our estimated TS with CO TS
         gft_NotFirstDTU = 1;
         guc_EstimatedTS = 0;
      }

      //Read the Recent DTU's status, though the length is 64, right now
      //the length of recent DTU's status maintained is till the Look Back value
      //Look back value is 31.
      ull_64MostRecentDtuStats = gt_RrcStat.ull_64MostRecentDtuStats;

      //DTU count incremented locally for every new DTU's received, it could be good or Bad.
      uc_AbsDtuNum = gt_RrcStat.uc_AbsDtuNum;

      //Size of the ReTx Queue in DTU's, derived from framing parameter.
      uc_QretxSize = guc_DsQRx;

      uc_NumDTUsInThisSymbol = 0;
      uc_InpBufListIndx = guc_InpBufListIndx;
      s_NumFreeBufs = (int16)gt_FreeBufList.uc_NumNodes;
      ft_Qrx_Full = gft_Qrx_Full;

      uc_Temp_Rd_SID_idx = ModXIncrY(guc_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);
      uc_Temp2_Rd_SID_idx = uc_Temp_Rd_SID_idx;

      while (ul_Temp1 >= DTU_INFO_BYTES_IN_FIFO1)
      {
         ReadZRFifo(RETX_FIFO1, RETX_LP1, (int8 *)(void *)&uc_SID);
         ReadZRFifo(RETX_FIFO1, RETX_LP1, (int8 *)(void *)&uc_TS);
         ul_Temp1 = ReadZRFifo(RETX_FIFO1, RETX_LP1, (int8 *)(void *)&uc_DtuStat);
         ull_64MostRecentDtuStats <<= 1;
         uc_AbsDtuNum++;

         //if (uc_ILVBWrptrTableIndx != uc_InpBufListIndx) {
            /* We should never come here !!!*/
            //gft_PauseOff = 0;
            //Pause(0x3333);
         //}

         #ifdef ENABLE_THREE_NEEDLE_TEST
         if (guc_StartThreeNeedle == 1)
         {
            if (guc_ThreeNeedleBadDTUCount < 3)
            {
               uc_DtuStat = BAD_DTU;
               guc_ThreeNeedleBadDTUCount++;

               if (guc_ThreeNeedleBadDTUCount == 3)
               {
                  guc_ThreeNeedleCount++;
               }
            }

            if (guc_ThreeNeedleCount == 3)
            {
               guc_StartThreeNeedle = 0;

               gus_ThreeNeedleDurationCount = 1;
            }

            guc_CountToNextNeedle++;
            if (guc_CountToNextNeedle == (gs_DsQTx+1)) //-2, -1
            {
               guc_ThreeNeedleBadDTUCount = 0;
               guc_CountToNextNeedle = 0;
            }
         }
         else
         {
            guc_ThreeNeedleBadDTUCount = 0;
            guc_ThreeNeedleCount = 0;
            guc_CountToNextNeedle = 0;

            #if 0
            gus_ThreeNeedleDurationCount++;
            if (gus_ThreeNeedleDurationCount == gus_ThreeNeedleDuration)
            {
               guc_StartThreeNeedle = 1;
               gus_ThreeNeedleDurationCount = 0;
            }

            if ((gft_Qrx_Full == TRUE) && (gus_ThreeNeedleDurationCount > 60)) //40
            {
               gft_PauseOff = 0;
               Pause(0x6769);
            }

            #else
            if (gus_ThreeNeedleDurationCount > 0)
            {
               gus_ThreeNeedleDurationCount++;
               if (gus_ThreeNeedleDurationCount == 90) {
                  gft_PauseOff = 0;
                  Pause(0x6769);
               }
            }
            #endif
         }
         #endif

         uc_DtuIndex = guca_InpBufList[uc_InpBufListIndx];

         if (ft_Qrx_Full == TRUE)
         {
            if ( (gta_QretxTable[uc_Temp2_Rd_SID_idx].uc_Stat == GOOD_DTU) ||
                  ((uc_DtuStat == GOOD_DTU) && (uc_SID == gta_QretxTable[uc_Temp2_Rd_SID_idx].uc_SID)) )
            {
               ft_Qrx_Full = FALSE;
               uc_Temp2_Rd_SID_idx = ModXIncrY(uc_Temp2_Rd_SID_idx, 1, QRETX_TRANS_TABLE_SIZE);
            }
         }

         #ifdef ENABLE_RETX_DS_DEBUG
         {
            int16 Indx;

            if (guc_ReTxDebugBufWrEnable == 1)
            {
               Indx = gus_ReTxDebugBufIdx;

               guca_ReTxDebugBuf[Indx++] = uc_SID;
               guca_ReTxDebugBuf[Indx++] = uc_DtuIndex;
               guca_ReTxDebugBuf[Indx++] = (uint8)(((ft_Qrx_Full&1) << 7) |
                                                   (uc_DtuStat & 0xF));
               guca_ReTxDebugBuf[Indx++] = guc_Wr_SID_idx;

               guca_ReTxDebugBuf[Indx++] = gta_QretxTable[guc_Wr_SID_idx].uc_SID;
               guca_ReTxDebugBuf[Indx++] = (uint8)s_NumFreeBufs; //guc_Rd_SID_idx;
               guca_ReTxDebugBuf[Indx++] = gta_QretxTable[guc_Rd_SID_idx].uc_SID;
               guca_ReTxDebugBuf[Indx++] = gta_QretxTable[uc_Temp_Rd_SID_idx].uc_SID;

               guca_ReTxDebugBuf[Indx++] = guca_InpBufList[0]; //guc_Prev_Rd_SID_idx;
               guca_ReTxDebugBuf[Indx++] = guca_InpBufList[1]; //guc_Prev_Rd_SID;
               guca_ReTxDebugBuf[Indx++] = guca_InpBufList[2]; //guc_Prev_Rd_DTU_idx;
               guca_ReTxDebugBuf[Indx++] = (uint8)((gt_ReTXStats.ul_UncorrectedDtuCnt & 0x3) |
                                                   ((gt_ReTXStats.ul_BadDtuCnt & 0x3) << 2) |
                                                   ((gt_ReTXStats.ul_UnexpectedDtuCnt & 0x3) << 4) |
                                                   ((gt_ReTXStats.ul_ForwardedDtuCnt & 0x3) << 6));
               //Filled up 12 bytes of data
               gus_ReTxDebugBufIdx += 12;
               if (gus_ReTxDebugBufIdx == 8184)
               {
                  gus_ReTxDebugBufIdx = 0;
               }
            }
         }
         #endif

         //Treat all DTUs as bad during Q-Full condition
         if (ft_Qrx_Full == TRUE) {
            uc_DtuStat = BAD_DTU;
         }

         // save SID and TS in translation table
         ft_DTUAccepted = UpdateQretxTable(uc_DtuStat, uc_SID, uc_TS, uc_DtuIndex);

         if (ft_DTUAccepted == TRUE) {
            guca_InpBufList[uc_InpBufListIndx] = 0xFF;
            s_NumFreeBufs--;
            if (s_NumFreeBufs <= 0) {
               ft_Qrx_Full = TRUE;
            }
         }

         //if (gft_DsUsReTxDiagEnter == TRUE) {
            //uc_DtuStat = GOOD_DTU; //XDSLRTFW-1854 Feature_VDSL2_ALL_RTX_TESTMODE (Start_End)
         //}

         if (uc_DtuStat != GOOD_DTU)
         {
            ull_64MostRecentDtuStats |= 1;

            gt_ReTXStats.ul_ErroredBitsPerSec += (gus_DTUPayloadSizeDS << 3);

         }

         gt_ReTXStats.ul_TotalDtuCnt++;

         uc_InpBufListIndx++;
         if (uc_InpBufListIndx == ILVB_WRPTR_TABLE_SIZE_LW) {
            uc_InpBufListIndx = 0;
         }

         uc_NumDTUsInThisSymbol++;

      }// While()

      gt_RrcStat.uc_AbsDtuNum = uc_AbsDtuNum;
      gt_RrcStat.ull_64MostRecentDtuStats = ull_64MostRecentDtuStats;
      gt_RrcStat.ft_RrcStatUpdated = 1;
   }

   ForwardDtusToPPE();

   //Populate the input buffer list -> to be populated by microcode
   for (i = 0; i < uc_NumDTUsInThisSymbol; i++)
   {
      if (guca_InpBufList[guc_InpBufListIndx] == 0xFF)
      {
         uc_DtuIndex = pop_node(&gt_FreeBufList.uc_Head,&gt_FreeBufList.uc_NumNodes);

         if (uc_DtuIndex == 0xFF) {
            #ifdef ENABLE_RETX_DS_DEBUG
            //We should never come here !!!
            gft_PauseOff = 0;
            Pause(0x4444);
            #endif

            break;
         } else {
            guca_InpBufList[guc_InpBufListIndx] = uc_DtuIndex;

           *((uint32 *)gula_ZrIlvbWrPtrTable[guc_InpBufListIndx]) =
                (uint32)(gt_ReTXParams.ul_ReTXQueue_BaseAddress +
                         (uc_DtuIndex * (gus_DTUPayloadSizeDS + gt_ReTXParams.uc_NumPaddingBytes)));
         }
      }

      guc_InpBufListIndx++;
      if (guc_InpBufListIndx == ILVB_WRPTR_TABLE_SIZE_LW) {
         guc_InpBufListIndx = 0;
      }
   }

   gft_Qrx_Full = FALSE;
   if (gt_FreeBufList.uc_NumNodes == 0) {
      gft_Qrx_Full = TRUE;
      gus_dbg_QreTx_full_cntr++;
   }

   #ifdef ENABLE_RETX_DS_DEBUG
   {
      uint32 ul_DTU_0, ul_DTU_1, ul_DTU_2;

      ul_DTU_0 = *((uint32 *)gula_ZrIlvbWrPtrTable[0]);
      ul_DTU_1 = *((uint32 *)gula_ZrIlvbWrPtrTable[1]);
      ul_DTU_2 = *((uint32 *)gula_ZrIlvbWrPtrTable[2]);

      if ((ul_DTU_0 == ul_DTU_1) || (ul_DTU_1 == ul_DTU_2) || (ul_DTU_2 == ul_DTU_0)) {
         gft_PauseOff = 0;
         Pause(0xAAAA);
      }

   }
   #endif

   return;
}
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
//XDSLRTFW-1634 (End)
//XDSLRTFW-1223 Qrx Full Fix (End)
