/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf_dmt.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */
// *****************************************************************************
// History ZPH_Iof_dmt.c
// 10/01/2012 Shakil/Bhadra:: Random link drops seen in ADSL2p mode in a noisy line of DTAG customer house.CPE dropped the link
//             due to near end LOS generated by excessive Downstream CRCs. According to our reboot criterion it
//             requires more than 1000 downstream CRCs to declare LOS from the CPE side but while we supressed
//             the LOS generation (cw test 29 0 0x4) we did not see the issue and the maximum CRC was less
//             than 300. Since we expected more than 1000 CRCs when the LOS was supressed the root cause was in
//             the LOS based on CRC block of the code where we did not increase gsa_good_count_ variable atall which
//             trigerred LOS if CRC is increased by more than 40 in 20 seconds interval. The reason that gsa_good_count
//             did not increased is, it resides in a function called ProcessFramingBytes() which was excluded in the VR9
//             compilation process(executes only ifndef HERCULES_ADSL_CPE). Asa fix this variable was moved to the
//             correct place to be compiled and incremented correctly.
//             Code Grep: XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC
//
// 07/9/2012 Vinjam: Code modified to get CRC errors per link (useful for debugging purpose)
//                   Grep for Fix_DS_All_All_ModifiedToGetCRCPerLink
//
// 07/01/2013 Ram: Fix added for JIRA 575. Attach "FEC uncorrectable CW count" to CMV
//            Grep for XDSLRTFW-575: Counter Write back in ADSL mode
//
//10/11/2014 Palaksha: "XDSLRTFW-1167:[ADSL1] Mixed path configuration leads to TcNoSync"
//                     Bug in function StartTxDataPump_DMT(), the variable gt_rx_config.s_Lp was instead of gt_tx_config.s_Lp
//                     Because of this Tx path was configured wrongly.
//                     Grep for XDSLRTFW-1167_BugFix_DMT_MixPathConfig
//
// *****************************************************************************


#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "fifo.h"
#include "tx_aoc.h"
#include "tx_eoc.h"
#include "tx_ib.h"
#include "rx_ib.h"
#include "tx_m3oh.h"
#include "cmv.h"
#include "bert.h"
#include "tx_plam.h"
#include "ALP_IOF.h"
#include "delay.h"
#include "gdata_dmt.h"
#include "trail.h"
#include "ZPH_Iof.h"



extern void WriteIndicatorBits(void);
extern void EnableRxPms(void);
extern uint8 guc_Start_BERT_Rx;

#ifdef LEAVE_TRAIL
   extern TRAILFILE crc_fid;
#endif

uint16 gus_message;

FlagT gft_EOC1;
uint16 gus_prev_frame_idx;

#define MAX_NUM_TX_AOC_BYTES (2)
void WriteEocMessage(uint16 us_message)
{
   //uint8 uc_NumValidBytes, uc_FirstByte, uc_SecondByte;
   gus_message = us_message;

   // read FIFO0 valid bytes counter
   //uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH, EOC_FIFO, USE_TX_FIFO);
   //if(uc_NumValidBytes == (32-2+1))
   // ul_error = 1; // otherwise error!

   WriteHwFifo(LP0_DATA_PATH , EOC_FIFO , USE_TX_FIFO , 2, (uint8*)(void *)&us_message);
}

void WriteAocMessage(uint16 us_message)
{
   //uint8 uc_NumValidBytes;
   // read FIFO0 (LP0:AOC FIFO) valid bytes counter
    //uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH, AOC_FIFO, USE_TX_FIFO);
   //if(uc_NumValidBytes == (32-2+1))
   // ul_error = 1; // otherwise error!

   // check if new AOC byte received
   WriteHwFifo(LP0_DATA_PATH, AOC_FIFO, USE_TX_FIFO, 1, (uint8*)(void *)&us_message);
}

/*------------------------------------------------------------------------
 *
 *  Name : WriteOverHeadByte
 *
 *  Description: Loads the zephyr register with the appropriate data based
 *      on the input frame number and the framing mode
 *
 *  Prototype:
 *      void WriteOverHeadByte(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

void WriteOverHeadByte(void)
{

   int16 s_OvhdFramingMode, s_MuxFrameCnt;
   int16 us_Message;
   uint32 ul_data, ul_addr, ptrs_fix, ptrs_prev;

   s_OvhdFramingMode = gt_tx_config.s_FramingMode;

   if (s_OvhdFramingMode <= 2)
   {
#ifdef VR9_FIXME
   /************* eoc transmission *************/
      if ((gs_MuxFrameCntTxFastPath & 0x1)==0) /* even frame */
      {
         if ((gs_MuxFrameCntTxFastPath != 0) && (gs_MuxFrameCntTxFastPath != 34))
         {
            if ((RemoveMessageFromFifo(&gt_TxEocFifo, &us_Message))==0)
               us_Message=0x0c0c;
            WriteEocMessage(us_Message);
         }
      }

   /************* aoc transmission *************/
      if (gs_MuxFrameCntTxInlvPath != 0)
      {
         if ((RemoveMessageFromFifo(&gt_TxAocFifo, &us_Message))==0)
               us_Message=0x0;
         WriteAocMessage(us_Message);
      }
#endif
   }
   else /* (s_OvhdFramingMode == 3) */
   {
      if(gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize==0)
      {
         //s_MuxFrameCnt = gs_MuxFrameCntTxInlvPath;
         s_MuxFrameCnt = gs_MuxFrameCntTxFastPath + 1;
         if (s_MuxFrameCnt == TX_SYMBOLS_PER_SFRAME)
            s_MuxFrameCnt = 0;
      }
      else
         s_MuxFrameCnt = gs_MuxFrameCntTxFastPath;

      if ((s_MuxFrameCnt != 0) &&
         (s_MuxFrameCnt != 1) &&          /* indicator bit slots */
         (s_MuxFrameCnt != 34) &&
         (s_MuxFrameCnt != 35))
      {

         switch (s_MuxFrameCnt & 0x3)
         {
            case 0:
            case 1:
               if ((RemoveMessageFromFifo(&gt_TxAocFifo, (uint16 *)(void *)&us_Message))==0)
                  us_Message=0;
               ul_addr = (uint32)ZEP_PRAM_ZT_FIFO_PTRS1_LP0_ADDR;
               ReadCoreBuf32(ul_addr, (int16 *)(void *)&ptrs_prev, 1); //record the ptrs prior to writing to the fifo

               WriteAocMessage(us_Message);

               do {
                  ReadCoreReg(ZEP_REG_ZT_FIFO_ACCESS_ADDR, &ul_data);
               } while ((ul_data & (1<<11)) == 0); //until FIFO_RDY(bit 11) = 1

               ReadCoreBuf32(ul_addr, (int16 *)(void *)&ptrs_fix, 1);
               ptrs_fix = (ptrs_prev&0xffff0000)|(ptrs_fix&0xffff); // Zep fifo workaround to restore the correct read ptr value
               WriteCoreBuf32(ul_addr, (int16 *)(void *)&ptrs_fix, 1);              // Rd ptr should not have changed.
               break;
            case 2:
               if ((RemoveMessageFromFifo(&gt_TxEocFifo, (uint16 *)(void *)&us_Message))==0)
                  us_Message = 0x0c0c;
               WriteEocMessage(us_Message);
                    break;
         }
      }
   }

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : Tx_FastOverHeadHandler_HWE
 *
 *  Description: Loads the Fast Byte with the appropriate data based
 *      on the input frame number
 *
 *  Prototype:
 *      uint8 Tx_FastOverHeadHandler(int16 s_frame_number)
 *
 *  Input Arguments:
 *      s_frame_number  -- TX frame number being generated
 *      puc_databuf     -- pointer to fast byte, the Synchronization/EOC
 *                         designator bit contains valid data
 *
 *  Output Arguments:
 *      puc_databuf     -- pointer to fast byte
 *
 * Return:
 *      None
 *
 *  Global Variables Used:
 *      gft_FrameMode             -- (I) Framing mode negotiated during
 *                                      initialization
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void Tx_FastOverHeadHandler_HWE(int16 s_frame_number)
{

   if (s_frame_number == 0)
      return;

    /* ==================================================================== */
    /*  Generate the fast byte */
    /* ==================================================================== */
    if (gft_FrameMode == REDUCED_MERGED)
        Tx_Mode3OH_Handler(s_frame_number);

   else {

      // gft_FrameMode = REDUCED_SEPARATE, FULL_SYNC or FULL_ASYNC

      /* Decide the content of the synch byte based on the frame number */
        if((s_frame_number == 1) || (s_frame_number == 34) || (s_frame_number == 35))
        {
            /* fast byte carries IB byte */
         TxIbHandler(s_frame_number);
      }
        else if(s_frame_number != 0)
        {
        // No support for FrameMode 0 byte stuff/rob on the upstream path, therefore always
      // send EOC byte in the fast byte.

            TxEocHandler(s_frame_number);
        }
    }
    return;
}

/*^^^
 *--------------------------------------------------------------------------
 *
 *  Name : Tx_IntlvOverHeadHandler
 *
 *  Description: Packs the framing overhead for the interleaved latency path
 *  into the mux data frame buffer
 *
 *  Prototype:
 *      Tx_IntlvOverHeadHandler(int16 s_frame_number, uint8 *puca_databuf)
 *
 *  Input Arguments:
 *      s_frame_number -- frame number being generated
 *
 *  Output Arguments:
 *      puca_databuf   -- pointer to buffer containing data and overhead
 *                        being generated
7 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *      gft_FrameMode -- Framing mode negotiated during initialization
 *
 *  Notes:
 *
 *--------------------------------------------------------------------------
 *^^^
 */

void Tx_IntlvOverHeadHandler_HWE(int16 s_frame_number, US_FrameParms_t *pt_InlvParms)
{

    /* ======================================= */
    /*  Generate the Interleaved Path Overhead */
    /* ======================================= */

      // For Framing modes 0,1 (FULL_ASYNC, FULL_SYNC):

         // If interleave path is payload path:
         //    sync byte = Mode10Sync field of Zephyr ZT_AOC register
         //    LEX byte = AOC byte (regardless of value of sync byte).
         //
         // If interleave path is not payload path:
         //    sync byte = AOC byte. (Mode10Sync field is ignored).
         //
         // Since this implementation does not support Tx byte
         // stuffing and robbing, the Mode10Sync field should always indicate NO SYNC
         // ACTION.
         // Since Zephyr always uses LEX byte for AOC when possible, bit 0 of Mode10Sync
         // field should be set to 1.
         // Therefore the value written to Mode10Sync should always be 0x0d, which
         // indicates "no sync action" (bits 3,2 == b11), and "LEX byte carries AOC data"
         // (bit 0 == 1).  This value is written to the ZT_AOC register during showtime
         // initialization.

         // In either case we need one AOC byte : either the interleave path is the payload
         // path, in which case the AOC byte is put into the LEX byte, or the interleave
         // path is not the payload path, in which case the sync byte carries an AOC byte.

      // For framing mode 2 (REDUCED_MERGED):
         // Always put AOC in sync byte.

      // For framing mode 3 (REDUCED_MERGED):
         // Depends on frame number.


   if (gft_FrameMode == REDUCED_MERGED)
   {
      Tx_Mode3OH_Handler(s_frame_number);
   }
   else
   {
      /* Decide the content of the synch byte based on the frame number */
      if(s_frame_number != 0)
         TxAocHandler(s_frame_number);
   }

    return;
}


/*****************************************************************************
;  Subroutine Name: StartTxDataPump_DMT(void)
;
;  This subroutine kicks off one Zephyr Tx path frame for g.dmt
;
;  Prototype:
;     void StartTxDataPump_DMT(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variables:
;
;****************************************************************************/

void StartTxDataPump_DMT(void)
{

   uint32 ul_data;
   int16 s_lp_bits, s_num_bytes0;

   //this is for LP01
   if (gt_tx_config.s_Lp[LP0_DATA_PATH])  //adsl2/+, g.dmt.interleave //XDSLRTFW-1167_BugFix_DMT_MixPathConfig (Start_End)
   {
      // compute # of bytes needed for QT to process for the next frame
      ReadCoreReg(IRI_QT_REG_TX_LP0_BITS_ADDR, &ul_data);
      s_lp_bits = (int16)(ul_data & 0x0000FFFF);
      ReadCoreReg(IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR, &ul_data);
      s_num_bytes0 = (s_lp_bits  + 7) >> 3;
      WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR,(uint32) s_num_bytes0); //Per port register
      WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR,(uint32) s_num_bytes0);
   }
   else
   {
      // compute # of bytes needed for QT to process for the next frame
      ReadCoreReg(IRI_QT_REG_TX_LP1_BITS_ADDR, &ul_data);
      s_lp_bits = (int16)(ul_data & 0x0000FFFF);
      ReadCoreReg(IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, &ul_data);
      s_num_bytes0 = (s_lp_bits  + 7) >> 3;
      WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR,(uint32) (s_num_bytes0<<16)); //Per port register
      WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR,(uint32) (s_num_bytes0<<16));
   }


   if(   gs_MuxFrameCntTxFastPath != TX_SYMBOLS_PER_SFRAME ||//Trigger data pump during showtime if not sync frame OR
      gs_TxState != R_SHOWTIME_TX)                 //in ANY frame before showtime for pre-processing of interleave path
   {
      // MuxFrameCnt for Tx intlv path, iff obtained from HW, doesn't have a uniform distribution between [0, 68],
      // since Mux frames differ in their allignment from FEC frames.
      // We need for various overhead processing (in the FG - not core timing critical) a counter that goes from [0, 68]
      // uniformly for all values, so just use the TxFast counter for MuxFrame
      gs_MuxFrameCntTxInlvPath = gs_MuxFrameCntTxFastPath + 1; //For HERC, the MuxFrameCntTxInlvPath is ahead by one because of the preprocessing
      if (gs_MuxFrameCntTxInlvPath == TX_SYMBOLS_PER_SFRAME)
         gs_MuxFrameCntTxInlvPath = 0;

      WriteOverHeadByte();
      if (gs_MuxFrameCntTxFastPath == 0)
         WriteIndicatorBits();
#if 0
      if(!gft_firstZep) //All set in datapumpsetup_tx.c for the very first Zephyr RUN
      {
         for (s_lp=0;s_lp<NUM_DATA_PATHS;s_lp++) {

            ReadCoreReg((uint32)(ZEP_REG_ZT_LP0_MP_ADDR + s_lp), &ul_MuxCnt);
            ul_MuxCnt &= 0x0000001F;
            ul_MuxCnt += 1;
            if(ul_MuxCnt == (uint32) gt_tx_config.s_Mp[s_lp])
               ul_MuxCnt = 0;

            // determine # of bytes to process for the current DMT frame
            if (ul_MuxCnt == (uint32) gt_tx_config.s_Mp[s_lp]-1)
               ul_data = gt_TxShowTimeVars.t_FrameParms[s_lp].s_MuxFrameSize + gt_tx_config.s_Rp[s_lp];
            else
               ul_data = gt_TxShowTimeVars.t_FrameParms[s_lp].s_MuxFrameSize;
            // program FC
            WriteCoreReg((uint32)(ZEP_REG_ZT_LP0_P_ADDR + s_lp), ul_data);
         }
      }
      else
         gft_firstZep = 0;
#endif
      //prior code
      // start FC
      //SetCoreReg(CRI_TX_FC_CTL_ADDR, REGISTER_START_TX_FC_START);
   }
}

/*****************************************************************************
;  Subroutine Name: StartRxDataPump_DMT()
;
;  This subroutine kicks off one Zephyr Rx path frame
;
;  Prototype:
;     void StartRxDataPump_DMT(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void StartRxDataPump_DMT(void)
{
   uint32 ul_data;
   if (gt_rx_config.s_Lp[LP0_DATA_PATH])
   {
      ul_data = (uint32)(gt_rx_config.s_Lp[LP0_DATA_PATH] >> 3);
   }
   else
   {
      ul_data = (uint32)(gt_rx_config.s_Lp[LP1_DATA_PATH] >> 3);
   }


   EnableRxPms();
#ifdef VR9_FIXME
   // start FC
   SetCoreReg(CRI_RX_FC_CTL_ADDR, REGISTER_START_RX_FC_START);
#endif
}

/*****************************************************************************
;  Subroutine Name: RxDataPumpMisc_DMT()
;
;  This subroutine kicks off one Zephyr Rx path frame
;
;  Prototype:
;     void RxDataPumpMisc_DMT(void)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/

void RxDataPumpMisc_DMT(void)
{
   /* Do BERT processing if BERT started and not sync frame */
   if (guc_Start_BERT_Rx && gs_MuxFrameCntRxFastPath != RX_SYMBOLS_PER_SFRAME) {
#ifndef DISABLE_BERT
      RxPNSequenceSetup(); /* Read PN Sequence */
      RxBERTSetup();       /* Switch the ping pong buffer */
#endif
   }

   if (gs_rx_framecnt == 0) {

        /* Enable fast path */
      if(   gt_rx_config.s_FramingMode == REDUCED_MERGED &&
         (gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize <
         gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize) ) {
         DisableRxFastPath();
      } else {
         EnableRxFastPath();
      }

      if(gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize >
         gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_RawFrameSize)
         EnableAlphaeusRxPath(FAST_DATA_PATH);  /* New BERT code */
   }

    if (gs_rx_framecnt == (int16) gus_RxInterleaveStartupDelay[INTERLEAVE_DATA_PATH])
    {
        /* Rx interleave path needs to be enabled some number of frames after Rx fast path */
      if(   gt_rx_config.s_FramingMode == REDUCED_MERGED &&
         (gt_RxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize <
         gt_RxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize) ) {
         DisableRxIntlvPath();
      } else {
         EnableRxIntlvPath();
      }

      if(gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize <
         gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_RawFrameSize)
         EnableAlphaeusRxPath(INTERLEAVE_DATA_PATH);     /* New BERT code */
    }

   if (gs_rx_framecnt <= (int16) gus_RxInterleaveStartupDelay[INTERLEAVE_DATA_PATH] + 1) // Don't want this counter to keep counting and wrap around.
        gs_rx_framecnt++;
}



// Functions moved from ZPH_IOf.c
void GetAocMessage(uint16 *aoc_message)
{

   uint32 ul_data;
   uint8  uc_NumValidBytes;

   // read FIFO0 (LP0:AOC FIFO) valid bytes counter
    uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH, AOC_FIFO, USE_RX_FIFO);

    //prior code
    //ReadCoreReg((uint32)ZEP_REG_ZR_AOC_ADDR, &ul_data);


   // check if new AOC byte received
    //if (ul_data & MASK_BIT8)
   if (uc_NumValidBytes >=1)
   {
      ReadHwFifo(LP0_DATA_PATH, AOC_FIFO, USE_RX_FIFO, 1, (void *)&ul_data);
      *aoc_message = (uint16)ul_data;
      *aoc_message |= NEW_AOC_MESSAGE;

#ifdef COLLECT_EOCAOCIB_INFO
      if ((gs_CollectRxOverheadInfoEnable & 0x2) != 0)
      {
         if ( (gs_RxOverheadBufferIndex < (2*MAX_STATES - 20)) && ((int32)gs_RxOverHeadSymbolCount <= gl_RxSymbolCount) )
         {

            /* 0x2 indicates collect aoc info */
            gsa_StatesTrail[gs_RxOverheadBufferIndex++] = 0xA0C;           /* indicates AOC message */
            gsa_StatesTrail[gs_RxOverheadBufferIndex++] = (int16) (*aoc_message); /* received aoc byte */

         }
         else
         {
            gs_RxOverheadBufferIndex = gs_InitRxOverheadBufferIndex;
         }
         if (gs_febe_cnt > 3)
            gs_InitRxOverheadBufferIndex = 2*MAX_STATES;
      }
#endif //#ifdef COLLECT_EOCAOCIB_INFO

      // prior code
      // WriteCoreReg((uint32)ZEP_REG_ZR_AOC_ADDR, 0); // so that we don't read the same message again
   }
}



/* writes CRC, FEC, los/sef bits (computed in synsymbl.c), NCD-I/F bits, and HEC-I/F bits, into zephyr Tx IB registers.
Note that unlike other platforms, Hercules does not take care of CRC, FEC bits by itself, so we need to do it explicitly
here.*/
void WriteIndicatorBits(void)
{
   uint32 ul_error = 0;
   uint8 uc_ibits[3];

   uc_ibits[0] = (uint8)0xFF;
   if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C)) {
      // if G992_2, bit 14 should be set to 0, as there is no cell delineation at start
      // bit 15 is reserved and hence is set to 1
      uc_ibits[1] = (uint8)0xBF;
   } else {
      // if G992_1, bit 14 and 15 should be set to 0, as there is no cell delineation at start
      uc_ibits[1] = (uint8)0x3F;
   }

   // update bit8 - Intlv path CRC (FEBE-I)
   if ((gt_TxIbData.uc_febe_i_anom == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressCRCIbToCO))
      uc_ibits[1] &= (uint8)~(0x1);

   // update bit9 - Intlv path FEC (FECC-I)
   if (gt_TxIbData.uc_ffec_i_anom == PRESENT)
      uc_ibits[1] &= (uint8)~(0x2);

   // update bit10 - Fast path  CRC (FEBE-F)
   if ((gt_TxIbData.uc_febe_f_anom == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressCRCIbToCO))
      uc_ibits[1] &= (uint8)~(0x4);

   // update bit11 - Fast path FEC (FECC-F)
   if (gt_TxIbData.uc_ffec_f_anom == PRESENT)
      uc_ibits[1] &= (uint8)~(0x8);

   // update bit12 - LOS defect
   // LOS defect computed during sync frame processing
   if ((gt_TxIbData.uc_flos_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressLosIbToCO))
      uc_ibits[1] &= (uint8)0xEF;
   else
      uc_ibits[1] |= (uint8)0x10;

   // update bit13 - SEF defect
   // SEF defect computed during sync frame processing
   if ((gt_TxIbData.uc_fsef_def == PRESENT) && !(TESTArray[TEST_Control3] & TEST_SuppressSefIbToCO))
      uc_ibits[1] &= (uint8)0xDF;
   else
      uc_ibits[1] |= (uint8)0x20;

   // update bit14 - NCD-I
   if (gt_TxIbData.uc_cd_i_flag == TRUE)
      uc_ibits[1] |= (uint8)0x40;
   else
      uc_ibits[1] &= (uint8)0xBF;

   // update bit15 - NCD-F
   if (gt_TxIbData.uc_cd_f_flag == TRUE)
      uc_ibits[1] |= (uint8)0x80;
   else
      uc_ibits[1] &= (uint8)0x7F;

   if (TESTArray[TEST_Control3] & TEST_SuppressCdIbToCO)
      uc_ibits[1] |= (uint8)0xC0;
   uc_ibits[2] = (uint8)0xFF;

   // update bit16 - HEC-I
   if(gt_TxIbData.uc_hec_i_flag == FALSE)
      uc_ibits[2] |= (uint8)0x01;
   else
      uc_ibits[2] &= (uint8)0xFE;

   // update bit17 - HEC-F
   if(gt_TxIbData.uc_hec_f_flag == FALSE)
      uc_ibits[2] |= (uint8)0x02;
   else
      uc_ibits[2] &= (uint8)0xFD;

   if (TESTArray[TEST_Control3] & TEST_SuppressHecIbToCO)
      uc_ibits[2] |= (uint8)0x03;

   // read FIFO2 (LP0:IBITS FIFO) valid bytes counter
    //uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH, IBITS_FIFO, USE_TX_FIFO);
   //if (uc_NumValidBytes == (6-3+1))
   // ul_error = 1; // otherwise error!

   // ZT_FIFO2_BYTE
   // fill in 3 IB into FIFO
   WriteHwFifo(LP0_DATA_PATH, IBITS_FIFO, USE_TX_FIFO, 3, &uc_ibits[0]);

}

/* returns a 1 if there is a message, zero otherwise */
int16 GetEocMessage(uint16 *pus_eoc_message)
{

   uint16 us_eoc_word;
   uint8 uc_NumValidBytes;
   FlagT gft_recover = TRUE;

   // read FIFO0 (LP0:EOC FIFO) valid bytes counter
    uc_NumValidBytes = getNumValidBytes(LP0_DATA_PATH, EOC_FIFO, USE_RX_FIFO);

   // consider the case only KEEP_SYNC is set to 0
   // that is only valid EOC bytes are stored in FIFO
   if (uc_NumValidBytes == 1) {
#ifdef VR9_FIXME
      if ((gs_CurrentCoChipset == ADI_CO_CHIPSET) || (gs_CurrentCoChipset ==  ANCDA_CO_CHIPSET)){
         ReadCoreReg((uint32)ZEP_REG_ZR_FRAME_IDX0_ADDR, &ul_data);
         us_Frame_Idx0 = (uint16)((0x0000FFFF) & ul_data);

         if(!gft_EOC1){ //1st byte (of a 2byte EOC message) is not in the fifo
            gft_EOC1 = TRUE; //  now it is
            gus_prev_frame_idx = us_Frame_Idx0; //watch the frame index
         }
         else{
            if (us_Frame_Idx0 != gus_prev_frame_idx){ //if the frame index has changed, and still only one byte in fifo

               //read the byte
               ReadCoreReg((uint32)ZEP_REG_ZR_FIFO0_BYTE_ADDR, &ul_FirstByte);

               // Clean the EOC fifo. That byte was invalid (not a complete EOC message). We will recover it of discard it.
               WriteCoreReg((uint32)ZEP_REG_ZR_FIFO0_CTRL_ADDR, 0);
               gft_EOC1 = FALSE; //clean the EOC Fifo indicator;

               //try to recover
               us_discarted = (int16)ul_FirstByte;
               switch(us_discarted)
               {
               case 0x004D:
                     us_eoc_word = 0x4D73;
                     break;
               case 0x0011:
                     us_eoc_word = 0x1173;
                     break;
               case 0x0001:
                     us_eoc_word = 0x01F3;
                     break;
               case 0x004F:
                     us_eoc_word = 0x4FF3;
                     break;
               default:
                     gft_recover = FALSE;
               }

               if(gft_recover){
               // gsa_StatesTrail[gs_RxOverheadBufferIndex++] = 0x3E0C;    /* indicates EOC message */
               // gsa_StatesTrail[gs_RxOverheadBufferIndex++] = us_eoc_word;  /* received eoc message */
                  gus_discarted_EOC = 0;
                  *pus_eoc_message = us_eoc_word;
                  return TRUE;
               }
               else//otherwise discard
               {
                  us_eoc_word = (0xD << 12) | (uint16)ul_FirstByte;
               // gsa_StatesTrail[gs_RxOverheadBufferIndex++] = us_eoc_word;  /* received eoc message */
                  gus_discarted_EOC++;
               }
            }
         }
         *pus_eoc_message = 0;
         return FALSE;
      }
#endif //VR9_FIXME
      return FALSE;
   }
   else if (uc_NumValidBytes >= 2)
   {
      ReadHwFifo(LP0_DATA_PATH, EOC_FIFO, USE_RX_FIFO, 2, (uint8 *)(void *)&us_eoc_word);

      #ifdef COLLECT_EOCAOCIB_INFO
      if ((gs_CollectRxOverheadInfoEnable & 0x1) != 0)
      {
         if ( (gs_RxOverheadBufferIndex < (2*MAX_STATES - 20)) && ((int32)gs_RxOverHeadSymbolCount <= gl_RxSymbolCount) )
         {
            /* 0x1 indicates collect eoc info */
            gsa_StatesTrail[gs_RxOverheadBufferIndex++] = 0xE0C;     /* indicates EOC message */
            gsa_StatesTrail[gs_RxOverheadBufferIndex++] = us_eoc_word;  /* received eoc message */
         }
         else
         {
            gs_RxOverheadBufferIndex = gs_InitRxOverheadBufferIndex;
         }
         if (gs_febe_cnt > 3)
            gs_InitRxOverheadBufferIndex = 2*MAX_STATES;
      }
      #endif //#ifdef COLLECT_EOCAOCIB_INFO
      *pus_eoc_message = us_eoc_word;
      gft_EOC1 = FALSE; //clean the EOC Fifo indicator;
      return TRUE;
   } else {
      // no valid EOC bytes
      *pus_eoc_message = 0;
      return FALSE;
   }

}


void DisableTxFraming()
{
#ifdef VR9_FIXME
   ResetCoreReg(ZEP_REG_ZT_LP0_CFG_ADDR, (uint32)MASK_BIT0);
   ResetCoreReg(ZEP_REG_ZT_LP1_CFG_ADDR, (uint32)MASK_BIT0);
#endif
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ShowTimeFastHandler_TX
 *
 *  Description:  This subroutine performs the following TX side ADSL
 *  processing on the fast latency path:
 *      loads the data from the individual bearer channels
 *      insert fast and LEX bytes into each frame,
 *
 *  Prototype:
 *      void ShowTimeFastHandler_TX(void)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      puca_data   Pointer to fast path FEC output data frame
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 ShowTimeFastHandler_TX(void)
{

   int16 s_NextMuxFrameCntTxFastPath;

   // Determine whether any IB, EOC or AOC bytes are needed for the next data
   // frame. This function should not be called if the next frame is a
   // sync frame, i.e. if gs_MuxFrameCntTxFastPath+1 == TX_SYMBOLS_PER_SFRAME.

   s_NextMuxFrameCntTxFastPath = gs_MuxFrameCntTxFastPath+1;

   if (s_NextMuxFrameCntTxFastPath > TX_SYMBOLS_PER_SFRAME)
      s_NextMuxFrameCntTxFastPath = 0;

   Tx_FastOverHeadHandler_HWE(s_NextMuxFrameCntTxFastPath);

   return 1;    /* dummy */
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ShowTimeInlvHandler_TX()
 *
 *  Description:  This subroutine performs the following TX side ADSL
 *  processing on the interleaved latency path:
 *      loads the data from the individual bearer channels
 *      insert sync, AEX and LEX bytes into each frame,
 *
 *  Prototype:
 *      int16 ShowTimeInlvHandler_TX(uint8 *puca_data)
 *
 *  Input Arguments:
 *      None
 *
 *  Output Arguments:
 *      puca_data   Pointer to interleaver output data (interleaved FEC
 *                  Output Frame)
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *      gt_TxShowTimeVars -- structure containing all global variables used
 *                           by tx.c
 *
 *  Notes:
 *
 *------------------------------------------------------------------------
 *^^^
 */

int16 ShowTimeInlvHandler_TX(void)
{

   int16 s_MuxFrameCntTxInlvPath;

   // Determine whether any IB, EOC or AOC bytes are needed for the next data
   // frame. This function should not be called if the next frame is a
   // sync frame, i.e. if gs_MuxFrameCntTxFastPath+1 == TX_SYMBOLS_PER_SFRAME.

   s_MuxFrameCntTxInlvPath = gs_MuxFrameCntTxInlvPath+1;

      // Note that interleave path frame counter only counts up to TX_SYMBOLS_PER_SFRAME-1
   if (s_MuxFrameCntTxInlvPath > (TX_SYMBOLS_PER_SFRAME-1))
      s_MuxFrameCntTxInlvPath = 0;

   /* ===================================================================================== */
   /* Load Interleaved path framing overhead into internal data buffer */
   /* ===================================================================================== */

   Tx_IntlvOverHeadHandler_HWE(s_MuxFrameCntTxInlvPath, &gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH]);

   return INLV_OUTPUT;

}

void EnableRxIntlvPath()
{
#ifdef VR9_FIXME
   SetCoreReg(ZEP_REG_ZR_LP0_CFG_ADDR, MASK_BIT0);
#endif //VR9_FIXME
}

void DisableRxIntlvPath()
{
#ifdef VR9_FIXME
   ResetCoreReg(ZEP_REG_ZR_LP0_CFG_ADDR, MASK_BIT0);
#endif //VR9_FIXME
}

void EnableRxFastPath()
{
#ifdef VR9_FIXME
   SetCoreReg(ZEP_REG_ZR_LP1_CFG_ADDR, MASK_BIT0);
#endif //VR9_FIXME
}

void DisableRxFastPath()
{
#ifdef VR9_FIXME
   ResetCoreReg(ZEP_REG_ZR_LP1_CFG_ADDR, MASK_BIT0);
#endif //VR9_FIXME
}

void DisableRxFraming()
{
#ifdef VR9_FIXME
   ResetCoreReg(ZEP_REG_ZR_LP0_CFG_ADDR, (uint32)MASK_BIT0);
   ResetCoreReg(ZEP_REG_ZR_LP1_CFG_ADDR, (uint32)MASK_BIT0);
#endif //VR9_FIXME
}

void GetCRCErrorCnt(void)
{
   int16 s_crc_lp0, s_LatencyPath;
   uint32 ul_crc_addr, ul_data;

     //processing LP0
     ul_crc_addr = ZEP_PRAM_ZR_CRC_CTRL0_LP0_ADDR;
     //read CRC errors
   ReadCoreReg(ul_crc_addr, &ul_data);
   s_crc_lp0 = (int16)(ul_data >> 16) & 0xFFFF;
   ul_data &= 0x0000FFFF;
   //clear counter
   WriteCoreReg(ul_crc_addr, ul_data);

#ifdef DUAL_LATENCY
     //processing LP1
     ul_crc_addr = ZEP_PRAM_ZR_CRC_CTRL0_LP1_ADDR;
     //read CRC errors
   ReadCoreReg(ul_crc_addr, &ul_data);
   s_crc_lp1 = (int16)(ul_data >> 16) & 0xFFFF;
   ul_data &= 0x0000FFFF;
   //clear counter
   WriteCoreReg(ul_crc_addr, ul_data);
#endif

   if ( (s_crc_lp0 > 0) && gt_rx_config.s_Lp[LP0_DATA_PATH] )
   {
      gula_CRC_count[LP0_DATA_PATH] += s_crc_lp0;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (Start)
      //gusa_CRC_count[LP0_DATA_PATH] = (int16) gula_CRC_count[LP0_DATA_PATH];   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      gusa_CRC_count[LP0_DATA_PATH] += s_crc_lp0;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (End)




#ifdef LEAVE_TRAIL
      fprintf(crc_fid,"\n There is a CRC error in SuperFrame %ld of LP0 data path", gl_rx_sframe_count);
#endif

   }
   else if ((s_crc_lp0 > 0) && gt_rx_config.s_Lp[LP1_DATA_PATH] )
   {
      gula_CRC_count[LP1_DATA_PATH] += s_crc_lp0;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (Start)
      //gusa_CRC_count[LP1_DATA_PATH] = (int16) gula_CRC_count[LP1_DATA_PATH];   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      gusa_CRC_count[LP1_DATA_PATH] += s_crc_lp0;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (End)

#ifdef LEAVE_TRAIL
      fprintf(crc_fid,"\n There is a CRC error in SuperFrame %ld of LP1 data path", gl_rx_sframe_count);
#endif
   }
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
   if (s_crc_lp0 == 0)
   {
      if(gt_rx_config.s_Lp[LP0_DATA_PATH])
         gusa_good_count[LP0_DATA_PATH]++;
      else if(gt_rx_config.s_Lp[LP1_DATA_PATH])
         gusa_good_count[LP1_DATA_PATH]++;

   }
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)


#ifdef DUAL_LATENCY
   s_crc_lp1 = (int16)ul_data & 0x00FF;
   if (s_crc_lp1 > 0) {
      gula_CRC_count[LP1_DATA_PATH] += s_crc_lp1;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (Start)
      //gusa_CRC_count[LP1_DATA_PATH] = (int16) gula_CRC_count[LP1_DATA_PATH];   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start_End)
      gusa_CRC_count[LP1_DATA_PATH] += s_crc_lp1;
      //Fix_DS_All_All_ModifiedToGetCRCPerLink (End)


#ifdef LEAVE_TRAIL
      fprintf(crc_fid,"\n There is a CRC error in SuperFrame %ld of LP1 data path", gl_rx_sframe_count);
#endif

   }
   //XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (Start)
   else
   {
      gusa_good_count[LP1_DATA_PATH]++;
   }
//XDSLRTFW-362 Bug_VR9_ALL_ALL_Incorrect_LOS_Due_to_CRC (End)
#endif


   if(STATArray[STAT_ACTIVEBCLP_US] & LP0_ACTIVE ) /* if interleave CRC calculation is enabled */
   {
      s_LatencyPath =0;
      SendCorruptCRC_DMT(s_LatencyPath);
   }

   else if(STATArray[STAT_ACTIVEBCLP_US] & LP1_ACTIVE)
   {
      s_LatencyPath =1;
      SendCorruptCRC_DMT(s_LatencyPath);
   }

}

/*****************************************************************************
;  Prototype:
;     void GetTxMuxInlvFrameCnt(int16 *ps_intlcnt)
;
;  Input Arguments:
;              pointer to the inlv mux frame count variable
;
;  Output Arguments: None
;
;  Time Critical function to read the Inlv path mux frame counts.
;
;  Global Variables:
;     Inputs:
;     Outputs:
;
;****************************************************************************/

void GetTxMuxInlvFrameCnt(int16 *ps_intlcnt)
{
#ifdef VR9_FIXME
   uint32 ul_data;

   // Zephyr's interleave Tx frame counter counts on data frames only. It does
   // not increment on a sync frame.  It resets to zero after reaching 67.

   // If the fast and interleave paths are initially enabled on the same frame,
   // the counters count like this:

   // Fast cntr: ...,0,1,2,3,...,66,67, 0,0,1,2,3,...
   // Intlv cntr:...,0,1,2,3,...,66,67, 0,0,1,2,3,...

   // If, for example, the interleave path is enabled one frame early, the
   // counters count like this:

   // Fast cntr: ...,0,1,2,3,...,65,66,67,0,0,1,2,3,...
   // Intlv cntr:...,1,2,3,4,...,66,67, 0, 1,1,2,3,4,...

   ReadCoreReg(ZEP_REG_ZT_FRAME_IDX0_ADDR, &ul_data); /* Initialize. */
   *ps_intlcnt = (int16)ul_data & 0x0000FFFF;

   // since FC increments this counter at the beginning of mux frame
   // instead of the end of mux frame, when DSP accesses this register,
   // frame index counter is not yet updated
   if (gft_ShowTimeFirstPassTx != 0) {
      (*ps_intlcnt)++;
      if (*ps_intlcnt == TX_SYMBOLS_PER_SFRAME)
         *ps_intlcnt = 0;
   }
#endif //VR9_FIXME
}

/*****************************************************************************
;  Prototype:
;     void GetRxMuxInlvFrameCnt(int16 *ps_intlcnt)
;
;  Input Arguments:
;              pointer to the inlv mux frame count variable
;
;  Output Arguments: None
;
;  Time Critical function to read the Inlv path mux frame counts
;
;  Global Variables:
;     Inputs:
;     Outputs:
;
;****************************************************************************/

void GetRxMuxInlvFrameCnt(int16 *ps_intlcnt)
{
#ifdef VR9_FIXME
   uint32 ul_data;

   ReadCoreReg (ZEP_REG_ZR_FRAME_IDX0_ADDR, &ul_data); /* Initialize. */
   *ps_intlcnt = (int16)ul_data & 0x0000FFFF;
#endif //VR9_FIXME
}


/***************************************************************************************
;  Subroutine Name: GetRxFastFrameCounter(int16 *ps_fastcnt)
;
;  Description:
;     This function increments the counter every time FDQ_DONE interrupt is received from Iridia.
;
;  Prototype:
;     void GetRxFastFrameCounter(int16 *ps_fastcnt)
;
;  Input Arguments:
;     ps_fastcnt
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/
void GetRxFastFrameCounter(int16 *ps_fastcnt)
{
   (*ps_fastcnt)++;
   if(*ps_fastcnt > RX_SYMBOLS_PER_SFRAME)
      *ps_fastcnt = 0;
}

/***************************************************************************************
;  Subroutine Name: GetTxFastFrameCounter(int16 *ps_fastcnt)
;
;  Description:
;     This function increments the counter for every TX_FRAME_START interrupt
;
;  Prototype:
;     void GetTxFastFrameCounter(int16 *ps_fastcnt)
;
;  Input Arguments:
;     ps_fastcnt
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/
void GetTxFastFrameCounter(int16 *ps_fastcnt)
{
   (*ps_fastcnt)++;
   if(*ps_fastcnt > TX_SYMBOLS_PER_SFRAME)
      *ps_fastcnt = 0;
}


/* collect indicator bits received in dmt mode */
void CollectIbInfo(void)
{
#ifdef COLLECT_EOCAOCIB_INFO
   if ((gs_CollectRxOverheadInfoEnable & 0x4) != 0)
   {
      if ( (gs_RxOverheadBufferIndex < (2*MAX_STATES - 20)) && ((int32)gs_RxOverHeadSymbolCount <= gl_RxSymbolCount) )
      {

         /* 0x4 indicates collect ib info */

         gsa_StatesTrail[gs_RxOverheadBufferIndex++] = (int16) 0xAAAA;
         gsa_StatesTrail[gs_RxOverheadBufferIndex++] = (int16) gul_RxIbInfo;
         gsa_StatesTrail[gs_RxOverheadBufferIndex++] = (int16) (gul_RxIbInfo >> 16);

      }
      else
      {
         gs_RxOverheadBufferIndex = gs_InitRxOverheadBufferIndex;
      }
      if (gs_febe_cnt > 3)
         gs_InitRxOverheadBufferIndex = 2*MAX_STATES;
   }
#endif
}

void GetRSErrorCnt(void)
{

   int16 s_lp, usa_fec_corr[NUM_DATA_PATHS], usa_fec_uncorr[NUM_DATA_PATHS];
   uint32 ul_fec_addr, ul_data;
   FlagT ft_generate_error = FALSE;
   uint8 *puca_temp_ptr[NUM_DATA_PATHS] = {&gt_TxIbData.uc_ffec_i_anom_hist, &gt_TxIbData.uc_ffec_f_anom_hist};

   // ZR_FECx_CNT accumulate # of CWs (not bytes) corrected/uncorrected






   for (s_lp=0;s_lp<NUM_DATA_PATHS;s_lp++) {

#ifdef DUAL_LATENCY
      if (s_lp == LP0_DATA_PATH)
         ul_fec_addr = ZEP_PRAM_ZR_FEC_CNT_LP0_ADDR;
      else
         ul_fec_addr = ZEP_PRAM_ZR_FEC_CNT_LP1_ADDR;
#else
       ul_fec_addr = ZEP_PRAM_ZR_FEC_CNT_LP0_ADDR;
#endif

      // read RS errors only from LP0 registers
      ReadCoreReg(ul_fec_addr, &ul_data);

      usa_fec_corr[s_lp] = (uint16)(ul_data >> 16);
      usa_fec_uncorr[s_lp] = (uint16)ul_data&0xFFFF;

      gula_CorrectedRSErrors[s_lp] += usa_fec_corr[s_lp];
      gsa_CorrectedRSErrors[s_lp] = (int16) gula_CorrectedRSErrors[s_lp];

      // XDSLRTFW-575: Counter Write back in ADSL mode (Start)
      #ifdef ADSL_62
      gula_UncorrectableRSCodewordCnt[s_lp] += usa_fec_uncorr[s_lp];
      #else
      gs_UncorrectableRSCodewordCnt[s_lp] += usa_fec_uncorr[s_lp];
      #endif
      // XDSLRTFW-575: Counter Write back in ADSL mode (End)

      // clear counters
      WriteCoreReg(ul_fec_addr, 0);

      // ported from Socrates
      // not sure if it works
      if (ft_generate_error) {
         usa_fec_corr[s_lp]++;
         gula_CorrectedRSErrors[s_lp]++;
         gsa_CorrectedRSErrors[s_lp] = (int16) gula_CorrectedRSErrors[s_lp];
      }

      if (usa_fec_corr[s_lp] > 0) {
      // counter of no. of FEC anomalies per second
         gs_fec_ecs_cnt++;


         if (gft_ModemType != G_DMT_BIS) {
            *(puca_temp_ptr[s_lp]) = PRESENT;
         }
      }
   }

}
C_SCOPE void EnableAlphaeusRxPath(int16 s_lp)
{
   int16 s_bc;

   for(s_bc = 0; s_bc < NUM_BEARER_CHANNELS; s_bc++)
   {
      if(gt_RxShowTimeVars.t_BCParms[s_bc].sa_BC_LPath == s_lp)
      {
#ifndef DISABLE_BERT
         if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
         {
            if(!guc_Start_BERT_Rx)  /* Setup Rx BERT if using for the first time */
            {
               guc_Start_BERT_Rx = 1;
               RxBERTSetup();
            }
         }
#endif
         EnableAAI_Rx(s_bc);
      }
   }
}
/***************************************************************************************
;  Subroutine Name: SendCorruptCRC_DMT(int16 s_LatencyPath)
;
;  Description:
;     This function corrupt Zephyr transmit CRC octet per PERp
;
;  Prototype:
;     void SendCorruptCRC_DMT(int16 s_LatencyPath)
;
;  Input Arguments:
;     s_LatencyPath
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;***************************************************************************************/
void SendCorruptCRC_DMT(int16 s_LatencyPath)
{
      uint32 ul_addr = 0;
        // SMS01437811 BugFix_US_ALL_Ovhd_CH_EOC ( Start)
        if (STATArray[STAT_ACTIVEBCLP_US] & LP0_ACTIVE)   /* if interleave CRC calculation is enabled */
        {
            ul_addr = (uint32)(ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR );
        }
        else if (STATArray[STAT_ACTIVEBCLP_US] & LP1_ACTIVE)
        {
            ul_addr = (uint32)(ZEP_PRAM_ZT_CRC_CTRL0_LP1_ADDR );/* if fast CRC calculation is enabled */
        }

        if (gft_send_crc_corrupt_bits_flag)
        {
            SetCoreReg(ul_addr, (uint32)MASK_BIT8);
        }
        else
        {
            ResetCoreReg(ul_addr, (uint32)MASK_BIT8);
        }
        // SMS01437811 BugFix_US_ALL_Ovhd_CH_EOC ( End)
}
