/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ZPH_IOf_showinit_dmt.C
 *
 *   Functions to Interface to zephyr core
 *
 *
 *
 *----------------------------------------------------------------------------
 */

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "ALP_IOF.h"
#include "cmv.h"
#include "bert.h"

void EnableTxIntlvFraming()
{
#ifdef VR9_FIXME
   // ADDED TO DISABLE NON-PAYLOAD PATH FOR FRAMING MODE 3
   if(   gt_tx_config.s_FramingMode == REDUCED_MERGED &&
      (gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize <
      gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize) ) {
      ResetCoreReg(ZEP_REG_ZT_LP0_CFG_ADDR, MASK_BIT0);  /*disable zephyr Tx intlv path */
   } else {
      SetCoreReg(ZEP_REG_ZT_LP0_CFG_ADDR, MASK_BIT0);  /*enable zephyr Tx intlv path */
   }

   if(gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_RawFrameSize >
      gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize) {
      EnableAlphaeusTxPath(LP0_DATA_PATH); /* Enable Alphaeus Tx */
   }
#endif //VR9_FIXME
}

void EnableTxFastFraming()
{
#ifdef VR9_FIXME
   // ADDED TO DISABLE NON-PAYLOAD PATH FOR FRAMING MODE 3
   if(   gt_tx_config.s_FramingMode == REDUCED_MERGED &&
      (gt_TxShowTimeVars.t_FrameParms[FAST_DATA_PATH].s_RawFrameSize <
      gt_TxShowTimeVars.t_FrameParms[INTERLEAVE_DATA_PATH].s_RawFrameSize) ) {
      ResetCoreReg(ZEP_REG_ZT_LP1_CFG_ADDR, MASK_BIT0);  /*disable zephyr Tx fast path */
   } else {
      SetCoreReg(ZEP_REG_ZT_LP1_CFG_ADDR, MASK_BIT0);  /*enable zephyr Tx fast path */
   }
   if(gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_RawFrameSize >
      gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_RawFrameSize ) {
      EnableAlphaeusTxPath(LP1_DATA_PATH); /* Enable Alphaeus Tx */
   }
#endif
}

extern uint16 gus_TxEocRegister;

extern MessageFifo_t gt_TxEocFifo;

/* Global variables for BERT */              // ADR into gdata.c
extern uint8 guc_Start_BERT_Rx ;
extern uint8 guc_Start_BERT_Tx ;

C_SCOPE void EnableAlphaeusTxPath(int16 s_lp)
{
   int16 s_bc;

   for(s_bc = 0; s_bc < NUM_BEARER_CHANNELS; s_bc++)
   {
      if(gt_TxShowTimeVars.t_BCParms[s_bc].sa_BC_LPath == s_lp)
      {
#ifndef DISABLE_BERT
         if ((TESTArray[TEST_Control] & TEST_BertControl) != 0)
         {
            if(!guc_Start_BERT_Tx)  /* Setup Tx BERT if using for the first time */
            {
               guc_Start_BERT_Tx = 1;
               TxBERTSetup();
            }
         }
#endif
         EnableAAI_Tx(s_bc);
      }
   }
}

C_SCOPE void EnableTxPath(int16 s_LatencyPath)
{
   // not used in Hercules build
}
