/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 2008-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: Zep_microCodeData.c
*
*   This file contains micro Code for Zephyr code engines.
*
*-------------------------------------------------------------------------------
*/
//****************************************************************************
//Zep_microCodeData.c
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
// 25/04/2012 Kannan:
//          1. Insertion of dummy byte logic is removed in DS ReTx micro code
//             at "fci_prog_rx_adsl2_retx_lp1", because we force D=1
//             when ReTx is enabled. Removing of dummy byte insertion logic
//             was required to operate FP0 as slave for FP7. FP7 completes the
//             Read process first(FP7) and forllowed by write process(FP0).
//             if both read(FP7) & write(FP0) operations was running concurrently, we observed
//             the memory corruption at the ReTx Queue buffer.
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 11/12/2014 Kannan:
//          1. DS ReTx micro code is changed as per New ReTx Queue design,
//             DSL FW will give 3 addresses of the DTU's which needs to written
//             by micro code for every symbol. This change will allow DTU's to be written
//             in anywhere in the Qrx as desired by the DSL FW.
//             These changes are done in "fci_prog_rx_adsl2_retx_lp1"
//             Grep for XDSLRTFW-1223.
//*****************************************************************************************

#include "common.h"
#include "data_alloc.h"


DATA_ZEP_TX_UCODE_BEGIN

#ifndef ZEP_DEBUG_BLD
    int fci_prog_tx_adsl2_2bc_ibits[] = {

    0x02111, // ID.V.v
    /*
    */
    0x0000003f, // UPROC_ENA
    0x0000,  16, 0x00000000, 0x20000000, 0x00000000, 0x00100000, 0x00000000,  // Code block 0 base, size, STATE0-4
    0x0010,  10, 0x00001400, 0x10000000, 0x00140000, 0x00000000, 0x00000000,  // Code block 1 base, size, STATE0-4
    0x001a,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000,  // Code block 2 base, size, STATE0-4
    0x001d,  13, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000,  // Code block 3 base, size, STATE0-4
    0x002a,  12, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 4 base, size, STATE0-4
    0x0036,  12, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
    0x04000004, // FLAG_DATA 0
    0x00000050, // FLAG_DATA 1
        66, // Total code length
    // Code block 0 memory
    0x402e0804, //   0('h00000): JUMP(2, `IFCNTLT(`R(ZT_R4+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R4+0x000,0)))
    0x40a20000, //   1('h00001): JUMP(10)
    0x6c14e000, //   2('h00002): SET_IO(`CONST(8'h00), `OUT(ILV0))
    0x80000804, //   3('h00003): MOV(`R(ZT_R4+0x000,0))
    0x6d10c00e, //   4('h00004): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
    0x80000811, //   5('h00005): MOV(`R(ZT_CODEWORD+0x001,0))
    0x6c14c010, //   6('h00006): SET_IO(`IN(RS_D), `OUT(ILV0))
    0x80000812, //   7('h00007): MOV(`R(ZT_CODEWORD+0x002,0))
    0x40220000, //   8('h00008): JUMP(2)  // END_FOREVER
    0x40f20000, //   9('h00009): JUMP(15)  // ELSE
    0x6d10c00e, //  10('h0000a): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
    0x80000811, //  11('h0000b): MOV(`R(ZT_CODEWORD+0x001,0))
    0x6c14c010, //  12('h0000c): SET_IO(`IN(RS_D), `OUT(ILV0))
    0x80000812, //  13('h0000d): MOV(`R(ZT_CODEWORD+0x002,0))
    0x40a20000, //  14('h0000e): JUMP(10)  // END_FOREVER
    0x40020000, //  15('h0000f): JUMP(0)  // END_FOREVER
    // Code block 1 memory
    0x402e0804, //   0('h00010): JUMP(2, `IFCNTLT(`R(ZT_R4+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R4+0x000,0)))
    0x40720000, //   1('h00011): JUMP(7)
    0x6e000000, //   2('h00012): SET_IO(`NULL_DST)
    0xc0000804, //   3('h00013): MOV(`R(ZT_R4+0x000,0), `KEEP_CNT)
    0x8c20089d, //   4('h00014): MOV(`R(ZT_ILV_PARAMS0+0x001,0), `OUT(FP2))
    0x40220000, //   5('h00015): JUMP(2)  // END_FOREVER
    0x40920000, //   6('h00016): JUMP(9)  // ELSE
    0x8c20089d, //   7('h00017): MOV(`R(ZT_ILV_PARAMS0+0x001,0), `OUT(FP2))
    0x40720000, //   8('h00018): JUMP(7)  // END_FOREVER
    0x40020000, //   9('h00019): JUMP(0)  // END_FOREVER
    // Code block 2 memory
    0xa0011df8, //   0('h0001a): MOV(`R(ZT_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
    0x00004000, //   1('h0001b): WAIT_EVENT(WAIT_STOP)
    0x40020000, //   2('h0001c): JUMP(0)  // END_FOREVER
    // Code block 3 memory
    0x88500001, //   0('h0001d): MOV(1, `IN(FP5))
    0x89600c14, //   1('h0001e): MOV(`R(ZT_VBC_SIZE+0x000,1), `IN(TCLAYER))
    0x89600c16, //   2('h0001f): MOV(`R(ZT_VBC_SIZE+0x002,1), `IN(TCLAYER))
    0x400c0001, //   3('h00020): JUMP(0, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
    0x408a081a, //   4('h00021): JUMP(8, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
    0x40c20000, //   5('h00022): JUMP(12)
    0x4088081a, //   6('h00023): JUMP(8, `REPEAT(`R(ZT_FRAMING+0x002,0)))
    0x40c20000, //   7('h00024): JUMP(12)
    0x89600001, //   8('h00025): MOV(1, `IN(TCLAYER))
    0x80000c14, //   9('h00026): MOV(`R(ZT_VBC_SIZE+0x000,1))
    0x80000c16, //  10('h00027): MOV(`R(ZT_VBC_SIZE+0x002,1))
    0x40620000, //  11('h00028): JUMP(6)  // END_WHILE
    0x40020000, //  12('h00029): JUMP(0)
    // Code block 4 memory
    0x8d622c14, //   0('h0002a): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x8d612c16, //   1('h0002b): MOV(`R(ZT_VBC_SIZE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x400c0001, //   2('h0002c): JUMP(0, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
    0x407a081a, //   3('h0002d): JUMP(7, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
    0x40b20000, //   4('h0002e): JUMP(11)
    0x4078081a, //   5('h0002f): JUMP(7, `REPEAT(`R(ZT_FRAMING+0x002,0)))
    0x40b20000, //   6('h00030): JUMP(11)
    0x8d622001, //   7('h00031): MOV(1, `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x8d622c14, //   8('h00032): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x8d612c16, //   9('h00033): MOV(`R(ZT_VBC_SIZE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x40520000, //  10('h00034): JUMP(5)  // END_WHILE
    0x40020000, //  11('h00035): JUMP(0)  // END_FOREVER
    // Code block 5 memory
    0x00002000, //   0('h00036): WAIT_EVENT(WAIT_OUT)
    0x403e0808, //   1('h00037): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)  // IF_CNT_LT(`R(ZT_R8+0x000,0)))
    0x40520000, //   2('h00038): JUMP(5)
    0xc8a51001, //   3('h00039): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
    0x40620000, //   4('h0003a): JUMP(6)  // ELSE
    0xc8a11001, //   5('h0003b): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
    0x20001c00, //   6('h0003c): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
    0xc9e00005, //   7('h0003d): MOV(5, `IN(FIFO2), `KEEP_CNT)
    0x6000e0ff, //   8('h0003e): SET_IO(`CONST(8'hffffffff))
    0xc0000006, //   9('h0003f): MOV(6, `KEEP_CNT)
    0x89c00c18, //  10('h00040): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
    0x40020000, //  11('h00041): JUMP(0)  // END_FOREVER
    // Program will require these registers:
    //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
    //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
    //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
    //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
    //   ZT_ILV_PARAMS0+0x001 [7:0] - ?? (MOV byte count)
    //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
    //   ZT_R4+0x000 [7:0] - ?? (MOV byte count)
    //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
    //   ZT_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
    //   ZT_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
    // Code block 5 will modify these registers:
    //   ZT_R0+0x000 [7:0] -
    0
    };

#else //#ifndef ZEP_DEBUG_BLD
int fci_prog_tx_adsl2_2bc_ibits[] = {
  0x02112, // ID.V.v
/*
*/
  0x0000003f, // UPROC_ENA
  0x0000,  16, 0x00000000, 0x20000000, 0x00000000, 0x00100000, 0x00000000, // Code block 0 base, size, STATE0-4
  0x0010,  10, 0x00001400, 0x10000000, 0x00140000, 0x00000000, 0x00000000, // Code block 1 base, size, STATE0-4
  0x001a,   3, 0x00000000, 0x20000000, 0x00000000, 0x04000000, 0x00000000, // Code block 2 base, size, STATE0-4
  0x001d,  14, 0x00000000, 0x20000000, 0x00000000, 0x00004400, 0x00000000, // Code block 3 base, size, STATE0-4
  0x002b,  12, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000, // Code block 4 base, size, STATE0-4
  0x0037,  12, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Code block 5 base, size, STATE0-4
  0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Code block 6 base, size, STATE0-4
  0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Code block 7 base, size, STATE0-4
  0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Code block 8 base, size, STATE0-4
  0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Code block 9 base, size, STATE0-4
  0x04000004, // FLAG_DATA 0
  0x00000050, // FLAG_DATA 1
   67, // Total code length
  // Code block 0 memory
  0x402e0804, //   0('h00000): JUMP(2, `IFCNTLT(`R(ZT_R4+0x000,0)), `KEEP_CNT)   // IF_CNT_LT(`R(ZT_R4+0x000,0)))
  0x40a20000, //   1('h00001): JUMP(10)
  0x6c14e000, //   2('h00002): SET_IO(`CONST(8'h00), `OUT(ILV0))
  0x80000804, //   3('h00003): MOV(`R(ZT_R4+0x000,0))
  0x6d10c00e, //   4('h00004): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
  0x80000811, //   5('h00005): MOV(`R(ZT_CODEWORD+0x001,0))
  0x6c14c010, //   6('h00006): SET_IO(`IN(RS_D), `OUT(ILV0))
  0x80000812, //   7('h00007): MOV(`R(ZT_CODEWORD+0x002,0))
  0x40220000, //   8('h00008): JUMP(2) // END_FOREVER
  0x40f20000, //   9('h00009): JUMP(15)  // ELSE
  0x6d10c00e, //  10('h0000a): SET_IO(`IN(SCR_D), `OUT(RS_D), `KEEP_MASK)
  0x80000811, //  11('h0000b): MOV(`R(ZT_CODEWORD+0x001,0))
  0x6c14c010, //  12('h0000c): SET_IO(`IN(RS_D), `OUT(ILV0))
  0x80000812, //  13('h0000d): MOV(`R(ZT_CODEWORD+0x002,0))
  0x40a20000, //  14('h0000e): JUMP(10)  // END_FOREVER
  0x40020000, //  15('h0000f): JUMP(0) // END_FOREVER
  // Code block 1 memory
  0x402e0804, //   0('h00010): JUMP(2, `IFCNTLT(`R(ZT_R4+0x000,0)), `KEEP_CNT)   // IF_CNT_LT(`R(ZT_R4+0x000,0)))
  0x40720000, //   1('h00011): JUMP(7)
  0x6e000000, //   2('h00012): SET_IO(`NULL_DST)
  0xc0000804, //   3('h00013): MOV(`R(ZT_R4+0x000,0), `KEEP_CNT)
  0x8c20089d, //   4('h00014): MOV(`R(ZT_ILV_PARAMS0+0x001,0), `OUT(FP2))
  0x40220000, //   5('h00015): JUMP(2) // END_FOREVER
  0x40920000, //   6('h00016): JUMP(9) // ELSE
  0x8c20089d, //   7('h00017): MOV(`R(ZT_ILV_PARAMS0+0x001,0), `OUT(FP2))
  0x40720000, //   8('h00018): JUMP(7) // END_FOREVER
  0x40020000, //   9('h00019): JUMP(0) // END_FOREVER
  // Code block 2 memory
  0xa0011df8, //   0('h0001a): MOV(`R(ZT_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_LAST))
  0x00004000, //   1('h0001b): WAIT_EVENT(WAIT_STOP)
  0x40020000, //   2('h0001c): JUMP(0) // END_FOREVER
  // Code block 3 memory
  0x6d1f0000, //   0('h0001d): SET_IO(`OUT(FIFO3), `KEEP_MASK)
  0x88500001, //   1('h0001e): MOV(1, `IN(FP5))
  0x89600c14, //   2('h0001f): MOV(`R(ZT_VBC_SIZE+0x000,1), `IN(TCLAYER))
  0x89600c16, //   3('h00020): MOV(`R(ZT_VBC_SIZE+0x002,1), `IN(TCLAYER))
  0x401c0001, //   4('h00021): JUMP(1, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
  0x409a081a, //   5('h00022): JUMP(9, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
  0x40d20000, //   6('h00023): JUMP(13)
  0x4098081a, //   7('h00024): JUMP(9, `REPEAT(`R(ZT_FRAMING+0x002,0)))
  0x40d20000, //   8('h00025): JUMP(13)
  0x89600001, //   9('h00026): MOV(1, `IN(TCLAYER))
  0x80000c14, //  10('h00027): MOV(`R(ZT_VBC_SIZE+0x000,1))
  0x80000c16, //  11('h00028): MOV(`R(ZT_VBC_SIZE+0x002,1))
  0x40720000, //  12('h00029): JUMP(7) // END_WHILE
  0x40120000, //  13('h0002a): JUMP(1) // END_FOREVER
  // Code block 4 memory
  0x8d622c14, //   0('h0002b): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x8d612c16, //   1('h0002c): MOV(`R(ZT_VBC_SIZE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x400c0001, //   2('h0002d): JUMP(0, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
  0x407a081a, //   3('h0002e): JUMP(7, `IFCNTLT(`R(ZT_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZT_FRAMING+0x002,0)))
  0x40b20000, //   4('h0002f): JUMP(11)
  0x4078081a, //   5('h00030): JUMP(7, `REPEAT(`R(ZT_FRAMING+0x002,0)))
  0x40b20000, //   6('h00031): JUMP(11)
  0x8d622001, //   7('h00032): MOV(1, `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x8d622c14, //   8('h00033): MOV(`R(ZT_VBC_SIZE+0x000,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x8d612c16, //   9('h00034): MOV(`R(ZT_VBC_SIZE+0x002,1), `OUT(TCLAYER), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x40520000, //  10('h00035): JUMP(5) // END_WHILE
  0x40020000, //  11('h00036): JUMP(0) // END_FOREVER
  // Code block 5 memory
  0x00002000, //   0('h00037): WAIT_EVENT(WAIT_OUT)
  0x403e0808, //   1('h00038): JUMP(3, `IFCNTLT(`R(ZT_R8+0x000,0)), `KEEP_CNT)   // IF_CNT_LT(`R(ZT_R8+0x000,0)))
  0x40520000, //   2('h00039): JUMP(5)
  0xc8a51001, //   3('h0003a): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT, `INVERT)
  0x40620000, //   4('h0003b): JUMP(6) // ELSE
  0xc8a11001, //   5('h0003c): MOV(1, `IN(CRC0_D), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
  0x20001c00, //   6('h0003d): WR_REG(`DEST(ZT_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))
  0xc9e00005, //   7('h0003e): MOV(5, `IN(FIFO2), `KEEP_CNT)
  0x6000e0ff, //   8('h0003f): SET_IO(`CONST(8'hffffffff))
  0xc0000006, //   9('h00040): MOV(6, `KEEP_CNT)
  0x89c00c18, //  10('h00041): MOV(`R(ZT_FRAMING+0x000,1), `IN(FIFO0))
  0x40020000, //  11('h00042): JUMP(0) // END_FOREVER
  // Program will require these registers:
  //   ZT_CODEWORD+0x001 [7:0] - ?? (MOV byte count)
  //   ZT_CODEWORD+0x002 [7:0] - ?? (MOV byte count)
  //   ZT_FRAMING+0x000 [15:0] - ?? (MOV byte count)
  //   ZT_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
  //   ZT_ILV_PARAMS0+0x001 [7:0] - ?? (MOV byte count)
  //   ZT_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
  //   ZT_R4+0x000 [7:0] - ?? (MOV byte count)
  //   ZT_R8+0x000 [7:0] - ?? (JUMP repeat count)
  //   ZT_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
  //   ZT_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
  // Code block 5 will modify these registers:
  //   ZT_R0+0x000 [7:0] -
  0
};

#endif //#ifndef ZEP_DEBUG_BLD
DATA_MAP_END


DATA_ZEP_RX_UCODE_BEGIN
#ifndef ZEP_DEBUG_BLD
    int fci_prog_rx_adsl2_2bc_ibits[] = {
    0x03110, // ID.V.v
    /*
    */
    0x000001ff, // UPROC_ENA
    0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
    0x0003,   2, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
    0x0005,  21, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
    0x001a,   6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
    0x0020,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
    0x0022,  15, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
    0x0031,   7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
    0x0038,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
    0x003c,   4, 0x00000000, 0x20000000, 0x00000000, 0x00000004, 0x00000000,  // Code block 8 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
    0x06000044, // FLAG_DATA 0
    0x00000656, // FLAG_DATA 1
        64, // Total code length
    // Code block 0 memory
    0x80000e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1))
    0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)
    0x40020000, //   2('h00002): JUMP(0)
    // Code block 1 memory
    // Pass DTB read-flags into DTB
    0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
    0x40020000, //   1('h00004): JUMP(0)  // END_FOREVER
    // Code block 2 memory
    0x30000cac, //   0('h00005): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x30000cae, //   1('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x200ffca9, //   2('h00007): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
    0x200ffca8, //   3('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
    0x30003caa, //   4('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
    0x409a089d, //   5('h0000a): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
    0x40c20000, //   6('h0000b): JUMP(12)
    0x4098089d, //   7('h0000c): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
    0x40c20000, //   8('h0000d): JUMP(12)
    0x8d400c08, //   9('h0000e): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
    0x30000cb0, //  10('h0000f): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x40720000, //  11('h00010): JUMP(7)  // END_WHILE
    0x80000804, //  12('h00011): MOV(`R(ZR_R4+0x000,0))
    0x80000810, //  13('h00012): MOV(`R(ZR_CODEWORD+0x000,0))
    0x6e00c014, //  14('h00013): SET_IO(`IN(ILV0), `NULL_DST)
    0x80000804, //  15('h00014): MOV(`R(ZR_R4+0x000,0))
    0x6c10c014, //  16('h00015): SET_IO(`IN(ILV0), `OUT(RS_D))
    0xce300001, //  17('h00016): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)
    0x8d000810, //  18('h00017): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))
    0x6c148000, //  19('h00018): SET_IO(`SLVIN, `OUT(ILV0))
    0x40c20000, //  20('h00019): JUMP(12)  // END_FOREVER
    // Code block 3 memory
    0x6e008000, //   0('h0001a): SET_IO(`SLVIN, `NULL_DST)
    0x80000001, //   1('h0001b): MOV(1)
    0x6e00c011, //   2('h0001c): SET_IO(`IN(RSDEC_MET), `NULL_DST)
    0x80000804, //   3('h0001d): MOV(`R(ZR_R4+0x000,0))
    0x8d100810, //   4('h0001e): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RSDEC_MET))
    0x40020000, //   5('h0001f): JUMP(0)
    // Code block 4 memory
    // Moves correct bytes from the reed solomon to the descrambler
    0x89000811, //   0('h00020): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
    0x40020000, //   1('h00021): JUMP(0)  // Restart
    // Code block 5 memory
    0x6c0ad007, //   0('h00022): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
    0x8e600001, //   1('h00023): MOV(1, `OUT(FP6), `KEEP_MASK)
    0x6c0ac00e, //   2('h00024): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
    0x8f622c14, //   3('h00025): MOV(`R(ZR_VBC_SIZE+0x000,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x80012c16, //   4('h00026): MOV(`R(ZR_VBC_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x400c0001, //   5('h00027): JUMP(0, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
    0x40aa081a, //   6('h00028): JUMP(10, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
    0x40e20000, //   7('h00029): JUMP(14)
    0x40a8081a, //   8('h0002a): JUMP(10, `REPEAT(`R(ZR_FRAMING+0x002,0)))
    0x40e20000, //   9('h0002b): JUMP(14)
    0x80022001, //  10('h0002c): MOV(1, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x80022c14, //  11('h0002d): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x80012c16, //  12('h0002e): MOV(`R(ZR_VBC_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
    0x40820000, //  13('h0002f): JUMP(8)  // END_WHILE
    0x40020000, //  14('h00030): JUMP(0)
    // Code block 6 memory
    0x6e000000, //   0('h00031): SET_IO(`NULL_DST)
    0xc0000001, //   1('h00032): MOV(1, `KEEP_CNT)
    0xcde00005, //   2('h00033): MOV(5, `OUT(FIFO2), `KEEP_CNT)
    0x6e000000, //   3('h00034): SET_IO(`NULL_DST)
    0xc0000006, //   4('h00035): MOV(6, `KEEP_CNT)
    0x8dc00c18, //   5('h00036): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))
    0x40020000, //   6('h00037): JUMP(0)  // END_FOREVER
    // Code block 7 memory
    0xc0011001, //   0('h00038): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
    0x20001c00, //   1('h00039): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
    0x80000c18, //   2('h0003a): MOV(`R(ZR_FRAMING+0x000,1))
    0x40020000, //   3('h0003b): JUMP(0)
    // Code block 8 memory
    0x6000e000, //   0('h0003c): SET_IO(`CONST(8'h00))
    0xc0000804, //   1('h0003d): MOV(`R(ZR_R4+0x000,0), `KEEP_CNT)
    0x8800089d, //   2('h0003e): MOV(`R(ZR_ILV_PARAMS0+0x001,0), `IN(FP0))
    0x40020000, //   3('h0003f): JUMP(0)  // END_FOREVER
    // Program will require these registers:
    //   ZR_CODEWORD+0x000 [7:0] - ?? (MOV byte count)
    //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
    //   ZR_FRAMING+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
    //   ZR_ILV_PARAMS0+0x001 [7:0] - ?? (MOV byte count)
    //   ZR_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_R4+0x000 [7:0] - ?? (MOV byte count)
    //   ZR_R8+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
    // Code block 2 will modify these registers:
    //   ZR_ILV_FULLNESS0+0x000 [15:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
    //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
    //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
    // Code block 7 will modify these registers:
    //   ZR_R0+0x000 [7:0] - SEQP Done
    0
    };

#else //#ifndef ZEP_DEBUG_BLD
int fci_prog_rx_adsl2_2bc_ibits[] = {
  0x03111, // ID.V.v
/*
*/
  0x000001ff, // UPROC_ENA
  0x0000,   3, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
  0x0003,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
  0x0006,  21, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
  0x001b,   6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
  0x0021,   2, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
  0x0023,  17, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
  0x0034,   7, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
  0x003b,   4, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
  0x003f,   4, 0x00000000, 0x20000000, 0x00000000, 0x00000004, 0x00000000,  // Code block 8 base, size, STATE0-4
  0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
  0x06000044, // FLAG_DATA 0
  0x00000656, // FLAG_DATA 1
      67, // Total code length
  // Code block 0 memory
  0x80000e3c, //   0('h00000): MOV(`R(ZR_PMS_SIZE+0x000,1))
  0x00004000, //   1('h00001): WAIT_EVENT(WAIT_STOP)
  0x40020000, //   2('h00002): JUMP(0)
  // Code block 1 memory
  // Pass DTB read-flags into DTB
  0xa0014e3c, //   0('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST))
  0x00004000, //   1('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
  0x40020000, //   2('h00005): JUMP(0)  // END_FOREVER
  // Code block 2 memory
  0x30000cac, //   0('h00006): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
  0x30000cae, //   1('h00007): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
  0x200ffca9, //   2('h00008): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
  0x200ffca8, //   3('h00009): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
  0x30003caa, //   4('h0000a): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
  0x409a089d, //   5('h0000b): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
  0x40c20000, //   6('h0000c): JUMP(12)
  0x4098089d, //   7('h0000d): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
  0x40c20000, //   8('h0000e): JUMP(12)
  0x8d400c08, //   9('h0000f): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
  0x30000cb0, //  10('h00010): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
  0x40720000, //  11('h00011): JUMP(7)  // END_WHILE
  0x80000804, //  12('h00012): MOV(`R(ZR_R4+0x000,0))
  0x80000810, //  13('h00013): MOV(`R(ZR_CODEWORD+0x000,0))
  0x6e00c014, //  14('h00014): SET_IO(`IN(ILV0), `NULL_DST)
  0x80000804, //  15('h00015): MOV(`R(ZR_R4+0x000,0))
  0x6c10c014, //  16('h00016): SET_IO(`IN(ILV0), `OUT(RS_D))
  0xce300001, //  17('h00017): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)
  0x8d000810, //  18('h00018): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))
  0x6c148000, //  19('h00019): SET_IO(`SLVIN, `OUT(ILV0))
  0x40c20000, //  20('h0001a): JUMP(12)  // END_FOREVER
  // Code block 3 memory
  0x6e008000, //   0('h0001b): SET_IO(`SLVIN, `NULL_DST)
  0x80000001, //   1('h0001c): MOV(1)
  0x6e00c011, //   2('h0001d): SET_IO(`IN(RSDEC_MET), `NULL_DST)
  0x80000804, //   3('h0001e): MOV(`R(ZR_R4+0x000,0))
  0x8d100810, //   4('h0001f): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RSDEC_MET))
  0x40020000, //   5('h00020): JUMP(0)
  // Code block 4 memory
  // Moves correct bytes from the reed solomon to the descrambler
  0x89000811, //   0('h00021): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
  0x40020000, //   1('h00022): JUMP(0)  // Restart
  // Code block 5 memory
  0x6c0ad007, //   0('h00023): SET_IO(`IN(FP7), `INPUT_FLAG, `OUT(CRC0_D))
  0x6d1f0000, //   1('h00024): SET_IO(`OUT(FIFO3), `KEEP_MASK)
  0x8e600001, //   2('h00025): MOV(1, `OUT(FP6), `KEEP_MASK)
  0x6c0ac00e, //   3('h00026): SET_IO(`IN(SCR_D), `OUT(CRC0_D))
  0x6d1f0000, //   4('h00027): SET_IO(`OUT(FIFO3), `KEEP_MASK)
  0x8f622c14, //   5('h00028): MOV(`R(ZR_VBC_SIZE+0x000,1), `OUT(TCLAYER), `KEEP_MASK, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x80012c16, //   6('h00029): MOV(`R(ZR_VBC_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x400c0001, //   7('h0002a): JUMP(0, `REPEAT(`COUNT(8'h01)), `KEEP_CNT)  // END_WHILE_CNT_LT(`COUNT(8'h01)), `KEEP_CNT)
  0x40ca081a, //   8('h0002b): JUMP(12, `IFCNTLT(`R(ZR_FRAMING+0x002,0)))  // WHILE_CNT_LT(`R(ZR_FRAMING+0x002,0)))
  0x41020000, //   9('h0002c): JUMP(16)
  0x40c8081a, //  10('h0002d): JUMP(12, `REPEAT(`R(ZR_FRAMING+0x002,0)))
  0x41020000, //  11('h0002e): JUMP(16)
  0x80022001, //  12('h0002f): MOV(1, `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x80022c14, //  13('h00030): MOV(`R(ZR_VBC_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_AND), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x80012c16, //  14('h00031): MOV(`R(ZR_VBC_SIZE+0x002,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h2), `APPLY_MODE(APPLY_MODE_ALL))
  0x40a20000, //  15('h00032): JUMP(10)  // END_WHILE
  0x40020000, //  16('h00033): JUMP(0)
  // Code block 6 memory
  0x6e000000, //   0('h00034): SET_IO(`NULL_DST)
  0xc0000001, //   1('h00035): MOV(1, `KEEP_CNT)
  0xcde00005, //   2('h00036): MOV(5, `OUT(FIFO2), `KEEP_CNT)
  0x6e000000, //   3('h00037): SET_IO(`NULL_DST)
  0xc0000006, //   4('h00038): MOV(6, `KEEP_CNT)
  0x8dc00c18, //   5('h00039): MOV(`R(ZR_FRAMING+0x000,1), `OUT(FIFO0))
  0x40020000, //   6('h0003a): JUMP(0)  // END_FOREVER
  // Code block 7 memory
  0xc0011001, //   0('h0003b): MOV(1, `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h1), `APPLY_MODE(APPLY_MODE_ALL), `KEEP_CNT)
  0x20001c00, //   1('h0003c): WR_REG(`DEST(ZR_R0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'h01))  // Set ZR_R0 to 1 to indicate SEQP_DONE
  0x80000c18, //   2('h0003d): MOV(`R(ZR_FRAMING+0x000,1))
  0x40020000, //   3('h0003e): JUMP(0)
  // Code block 8 memory
  0x6000e000, //   0('h0003f): SET_IO(`CONST(8'h00))
  0xc0000804, //   1('h00040): MOV(`R(ZR_R4+0x000,0), `KEEP_CNT)
  0x8800089d, //   2('h00041): MOV(`R(ZR_ILV_PARAMS0+0x001,0), `IN(FP0))
  0x40020000, //   3('h00042): JUMP(0)  // END_FOREVER
  // Program will require these registers:
  //   ZR_CODEWORD+0x000 [7:0] - ?? (MOV byte count)
  //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
  //   ZR_FRAMING+0x000 [15:0] - ?? (MOV byte count)
  //   ZR_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
  //   ZR_ILV_PARAMS0+0x001 [7:0] - ?? (MOV byte count)
  //   ZR_PMS_SIZE+0x000 [15:0] - ?? (MOV byte count)
  //   ZR_R4+0x000 [7:0] - ?? (MOV byte count)
  //   ZR_R8+0x000 [15:0] - ?? (MOV byte count)
  //   ZR_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
  //   ZR_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
  // Code block 2 will modify these registers:
  //   ZR_ILV_FULLNESS0+0x000 [15:0] -
  //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
  //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
  //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
  //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
  //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
  // Code block 7 will modify these registers:
  //   ZR_R0+0x000 [7:0] - SEQP Done
  0
};
#endif //#ifndef ZEP_DEBUG_BLD
DATA_MAP_END
//XDSLRTFW-1223 Qrx Full Fix (Start)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
DATA_ZEP_RX_RETX_LP1_UCODE_BEGIN
    int fci_prog_rx_adsl2_retx_lp1[] = {
    0x03111, // ID.V.v
    /*
    */

    0x000000FF, // FP9(0),FP8(0),  FP7(1),FP6(1),FP5(1),FP4(1),   FP3(1),FP2(1),FP1(1),FP0(1)   UPROC_ENA
    0x0000,   6, 0x00001a00, 0x10000000, 0x001a0000, 0x00000000, 0x00000000,  // Code block 0 base, size, STATE0-4
    0x0006,   3, 0x00000000, 0x70000000, 0x00000000, 0x08000000, 0x00000000,  // Code block 1 base, size, STATE0-4
    0x0009,  18, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 2 base, size, STATE0-4
    0x001b,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 3 base, size, STATE0-4
    0x0020,   5, 0x00000000, 0x20000000, 0x00000000, 0x00004000, 0x00000000,  // Code block 4 base, size, STATE0-4
    0x0025,  35, 0x00000e00, 0x10000000, 0x000e0000, 0x00000000, 0x00000000,  // Code block 5 base, size, STATE0-4
    0x0048,   5, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 6 base, size, STATE0-4
    0x004d,  11, 0x00000000, 0x50000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 7 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 8 base, size, STATE0-4
    0x0000,   0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,  // Code block 9 base, size, STATE0-4
    0x76000000, // FLAG_DATA 0
    0x00000656, // FLAG_DATA 1
        88, // Total code length

     // Moves bytes from the DTB to the DILV, counting PMS_SIZE before stopping
    0x6e008007, //   0('h00000):setio input pf7, slave, output null
   0x80000001, //   1('h00001):move 1 byte
    0x6c02c01a,   //    2('h00002):set io input 0x1a, master
    0x8c200e3e, //   3('h00003): MOV(`R(ZR_PMS_SIZE+0x000,1), `OUT(FP2))  // Move P bytes to DILV
    0x00004000, //   4('h00004): WAIT_EVENT(WAIT_STOP)  // wait for a stop
    0x40020000, //   5('h00005): JUMP(0)  // Restart

    // Code block 1 memory
    // Pass DTB read-flags into DTB
    0xa0014e3e, //   0('h00006): MOV(`R(ZR_PMS_SIZE+0x000,1), `FLAG_MODE(FLAG_MODE_OR), `FLAG_MASK(4'h4), `APPLY_MODE(APPLY_MODE_LAST)), i.e LP1_PMS_SIZE
    0x00004000, //   1('h00007): WAIT_EVENT(WAIT_STOP)
    0x40020000, //   2('h00008): JUMP(0)  // END_FOREVER

    // Code block 2 memory
    0x30000cac, //   0('h00009): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x30000cae, //   1('h0000a): WR_REG(`DEST(ZR_ILV_MIN_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x200ffca9, //   2('h0000b): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x001), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
    0x200ffca8, //   3('h0000c): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x000), `WR_MODE(WR_REG_OVER), `WR_MASK(8'hff))
    0x30003caa, //   4('h0000d): WR_REG(`DEST(ZR_ILV_MAX_FULLNESS0+0x002), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0003))
    0x409a089d, //   5('h0000e): JUMP(9, `IFCNTLT(`R(ZR_ILV_PARAMS0+0x001,0)))  // WHILE_CNT_LT(`R(ZR_ILV_PARAMS0+0x001,0)))
    0x40c20000, //   6('h0000f): JUMP(12)
    0x4098089d, //   7('h00010): JUMP(9, `REPEAT(`R(ZR_ILV_PARAMS0+0x001,0)))
    0x40c20000, //   8('h00011): JUMP(12)
    0x8d400c08, //   9('h00012): MOV(`R(ZR_R8+0x000,1), `OUT(ILV0))
    0x30000cb0, //  10('h00013): WR_REG(`DEST(ZR_ILV_FULLNESS0+0x000), `ACCESS_MODE(WR_REG_16), `WR_MODE(WR_REG_OVER), `WR_MASK(16'h  0000))
    0x40720000, //  11('h00014): JUMP(7)  // END_WHILE
    0x80000810, //  12('h00015): MOV(`R(ZR_CODEWORD+0x000,0))
    0x6c10c014, //  13('h00016): SET_IO(`IN(ILV0), `OUT(RS_D))
    0xce300001, //  14('h00017): MOV(1, `OUT(FP3), `KEEP_MASK, `KEEP_CNT)
    0x8d000810, //  15('h00018): MOV(`R(ZR_CODEWORD+0x000,0), `OUT(RS_D))
    0x6c148000, //  16('h00019): SET_IO(`SLVIN, `OUT(ILV0))
    0x40c20000, //  17('h0001a): JUMP(12)  // END_FOREVER

    // Code block 3 memory
    // Move metrics from METRIC FIFO to the RS Decoder
    0x6e008000, //   0('h0001b): SET_IO(`SLVIN, `NULL_DST)
    0x80000001, //   1('h0001c): MOV(1)  // Move the first byte (which is for synchro) to NULL
    0x6c11c011, //   2('h0001d): SET_IO(`IN(RSDEC_MET), `OUT(RSDEC_MET))
    0x80000810, //   3('h0001e): MOV(`R(ZR_CODEWORD+0x000,0))  // Move N bytes from metric FIFO to RSD metric
    0x40020000, //   4('h0001f): JUMP(0)  // Restart

    // Code block 4 memory
    // Moves correct bytes from the reed solomon to the descrambler
    0x30000c40, //   0('h00020): WR_REG, <reg_mode>=3, <byte_addr>=0x40    LSW //Reset Scrambler ZR_SCR_OFFSET                (0x40)
    0x30000c42, //   1('h00021): WR_REG, <reg_mode>=3, <byte_addr>=0x42    MSW //Reset Scrambler ZR_SCR_OFFSET                (0x40)
    0x89000811, //   2('h00022): MOV(`R(ZR_CODEWORD+0x001,0), `IN(RS_D))  // Move K bytes from RSD to the scrambler
    0x40280818, //   3('h00023): Jump, <repeat>=1, <use_reg>=1, <reg_id>=0x18  // Repeat(Q), ZR_FRAMING stores Q
    0x40020000, //   4('h00024): JUMP(0)  // Restart

// Code block 5 memory
//START_FP5_L0:
    0x6c1dc00e, //   0('h00025):SET IO('IN(SCR_D), OUT(FIFO1))
    0x20000c1b, //   1('h00026):WR_REG('R(ZR_FRAMING+0x003), BAD_DTU = 0, Clear
    0x80000002, //   2('h00027):MOV 2 bytes (SID, TS) to FIFO1
    0x6e000000, //   3('h00028):SET_IO('OUT(NULL_DEST= 1))
    0x80000819, //   4('h00029):MOV ('R(ZR_FRAMING+0x001,1)) V bytes to null_dest
    0x8d80081a, //   5('h0002a):MOV (K-V-2) bytes to ILVIF <block_id>=24
//IS_CW_OK_L_6:
    0x40804000, //   6('h0002b):JUMP(CW_OK_L8, IF_FLAG != 0x4), i.e CW = OK;(SET_RST=0, FLAG_MASK=0x4)
    0x20001c1b, //   7('h0002c):WR_REG(`R(ZR_FRAMING+0x003),REG_MODE('11'),OVER_REG_WITH_MASK),MASK = 1; BAD_CW=1;

//CW_OK_L8:
    0x40a80818, //   8('h0002d):JUMP(TRANS_CW_L10, END_WHILE_CNT_LT(`R(ZR_FRAMING+0x000,0)))
    0x40c20000, //   9('h0002e):JUMP(TRANS_DONE_L12)
//TRANS_CW_L10:
    0x8d800811, //  10('h0002f):MOV('R(ZR_CODEWORD+0x001,1)) K bytes to ILVIF <block_id>=24
    0x40620000, //  11('h00030):JUMP(IS_CW_OK_L_6)

//TRANS_DONE_L12:
    0x6c1de81b, //  12('h00031):SET_IO('OUT(FIFO1), INPUT('R(ZR_FRAMING+0x003))) (R'(ZR_FRAMING+0x003))==> BAD_CW
    0x80000001, //  13('h00032):MOV 1 byte

    0x6000E055, //  14           SET_IO(Input Enabled, Input Master,Input Null SRC,  Input CONST(0x55); DTU size to be 32bit aligned, hence stuff the constant to inc WRAD
    0x8d800835, //  15           Move No of stuffing bytes available at (ZR_CRC1+0x0001, 1) to ILVBIF

    0x20034192, //  16           WR_REG(ZR_CRC1 + 0x0000 ==> ZR_UPROC5_STATE0 + 0x0002) Copy 8bit data from ZR_CRC1 + 0x0000 to ZR_UPROC5_STATE0 + 0x0002
//    0x415c080d, //  17           JUMP(FP5_INC_Qrx_WRITE_COUNT_L21 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(R(ZR_R12+0x001))), Added to increment the counter
    0x415c0003, //  17           JUMP(FP5_INC_Qrx_WRITE_COUNT_L21 , REPEAT, KEEP_CNT, END_WHILE_CNT_LT(0x3)), Added to increment the counter
    0x20000d92, //  18           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5
    0x30028058, //  19('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW_RETX_QUEUE_BASE_AD(0x28); LSW 1st DTU Address (0x28)
    0x3002a05a, //  20('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = LSW_RETX_QUEUE_BASE_AD(0x2a); MSW 1st DTU Address (0x2a)

//FP5_INC_Qrx_WRITE_COUNT_L21
    0x20192034, //  21           WR_REG(ZR_UPROC5_STATE0 + 0x0002 ==> ZR_CRC1 + 0x0000) Copy 8bit data from ZR_UPROC5_STATE0 + 0x0002 to ZR_CRC1 + 0x0001
    0x20000d92, //  22           WR_REG(Data_Mask0(0) ==> ZR_UPROC5_STATE0 + 0x0002) Clear repeat counter at FP5
    0x41880001, //  23           JUMP(FP5_CLR_KEEP_CNT_BIT_L24 , REPEAT(0x1),END_WHILE_CNT_LT(0x01))), Clear Keep count bit

//FP5_CLR_KEEP_CNT_BIT_L24
    0x6e00e834, //  24('h00034):SET_IO('OUT(NULL), INPUT('R(ZR_CRC1+0x0))) (R'(ZR_CRC1x0))==> Read Idx counter
    0x80000001, //  25('h00035):MOV 1 byte
    0x41d10101, //  26('h00036):JUMP(RX_Q_READ_IDX_1_FP5_L29 if IDX ==1, SET_RST=1, DATA_JUMP=1,MATCH_DATA=1)
    0x42010102, //  27('h00036):JUMP(RX_Q_READ_IDX_2_FP5_L32 if IDX ==2, SET_RST=1, DATA_JUMP=1,MATCH_DATA=2)
    0x40020000, //  28('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_1_FP5_L29:
    0x3001c058, //  29('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 2nd DTU Address (0x1c)
    0x3001e05a, //  30('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 2nd DTU Address (0x1e)
    0x40020000, //  31('h00038):JUMP(START_FP5_L0)

//RX_Q_READ_IDX_2_FP5_L32
    0x30060058, //  32('h0004b): WR_REG: LSW ZR_ILV_WRAD(0x58) = LSW 3rd DTU Address (0x60)
    0x3006205a, //  33('h0004c): WR_REG: LSW ZR_ILV_WRAD(0x5a) = MSW 3rd DTU Address (0x62)
    0x40020000, //  34('h00038):JUMP(START_FP5_L0)

// Code block 6 memory
//START_FP6_L0:
#ifdef FIFO3_FOR_RETX
    0x6c1fc018, //   0('h0003f): SET_IO: input=24 ILBIF master, output=22 FIFO3 master
//TX_DTU_PLOAD_L1:
    0x8f622c0e, //   1('h00040): MOV: (QH - V - 2) bytes, <use_reg>=1, <reg_id>=0x1B, <flag_mode>=2, <flag_mask>=2, out TC-LAYER
#else
    0x6c16c018, //   0('h0003f): SET_IO: input=24 ILBIF master, output=22 TC-LAYER master
//TX_DTU_PLOAD_L1:
    0x80022c0e, //   1('h00040): MOV: (QH - V - 2) bytes, <use_reg>=1, <reg_id>=0x1B, <flag_mode>=2, <flag_mask>=2
            //          set FLAG_MASK = 2 with FLAG_MODE=2(AND) to choose the Bearer Channel 0;
            //          Do FLAG_MODE=1(OR) to send data on Bearer channel 1.
#endif
    0x4018080C, //   2('h00041): JUMP(TX_DTU_PLOAD_L1: <repeat>=1, <use_reg>=1, <reg_id>=0xC (XDTUS), line 1
    0x00004000, //   3('h00042) : WAIT for frame next frame
    0x40020000, //   4('h00043): JUMP(START_FP6_L0)  // Restart


    // Code block 7 memory
   //(1) Poll the Register ZR_R12[7:0](0xc) to know the No of DTU's that read out from the
   //Rx Queue
   //(2)Set the ILV Buffer Read flags (Block ID: 25) if the ZR_R12[7:0] is non zero
   //(3)wait for FP0 to write DTU's in the ReTx RxQueue
   //(4)Forward data to TC layer after the write is completed
//START_FP7_L0:
    0x6e00e80c, //   0('h00044): SET_IO: input=0xC (XDTUs), output null,
    0x80000001, //   1('h00045): MOV 1 byte
    0x40610100, //   2('h00046): JUMP(DTU_TX_DONE_L6: line 6, match_data = 0, data_jump= 1
    0x6c19e000, //   3('h00047): SET_IO, input null_src, output block_id=25 (ILVB read flags) master
               //          flag 3 (x000) contains ptr flag. Set in 0x76000044, // FLAG_DATA 0
//SEND_FLAG_L4
    0x90038c0e, //   4('h00048): MOV: (DTU_SIZE - V - 2) bytes, <use_reg>=1,
               //               reg_mode=1(16bit) <apply_mode>=1(Apply first byte only),
               //               <flag_mode>=3(overwrite flag with flag mask),<flag_mask>=0x8
    0x4048080C, //   5('h00049): JUMP(SEND_FLAG_L4: <repeat>=1, <use_reg>=1, <reg_id>=0xC (XDTUS), line 4
//DTU_TX_DONE_L6:
    0x6c00e000, //   6('h0004a):SET IO('OUT(FP0), OUT_MASTER, IN_ENABLED, IN_MASTER, IN_NULL)
    0x80000001, //   7('h0004b):MOV (1 BYTE); Purpose: SEND 1 BYTE TO FP0 TO INDICATE FP0 CAN WRITE DATA DILVBIF
    0x00004000, //   8('h0004c): WAIT_EVENT(WAIT_STOP)  // wait for a stop
    0x40020000, //   9('h0004d): JUMP(START_FP7_L0)  // Restart

    // Program will require these registers:
    //   ZR_CODEWORD+0x000 [7:0] - ?? (MOV byte count)
    //   ZR_CODEWORD+0x001 [7:0] - Kp = N - R
    //   ZR_FRAMING+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_FRAMING+0x002 [7:0] - ?? (JUMP repeat count)
    //   ZR_ILV_PARAMS0+0x001 [7:0] - ?? (MOV byte count)
    //   ZR_PMS_SIZE+0x002 [31:16] - ?? (MOV byte count)
    //   ZR_R4+0x000 [7:0] - ?? (MOV byte count)
    //   ZR_R8+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_VBC_SIZE+0x000 [15:0] - ?? (MOV byte count)
    //   ZR_VBC_SIZE+0x002 [15:0] - ?? (MOV byte count)
    // Code block 5 will modify these registers:
    //   ZR_CRC0   - Contains base address of 1st DTU
    //   ZR_OHRATE - Contains base address of 2nd DTU
    //   ZR_ILVB_WRPTR - Contains base address of 3rd DTU
    //   ZR_CRC1 + 0[7:0]  - used to keep track of which DTU is being processed out of 3 DTU's
    //   ZR_FRAMING+0x003[31:24] - used to mark the bad dtu status
    //   ZR_ILV_WRAD[31:0]  - Updated with address available in ZR_CRC0/ZR_OHRATE/ZR_ILVB_WRPTR
    // Code block 2 will modify these registers:
    //   ZR_ILV_FULLNESS0+0x000 [15:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x000 [7:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x001 [7:0] -
    //   ZR_ILV_MAX_FULLNESS0+0x002 [15:0] - Set MAX_FULLNESS to 0x3FFFF
    //   ZR_ILV_MIN_FULLNESS0+0x000 [15:0] -
    //   ZR_ILV_MIN_FULLNESS0+0x002 [15:0] - Set MIN_FULLNESS to 0
    //   Code block 7 will modify these registers:
    //   ZR_R0+0x000 [7:0] - SEQP Done
    0
    };
DATA_MAP_END
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
//XDSLRTFW-1223 Qrx Full Fix (End)
