/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ALP_ResetARCellCnt.c
 *
 *   Alphaeus interface functions.
 *
 *
 *----------------------------------------------------------------------------
 */

// alp_ResetARCellCnt.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping


// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 05/02/2014 Prashant: Incorporated fix suggested by Mahesh for Incorrect ATM counters on API-level,
//                      when ReTx is enabled in DS in ADSL. (nUserTotalCells is always 0)
//                      Grep for XDSLRTFW-1556
// ******************************************************************


#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "tx_plam.h"
#include "rx_plam.h"
#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
#include "cmv.h"

#ifdef PPE_ENGINE
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void CompWrapAroundCounterDiff(uint32 *pul_pre_data, uint32 *pul_curr_data)
*
*  Compute the difference between two wrap around counters and copy
*   the current counter to the previous count
*  ul_diff = (MAX_32BITS_COUNTER + (ul_curr_data - ul_pre_data)) mod MAX_32BITS_COUNTER
*
*  Input Arguments:
*     *pul_pre_data -- the previous count value
*     *pul_curr_data -- the current count value
*
*  Output Arguments:
*
*  Returns:
*     the difference between two counters
*
*-------------------------------------------------------------------------------
*/

#define MAX_32BITS_COUNTER (0xFFFFFFFF)

C_SCOPE uint32 CompWrapAroundCounterDiff(uint32 *pul_pre_data, uint32 *pul_curr_data)
{
   int32 ul_diff;
   uint32 ul_pre_data, ul_curr_data;

   ul_pre_data = *pul_pre_data;
   ul_curr_data = *pul_curr_data;

   if(ul_curr_data >= ul_pre_data)
      ul_diff = ul_curr_data - ul_pre_data;
   else
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (START)
   {
      //Taking care of wrap around by computing ul_data-ul_pre_data + 0xFFFFFFFF
      //ul_diff = MAX_32BITS_COUNTER - ul_pre_data + ul_curr_data;
      ul_diff = ul_curr_data + (MAX_32BITS_COUNTER - ul_pre_data + 1);
   }
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (END)

   *pul_pre_data = ul_curr_data;

   return(ul_diff);
}
#endif
/***************************************************************************************
;  Subroutine Name: ResetARCellCnt
;
;  Description:
;     This function resets all the alphaeus receive cell counters
;
;  Prototype:
;     void ResetARCellCnt(int16 s_bc)
;
;  Input Arguments:
;     s_bc: bearer channel index
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/

C_SCOPE void ResetARCellCnt(int16 s_bc)
{
#ifdef ENABLE_ALPHAEUS
   uint32 ul_addr;
   if (s_bc == 0)
      ul_addr = ALP_R_CELL_CNT_BC0_ADDR;
   else
      ul_addr = ALP_R_CELL_CNT_BC1_ADDR;

   // there are no gaps between these registers
   // ALP_R_CELL_CNT_BC0_ADDR
   // ALP_R_IDLE_CNT_BC0_ADDR
   // ALP_R_AIDLE_CNT_BC0_ADDR
   // ALP_R_BE_CNT_BC0_ADDR
   // ALP_R_HEC_CNT_BC0_ADDR
   // ALP_R_CD_CNT_BC0_ADDR
   FillCoreBuf32(ul_addr, 0, ATM_RX_NUM_COUNTERS);
#endif //ENABLE_ALPHAEAUS

}



/*****************************************************************************
;  Subroutine Name: Get_ATM_Counters(int16 s_bc)
;
;  This function reads the ATM Status register to log the counter value
;
;  Prototype:
;     void Get_ATM_Counters(int16 s_bc)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE void Get_ATM_Counters(int16 s_bc)
{
   uint8 uc_offset;
   uint32 ul_total_user_cell_cnt;
   uint32 ul_addr, ul_data[ATM_RX_NUM_COUNTERS];

#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0)
      ul_addr = ALP_R_CELL_CNT_BC0_ADDR;
   else
      ul_addr = ALP_R_CELL_CNT_BC1_ADDR;

   ReadCoreBuf32(ul_addr, (int16*)&ul_data, ATM_RX_NUM_COUNTERS);
#endif //ENABLE_ALPHAEUS

#ifdef PPE_ENGINE
   //Compute the register address offset
   uc_offset = (uint8)(s_bc<<2);

   //Compute the number of cells with HEC error -------------
   ul_addr = DREG_AR_HEC_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_HEC_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_HEC_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_HEC_CNT_Shadow[s_bc], &ul_data[ATM_RX_HEC_CNT]);

   //Compute the number of cells with bit error ------------
   ul_addr = DREG_AR_BE_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_BE_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_BE_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_BE_CNT_Shadow[s_bc], &ul_data[ATM_RX_BE_CNT]);

   //Compute the number of idle cells ---------------------
   ul_addr = DREG_AR_IDLE_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_IDLE_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_IDLE_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_IDLE_CNT_Shadow[s_bc], &ul_data[ATM_RX_IDLE_CNT]);

   //Compute the number of user cells -------------------
   ul_addr = DREG_AR_CELL0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_CELL_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_CELL_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CELL_Shadow[s_bc], &ul_data[ATM_RX_CELL_CNT]);

   //Compute the number of dropped cells --------------------
   ul_addr = DREG_AR_CD_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_CD_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_CD_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CD_CNT_Shadow[s_bc], &ul_data[ATM_RX_CD_CNT]);

   //Compute the passed idle ATM cells -------------------
   ul_addr = DREG_AR_AIIDLE_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data[ATM_RX_AIDLE_CNT]);
   //Compute the counter difference between the previous read and current read
   ul_data[ATM_RX_AIDLE_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_AIIDLE_CNT_Shadow[s_bc], &ul_data[ATM_RX_AIDLE_CNT]);

#endif //PPE_ENGINE
   // Update the global counters
   gula_hec_error_cnt[s_bc] += ul_data[ATM_RX_HEC_CNT];

   gula_bit_error_cnt[s_bc] += ul_data[ATM_RX_BE_CNT];




   gula_idle_cell_cnt[s_bc]+= ul_data[ATM_RX_IDLE_CNT];

   gula_non_idle_cell_cnt[s_bc]+= ul_data[ATM_RX_CELL_CNT];

   gula_dropped_cell_cnt[s_bc] += ul_data[ATM_RX_CD_CNT];

   // User_total_cell_count is the sum of User Idle and User Non-idle cell counts.
   // XDSLRTFW-1556(Start)
   // ul_total_user_cell_cnt = ul_data[ATM_RX_AIDLE_CNT] + ul_data[ATM_RX_CELL_CNT];
      ul_total_user_cell_cnt = ul_data[ATM_RX_IDLE_CNT] + ul_data[ATM_RX_CELL_CNT];
   // XDSLRTFW-1556(End)
   gula_tot_cell_cnt[s_bc] += ul_total_user_cell_cnt;

   // delineated_total_cell_count is sum of User Total Cell count and Dropped Cell count.
   gula_tot_hec_cnt[s_bc] += ul_total_user_cell_cnt + ul_data[ATM_RX_CD_CNT];

   // Counts the number of cells dropped due to: the Rx cell buffer being full,
   gula_dropped_cell_fullbuffer_cnt[s_bc] = gula_dropped_cell_cnt[s_bc] - gula_hec_error_cnt[s_bc] - gula_idle_cell_cnt[s_bc];
}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
/*****************************************************************************
;  Subroutine Name: Get_Rx_PTM_Counters(int16 s_bc,uint32 *pula_CntBuf)
;
;  This function reads the PTM Status register to log the counter value
;
;  Prototype:
;     void Get_Rx_PTM_Counters(int16 s_bc,uint32 *pula_CntBuf)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
//uint32 *gul_dummyRead = (uint32 *);;
//unsigned long int * gul_dummyRead = (unsigned long int *)0x20D598;
//uint32 *gul_dummyRead;
// *p = (int *)0x28ff44;

C_SCOPE void Get_Rx_PTM_Counters(int16 s_bc, uint32 *pula_CntBuf)
{

   //Sriram : vdsl code ptm_ppe_cntr_register
   uint8 uc_offset;
   uint32 ul_addr, ul_data;
   //uint32 addr = 0x20D598;
   //*gul_dummyRead = &addr;
   int mydata = 10;
   uint32 *mypointer = (uint32 *)0x20D598;
#ifdef PPE_ENGINE
   //Compute the register address offset
   uc_offset = (uint8)(s_bc<<2);

   // Check PPE RX Status Register ----------------------------
   ul_addr = DREG_AR_STAT0_ADDR + uc_offset;
   ReadPpeReg(ul_addr, &ul_data);

   pula_CntBuf[RX_PTM_STAT] = ul_data;

#if 0
   // Sriram : For testing the TC-SYNC status
   if (gft_enable_PpeExtraRead == 0x1)
   {
      ReadPpeReg(0x20D598, &mydata);
      //0x20D400 + 0x198 = 0x20D598
   }
#endif
   mydata = 0;
   //Clear the status register
   //WritePpeReg(ul_addr, 0);
   WritePpeReg(0x20D598, 0);
#if 0
   // Sriram : For testing the TC-SYNC status
   if (gft_enable_PpeExtraRead  == 0x2)
      ReadPpeReg(0x20D598, &mydata);
      //mypointer = &ul_data;

#endif

   //Compute the number of non-idle cells -----------------------
   ul_addr = DREG_AR_CELL0_ADDR + uc_offset;
   ReadPpeReg(ul_addr, &ul_data);

   //Compute the counter difference between the previous read and current read
   pula_CntBuf[RX_CW_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CELL_Shadow[s_bc], &ul_data);

   //Compute the number of CRC errors for normal flow -----------------------
   ul_addr = DREG_AR_CERRN_CNT0_ADDR + uc_offset;
   ReadPpeReg(ul_addr, &ul_data);

   //Clear this count if it satures
   if(ul_data == MAX_32BITS_COUNTER)
   {
      WritePpeReg(ul_addr, 0);
      gula_DREG_AR_CERRN_CNT_Shadow[s_bc] = 0;
      pula_CntBuf[RX_CERRN_CNT] = 0;
   }
   else
   {
      //Compute the counter difference between the previous read and current read
      pula_CntBuf[RX_CERRN_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CERRN_CNT_Shadow[s_bc], &ul_data);
   }


   //Compute the number of CRC errors for preemption flow -----------------------
   ul_addr = DREG_AR_CERRNP_CNT0_ADDR + uc_offset;
   ReadPpeReg(ul_addr, &ul_data);

   //Clear this count if it satures
   if(ul_data == MAX_32BITS_COUNTER)
   {
      WritePpeReg(ul_addr, 0);
      gula_DREG_AR_CERRNP_CNT_Shadow[s_bc] = 0;
      pula_CntBuf[RX_CERRNP_CNT] = 0;
   }
   else
   {
      //Compute the counter difference between the previous read and current read
      pula_CntBuf[RX_CERRNP_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CERRNP_CNT_Shadow[s_bc], &ul_data);
   }

   //Compute the number of code violations for normal flow -----------------------
   ul_addr = DREG_AR_CVN_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data);

   //Clear this count if it satures
   if(ul_data == MAX_32BITS_COUNTER)
   {
      WritePpeReg(ul_addr, 0);
      gula_DREG_AR_CVN_CNT_Shadow[s_bc] = 0;
      pula_CntBuf[RX_CVN_CNT] = 0;
   }
   else
   {
      //Compute the counter difference between the previous read and current read
      pula_CntBuf[RX_CVN_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CVN_CNT_Shadow[s_bc], &ul_data);
   }

   //Compute the number of code violations for preemption flow -----------------------
   ul_addr = DREG_AR_CVNP_CNT0_ADDR + uc_offset;
   ReadPpeReg(ul_addr, &ul_data);

   //Clear this count if it satures
   if(ul_data == MAX_32BITS_COUNTER)
   {
      WritePpeReg(ul_addr, 0);
      gula_DREG_AR_CVNP_CNT_Shadow[s_bc] = 0;
      pula_CntBuf[RX_CVNP_CNT] = 0;
   }
   else
   {
      //Compute the counter difference between the previous read and current read
      pula_CntBuf[RX_CVNP_CNT] = CompWrapAroundCounterDiff(&gula_DREG_AR_CVNP_CNT_Shadow[s_bc], &ul_data);
   }

//Sriram : Vdsl code ptm_ppe_cnts_register
#endif   // PPE_ENGINE
}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)

/*****************************************************************************
;  Subroutine Name: Get_ATM_Status(int16 s_bc)
;
;  This function reads the ATM Status register to check for loss of
;  cell delineation
;
;  Prototype:
;     void Get_ATM_Status(int16 s_bc)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE uint16 Get_ATM_Status(int16 s_bc)
{
   uint32 ul_addr, ul_data;

#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0)
      ul_addr = ALP_R_ATM_STAT_BC0_ADDR;
   else
      ul_addr = ALP_R_ATM_STAT_BC1_ADDR;

   /* Read the AR_ATM_STAT register */
   ReadCoreReg(ul_addr, &ul_data);

   /* Set ATM_SYNC (bit 1) and reset ATM_ERR (bit 0) */
   WriteCoreReg(ul_addr, (uint32)0x2);
#endif //ENABLE_ALPHAEUS
#ifdef PPE_ENGINE
   if (s_bc == 0)
      ul_addr = DREG_AR_STAT0_ADDR;
   else
      ul_addr = DREG_AR_STAT1_ADDR;

   /* Read the AR_ATM_STAT register */
   ReadCoreReg(ul_addr, &ul_data);

   //Clear the status register
   //WriteCoreReg(ul_addr, 0); //OLD Implementation
   //XDSLRTFW-2050
   //Latest Spec for ATM PPE
   //Status Bit 1 = 0 No TC Sync
   //Status Bit 1 = 1 TC Sync
   //Reset value to be 2 with BIT 1 = 1
   WriteCoreReg(ul_addr, 0x2);
#endif
   return (uint16)ul_data;
}
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(start)
#if 1
/*****************************************************************************
;  Subroutine Name: Get_PTM_Status(int16 s_bc)
;
;  This function reads the PTM Status register to check for loss of
;  cell delineation
;
;  Prototype:
;     void Get_PTM_Status(int16 s_bc)
;
;  Input Arguments:
;
;  Output Arguments:
;
;  Global Variable used by this file:
;
;****************************************************************************/
C_SCOPE uint16 Get_PTM_Status(int16 s_bc)
{
   uint32 ul_addr, ul_data;

#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0)
      ul_addr = ALP_R_ATM_STAT_BC0_ADDR;
   else
      ul_addr = ALP_R_ATM_STAT_BC1_ADDR;

   /* Read the AR_PTM_STAT register */
   ReadCoreReg(ul_addr, &ul_data);

   /* Set ATM_SYNC (bit 1) and reset ATM_ERR (bit 0) */
   WriteCoreReg(ul_addr, (uint32)0x2);
#endif //ENABLE_ALPHAEUS
#ifdef PPE_ENGINE
   if (s_bc == 0)
      ul_addr = DREG_AR_STAT0_ADDR;
   else
      ul_addr = DREG_AR_STAT1_ADDR;

   /* Read the AR_ATM_STAT register */
   ReadPpeReg(ul_addr, &ul_data);

   //Clear the status register
   //WritePpeReg(ul_addr, 0);
   WritePpeReg(ul_addr, 0);
#endif
   return (uint16)ul_data;
}
#endif
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)

