/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   ALP_ResetATCellCnt.c
 *
 *   Alphaeus interface functions.
 *
 *
 *----------------------------------------------------------------------------
 */

// 27/03/2014 Prashant: Merged only the Counter WrapAround Fix from
//            XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (Author: ChihWen)
//
// ******************************************************************
#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE
/***************************************************************************************
;  Subroutine Name: ResetATCellCnt
;
;  Description:
;     This function resets all the alphaeus transmit cell counters
;
;  Prototype:
;     void ResetATCellCnt(int16 s_bc)
;
;  Input Arguments:
;     s_bc: bearer channel index
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/

C_SCOPE void ResetATCellCnt(int16 s_bc)
{
#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0) {
      WriteCoreReg((uint32)ALP_T_CELL_CNT_BC0_ADDR, 0);
      WriteCoreReg((uint32)ALP_T_IDLE_CNT_BC0_ADDR, 0);
   } else {
      WriteCoreReg((uint32)ALP_T_CELL_CNT_BC1_ADDR, 0);
      WriteCoreReg((uint32)ALP_T_IDLE_CNT_BC1_ADDR, 0);
   }
#endif //ENABLE_ALPHAEUS
#if 0 //def PPE_ENGINE
   if (s_bc == 0) {
      WriteCoreReg((uint32)DREG_AT_CELL0_ADDR, 0);
      WriteCoreReg((uint32)DREG_AT_IDLE_CNT0_ADDR, 0);
   } else {
      WriteCoreReg((uint32)DREG_AT_CELL1_ADDR, 0);
      WriteCoreReg((uint32)DREG_AT_IDLE_CNT1_ADDR, 0);
   }
#endif //PPE_ENGINE
}



/***************************************************************************************
;  Subroutine Name: GetTxNonIdleCellCnt
;
;  Description:
;     This function counts the number of non idle cells that are transmitted.
;
;  Prototype:
;     int16 GetTxNonIdleCellCnt(s_bc)
;
;  Input Arguments:
;     s_bc: bearer channel index
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
#define MAX_32BITS_COUNTER (0xFFFFFFFF)
C_SCOPE uint32 GetTxNonIdleCellCnt(int16 s_bc)
{
   uint32 ul_addr, ul_data,ul_diff;
   uint8 uc_offset;

#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0)
      ul_addr = ALP_T_CELL_CNT_BC0_ADDR;
   else
      ul_addr = ALP_T_CELL_CNT_BC1_ADDR;

   ReadCoreReg(ul_addr, &ul_data);
#endif

#ifdef PPE_ENGINE
   //Compute the register address offset
   uc_offset = (uint8)(s_bc<<2);

   //Compute the number of idle cells -----------------------
   ul_addr = DREG_AT_CELL0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data);
   //Compute the counter difference between the previous read and current read
   //ul_data = CompWrapAroundCounterDiff(&gula_DREG_AT_CELL_Shadow[s_bc], &ul_data);
   if(ul_data >= gula_DREG_AT_CELL_Shadow[s_bc])
      ul_diff = ul_data - gula_DREG_AT_CELL_Shadow[s_bc];
   else
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (START)
      //Taking care of wrap around by computing ul_data-ul_pre_data + 0xFFFFFFFF
      //ul_diff = MAX_32BITS_COUNTER - gula_DREG_AT_CELL_Shadow[s_bc] + ul_data;
      ul_diff = ul_data + (MAX_32BITS_COUNTER - gula_DREG_AT_CELL_Shadow[s_bc] + 1);
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (END)

   gula_DREG_AT_CELL_Shadow[s_bc] = ul_data;

#endif

   return (ul_diff);
}

/***************************************************************************************
;  Subroutine Name: GetTxIdleCellCnt
;
;  Description:
;     This function counts the number of idle cells that are transmitted.
;
;  Prototype:
;     int16 GetTxIdleCellCnt(s_bc)
;
;  Input Arguments:
;     s_bc: bearer channel index
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables:
;
;   Substates:
;
;**********************************************************************************************/
C_SCOPE uint32 GetTxIdleCellCnt(int16 s_bc)
{
   uint32 ul_addr, ul_data,ul_diff;
   uint8 uc_offset;

#ifdef ENABLE_ALPHAEUS
   if (s_bc == 0)
      ul_addr = ALP_T_IDLE_CNT_BC0_ADDR;
   else
      ul_addr = ALP_T_IDLE_CNT_BC1_ADDR;

   ReadCoreReg(ul_addr, &ul_data);

#endif
#ifdef PPE_ENGINE
   //Compute the register address offset
   uc_offset = (uint8)(s_bc<<2);
   //Compute the number of idle cells -----------------------
   ul_addr = DREG_AT_IDLE_CNT0_ADDR + uc_offset;
   ReadCoreReg(ul_addr, &ul_data);
   //Compute the counter difference between the previous read and current read
   //ul_data = CompWrapAroundCounterDiff(&gula_DREG_AT_IDLE_CNT_Shadow[s_bc], &ul_data);
   if(ul_data >= gula_DREG_AT_IDLE_CNT_Shadow[s_bc])
      ul_diff = ul_data - gula_DREG_AT_IDLE_CNT_Shadow[s_bc];
   else
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (START)
      //Taking care of wrap around by computing ul_data-ul_pre_data + 0xFFFFFFFF
      //ul_diff = MAX_32BITS_COUNTER - gula_DREG_AT_IDLE_CNT_Shadow[s_bc] + ul_data;
      ul_diff = ul_data + (MAX_32BITS_COUNTER - gula_DREG_AT_IDLE_CNT_Shadow[s_bc] + 1);
   //XDSLRTFW-1446 BugFix_AB_ALL_ALL_ALL_ATM_ReadPPEregistersTwice_BugFixWrapAround (END)

   gula_DREG_AT_IDLE_CNT_Shadow[s_bc] = ul_data;
#endif
   return (ul_diff);
}




