/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cri_ini.c
 *
 *   init Clock, Reset, Interrupt (CRI) block core interface function
 *
 *
 *----------------------------------------------------------------------------
 */
//*******************************************************************
// cri_ini.c
//
// History
//
// 25/03/2013 Kannan:
//          1. Initialize the Uninitialized CRI registers with their reset
//             values.
//             Grep for "XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues "
//*****************************************************************************

#include "common.h"
#include "cri_cocomo_interface.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "gdata.h"
#include "cri_iof.h"
#ifdef TARGET_HW
    #include "dsp_regs_62.h"
#endif

extern uint8 guc_PortMode;
extern PortModeControl_t gt_PortModeControl;
void SoftResetCores(void);
extern FlagT gft_EnableQtStall;



void InitCRI(void)
{

   uint32 ul_data;
   /* =============================================== */
   /* Enable clocks                          */
   /* =============================================== */

#if 0   // this part of initialization was moved to HwResetInit()
   //Enable all core clocks
   WriteCoreReg(CRI_CCR_ADDR, 0x0);

   //Skip CRI_RST

   //Set the port mode (for now to 1 port)
   #define CRI_PORT_MODE_1PORT   (0x0)
   #define CRI_PORT_MODE_2PORT (0x1555)

   if(guc_PortMode == 0)
      WriteCoreReg(CRI_PORT_MODE_ADDR, CRI_PORT_MODE_1PORT);
   else //if(guc_PortMode == 1)
      WriteCoreReg(CRI_PORT_MODE_ADDR, CRI_PORT_MODE_2PORT);

   //Set the time slot control
   //TSC will be enabled at LinkStart
   WriteCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_NUM_TS_4K | ((CRI_TSC_CTRL_NUM_CLKS-1)<<5) |
                           (CRI_TSC_CTRL_CLKS_LAST<<22) | (CRI_TSC_CTRL_DISABLE<<31)));

   //Reset the TSC status counters
   WriteCoreReg(CRI_TSC_STATUS_ADDR, 0x0);
#endif

   //Configure the transmit timeslot settings for current port (0 or 1),
   //as set by the DSP's port-select setting
   if(guc_ch_id == 0)
   {

#define TX_QTP_TS_PORT0_4K (0)
#define TX_PMS_TS_PORT0_4K (0)
#define TX_QT_TS_PORT0_4K  (1)
#define TX_IFFT_TS_PORT0_4K   (0x1F)   //inactive
#define TX_PAR_TS_PORT0_4K (0x1F)   //inactive
#define TX_DSP_TS_PORT0_4K (3)
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

      ul_data = (TX_QTP_TS_PORT0_4K |(TX_PMS_TS_PORT0_4K<<5)|
                     (TX_QT_TS_PORT0_4K<<10)|(TX_IFFT_TS_PORT0_4K<<15)|
                     (TX_PAR_TS_PORT0_4K<<20)|(TX_DSP_TS_PORT0_4K<<25));
      WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, ul_data);
#if 0
      WriteCoreReg(CRI_TX_TSLOT0_ADDR, ul_data);
#endif
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   }
   else if(guc_ch_id == 1)
   {

#define TX_QTP_TS_PORT1_4K (2)
#define TX_PMS_TS_PORT1_4K (2)
#define TX_QT_TS_PORT1_4K  (3)
#define TX_IFFT_TS_PORT1_4K   (0x1F)   //inactive
#define TX_PAR_TS_PORT1_4K (0x1F)   //inactive
#define TX_DSP_TS_PORT1_4K (1)
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
      ul_data = (TX_QTP_TS_PORT1_4K    |(TX_PMS_TS_PORT1_4K<<5)|
                  (TX_QT_TS_PORT1_4K<<10)|(TX_IFFT_TS_PORT1_4K<<15)|
                  (TX_PAR_TS_PORT1_4K<<20)|(TX_DSP_TS_PORT1_4K<<25));
      WriteCoreReg(CRI_TX_TSLOTC_A_ADDR, ul_data);
#if 0
      WriteCoreReg(CRI_TX_TSLOT0_ADDR, ul_data);
#endif
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   }
#if 0
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //CRI_TX_TSLOTC_B (it is for port 2 or 3)
   //CRI_TX_TSLOTx, 0, 1, 2, 3
   ul_data = 0x3fffffff;
   WriteCoreReg(CRI_TX_TSLOTC_B_ADDR, ul_data);
   WriteCoreReg(CRI_TX_TSLOT1_ADDR, ul_data);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
#endif

   //Configure the receive timeslot settings for Port 0 or 1
   if(guc_ch_id == 0)
   {

#define RX_QTP_TS_PORT0_4K (1)
#define RX_FFT_TS_PORT0_4K (0x1F)   //inactive
#define RX_QT_TS_PORT0_4K  (2)
#define RX_PMS_TS_PORT0_4K (0)
#define RX_DSP_TS_PORT0_4K (3)
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

      ul_data = ((RX_QTP_TS_PORT0_4K<<0)|(RX_FFT_TS_PORT0_4K<<5)|
                  (RX_QT_TS_PORT0_4K<<10)|(RX_PMS_TS_PORT0_4K<<15)|(RX_DSP_TS_PORT0_4K<<25));
      WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ul_data);
#if 0
      WriteCoreReg(CRI_RX_TSLOT0_ADDR, ul_data);
#endif
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   }
   else if(guc_ch_id == 1)
   {

#define RX_QTP_TS_PORT1_4K (3)
#define RX_FFT_TS_PORT1_4K (0x1F)   //inactive
#define RX_QT_TS_PORT1_4K  (0)
#define RX_PMS_TS_PORT1_4K (2)
#define RX_DSP_TS_PORT1_4K (1)
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
      ul_data = ((RX_QTP_TS_PORT1_4K<<0)|(RX_FFT_TS_PORT1_4K<<5)|
                  (RX_QT_TS_PORT1_4K<<10)|(RX_PMS_TS_PORT1_4K<<15)|(RX_DSP_TS_PORT1_4K<<25));
      WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, ul_data);
#if 0
      WriteCoreReg(CRI_RX_TSLOT0_ADDR, ul_data);
#endif
      //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
   }
    //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
#if 0
   //CRI_RX_TSLOTC_B
   //CRI_RX_TSLOTx, x = 0, 1, 2, 3
   ul_data = 0x3e0fffff;
   WriteCoreReg(CRI_RX_TSLOTC_B_ADDR, ul_data);
   WriteCoreReg(CRI_RX_TSLOT1_ADDR, ul_data);

   //Given below registers indicate the active time slots for
   //Tx & Rx
   //skip CRI_TX_ATSLOTC_x, x = A, B
   //skip CRI_TX_ATSLOTx, x= 0, 1, 2, 3
   //skip CRI_RX_ATSLOTC_x, x = A, B
   //skip CRI_RX_ATSLOTx, x= 0, 1, 2, 3

   //Init with default values
   WriteCoreReg(CRI_RXGP0_CTL_ADDR,0x0);
   WriteCoreReg(CRI_RXGP1_CTL_ADDR,0x0);
   WriteCoreReg(CRI_TXGP0_CTL_ADDR,0x0);
   WriteCoreReg(CRI_TXGP1_CTL_ADDR,0x0);
   WriteCoreReg(CRI_RXGP0_VAL_ADDR,0x0);
   WriteCoreReg(CRI_RXGP1_VAL_ADDR,0x0);
   WriteCoreReg(CRI_TXGP0_MCNT_ADDR,0x0);
   WriteCoreReg(CRI_TXGP1_MCNT_ADDR,0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
#endif

#if 0   // this part of initialization was moved to SoftResetCores()
   //Enable DSP interrupt to TSC interrupt
   //TSC_RX_INT = 1, all the others are 0's
   WriteCoreReg(CRI_MASK0_RX_ADDR, CRI_MASK_RX_TSC_INT);
#endif
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
#if 0
   //Init with default values
   WriteCoreReg(CRI_MASK0_TX_ADDR,0x0);
   WriteCoreReg(CRI_MASK1_TX_ADDR,0x0);
   WriteCoreReg(CRI_MASK1_RX_ADDR,0x0);
   WriteCoreReg(CRI_STATUS0_ADDR,0x0);
   WriteCoreReg(CRI_STATUS1_ADDR,0x0);
#endif
   //Given below registers are Read only registers.
   //skip CRI_AMASK0_TX
   //skip CRI_AMASK1_TX
   //skip CRI_AMASK1_RX
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)

#if 0   // this part of initialization was moved to SoftResetCores()
   //Configure the update control register
#define DIS_RXTSC_UPD   (0) // (do not disable TSC start assertion)
#define FRC_RXTSC_UPD   (1) // (constantly update)
#define DIS_TXTSC_UPD   (0) // (do not disable TSC start assertion)
#define FRC_TXTSC_UPD   (1) // (constantly update)
#define MASK1_TX_UPD    (3)   // (continuous update)
#define MASK0_TX_UPD (3)   // (continuous update)
#define MASK1_RX_UPD    (3)   // (continuous update)
#define MASK0_RX_UPD (3)   // (continuous update)

   WriteCoreReg(CRI_UPDCTL_ADDR, (DIS_RXTSC_UPD<<15)|(FRC_RXTSC_UPD<<14)|(DIS_TXTSC_UPD<<13)|(FRC_TXTSC_UPD<<12)|
                        (MASK1_TX_UPD<<7)|(MASK0_TX_UPD<<5)|(MASK1_RX_UPD<<3)|(MASK0_RX_UPD<<1));
#endif //#if 0
#if 0
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)

   //CRI_EVENT
   WriteCoreReg(CRI_EVENT_ADDR, (uint32)0xFFFFFFFF);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
#endif
   //Clear TX timer
   WriteCoreReg(CRI_TX_TIMER_ADDR, 0);

   //Enable TX timer counter and set roll over on TX buffer swap
#define TX_TIM_RLVR     (0)   //set roll over on TX buffer swap
#define TX_TIM_ENB      (1) //Enable TX timer counter

   WriteCoreReg(CRI_TX_TIMER_CTL_ADDR, (TX_TIM_RLVR<<21)|(TX_TIM_ENB<<20)|(1<<28));

   //Clear RX timer
   WriteCoreReg(CRI_RX_TIMER_ADDR, 0);

   // Enable RX timer counter and set roll over on RX buffer swap
#define RX_TIM_RLVR     (0)   //set roll over on TX buffer swap
#define RX_TIM_ENB      (1) //Enable TX timer counter

   WriteCoreReg(CRI_RX_TIMER_CTL_ADDR, (RX_TIM_RLVR<<21)|(RX_TIM_ENB<<20)|(1<<28));

   //Configure TX PMS
   //Disable TX PMS for now, it should be configured to tx time-slot start later
   //TX_PMS_REG_START = 0
   //TX_PMS_START_SEL = 0
   //TX_PMS_GO_CNT = 0
   WriteCoreReg(CRI_TX_PMS_CTL_ADDR, 0x0);

   //Disable all the cores and they will be enabled at LinkStart by function EnableCores_ForLinkStart()
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0);

   //Configure RX PMS
   //Disable RX PMS for now, it should be configured to rx time-slot start later
   //RX_PMS_REG_START = 0
   //RX_PMS_START_SEL = 0
   //RX_PMS_GO_CNT = 0
   WriteCoreReg(CRI_RX_PMS_CTL_ADDR, 0x0);

   //Configure TX_QT_STALL register (but do not enable it yet)

   //First reset this register to the power-on state
   WriteCoreReg(CRI_TX_QT_STALL_ADDR, 0xE0000);

#define TX_QT_STALL_DIS    (0)   //disable
#define TX_QT_START_DROP   (1) //write 1 to clear this bit

   WriteCoreReg(CRI_TX_QT_STALL_ADDR, ((CRI_TX_QT_STALL_CLKS_4K)|(TX_QT_STALL_DIS<<16)|(TX_QT_START_DROP<<17)));

   //Configure RX_QT_STALL register (but do not enable it yet)

   //First reset this register to the power-on state
   WriteCoreReg(CRI_RX_QT_STALL_ADDR, 0xE0000);

#define RX_QT_STALL_DIS    (0)   //disable
#define RX_QT_START_DROP   (1) //write 1 to clear this bit

   WriteCoreReg(CRI_RX_QT_STALL_ADDR, ((CRI_RX_QT_STALL_CLKS_4K)|(RX_QT_STALL_DIS<<16)|(RX_QT_START_DROP<<17)));

   //Default is to enable QT stall (in InitCRI_ForLinkStart())
   gft_EnableQtStall = TRUE;

   //Configure RX_FFT_STALL_CTL register
#if 1
   //Configure RX_FFT_STALL_CTL register such that
   //FFT done is generated by the actual done
   //RX_FFT_DONE_SEL = 3 (actual done)
   WriteCoreReg(CRI_RX_FFT_STALL_CTL_ADDR, (3<<20));
#else

#define RX_FFT_REG_DONE    (0)   //(no action)
#define RX_FFT_DONE_SEL    (2) //(timer based)

   WriteCoreReg(CRI_RX_FFT_STALL_CTL_ADDR, (CRI_FFT_STALL_CTL_FFT_DONE_CLKS|(RX_FFT_DONE_SEL<<20)|(RX_FFT_REG_DONE<<23)));
#endif

   //Mei fixme: disable NTR regeneration logic (not supporte yet)
   WriteCoreReg(CRI_NTR_CPE_CTRL_ADDR, 0);
#if 0
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (START)
   //Init with default values
   WriteCoreReg(CRI_NTR_SRCFR_ADDR,0x137a7);
   WriteCoreReg(CRI_NTR_PHASE_ADDR,0x0);
   WriteCoreReg(CRI_NTR_CO_CTRL_ADDR,0x0);
   WriteCoreReg(CRI_NTR_CO_PERP_NUM_ADDR,0x0);
   WriteCoreReg(CRI_NTR_CO_PERP_DENOM_ADDR,0x0);
   WriteCoreReg(CRI_FCIMASK2_TX_ADDR,0x0);
   WriteCoreReg(CRI_FCIMASK2_RX_ADDR,0x0);
   WriteCoreReg(CRI_FCIMASK3_TX_ADDR,0x0);
   WriteCoreReg(CRI_FCIMASK3_RX_ADDR,0x0);
   WriteCoreReg(CRI_FCISTATUS2_ADDR,0x0);
   WriteCoreReg(CRI_FCISTATUS3_ADDR,0x0);
   //XDSLRTFW-558: VR9_VRX318_DFE_InitWithResetValues (END)
#endif
} //void InitCRI(void)


extern int32 gl_CurrentStackPointer;
extern int32 gl_MaxBgDuration;
extern uint8 guc_KernelState;                  // first interrupts or not

void HwResetInit(int32 l_Port, int32 l_StackPointer)
{

    guc_ch_id = (uint8)l_Port;
    gl_CurrentStackPointer = l_StackPointer;
    guc_PortMode = gt_PortModeControl.uc_DualPortModeCurrent;
    gt_PortModeControl.uc_MaxBgDuration = MAX_BG_DURATION;
    gt_PortModeControl.uc_BgDuration = MAX_BG_DURATION;
    guc_KernelState = 0;


#ifdef TARGET_HW
    if (l_Port == 0)
    {
        guc_adma_reg_offset = 0;
        guc_xdma_reg_offset = 0;
    }
    else
    {
        guc_adma_reg_offset =  DSP_ADMA1_CTRL - DSP_ADMA0_CTRL;
        guc_xdma_reg_offset = DSP_XDMA1_CTRL - DSP_XDMA0_CTRL;
    }
#endif

    SoftResetCores();

}

#ifndef TARGET_HW
// this function immitate the HW_RESET event on the
// real board.
void hw_reset_isr(void)
{
    uint32 ul_Val = 0xFFFFFFFF;

    // set guc_ch_id here so that BM behaves correctly
    guc_ch_id = 0;              // reset default



    WriteCoreReg(CRI_RST_ADDR, ul_Val);
    WriteCoreReg(CRI_RST_ADDR, 0);
    WriteCoreReg(CRI_CCR_ADDR, 0x0);

    // set guc_ch_id here so that BM behaves correctly
    if (gt_PortModeControl.uc_DualPortModeCurrent == SINGLE_PORT_MODE)
    {
        WriteCoreReg(CRI_PORT_MODE_ADDR, 0);
        //WriteCoreReg(DSP_INT_MASK, DSP_INT_MASK_XDSL1_PORT0_MASK);
    }
    else
    {
        WriteCoreReg(CRI_PORT_MODE_ADDR, ul_Val);   // set core to dual port mode
        //WriteCoreReg(DSP_INT_MASK, DSP_INT_MASK_XDSL1_2PORT_MASK);
        guc_ch_id = 1;              // reset default
        HwResetInit(1, 0);
    }

    guc_ch_id = 0;              // reset default
    HwResetInit(0, 0);

    // enable TSC
    SetCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_ENABLE<<31));

}
#endif

