/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   cri_iof.c
 *
 *   Clock, Reset, Interrupt (CRI) block core interface functions
 *
 *
 *----------------------------------------------------------------------------
 */
//*-------------------------------------------------------------------------------//
// cri_iof.c
//
// History
//
// 21/11/2012 Kannan:
//          1. Added functions to notify PPE that both TX and RX directions leave
//             the showtime state and added an another function to notify PPE that
//             Zephyr Rx is disabled when link is drop from the showtime,
//             i.e bytes stop going to PPE.
//             Grep for "XDSLRTFW-541: Platform_VRX318"
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//*-------------------------------------------------------------------------------//



#include "common.h"
#include "LL_IOf.h"
#include "cri_memmap.h"
#include "ftb_memmap.h"
#include "cri_iof.h"
#include "gdata.h"
#include "cmv.h"
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VRX318 (START)
#include "str_memmap.h"
#include "memrymap.h"
#include "ppe_memmap.h"
//XDSLRTFW-541: Platform_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

// Global array to map f/w interrupts to cri register mask
uint32 gula_MapInterruptToMask[NUM_INTERRUPTS] =
{
   (uint32) CRI_MASK_TX_PMS_DONE,
   (uint32) CRI_MASK_TX_QT_DONE,
   (uint32) CRI_MASK_TX_QTP_DONE,
   (uint32) CRI_MASK_TX_FT_IFFT_DONE,
   (uint32) CRI_MASK_TX_FTB_FRAME,
   (uint32) CRI_MASK_TX_CRI_TIMER,
   (uint32) CRI_MASK_TX_TSC_INT,
   (uint32) CRI_MASK_TX_QT_BAT_ERROR,
   (uint32) CRI_MASK_RX_FTB_FRAME,
   (uint32) CRI_MASK_RX_FT_FFT_DONE,
    (uint32) CRI_MASK_RX_QTP_DONE,
    (uint32) CRI_MASK_RX_QT_DONE,
    (uint32) CRI_MASK_RX_PMS_DONE,
    (uint32) CRI_MASK_RX_CRI_TIMER,
    (uint32) CRI_MASK_RX_TSC_INT,
    (uint32) CRI_MASK_RX_FC_NTR_INT,
    (uint32) CRI_MASK_RX_QT_BAT_ERROR,
    (uint32) CRI_MASK_RX_VFDF_DECDONE
};

/*
 *------------------------------------------------------------------------
 *
 *  Name : ModifyTxInterruptReg
 *
 *  Description:    Enable or disable Tx Interrupt.
 *
 *  Prototype:  ModifyTxInterruptReg(int16 s_enable, uint32 ul_bitmask)
 *
 *
 *  Input Arguments: s_enable -- 0 : disable interrupt, 1 : enable interrupt
 *                   ul_bitmask -- interrupt source mask
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */

void ModifyTxInterruptReg(int16 s_enable, uint32 ul_bitmask)
{
   if (s_enable) {
      SetCoreReg(CRI_MASK0_TX_ADDR,  ul_bitmask );
   } else {
      ResetCoreReg(CRI_MASK0_TX_ADDR,  ul_bitmask );
   }
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ModifyRxInterruptReg
 *
 *  Description:    Enable or disable Rx Interrupt.
 *
 *  Prototype:  ModifyRxInterruptReg(int16 s_enable, uint32 ul_bitmask)
 *
 *
 *  Input Arguments: s_enable -- 0 : disable interrupt, 1 : enable interrupt
 *                   ul_bitmask -- interrupt source mask
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ModifyRxInterruptReg(int16 s_enable, uint32 ul_bitmask)
{
   if (s_enable) {
      SetCoreReg(CRI_MASK0_RX_ADDR,  ul_bitmask );
   } else {
      ResetCoreReg(CRI_MASK0_RX_ADDR,  ul_bitmask );
   }
}
 /*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableTxInterrupt
 *
 *  Description:    Time Critical Function to Disable interrupts
 *
 *  Prototype:  DisableTxInterrupt(uint32 ul_bitmask)
 *
 *
 *  Input Arguments:source
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableTxInterrupt(uint32 ul_bitmask)
{
   ModifyTxInterruptReg(0, ul_bitmask);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableTxInterrupt
 *
 *  Description:    Time Critical Function to enable interrupts
 *
 *  Prototype:  EnableTxInterrupt(uint32 ul_bitmask)
 *
 *
 *  Input Arguments:source
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void EnableTxInterrupt(uint32 ul_bitmask)
{
   ModifyTxInterruptReg(1, ul_bitmask);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableRxInterrupt
 *
 *  Description:    Time Critical Function to Disable interrupts
 *
 *  Prototype:  DisableRxInterrupt(int16)
 *
 *
 *  Input Arguments:source
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableRxInterrupt(uint32 source)
{
   ModifyRxInterruptReg(0, source);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableRxInterrupt
 *
 *  Description:    Time Critical Function to Disable interrupts
 *
 *  Prototype:  EnableRxInterrupt(int16)
 *
 *
 *  Input Arguments:source
 *
 *
 *  Output Arguments: None
 *
 *  Return:
 *          None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
void EnableRxInterrupt(uint32 source)
{
   ModifyRxInterruptReg(1, source);
}

FlagT isDataPumpRunComplete(int16 s_TxRx, int16 s_mask)
{
   // not used in Hercules build
   return(TRUE);
}


void ClearEventRegister(int16 s_TxRx, uint16 us_mask)
{
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableTSC
 *
 *  Description: Enable/Disable Time-Slot Control
 *
 *  Prototype:  void EnableTSC(void) or DisableTSC(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void EnableTSC(void)
{
   //Enable time slot control
   SetCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_ENABLE<<31));
}

void DisableTSC(void)
{
   //Disable time slot control
   ResetCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_ENABLE<<31));
}




/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableTxPms
 *
 *  Description: Enable TX PMS core
 *
 *  Prototype:  void EnableTxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */

void EnableTxPms(void)
{
   uint32 ul_GO_CNT = 0;

   WriteCoreReg(CRI_TX_PMS_CTL_ADDR, (ul_GO_CNT | TX_TSC_START_TX_FC_SEL));
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableTxPms
 *
 *  Description: Disable TX PMS core
 *
 *  Prototype:  void EnableTxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableTxPms(void)
{
   //Disable TX PMS
   WriteCoreReg(CRI_TX_PMS_CTL_ADDR, 0x0);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableRxPms
 *
 *  Description: Enable RX PMS core
 *
 *  Prototype:  void EnableRxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void EnableRxPms(void)
{
   uint32 ul_GO_CNT = 0;

   WriteCoreReg(CRI_RX_PMS_CTL_ADDR, (ul_GO_CNT | RX_TSC_START_RX_FC_SEL));
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableRxPms
 *
 *  Description: Disable RX PMS core
 *
 *  Prototype:  void EnableRxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableRxPms(void)
{
   //Disable RX PMS
   WriteCoreReg(CRI_RX_PMS_CTL_ADDR, 0x0);
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableTxQtp
 *
 *  Description: Enable TX Qtp core
 *
 *  Prototype:  void EnableTxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */

uint8 guc_ftb_tx_qt_stalls;

void EnableTxQtp(void)
{
   uint32 ul_GO_CNT = 0;

   //Enable TX QTP
    guc_ftb_tx_qt_stalls = 0;
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, (ul_GO_CNT | TX_TSC_START_TX_QTP_SEL));
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableTxQtp
 *
 *  Description: Disable TX QTP core
 *
 *  Prototype:  void EnableTxQtp(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableTxQtp(void)
{
   //Disable TX QTP
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, 0x0);
}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : EnableRxPms
 *
 *  Description: Enable RX PMS core
 *
 *  Prototype:  void EnableRxPms(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */

uint8 guc_ftb_rx_qt_stalls;

void EnableRxQtp(void)
{
   uint32 ul_GO_CNT = 0;

   //Enable RX QTP
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, (ul_GO_CNT | RX_TSC_START_RX_QTP_SEL));
    guc_ftb_rx_qt_stalls = 0;
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : DisableRxQtp
 *
 *  Description: Disable RX QTP core
 *
 *  Prototype:  void EnableRxQtp(void)
 *
 *
 *  Input Arguments: None
 *
 *  Return: None
 *
 *  Global Variables Used: None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void DisableRxQtp(void)
{
   //Disable RX QTP
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, 0x0);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void StopTxDataPath(void)
*
*  This function disables TX data path.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void StopTxDataPath(void)
{
   //Disable TX PMS
   DisableTxPms();
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void StopRxDataPath(void)
*
*  This function disables RX data path.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void StopRxDataPath(void)
{
   //Disable RX PMS
   DisableRxPms();

}


/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : SoftResetCores()
 *
 *  Description:   Reset all the cores
 *
 *  Prototype:  void ResetCores(void)
 *
 *
 *  Input Arguments:
 *
 *  Output Arguments:
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *
 *
 *------------------------------------------------------------------------
 *^^^
 */
extern uint8 guc_ch_id;

void SoftResetCores(void)
{
#if 0
   // Issue soft reset to the following cores:
   // PMS, QT, FT, FTB, VFDF
   WriteCoreReg(CRI_RST_ADDR, 0x7F);
#else
    // have to manually disable each core for the port

    uint32 ul_RegAddr, ul_RegVal;

    for (ul_RegAddr = CRI_RXGP0_CTL_ADDR; ul_RegAddr <= CRI_RX_PMS_CTL_ADDR; ul_RegAddr += 4)
    {
        WriteCoreReg(ul_RegAddr, 0);
    }

    if(guc_ch_id == 0)
    {

        #define RX_DSP_TS_PORT0_4K  (3)
        WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, (RX_DSP_TS_PORT0_4K<<25));
    }
    else if(guc_ch_id == 1)
    {
        #define RX_DSP_TS_PORT1_4K  (1)
        WriteCoreReg(CRI_RX_TSLOTC_A_ADDR, (RX_DSP_TS_PORT1_4K<<25));
    }

   //Enable DSP interrupt to TSC interrupt
   //TSC_RX_INT = 1, all the others are 0's
    WriteCoreReg(CRI_MASK0_RX_ADDR, CRI_MASK_RX_TSC_INT);


#ifndef TARGET_HW
   //CRI_MASK0_TX, using TX_FTB_FRAME to indicate the frame boundary for linking with DLI
    WriteCoreReg(CRI_MASK0_TX_ADDR, CRI_MASK_TX_FTB_FRAME);
#endif

   #define DIS_RXTSC_UPD   (0) // (do not disable TSC start assertion)
   #define FRC_RXTSC_UPD   (1) // (constantly update)
   #define DIS_TXTSC_UPD   (0) // (do not disable TSC start assertion)
   #define FRC_TXTSC_UPD   (1) // (constantly update)
   #define MASK1_TX_UPD    (3)   // (continuous update)
   #define MASK0_TX_UPD (3)   // (continuous update)
   #define MASK1_RX_UPD    (3)   // (continuous update)
   #define MASK0_RX_UPD (3)   // (continuous update)

    WriteCoreReg(CRI_UPDCTL_ADDR, (DIS_RXTSC_UPD<<15)|(FRC_RXTSC_UPD<<14)|(DIS_TXTSC_UPD<<13)|(FRC_TXTSC_UPD<<12)|
                                  (MASK1_TX_UPD<<7)|(MASK0_TX_UPD<<5)|(MASK1_RX_UPD<<3)|(MASK0_RX_UPD<<1));

    // reconfig CRI_TSC without touching TSC_ENA bit
    ReadCoreReg(CRI_TSC_CTRL_ADDR, &ul_RegVal);
    ul_RegVal &= (1 << 31);
   WriteCoreReg(CRI_TSC_CTRL_ADDR, (CRI_TSC_CTRL_NUM_TS_4K | ((CRI_TSC_CTRL_NUM_CLKS-1)<<5) |
                           (CRI_TSC_CTRL_CLKS_LAST<<22) | ul_RegVal));
#endif
}





/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : CheckQtStall
 *
 *  Description: Check to see if the QT run is dropped or not (stalled).
 *
 *  Prototype: FlagT CheckQtStall(uint8 uc_TxRxIndicator)
 *
 *  Input Arguments:
 *    uc_TxRxIndicator -- indicator of TX or RX direction
 *
 *  Output Arguments (global variables):
 *
 *  Return:
 *      1: QT is stalled, 0: QT has run
 *
 *  Global Variables Used:
 *    None
 *
 *------------------------------------------------------------------------
 *^^^
 */

#ifdef VR9_BRINGUP_DBG
extern int16 gft_GetFtbStatus;
extern int16 gs_FtbStatusBufSize;
extern int16 *gpsa_FtbStatusTx;
extern int16 *gpsa_FtbStatusRx;
extern int16 gs_FtbStatusCntTx;
extern int16 gs_FtbStatusCntRx;
#endif //#ifdef VR9_BRINGUP_DBG

uint8 guc_ftb_rx_qt;
uint8 guc_ftb_tx_qt;




FlagT CheckQtStall(uint8 uc_TxRxIndicator)
{
   uint8 uc_qt_curr, *puc_qt_prev;
   FlagT ft_flag;
   uint32 ul_data;
   uint32 ul_addr;

   //Get the QT buffer status
   if(uc_TxRxIndicator == TX)
   {
      ul_addr = IRI_FTB_TX_STATUS_ADDR;
      puc_qt_prev = &guc_ftb_tx_qt;
   }
   else
   {
      ul_addr = IRI_FTB_RX_STATUS_ADDR;
      puc_qt_prev = &guc_ftb_rx_qt;
   }

   ReadCoreReg(ul_addr, &ul_data);
   uc_qt_curr = ul_data & 3;

   //QT stalled
   if(uc_qt_curr == *puc_qt_prev)
      ft_flag = 1;
   else //QT not stalled
      ft_flag = 0;

   *puc_qt_prev = uc_qt_curr;


#ifdef VR9_BRINGUP_DBG
if(gft_GetFtbStatus)
{

   //Log the FTB buffer assignment before enabling core
   if(uc_TxRxIndicator == TX)
   {
      if(gs_FtbStatusCntTx < (gs_FtbStatusBufSize - 6))
      {
         gpsa_FtbStatusTx[gs_FtbStatusCntTx] = ul_data & 0x0FFF;
         if(ft_flag)
            gpsa_FtbStatusTx[gs_FtbStatusCntTx] |= 0x8000;
         gs_FtbStatusCntTx++;
      }
   }
   else
   {
      if(gs_FtbStatusCntRx < (gs_FtbStatusBufSize - 6))
      {
         gpsa_FtbStatusRx[gs_FtbStatusCntRx] = ul_data & 0x0FFF;
         if(ft_flag)
            gpsa_FtbStatusRx[gs_FtbStatusCntRx] |= 0x8000;
         gs_FtbStatusCntRx++;
      }
   }
}
#endif //#ifdef VR9_BRINGUP_DBG


   return(ft_flag);

}

#if 0
FlagT CheckQtStall(uint8 uc_TxRxIndicator)
{
   uint32 ul_data;
   uint32 ul_addr;

   if(uc_TxRxIndicator == TX)
      ul_addr = CRI_TX_QT_STALL_ADDR;
   else
      ul_addr = CRI_RX_QT_STALL_ADDR;

   ReadCoreReg(ul_addr, &ul_data);

   //Get bit TX_QT_START_DROP
   ul_data >>= 17;
   ul_data &= 0x1;

   return((FlagT)ul_data);
}
#endif
/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ClearTxStall
 *
 *  Description: Clear bit TX_QT_STALL_DROP in reg CRI_TX_QT_STALL
 *
 *  Prototype: void ClearTxStall(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments{
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *    None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ClearTxStall(void)
{
   SetCoreReg(CRI_TX_QT_STALL_ADDR, (1<<17));
}

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : ClearRxStall
 *
 *  Description: Clear bit RX_QT_STALL_DROP in reg CRI_RX_QT_STALL
 *
 *  Prototype: void ClearRxStall(void)
 *
 *  Input Arguments:
 *
 *  Output Arguments{
 *
 *  Return:
 *      None
 *
 *  Global Variables Used:
 *    None
 *
 *------------------------------------------------------------------------
 *^^^
 */
void ClearRxStall(void)
{
   SetCoreReg(CRI_RX_QT_STALL_ADDR, (1<<17));
}


FlagT gft_EnableQtStall = TRUE;
FlagT gft_IfftTimerStart = TRUE;
int16 gs_CRI_DbgCntl;


void InitCRI_ForLinkStart(void)
{
   //Configure TX QTP to tx time-slot start
   //TX_QTP_REG_START = 0
   //TX_QTP_START_SEL = 4
   //TX_QTP_GO_CNT = 0
   WriteCoreReg(CRI_TX_QTP_CTL_ADDR, TX_TSC_START_TX_QTP_SEL);

   //Configure TX QT to tx time-slot start
   //TX_QT_REG_START = 0
   //TX_QT_START_SEL = 4
   //TX_QT_GO_CNT = 0
   WriteCoreReg(CRI_TX_QT_CTL_ADDR, TX_TSC_START_TX_QT_SEL);

   //Mei fixme ??? This may need to be changed to the timer start mode
   //Program IFFT to be triggered by TX QT done signal
   //TX_IFFT_REG_START = 0
   //TX_IFFT_START_SEL = 6
   //TX_IFFT_GO_CNT = 0


   if(gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_IFFT)
    {
      WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, 0);
    }
   else
   {
      //Mei debug
      if(gft_IfftTimerStart == 0)
      {
         //Program IFFT to be triggered by TX QT done signal
         //TX_IFFT_REG_START = 0
         //TX_IFFT_START_SEL = 6 (tx_qt_done)
         //TX_IFFT_GO_CNT = 0
         WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, TX_QT_DONE_START_TX_IFFT_SEL);
      }
      else
      {
         //Program IFFT to be triggered by timer-based method
         //TX_IFFT_REG_START = 0
         //TX_IFFT_START_SEL = 2 (timer-based)
         //TX_IFFT_GO_CNT = Predefined timer
         WriteCoreReg(CRI_TX_IFFT_CTL_ADDR, (TX_TIMER_START_TX_IFFT_SEL|TX_IFFT_START_TIMER_4K));
      }
   }

   if((gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_FFT) == 0)
   {
      //Configure RX FFT to rx buffer swap
      WriteCoreReg(CRI_RX_FFT_CTL_ADDR, RX_BUFFER_SWAP_START_RX_FFT_SEL);
   }
   else
   {
      //Configure RX FFT to disabled
      WriteCoreReg(CRI_RX_FFT_CTL_ADDR, 0);
   }

   if((gs_CRI_DbgCntl & CRI_DBG_CNTL_DISABLE_RXQT) == 0)
   {
      //Configure RX QT to rx time-slot start
      //RX_QT_REG_START = 0
      //RX_QT_START_SEL = 4
      //RX_QT_GO_CNT = 0
      WriteCoreReg(CRI_RX_QT_CTL_ADDR, RX_TSC_START_RX_QT_SEL);
   }
   else
    {
      WriteCoreReg(CRI_RX_QT_CTL_ADDR, 0);
    }

   //Configure RX QTP to rx time-slot start
   //RX_QTP_REG_START = 0
   //RX_QTP_START_SEL = 4
   //RX_QTP_GO_CNT = 0
   WriteCoreReg(CRI_RX_QTP_CTL_ADDR, RX_TSC_START_RX_QTP_SEL);

   //According to Strymon Spec (Initial FIFO Condition)
   //we need to follow the following procedure to enable QT stall and strymon
   //(Note: At this point, Strymon is held at reset mode)

   //First disable QT stall
   ResetCoreReg(CRI_TX_QT_STALL_ADDR, (1<<16));
   ResetCoreReg(CRI_RX_QT_STALL_ADDR, (1<<16));

   //Then enable QT stall if desired
   if(gft_EnableQtStall == TRUE)
   {
      SetCoreReg(CRI_TX_QT_STALL_ADDR, (1<<16));
      SetCoreReg(CRI_RX_QT_STALL_ADDR, (1<<16));
   }

} //void InitCRI_ForLinkStart(void)


//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
//XDSLRTFW-541: Platform_VRX318 (START)
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DFE_PPE_LinkStatus_TxRxLeaveShow()
*
*  This function notifies PPE that both TX and RX directions leave
*   showtime. (BIT0)
*
*  Input Arguments:
*
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DFE_PPE_LinkStatus_TxRxLeaveShow(void)
{
   uint32 ul_addr, ul_data;

   // Bit defintion of various DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF

   // Bit definition of 0X7DC6 (DREG_MISCRAM6_ADDR):
   //  Bit 0      --> Framer Request Enable (Set by the PPE driver and cleared by DSL FW)
   //  Bit 1      --> Dynamic Frequency supported (Set by the PPE driver and cleared by DSL FW)

   // Bit definition of 0x7DC7 (DREG_MISCRAM7_ADDR)
   //  Bit 0     --> Framer Request Stopped (Set by DSL FW and cleared by PPE FW)

   ul_addr = DREG_MISCRAM6_ADDR;
   ReadPpeReg(ul_addr, &ul_data);
   if (ul_data & (MASK_BIT0 | MASK_BIT1))
   {
      ul_data &= ~(MASK_BIT0 | MASK_BIT1);
      WritePpeReg(ul_addr,ul_data);
   }

   ul_addr = DREG_MISCRAM0_ADDR;
   ReadPpeReg(ul_addr, &ul_data);

   // XDSLRTFW-2778 (Start): Teardown procedure in VRX518
   #ifdef VRX518
   if (ul_data & (MASK_BIT0 | MASK_BIT1))
   {
      ul_data &= (~(MASK_BIT0 | MASK_BIT1));
      WritePpeReg(ul_addr,ul_data);

      ul_addr = DREG_MISCRAM7_ADDR;
      ReadPpeReg(ul_addr, &ul_data);
      ul_data |= MASK_BIT0;
      WritePpeReg(ul_addr,ul_data);
   }
   #endif
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DFE_PPE_RxDataStatus_LeaveShow(void)
*
*  This function notifies PPE that Zephyr Rx is disabled (bytes stop going to PPE).
*
*
*  Input Arguments:
*
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
void DFE_PPE_RxDataStatus_LeaveShow(void)
{
   uint32 ul_addr, ul_data;
   // Bit defintion of DREG registers:
   // 0x7DC0 (DREG_MISCRAM0_ADDR)
   //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
   //  Bit 1      --> Set by DSL FW on first Rx showtime
   //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF

   ul_addr = DREG_MISCRAM0_ADDR ;
   ReadPpeReg(ul_addr, &ul_data);
   ul_data &=~MASK_BIT1;
   WritePpeReg(ul_addr, ul_data);
}
//XDSLRTFW-541: Platform_VRX318 (END)
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DFE_PPE_PDBRAM_S_44K_Mem_Owner(void)
*
*  This function notifies to DSL FW that S_44K of PDBRAM (shared memory) can be
*    used for training or not.
*    Notifications:
*    "Bit 0"  ==> 0 (DSL FW is allowed to use S_44K Memory)
*    "Bit 0"  ==> 1 (DSL FW is not allowed to USE S_44K memory), DSL FW need to wait till
*                    clearing of Tx buffer is done to use S_44K.
*
*
*  Input Arguments:
*
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*                    guc_s_44k_owner
*-------------------------------------------------------------------------------
*/

void DFE_PPE_PDBRAM_S_44K_Mem_Owner(void)
{
#ifdef VRX318
   uint32 ul_addr, ul_data;

   ul_addr = DREG_MISCRAM2_ADDR ;
   ReadPpeReg(ul_addr, &ul_data);
   ul_data &= MASK_BIT0;
   guc_s_44k_owner = (uint8)ul_data;
#else
   //VR9, this is set to zero, since there is no shared PDBRAM between DFE & DFE
   //Hence for VR9, DSL FW always owns the PDBRAM.
   guc_s_44k_owner = 0;
#endif
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void DFE_PPE_Shared_PPE_Reg_Init(void)
*
*  This function initializes the DSL FW & PPE FW shared regsisters for both bearer channel.
*
*
*  Input Arguments:
*
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void DFE_PPE_Shared_PPE_Reg_Init(void)
{
   uint32 ul_addr, ul_data;

   //BC0 related registers
   //Clear B0 ==> Tx & Rx showtime status
   //clear B1 ==> Rx Data status
   //Clear B2 ==> Selected BC0 indication
   ul_addr = DREG_MISCRAM0_ADDR;   //0x7DC0
   ReadPpeReg(ul_addr, &ul_data);

   ul_data &= (~(MASK_BIT2 | MASK_BIT1 | MASK_BIT0));
   WritePpeReg(ul_addr, ul_data);


   //BC1 related registers
   //Clear B0 ==> Tx & Rx showtime status
   //clear B1 ==> Rx Data status
   //Clear B2 ==> Selected BC0 indication
   ul_addr = DREG_MISCRAM16_ADDR;   //0x7DD0
   ReadPpeReg(ul_addr, &ul_data);
   ul_data &= (~(MASK_BIT2 | MASK_BIT1 | MASK_BIT0));
   WritePpeReg(ul_addr, ul_data);


}
//XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (Start)
/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  Ppe_clockChange
**
** DESCRIPTION:    Set the clock bits of the PPE's CGU_FSR_OFFSET register.
**
** PARAMETERS:     gul_PpeClockValue holds a 2 bit field for the clock.
**
** RETURN VALUE:
**
**
** NOTES:          Reference:
**
** =============================================================================
*/
// XDSLRTFW-3712 (Start)
void Ppe_clockChange(void)
{
   // Bit defintion of DREG register 0x7DCE (DREG_MISCRAM14_ADDR):
   //       Value (Bit1 - Bit0)                 PPE Frequency
   //             0                                576 MHz
   //             1                                494 MHz
   //             2                                432 MHz
   //             3                                288 MHz

   uint32 ul_addr, ul_data = 0;
   ul_addr = DREG_MISCRAM14_ADDR;

   if (gus_PpeClockControl & TRIGGER_PPE_WRITE)
   {
      gus_PpeClockControl &= ~TRIGGER_PPE_WRITE;
      ul_data = (gus_PpeClockControl& PPE_CLOCK_FREQ_MASK) - 1;
   }
   else
   {
      if (gus_PPEClockConfigure == FSCALE_AUTO_A)
      {
         if (gt_Bonding_DiscAggr_Control.s_PCS_control & CNFG_PAF_ENABLE_MASK)
         {
            ul_data = (PPE_CLOCK_576MHz - 1);
         }
         else
         {
            if ((gus_Required_TC_Info & EFM_ATM_TC) == ATM_TC)
            {
               ul_data = (PPE_CLOCK_432MHz - 1);
            }
            else
            {
               ul_data = (PPE_CLOCK_288MHz - 1);
            }
         }
      }
      else
      {
         ul_data = (PPE_CLOCK_576MHz - 1);
      }
   }
   WritePpeReg(ul_addr,ul_data);
}
// XDSLRTFW-3712 (End)
//XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL (End)
