/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2005 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: datapumpsetup_rx.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime RX path operations.
*
*-------------------------------------------------------------------------------
*/
//*-------------------------------------------------------------------------------//
// Datapumpsetup_rx.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 07/02/2012 Shakil: Erasaure decoding feature was turned off by default which introduced CRCs in
//          the REIN test from Telefonica Spain in ADSL 2plus profile. As a sollution we enabled
//          erasure decoding feature and also make some small modification in the logic to easily
//          understand the code.
//          Grep for XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//
// 14/06/2012 Kannan:
//          1. No of DTU's to store in ReTx Queue buffer is estimated based on
//             the available ReTx Queue buffer size and DTU payload size.
//       2. ZR_R4 <7:0> is being used as ReTx Queue overflow indicator for LP1.
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//       3. BC for G.DMT(fast path) was not configured properly when ReTx is
//          enabled.
//
// 21/11/2012 Kannan:
//          1. Indicate selected Bearer channel to PPE
//             Grep for "XDSLRTFW-541: Platform_VRX318"
//
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//
// 18/02/2013 Vinjam: Report downstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 1 [14:15]" & "CMV_RATE 1 [16:17] respectively.
//            Also, Report upstream "ActInpNoErasure" & "ActInpErasure" through "CMV RATE 0 [14:15]" & "CMV_RATE 0 [16:17] respectively.
//            Modified enable/disable of Erasuredecoder logic as per VRx Msg Spec through "CMV DSL 1 0"
//            Grep for XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec
//
// 04/01/2015 Anantha Ramu/TV Ram: Added fix for uncorrected DTUs due to Q full condition.
//            Grep for XDSLRTFW-1223.
//*-------------------------------------------------------------------------------//

#include "common.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "gdata.h"
#include "gdata_bis.h"
#include "datapumpsetup_rx.h"
#include "IRI_Iof.h"
#include "cmv.h"
#include "tone_reord_load.h"
#include "mul.h"
#include "dsp_op2.h"
#include "fifo.h"
#include "ALP_Iof.h"
#include "IRI_IOf_tables.h"
#include "T1413.h"
#include "ZPH_Iof.h"
#include "version.h"
#ifdef IFX_XTC
   #include "xtc_setup.h"
   #include "ConfigXtcIfRxPath.h"
#endif
#ifdef CUSTOMER_TASKS
   #include "customertasks.h"
#endif

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif //PPE_ENGINE
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
#ifdef BIS_CODESWAP
#include "codeswap.h"
#include "soc_codeswap.h"
#endif
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

//jg uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I);
uint16 Find_Pmd_Step_RXDP(uint16 s_D, uint16 s_I);
int16 gus_invalid_bytes[2];

int16 gs_Dmetric_WP = 1;
extern uint32 PSCRAM32;
extern uint32 gula_rxILVBaseAddr[2] ;
extern uint16 gusa_rxFifoExt[2] ;
uint32 gul_qtp_rx_ctrl_L0;


void LoadRxZepMicroCode(void); //VR9_ADSL_RETX (STRAT - END)

/*
*-------------------------------------------------------------------------------
*
*  Prototype: int16 GetFifoReadWriteStep(int16 s_D, int16 s_N)
*
*  This function returns "read-step" or "write-step" - # of FIFO's to be skipped
*  between reads (ILVB to TxDTB) or writes (RxDTB to DILVB), which is uniquely
*  determined by interleave depth (D) and codeword size (N).
*
*  Input Arguments:
*     s_D: interleave depth
*     s_N: actual codeword size in bytes
*
*  Output Arguments:
*
*  Returns:
*     i s.t. i*D mod N == 1
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

static int16 GetFifoReadWriteStep(int16 s_D, int16 s_N)
{
   int16 i, s_odd_cw;
   int32 l_temp;

   s_odd_cw = (s_N | 0x1);
   for (i=1;i<s_odd_cw;i++) {
      // l_temp = i*D mod N
      MULS16(l_temp, i, s_D);
      while (l_temp > s_odd_cw)
         l_temp -= s_odd_cw;
      if (l_temp == 1) break;
   }

   return (i);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void RxDataPumpSetUp(void)
*
*  This function initializes cores for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

// gs_RxDataPumpLoadState
#define RX_CONFIG_TPS_ALP     (0)
#define RX_CONFIG_TPS_ELE     (1)
#define RX_CONFIG_PMS_ZEP_FC  (2)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   #define RX_ZEP_FC_LOADING_LP0_UCODE    (21)
   #define RX_ZEP_FC_CODESWAP_LP1_UCODE   (22)
   #define RX_ZEP_FC_WAIT_FOR_LP1_UCODE   (23)
   #define RX_ZEP_FC_LOADING_UCODE_DONE   (24)
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
#define RX_CONFIG_PMS_ZEP_ILV (3)
#define RX_CONFIG_PMD_IRI_QT  (4)
#define RX_CONFIG_PMD_LOAD_BAT   (5)
#define RX_CONFIG_PMD_LOAD_GST   (6)
#define RX_CONFIG_PMD_LOAD_TRT   (7)
#define RX_CONFIG_PMD_LOAD_EGT   (8)
#define RX_CONFIG_PMD_IRI_QTP   (9)
#define RX_CONFIG_CORE_WAITING   (10)
#define RX_CONFIG_CORE_START  (RX_CONFIG_TPS_ALP)
#define RX_CONFIG_CORE_DONE      (RX_CONFIG_CORE_WAITING+1)

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#endif
void RxDataPumpSetUp(void)
{

    // initialize gs_RxDataPumpLoadState
   if (guc_RxDataPumpState == TRAINING_WAITING) {
      gs_RxDataPumpLoadState = RX_CONFIG_CORE_START;
      guc_RxDataPumpState = TRAINING_IN_PROGRESS;
   }

   // initialize cores one by one
   // make sure each core initialization is within MIPS budget for TC task
   switch (gs_RxDataPumpLoadState) {

   case RX_CONFIG_TPS_ALP:
#ifdef PPE_ENGINE
      // Configure PPE interface registers
      ConfigurePPERxPath();
#else
      // Configure ALP interface registers
      ConfigAlphaeusRxPath();
#endif //PPE_ENGINE
      gs_RxDataPumpLoadState = RX_CONFIG_PMS_ZEP_FC;
      break;

   case RX_CONFIG_PMS_ZEP_FC:
      ConfigZephyrFcRxPath();
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
      gs_RxDataPumpLoadState = RX_ZEP_FC_LOADING_LP0_UCODE;
      break;

    case RX_ZEP_FC_LOADING_LP0_UCODE:
    case RX_ZEP_FC_CODESWAP_LP1_UCODE:
    case RX_ZEP_FC_WAIT_FOR_LP1_UCODE:
        LoadRxZepMicroCode();               // this function will step thru these 3 substates
        break;

    case RX_ZEP_FC_LOADING_UCODE_DONE:
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
      gs_RxDataPumpLoadState = RX_CONFIG_PMD_IRI_QT;
      break;


   case RX_CONFIG_PMD_IRI_QT:
      ConfigIridiaQtRxPath();
      gs_RxDataPumpLoadState = RX_CONFIG_PMD_LOAD_BAT;
      break;

   case RX_CONFIG_PMD_LOAD_BAT:
      LoadRxBitAllocationTable();
      gs_RxDataPumpLoadState = RX_CONFIG_PMD_LOAD_GST;
      break;

   case RX_CONFIG_PMD_LOAD_GST:
      LoadRxGainScaleTable();
      guc_RxToneOrderLoadState = RXTONEORDERLOAD_WAITING;
      gs_RxDataPumpLoadState = RX_CONFIG_PMD_LOAD_TRT;
      break;

   case RX_CONFIG_PMD_LOAD_TRT:
      // this state can be revisited multiple times
      LoadRxToneReorderTable();
      if (guc_RxToneOrderLoadState == RXTONEORDERLOAD_BKGD_DONE)
      {
         gs_RxDataPumpLoadState = RX_CONFIG_PMD_LOAD_EGT;
         guc_RxToneOrderLoadState = RXTONEORDERLOAD_WAITING;
      }
      break;

    case RX_CONFIG_PMD_LOAD_EGT:
      LoadRxExtendedGainTable();
      gs_RxDataPumpLoadState = RX_CONFIG_PMD_IRI_QTP;
      break;

    case RX_CONFIG_PMD_IRI_QTP:

        ConfigIridiaQtpRxPath();
      ReadCoreReg( IRI_QTP_REG_RXTC_CTRL_ADDR, &gul_qtp_rx_ctrl_L0);
      gs_RxDataPumpLoadState = RX_CONFIG_CORE_DONE;
      guc_RxDataPumpState = TRAINING_DONE;
      break;
   }

}


#ifdef ENABLE_ALPHAEUS
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigAlphaeusRxPath(void)
*
*  This function initializes Alphaeus core for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigAlphaeusRxPath(void)
{

   uint16 us_CB_Start, us_CB_NPages;
   uint32 ul_data;

   // all RX registers are cleared in InitAlphaeus()

   // AR_CONFIG
   ul_data =
      (uint32)(0x0) // RXIFMODE_BC0 (0: Utopia mode, 1: Utopia bypass mode, 2: DSP intercept mode)
      | (uint32)(0x0 << 2) // RXIFMODE_BC1 (0: Utopia mode, 1: Utopia bypass mode, 2: DSP intercept mode)
      | (uint32)(0 << 4) // RX_PSTM_MODE (1: enable Pseudo STM mode)
      | (uint32)(0 << 5); // IMA_ENA (1: enable IMA mode)
   WriteCoreReg(ALP_R_CONFIG_ADDR, ul_data);

   // AR_CB_STAT
   // cleared

   // AR_CB_CFG_BC0
   us_CB_Start  = 0;

   // for now we give as many cell buffers as possible to the first bearer channel.
   // for multiple bearer channels we need to restore the logic that partitions available
   // cell buffers between the bearer channels.
   if ((OPTNArray[OPTN_ATMNumCellConfig] & OPTN_RX_BC0_NUM_CELL_PAGES) == 0)
      us_CB_NPages = MAX_NUM_RX_CELL_BUFFERS; // = 15 for now. leaves at least 3 for BC1.
   else
      us_CB_NPages = OPTNArray[OPTN_ATMNumCellConfig] & OPTN_RX_BC0_NUM_CELL_PAGES;
   if (us_CB_NPages > MAX_NUM_RX_CELL_BUFFERS)
      us_CB_NPages = MAX_NUM_RX_CELL_BUFFERS;

   ul_data =
      (uint32)(us_CB_Start & 0x0FFF)
      | ((uint32)(us_CB_NPages & 0x7F) << 16);
   WriteCoreReg(ALP_R_CB_CFG_BC0_ADDR, ul_data);

   // AR_CB_CFG_BC1
   us_CB_Start = (us_CB_NPages * CBPAGE_SIZE) >> 1;

   us_CB_NPages = NUM_RX_CBPAGE - us_CB_NPages;

   ul_data =
      (uint32)(us_CB_Start & 0x0FFF)
      | ((uint32)(us_CB_NPages & 0x7F) << 16);
   WriteCoreReg(ALP_R_CB_CFG_BC1_ADDR, ul_data);

   // AR_IMAHEC
   ul_data =
      (uint32)(0x00 & 0x00FF) // IMA_GOOD_HEC
      | ((uint32)(0x80 & 0x00FF) << 8) // IMA_BAD_HEC
      | ((uint32)0 << 16); // INSERT_IMA_HEC
   WriteCoreReg(ALP_R_IMAHEC_ADDR, ul_data);

   // AR_PCNTL_BC0
   ul_data =
      (uint32)1 // SCRMENA
      | ((uint32)0 << 1) // TPMODE
      | ((uint32)0 << 2) // BYTE_FLIP (1: disable)
      | ((uint32)0 << 3); // RXIDLEKEEP
   if ((STATArray[STAT_Mode1] & STAT_ConfigMode_ETSI_AnnexC) && (gs_fe_T1413_VendorID == T1413_ALA_ID))
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
   {
      ul_data &= ~(0x4);   //BYTE_FLIP (0: enable)
   }
   else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   WriteCoreReg(ALP_R_PCNTL_BC0_ADDR, ul_data);

   // AR_ATM_STAT_BC0
   // cleared

   // AR_CELL_CNT_BC0
   // cleared

   // AR_IDLE_CNT_BC0
   // cleared

   // AR_AIDLE_CNT_BC0
   // cleared

   // AR_BE_CNT_BC0
   // cleared

   // AR_HEC_CNT_BC0
   // cleared

   // AR_CD_CNT_BC0
   // cleared

   // AR_IDLE_BC0
   ul_data =
      (uint32)RX_IDLE_CELL_PAYLOAD;
   WriteCoreReg(ALP_R_IDLE_BC0_ADDR, ul_data);

   // AR_DELIN_BC0
   ul_data =
      (uint32)(CELL_DELIN_DELTA & 0x000F)
      | ((uint32)(CELL_DELIN_ALPHA & 0x000F) << 4);
   WriteCoreReg(ALP_R_DELIN_BC0_ADDR, ul_data);

   // AR_PCNTL_BC1
   ul_data =
      (uint32)1 // SCRMENA
      | ((uint32)0 << 1) // TPMODE
      | ((uint32)0 << 2) // BYTE_FLIP (1: disable)
      | ((uint32)0 << 3); // RXIDLEKEEP
   if ((STATArray[STAT_Mode1] & STAT_ConfigMode_ETSI_AnnexC) && (gs_fe_T1413_VendorID == T1413_ALA_ID))
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
   {
      ul_data &= ~(0x4);   //BYTE_FLIP (0: enable)
   }
   else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   WriteCoreReg(ALP_R_PCNTL_BC1_ADDR, ul_data);

   // AR_ATM_STAT_BC0
   // cleared

   // AR_CELL_CNT_BC0
   // cleared

   // AR_IDLE_CNT_BC0
   // cleared

   // AR_AIDLE_CNT_BC0
   // cleared

   // AR_BE_CNT_BC0
   // cleared

   // AR_HEC_CNT_BC0
   // cleared

   // AR_CD_CNT_BC0
   // cleared

   // AR_IDLE_BC1
   ul_data =
      (uint32)RX_IDLE_CELL_PAYLOAD;
   WriteCoreReg(ALP_R_IDLE_BC1_ADDR, ul_data);

   // AR_DELIN_BC1
   ul_data =
      (uint32)(CELL_DELIN_DELTA & 0x000F)
      | ((uint32)(CELL_DELIN_ALPHA & 0x000F) << 4);
   WriteCoreReg(ALP_R_DELIN_BC1_ADDR, ul_data);

}
#endif //EANBLE_ALPHAEUS


#ifdef PPE_ENGINE
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigurePPERxPath(void)
*
*  This function initializes PPE engine for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*     guc_PortMode -- (I)
*     gula_DREG_AR_CFG_Cnfg[] -- (I)
*     gft_TcTypeSelected -- (I)
*-------------------------------------------------------------------------------
*/
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
/*Sriram : PTM_Sprt_PPE Engine */
#define PPE_EFM_MODE (3<<5)
#define PPE_BYTE_FLIP_DISABLE (2)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
void ConfigurePPERxPath(void)
{
   uint32 ul_data,ul_addr;
   uint8 uc_bc, uc_offset;

   for (uc_bc=0; uc_bc<(guc_PortMode+1); uc_bc++)
   {
      uc_offset = uc_bc<<2;

      //DREG_AR_CFG
      if((STATArray[STAT_ACTIVEBCLP_DS] & (BC0_ACTIVE << uc_bc)))
      {
         //Configure DREG_AR_CFG0
         ul_data = gula_DREG_AR_CFG_Cnfg[uc_bc];

         if((gl_SelectedMode & (MODE_ADSL2)) && (guca_DS_TransferMode_bis[uc_bc] & PTM)) //only ADSL2/2+ support PTM mode
         {
            //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
            //If EFM preemption is supported, set the corresponding bit in this register
            if(gt_HercADSL_TPS_TC_Params[uc_bc].ta_TPS_TC_Type[0].uc_TPSTCoptions & 1)
            {
            //if(guc_TPSTCoptions & 1)
               ul_data |= (1<<7);
            }
            //If EFM short packets are supported, set the corresponding bit in this register
            if(gt_HercADSL_TPS_TC_Params[uc_bc].ta_TPS_TC_Type[0].uc_TPSTCoptions & 2)
            {
            //if(guc_TPSTCoptions & 2)
               ul_data |= (1<<8);
            }
            ul_data |= (PPE_EFM_MODE | PPE_BYTE_FLIP_DISABLE );
            //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
            //Set the TX TC mode to EFM TC mode
            ul_data |= (3<<5);   //Sriram : Not required , already initialized above
         }
            else //ATM mode
         //if (((gl_SelectedMode & (MODE_ADSL2) && (guca_DS_TransferMode_bis[s_bc] == ATM)) || ((gl_SelectedMode & (MODE_ADSL1) && (gft_TransferMode===ATM)))
         {
            //Enable byte flip (seting bit 1 to 0)
                if (gft_disableAlphaeusRxByteFlip)
               ul_data  |= (1<<1);
            else
                    ul_data  |= (0<<1);
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
            if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
            {
               //disable scrambling
               ul_data |= (0<<2);
            }
            else
            {
            //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
               //Enable scrambling
               ul_data |= (1<<2);
            } //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)
         }
         //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
         WritePpeReg((DREG_AR_CFG0_ADDR + uc_offset), ul_data);

         //DREG_AR_IDLE
         if((guca_DS_TransferMode_bis[uc_bc] & PTM)==0)
            ul_data = 0x6A;
         else
            ul_data = 0;
         WritePpeReg((DREG_AR_IDLE0_ADDR + uc_offset), ul_data);

         //DREG_AR_DELIN
         ul_data = (CELL_DELIN_DELTA & 0xF) | ((CELL_DELIN_ALPHA & 0xF) <<4);
         WritePpeReg((DREG_AR_DELIN0_ADDR + uc_offset), ul_data);


         //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
         //XDSLRTFW-541: Platform_VRX318 (START)
         //VRX318 doesn't support onchip binding and it support only offchip bonding.
         //Hence BC0 only will be used for given line. Indicate the same to PPE.
         if (uc_bc == 0)
         {
            // Bit defintion of DREG registers:
            // 0x7DC0 (DREG_MISCRAM0_ADDR)
            //  Bit 0      --> Set by DSL FW when both Tx and Rx enter showtime and cleared by DSL FW when showtime is left
            //  Bit 1      --> Set by DSL FW on first Rx showtime
            //  Bit 2      --> To indicate whether BEARER_CHANNEL is ON or OFF
            ul_addr = DREG_MISCRAM0_ADDR;
            ReadPpeReg(ul_addr, &ul_data);
            ul_data |=MASK_BIT2;
            WritePpeReg(ul_addr, ul_data);
         }
         //XDSLRTFW-541: Platform_VRX318 (END)
         //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

      } //if(gt_rx_TPS_Map.s_BCtoTPS[uc_bc] != 0)
      else
      {
         //Clear all registers
         WritePpeReg((DREG_AR_CFG0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_AR_IDLE0_ADDR + uc_offset), 0);
         //From Spec 0x3 should be the reset value.
         //0 is not valid
         WritePpeReg((DREG_AR_DELIN0_ADDR + uc_offset), 3);
         //WriteCoreReg((DREG_B0_LADR_ADDR + uc_offset), 0); //Sriram : No write operation is done, so it is deleted
      } //if(gt_rx_TPS_Map.s_BCtoTPS[uc_bc] != 0) else
      //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)


      //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
      //DREG_AR_STAT
      //XDSLRTFW-2050
      //Latest Spec for ATM PPE
      //Status Bit 1 = 0 No TC Sync
      //Status Bit 1 = 1 TC Sync
      WritePpeReg((DREG_AR_STAT0_ADDR + uc_offset), 0);

      //Read PPE counter registers and initiate shadow global variables
      ReadPpeReg((DREG_AR_CELL0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CELL_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_IDLE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_IDLE_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_AIIDLE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_AIIDLE_CNT_Shadow[uc_bc] = ul_data;

      ReadCoreReg((DREG_AR_BE_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_BE_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_HEC_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_HEC_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CD_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CD_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_OVDROP_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_OVDROP_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CERRN_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CERRN_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CERRNP_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CERRNP_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CVN_CNT0_ADDR + uc_offset), &ul_data);
      gula_DREG_AR_CVN_CNT_Shadow[uc_bc] = ul_data;

      ReadPpeReg((DREG_AR_CVNP_CNT0_ADDR + uc_offset), &ul_data);
      //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)

   } //for (uc_bc=0; uc_bc<(guc_PortMode+1); uc_bc++)

} //ConfigurePPERxPath()

#endif //PPE_ENGINE

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigIridiaQtRxPath(void)
*
*  This function initializes Iridia-QT core for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/
uint8 guc_MetricShift;

void ConfigIridiaQtRxPath(void)
{
   FlagT ft_TcmFlag;
   uint32 ul_data;
    int16 s_Rx_NumLogical_Tones, s_Rx_Num0bits_Tones;
   Config_t *pt_Config;
   // map the RX parameter structure
   pt_Config = &gt_rx_config;

   if(gft_ModemType == G_DMT_BIS) ft_TcmFlag =  gft_TcmFlag_bis_DS;
   else ft_TcmFlag = gft_TcmFlag;

    //==============================================
    // Global Registers
    //==============================================
    //IT_ENABLE
    //IR_ENABLE
    //IR_NSC, set during initialization/training
    //IR_PRBS_CTRL
    //IR_PRBS0
    //IR_PRBS1
    //I_ABGT_OFFSET
     WriteCoreReg(IRI_QT_REG_ABGT_OFFSET_ADDR, (gus_segment_size<<16)|0 );

    //==============================================
    // RXPRAM
    //==============================================
     //IR_CONFIG
   //IR_TCM_CTRL
    Configure_TCM_Bits(gus_Rx_Tcm_Num1bits, (uint16)(gs_RxNumTones - gus_Rx_Tcm_Num1bits));

   // IR_MISC
    // will be reconfigured when entering showtime
   // IR_ACT_ADDR

   /*check to figure out the number of pairs of tones. For legacy reasons, we first figure out
   the number of pairs in loaded tones, by counting two 1 bit tones as one*/

   if((gus_ncloaded - (gus_Rx_Tcm_Num1bits>>1)) & 0x1 == 1)
      {
         gft_Rx_Tcm_X0_YGT1 = TRUE;
      }

   //we also need to ensure the total number of tones, including zero bit tones is even
   // for that we take care by looking at number of unloaded tones
   // and decide if we need to move rx first channel to one tone earlier

   s_Rx_NumLogical_Tones = gus_Rx_MaxToneIndx - gs_RxFirstChannel + 1;
    s_Rx_Num0bits_Tones =  s_Rx_NumLogical_Tones - gus_ncloaded;


   if (ft_TcmFlag == TRUE)
   {
      if (gft_Rx_Tcm_X0_YGT1)
      {
         if (s_Rx_Num0bits_Tones & 0x1)
            gus_Rx_MinToneIndx = gs_RxFirstChannel;
         else
            gus_Rx_MinToneIndx = gs_RxFirstChannel-1;

      }
      else
      {
         if (s_Rx_Num0bits_Tones & 0x1)
            gus_Rx_MinToneIndx = gs_RxFirstChannel - 1;
         else
            gus_Rx_MinToneIndx = gs_RxFirstChannel;
      }

   }
   else
      gus_Rx_MinToneIndx = gs_RxFirstChannel;



   SetUpRxTonesRegister(gus_Rx_MinToneIndx, gus_Rx_MaxToneIndx);

   // IR_LP0_BITS
   ul_data = (uint32)pt_Config->s_Lp[LP0_DATA_PATH];
   WriteCoreReg(IRI_QT_REG_RX_LP0_BITS_ADDR, ul_data);

   // IR_LP1_BITS
   ul_data = (uint32)pt_Config->s_Lp[LP1_DATA_PATH];
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP1_BITS_ADDR, ul_data);

    //IR_LP2_BITS

   // IR_DUMMY
   WriteCoreReg((uint32)IRI_QT_REG_RX_DUMMY_ADDR, 0);

   // IR_LP0_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP0_BIT_FIFO_ADDR, 0);

   // IR_LP1_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_RX_LP1_BIT_FIFO_ADDR, 0);
    // IR_LP2_BIT_FIFO

   // IR_DEROT_MISC
    // IR_DEROT_POLY
   // IR_FD_RNG0
    // will be reconfigured when entering showtime

    // IR_FD_RNG1
    // will be reconfigured when entering showtime

    //IR_FD_RNG1_BASE
    //IR_NPR_IIBRAM
    //IR_QUAD0
    //IR_QUAD1
    //IR_SLOWDOWN
    //IR_PTINDEX
    //IR_PILOT
    //IR_FDQADPT
    //IR_VECPOW_L
    //IR_VECPOW_H
    //IR_METRIC_CTL
#ifdef VR9_ERASURE
   // The configuration of metric register is irrelavent if erasure decoding is off
    // metric = CPM(2nd best)- CPM(best)
    // usually a shift of 6,7 or 8 may produce a good metric without satuation
   WriteCoreReg (IRI_QT_REG_RX_RMETRIC_CTL_ADDR,  TESTArray[TEST_ERASURE_METRIC_control]);
    guc_MetricShift = TESTArray[TEST_ERASURE_METRIC_control]&0xF;

#endif
    //IR_RMETRIC_VAL
    //IR_RXCG_x: x=0,...,15


}



/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigZephyrFcRxPath(void)
*
*  This function initializes Zephyr-FC core for showtime RX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigZephyrFcRxPath(void)
{
   int16 i;//XDSLRTFW-1223 Qrx Full Fix (Start-End)
   int16 s_sHalfCntl, s_Lp;
   uint32 ul_data , ul_addr, ul_RegBaseAddr;
   uint16 us_Iblk=0, us_D=1, us_L=0, us_R=0, us_M=1,us_dummyBytes=0, us_cwsize=0;
   uint32 l_ilvSize, l_DoverI;
   uint32 ceil_DoverI ;
   Config_t *pt_Config;
   uint16 us_PPE_INPUT_MAX;   // XDSLRTFW-1924: (Start_End)

   // map the RX parameter structure
   pt_Config = &gt_rx_config;

   ///////////////////////////////////////////
   // GLOBAL REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////
   //Per Port Registers
   //ZEP_REG_ZR_FIFO_ACCESS_ADDR - Init to 0

   //ZEP_REG_ZR_CONFIG_ADDR
   WriteCoreReg(ZEP_REG_ZR_CONFIG_ADDR, ZEP_PRAM_RX_START_ADDR/4); //Longword address
   ul_addr = ZEP_RAM_IIBRAM_ADDR + ZEP_PRAM_RX_START_ADDR;


   WriteCoreReg(ul_addr, pt_Config->s_Nlp);  //Number of LP

   ul_addr += 4;
   WriteCoreReg(ul_addr, ZEP_RX_CFG_LP0_PTR/4);

   ul_addr += 4;
   WriteCoreReg(ul_addr, ZEP_RX_CFG_LP1_PTR/4);

   /////////////////////////////////////////////////////////////
   // Zephyr 62 Rx per Latency PATH REGISTERS INITIALIZATION  //
   /////////////////////////////////////////////////////////////
   for(s_Lp = 0; s_Lp < pt_Config->s_Nlp; s_Lp++)
   {
      if(s_Lp == LP0_DATA_PATH)
         ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
      else //(s_Lp == LP1_DATA_PATH)
         ul_RegBaseAddr = ZEP_PRAM_RX_LP1_START_ADDR;

      if ((pt_Config->s_Nlp < 2) && (gt_rx_config.s_Lp[LP1_DATA_PATH] > 0))
      {
         //G.DMT mode has single latency with LP1 has framing parameters.
         us_Iblk = gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize;
         us_cwsize = gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize;
         us_D = gt_rx_config.s_Dp[LP1_DATA_PATH];
         us_L = gt_rx_config.s_Lp[LP1_DATA_PATH];
         us_R = gt_rx_config.s_Rp[LP1_DATA_PATH];
         us_M = gt_rx_config.s_Mp[LP1_DATA_PATH];
         us_dummyBytes = !(gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize & 1); // 1 dummy if cw is even
      }
      else
      {
         us_Iblk = gt_RxShowTimeVars.t_FrameParms[s_Lp].s_CodewordSize;
         us_cwsize = gt_RxShowTimeVars.t_FrameParms[s_Lp].s_CodewordSize;
         us_D = gt_rx_config.s_Dp[s_Lp];
         us_L = gt_rx_config.s_Lp[s_Lp];
         us_R = gt_rx_config.s_Rp[s_Lp];
         us_M = gt_rx_config.s_Mp[s_Lp];
         us_dummyBytes = !(gt_RxShowTimeVars.t_FrameParms[s_Lp].s_CodewordSize & 1); // 1 dummy if cw is even
      }


      //ZR_R0_OFFSET
      // 0 not needed.

      // Program R8 before R4, because R4 uses us_Iblk
      // ZR_R8_OFFSET
      // ADSL2 m-code uses reg R8 for DDelay
      if (us_D <= 64)
         us_Iblk |= 1; // make odd.

      if ( us_Iblk != 0)
         l_DoverI = us_D / us_Iblk ;
      else
         l_DoverI = 0;

      ul_data = us_D - l_DoverI -1 ;
      ul_addr = ul_RegBaseAddr + ZR_R8_OFFSET;
      WriteCoreReg(ul_addr, ul_data);


      //ZR_R4_OFFSET  used for
      //ADSL2 m-code uses reg R4 for dummy byte.
      // 1 dummy if cw is even

      //bit[7:0] contains the number of the dummy_byte for all mode
      ul_data =us_dummyBytes;
      //program S_HALF in ZR-R4 register
      if (( gl_SelectedMode & (MODE_ADSL2))==0) // ADSL1 framing mode
      {
         if(gt_rx_config.s_Mp[0] == S_HALF)
         {
            s_sHalfCntl = gt_RxShowTimeVars.t_FrameParms[0].s_sHalfCntl;
            // bit[15:8] set to the additianl dummies in the second codeword
            // "1" for even/odd or odd/even, "0" for even/even or odd/odd
            if ( (s_sHalfCntl == 1) || (s_sHalfCntl == 2))
            {
               ul_data |= (1<<8);
            }
            //bit[23:16] set to the readout order of FIFO1,
            //FIFO1 contains an additional dummy for the second codeword
            ul_data |= ((us_D % us_Iblk)<<16) ;

            //bit[31:24]
            //for even/odd case where the 2nd cw has 2 dummy bytes
            if ( s_sHalfCntl == 2)
               ul_data |= ((us_D % us_Iblk + 1)<<24) ;
         }
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START)
      if ((gt_ReTxConfigInfo.ft_ReTxOn == 1) && (s_Lp))
      {
         //Register R4 bits <7:0> will be used as an overflow indicator in LP1
         //for microcode, Therefore it is cleared here.
         ul_data = 0;
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (END)
      ul_addr = ul_RegBaseAddr + ZR_R4_OFFSET;
      WriteCoreReg(ul_addr, ul_data);


      //ZR_R12_OFFSET - not used.
      //ZR_CODEWORD_OFFSET
      ul_data = ((uint32)us_M << 24);
      ul_data |= ((uint32)us_R << 16);
      ul_data |= ((uint32)(us_cwsize - us_R)<<8);
      ul_data |=(uint32)us_cwsize;
      ul_addr = ul_RegBaseAddr + ZR_CODEWORD_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_VBC_SIZE_OFFSET
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START)
      if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
      {
         if (gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath == s_Lp)
            ul_data = (uint32)gt_RxShowTimeVars.t_BCParms[0].sa_BC_Bytes; //BC0
         else
            ul_data = 0; //BC0

         if (gt_RxShowTimeVars.t_BCParms[1].sa_BC_LPath == s_Lp)
            ul_data |= (uint32)gt_RxShowTimeVars.t_BCParms[1].sa_BC_Bytes <<16; //BC1
      } else
      {

         if (gt_RxShowTimeVars.t_BCParms[0].sa_BC_LPath == LP0_DATA_PATH)
            ul_data = (uint32)gt_RxShowTimeVars.t_BCParms[0].sa_BC_Bytes; //BC0
         else
            ul_data = (uint32)gt_RxShowTimeVars.t_BCParms[0].sa_BC_Bytes; //BC0

         if (gt_RxShowTimeVars.t_BCParms[1].sa_BC_LPath == LP0_DATA_PATH)
            ul_data |= (uint32)gt_RxShowTimeVars.t_BCParms[1].sa_BC_Bytes <<16; //BC1
         else
            ul_data |= (uint32)gt_RxShowTimeVars.t_BCParms[1].sa_BC_Bytes <<16; //BC1
      }
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (END)
      ul_addr = ul_RegBaseAddr + ZR_VBC_SIZE_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_FRAMING_OFFSET
      if (( gl_SelectedMode & (MODE_ADSL2)  )) // ADSL2 framing mode
      {
         ul_data = (uint32)(gsa_rx_SEQp[LP0_DATA_PATH] );//15:0 Max_Frm_Idx -- (1 based, no need to minus 1)
                                                //was ZT_FRAME_IDX0
         ul_data |= ((uint32)gt_rx_config.s_Tp[LP0_DATA_PATH] << 16); //Tp
         ul_data |= 1<<24 ; // note bits 31:24 Rx_OHSwitch =1 .(check for adsl2!)
      }
      else // ADSL framing mode
         ul_data = (uint32)(RX_SYMBOLS_PER_SFRAME ) ;

      ul_addr = ul_RegBaseAddr + ZR_FRAMING_OFFSET;
      WriteCoreReg(ul_addr, ul_data);


      //ZR_OHRATE_OFFSET
      if (( gl_SelectedMode & (MODE_ADSL2)  )) // ADSL2 framing mode
      {
         ul_data = (uint32)1 << 16; //31:16 Max_OH
         ul_data |= 0 << 8; //15:8 Rx_OH2Rate
         ul_data |= (uint32)1; //7:0 Rx_OH1Rate
         ul_addr = ul_RegBaseAddr + ZR_OHRATE_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }

      //ZR_FLAG_CTRL0_OFFSET
      //ZR_FLAG_CTRL1_OFFSET
      //  -  done with m-code init - as these values are spec'd with m-code data.

      //ZR_CRC0_OFFSET
      //zero

      //ZR_CRC_POLY0_OFFSET
      ul_addr = ul_RegBaseAddr + ZR_CRC_POLY0_OFFSET;
      WriteCoreReg(ul_addr, 0x8e); //x^8 + x^4 + x^3 + x^2 + x^0

      //ZR_CRC_CTRL0_OFFSET
      ul_addr = ul_RegBaseAddr + ZR_CRC_CTRL0_OFFSET;
      WriteCoreReg(ul_addr, 0); //1:0 CRC_Len, 0 = 8-bit CRC

      //ZR_CRC1_OFFSET
      //ZR_CRC_POLY1_OFFSET
      //ZR_CRC_CTRL1_OFFSET
      //not used

      //ZR_SCR_OFFSET
      //zero

      //ZR_SCR_POLY_OFFSET
      if (gft_disableZephyrRxScrambler)
         ul_data = 0;
      else
         ul_data = PSCRAM32;  //Polynomial has degrees 23 and 18
      ul_addr = ul_RegBaseAddr + ZR_SCR_POLY_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_SCR_CTRL_OFFSET
      ul_addr = ul_RegBaseAddr + ZR_SCR_CTRL_OFFSET;
      WriteCoreReg(ul_addr, 31); //4:0 SCR_Len

      //ZR_SCR_STATE_OFFSET
      //init to 0

      //ZR_DTB_CTRL_OFFSET
      if (s_Lp == LP0_DATA_PATH)
      {
         ul_data = (uint32)(ZEP_ILV_RAM_RXDTB_LP0_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
         ul_data |= ZEP_ILV_RAM_RXDTB_LP0_BASE; //11:0 DTB_Base in 32-bit words
      }else
      {
         ul_data = (uint32)(ZEP_ILV_RAM_RXDTB_LP1_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
         ul_data |= ZEP_ILV_RAM_RXDTB_LP1_BASE; //11:0 DTB_Base in 32-bit words
      }
      ul_addr = ul_RegBaseAddr + ZR_DTB_CTRL_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_DTB_PTRS_OFFSET
      //zero
      //ZR_ILVB_WRAD_OFFSET
      //ZR_ILVB_RDAD_OFFSET
      //not used.
      //ZR_ILVB_WRPTR_OFFSET
      //ZR_ILVB_RDPTR_OFFSET
      //zero

      //ZR_FIFO_BASE0_OFFSET
      if (s_Lp == LP0_DATA_PATH)
      {
         ul_data = ZEP_RAM_RX_LP0_OHFIFO0_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }else
      {
         ul_data = ZEP_RAM_RX_LP1_OHFIFO0_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }
      ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << 19; //25:18 FIFO_Size -1
      ul_addr = ul_RegBaseAddr + ZR_FIFO_BASE0_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_FIFO_PTRS0_OFFSET
      //zero

      //ZR_FIFO_CNST0_OFFSET
      //init to 0 used for HDLC, (read value if empty)

      //ZR_FIFO_BASE1_OFFSET
      if (s_Lp == LP0_DATA_PATH)
      {
         ul_data = ZEP_RAM_RX_LP0_OHFIFO1_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }else
      {
         ul_data = ZEP_RAM_RX_LP1_OHFIFO1_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }
      ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << 19; //25:18 FIFO_Size -1
      ul_addr = ul_RegBaseAddr + ZR_FIFO_BASE1_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_FIFO_PTRS1_OFFSET
      //zero
      //ZR_FIFO_CNST1_OFFSET
      //zero
      //ZR_FIFO_BASE2_OFFSET
      if (s_Lp == LP0_DATA_PATH)
      {
         ul_data = ZEP_RAM_RX_LP0_OHFIFO2_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }else
      {
         ul_data = ZEP_RAM_RX_LP1_OHFIFO2_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      }
      ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_6-1) << 19; //26:19 FIFO_Size -1
      ul_addr = ul_RegBaseAddr + ZR_FIFO_BASE2_OFFSET;
      WriteCoreReg(ul_addr, ul_data);
      //ZR_FIFO_PTRS2_OFFSET
      //zero
      //ZR_FIFO_CNST2_OFFSET
      //used for IBITS, initial = 0

      //ZR_FIFO_BASE3_OFFSET
      //ZR_FIFO_PTRS3_OFFSET
      //ZR_FIFO_CNST3_OFFSET
      // - not used

      //ZR_DEPTH_OFFSET
      ul_data = (uint32)us_D << 16; // note D_MAX (for dcid)
      ul_data |= (uint32)us_D; // D
      ul_addr = ul_RegBaseAddr + ZR_DEPTH_OFFSET;
      WriteCoreReg(ul_addr, ul_data);
      //ZR_ILV_PARAMS0_OFFSET
      ul_data = (uint32) Find_Pmd_Step_RXDP(us_D , us_Iblk);
      ul_data <<= 16;
      ul_data |= 1<<24; //pms_step =1
      ul_data |= ((uint32) us_Iblk <<8); //7:0
      ul_data |= 0 ; //  efficient DE_interleaver
      ul_addr = ul_RegBaseAddr + ZR_ILV_PARAMS0_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_ILV_BASE0_OFFSET
      ul_addr = ul_RegBaseAddr + ZR_ILV_BASE0_OFFSET;
      WriteCoreReg(ul_addr, gula_rxILVBaseAddr[s_Lp]);

      //ZR_ILV_SIZE0_OFFSET
      //calculate total_delay per fifo as (D-M-1) to set ILV_SIZE
      l_ilvSize= us_D - l_DoverI -1;
      ul_data = 1  ; //s_q[LP0] ;
      ul_data +=  gusa_rxFifoExt[s_Lp] ;  // ILV EXT 16:23
      ul_addr = ul_RegBaseAddr + ZR_ILV_SIZE0_OFFSET;
      WriteCoreReg(ul_addr, (( ul_data<<16) |l_ilvSize ));

      //ZR_ILV_MAX_FULLNESS0_OFFSET
      ul_data = 0x3FFFF;
      ul_addr = ul_RegBaseAddr + ZR_ILV_MAX_FULLNESS0_OFFSET;
      WriteCoreReg(ul_addr, ul_data);

      //ZR_ILV_MIN_FULLNESS0_OFFSET
      ul_addr = ul_RegBaseAddr + ZR_ILV_MIN_FULLNESS0_OFFSET;
      WriteCoreReg(ul_addr, us_cwsize);

      //ZR_ILV_FULLNESS0_OFFSET
      //zero
      //ZR_ILV_CNTRS0_OFFSET
      //ZR_ILV_PMS_CNTRS0_OFFSET
      //ZR_ILV_PMD_CNTRS0_OFFSET
      //zero
      //ZR_ILV_PARAMS1_OFFSET
      //ZR_ILV_BASE1_OFFSET
      //ZR_ILV_SIZE1_OFFSET
      //ZR_ILV_MAX_FULLNESS1_OFFSET
      //ZR_ILV_MIN_FULLNESS1_OFFSET
      //ZR_ILV_FULLNESS1_OFFSET
      //ZR_ILV_CNTRS1_OFFSET
      //ZR_ILV_PMS_CNTRS1_OFFSET
      //ZR_ILV_PMD_CNTRS1_OFFSET
      // not used.

      //ZIR_DL_REL0_OFFSET
      //ZIR_NL_REL0_OFFSET
      {
         uint16 Dp, Ip, Lp;
         uint32 ul_divL, ul_modL ;
         //uint32 ul_ZIR_DL_RELaddr  = ZEP_PRAM_ZIR_DL_REL0_LP0_ADDR;

         Ip = us_Iblk ;
         Dp = us_D;
         Lp = us_L;

         if (Lp != 0)  // pram pre-cleared otherwise need else clause here.
         {
            if (us_dummyBytes == 0)
            {
               ul_divL = (8 * Dp) / Lp;
               ul_modL = (8 * Dp) % Lp;
            }
            else
            {
               ceil_DoverI = (us_D + us_Iblk -1 )/us_Iblk;
               ul_divL = (8 * (Dp- ceil_DoverI))/Lp;
               ul_modL = (8 * (Dp- ceil_DoverI)) % Lp;
            }

            ul_data = ul_modL & 0xFFFF;
            ul_data |= ((ul_divL & 0xFFF ) << 16);
            // write to   ZEP_PRAM_ZIR_DL_REL0_LP0_ADDR
            ul_addr = ul_RegBaseAddr + ZIR_DL_REL0_OFFSET;
            WriteCoreReg(ul_addr, ul_data);

            if (us_dummyBytes == 0)
            {
               ul_divL = (8 * Ip) / Lp;
               ul_modL = (8 * Ip) % Lp;
            }
            else
            {
               ul_divL = (8 * (Ip-1)) / Lp;
               ul_modL = (8 * (Ip-1)) % Lp;
            }
            ul_data = ul_modL & 0xFFF;
            ul_data |= ((ul_divL & 0xFFF ) << 16);
            // write to   ZEP_PRAM_ZIR_NL_REL0_LP0_ADDR
            ul_addr = ul_RegBaseAddr + ZIR_NL_REL0_OFFSET;
            WriteCoreReg(ul_addr, ul_data);
         }



      //ZIR_DMETRIC0_OFFSET (ZEP_PRAM_ZIR_DMETRIC_CTRL_LPx_ADDR)
      //Counter to store codeword byte locations in the DMETRIC RAM for LP.
      //Initialize to (8*(D-ceil(L/I))) % L, if LP has dummy bytes,
      //or to 0 oth-erwise.

         if (us_dummyBytes && us_Iblk)
         {
            ceil_DoverI = (us_D + us_Iblk -1 )/us_Iblk;
            ul_divL = (8 * (Dp- ceil_DoverI))/Lp;
            ul_modL = (8 * (Dp- ceil_DoverI)) % Lp;
            ul_data = ul_divL <<16;
            ul_data |= (7 + ul_modL);
         }
         else
            ul_data =7;
         ul_addr = ul_RegBaseAddr + ZIR_DMETRIC0_OFFSET;
         WriteCoreReg(ul_addr, ul_data);
      }
      //skip ZEP_PRAM_ZIR_DMETRIC0_LP1_ADDR

      //ZIR_DMETRIC_CTRL_OFFSET(ZEP_PRAM_ZIR_DMETRIC_CTRL_LPx_ADDR)
      if ( us_Iblk)
         ul_data = us_D % us_Iblk;
      else
         ul_data = 0;

      ul_data <<= 24;
      ul_data |= (us_dummyBytes << 20);
      ul_data |= 1 << 16 ; // use least reliable for boundary byte.
      ul_addr = ul_RegBaseAddr + ZIR_DMETRIC_CTRL_OFFSET;
      WriteCoreReg(ul_addr, ul_data);
      //skip ZEP_PRAM_ZIR_DMETRIC_CTRL_LP1_ADDR
   } //for(s_Lp = 0; s_Lp < pt_Config->s_Nlp; s_Lp++)

      //IR_LPBITS_OFFSET(ZEP_PRAM_ZIR_LPBITS_LP0_ADDR_
      WriteCoreReg(ZEP_PRAM_ZIR_LPBITS_LP0_ADDR, pt_Config->s_Lp[LP0_DATA_PATH]) ;
      WriteCoreReg(ZEP_PRAM_ZIR_LPBITS_LP1_ADDR, pt_Config->s_Lp[LP1_DATA_PATH]) ;


      //ZR_CW_COUNT_OFFSET
      //ZR_FEC_CNT_OFFSET
      //ZR_UNCORR_CW0_OFFSET
      //ZR_UNCORR_CW1_OFFSET
      //zero(these are counters set by the HW.)

#ifdef VR9_ERASURE
   #define WB_SCORE1 (0)
      // ZEP_PRAM_ZR_WB_SCORE_CTL_LPx_ADDR
      ul_data =  0x4040000;
      // XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start_End)
      // Remove old complex condition to easily understand the code
      //XDSLRTFW-728 FIX_All_BisPlus_All_ActInpAsPerVRxMsgSpec (Start_End)
//    gft_erasure_on =  gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE;
//    if (gft_erasure_on == 0) //erasure off
//    gft_erasure_on =  gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE;
      //if (!(gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE)) //erasure off
#ifdef REIN_DBG_CODE
      if((TESTArray[Test_Erasure_HW_Block] & Test_Erasure_HW_Block_ON) == Test_Erasure_HW_Block_ON)
      {
         gft_erasure_hw_on = FALSE;                // Sriram : Test control for  Erasure block control// XDSLRTFW-2126(Start_End)
      }
#endif
      if(gft_erasure_hw_on == 0)
      {
      //erasure off
         ul_data |= 1 << 14; //14 NO_WB_SCORE
         ul_data |= 1 << 12; //12 Bypass_Metric
      }
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR, ul_data|WB_SCORE1);
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data|WB_SCORE1);

      // ZEP_PRAM_ZR_WB_SCORE2_LPx_ADDR
   // XDSLRTFW-399 ENH_DS_BisPlus_All_Enable_ErasureDecoding (Start_End)
   // Remove old complex condition to easily understand the code
//    if (gft_erasure_on == 1) //erasure on
      //if (gs_DSL_EDcontrol & ERASURE_DECODING_ENABLE) //erasure on
      if(gft_erasure_hw_on == TRUE)
      {
      //erasure on
         if (gt_RxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_R>0)
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR, gs_wb_maxscore);
         else
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR, 0xFFFF);

         if (gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_R>0)
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, gs_wb_maxscore);
         else
            WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, 0xFFFF);
      }
      else
      {
         //erasure off
         // ul_data = 0x0FFF;
         ul_data = (uint32) (255* pt_Config->s_Rp[LP0_DATA_PATH]/2)+1; //(use for HD emulation)
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR , ul_data);
         ul_data = (uint32) (255* pt_Config->s_Rp[LP1_DATA_PATH]/2)+1;
         WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR , ul_data);
      }
#else
         // ZEP_PRAM_ZR_WB_SCORE_CTL_LPx_ADDR
      //  This register controls the Welch-Berlekamp scoring operation.
      //A reasonable default value for this register would be 0x04040000.
      ul_data =  0x4040000;
      ul_data |= 1 << 14; //14 NO_WB_SCORE
      ul_data |= 1 << 12; //12 Bypass_Metric
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP0_ADDR, ul_data);
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data);


      // ZEP_PRAM_ZR_WB_SCORE2_LPx_ADDR
      //ul_data = 0x0FFF;
      ul_data = (uint32) (255*pt_Config->us_Rp[LP0_DATA_PATH]/2)+1; //(use for HD emulation)
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP0_ADDR , ul_data);
      ul_data = (uint32) (255*pt_Config->us_Rp[LP1_DATA_PATH]/2)+1;
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR , ul_data);


#endif //VR9_ERASURE

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      //Metric must be bypassed in order for RS error detection to work properly
      ul_data =  0x4041000;
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE_CTL_LP1_ADDR, ul_data);
      WriteCoreReg(ZEP_PRAM_ZR_WB_SCORE2_LP1_ADDR, 1);

      ReadCoreReg(ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR,&ul_data);
      ul_data &= ~0x0700;
      ul_data |= 0x200;
      WriteCoreReg(ZEP_PRAM_ZR_FLAG_CTRL0_LP1_ADDR,ul_data);

      //Do we need add the dummy bytes here ?
      guc_retx_N = (uint8)gt_RxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize;
      guc_retx_K = (uint8)(guc_retx_N - pt_Config->s_Rp[LP1_DATA_PATH]); // K = N - R = H

      //XDSLRTFW-1634 (Start)
      gus_DTUSizeDS = (gt_ReTxConfigInfo.us_Q*guc_retx_K);
      gus_DTUPayloadSizeDS = (gt_ReTxConfigInfo.us_Q*guc_retx_K - gt_ReTxConfigInfo.us_V - 2); //Q.H - V - 2
      //XDSLRTFW-1223 Qrx Full Fix (Start)
      gt_ReTXParams.uc_NumPaddingBytes = ((4 - (gus_DTUPayloadSizeDS & 3)) & 3); //Padding bytes, to make DTUPayloadBytes a multiple of 4.
      WriteCoreReg(ZEP_PRAM_ZR_CRC1_LP1_ADDR, (gt_ReTXParams.uc_NumPaddingBytes << 8));
      //XDSLRTFW-1223 Qrx Full Fix (End)

      guc_retx_payload_cw1 = guc_retx_K - gt_ReTxConfigInfo.us_V - 2;// K - V -2


      // ZEP_PRAM_ZR_FRAMING_LP1_ADDR
      ul_data = guc_retx_payload_cw1 << 16; //23:16 // K - V -2
      ul_data |= gt_ReTxConfigInfo.us_V << 8; // V
      ul_data |= gt_ReTxConfigInfo.us_Q; // Q
      WriteCoreReg(ZEP_PRAM_ZR_FRAMING_LP1_ADDR, ul_data);

      //ZR_CRC_POLY0_OFFSET
      WriteCoreReg(ZEP_PRAM_ZR_CRC_POLY0_LP1_ADDR, 0); //Disable CRC0

      // Bit defintion of DREG registers:
      // 0x7DC5 (DREG_MISCRAM5_ADDR)
      //  Bit 15 - Bit 0       --> US PPE codeword buffer
      //  Bit 31 - Bit 16      --> DS PPE codeword buffer
      ul_addr = DREG_MISCRAM5_ADDR;
      ReadPpeReg(ul_addr, &ul_data);
      if (ul_data == 0)
      {
         us_PPE_INPUT_MAX = PPE_INPUT_MAX;  // If PPA used is prior to PPA 3.2, then the default value (4160) is assumed.
      }
      else
      {
         us_PPE_INPUT_MAX = (uint16)ul_data;
      }

      //Max no of DTU's to be forwarded to PPE in a symbol. "guc_maxdtuout" was set to 2 in "gdata.c"
      if ((gus_DTUPayloadSizeDS*3) < us_PPE_INPUT_MAX) // XDSLRTFW-1634 (Start_End)
         guc_maxdtuout = 3;

      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (START)
      //XDSLRTFW-1223 Qrx Full Fix (Start)
      guc_DsQRx = (uint8) (RETX_QUEUE_SIZE / (gus_DTUPayloadSizeDS+gt_ReTXParams.uc_NumPaddingBytes));
      //XDSLRTFW-1223 Qrx Full Fix (End)
      guc_DsQTx = gt_ReTxConfigInfo.us_Qtx;
      //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx (END)

      // ZEP_PRAM_ZR_R12_LP1_ADDR
      ul_data = gus_DTUPayloadSizeDS << 16; //31:16 DTU_PAYLOAD_SIZE = Q.H - V - 2
      //XDSLRTFW-1223 Qrx Full Fix (Start)
      ul_data |= (ILVB_WRPTR_TABLE_SIZE_LW << 8); //Write pointer table size
      //XDSLRTFW-1223 Qrx Full Fix (End)
      ul_data |= guc_XDTUs; // XDTUs
      WriteCoreReg(ZEP_PRAM_ZR_R12_LP1_ADDR, ul_data);
      //XDSLRTFW-1634 (End)

      // set R8 to Start Address of the RETX_Q
      //XDSLRTFW-1223 Qrx Full Fix (Start)
      gt_ReTXParams.ul_ReTXQueue_BaseAddress = RETX_QUEUE_BASE_ADDR;

     //Initialize ReTx buffer management parameters
      {
         /* Init of Free buffer list */
         for (i = 0; i < ILVB_WRPTR_TABLE_SIZE_LW; i++) {
            gt_NodeList[i].uc_NextNode = 0xFF;
            gt_NodeList[i].uc_Indx = i;

            //Add first three buffers to ILVB Write Pointer table.
            guca_InpBufList[i] = i;

            gula_ZrIlvbWrPtrTable[i] = 0;
         }

         for (i = ILVB_WRPTR_TABLE_SIZE_LW; i < ((guc_DsQRx)-1); i++) {
            gt_NodeList[i].uc_NextNode = i+1;
            gt_NodeList[i].uc_Indx = i;
         }
         gt_NodeList[i].uc_NextNode = 0xFF;
         gt_NodeList[i].uc_Indx = i;

         //First three buffers will be added to ILVB Write Pointer table. Rest will be in the free buffer list.
         gt_FreeBufList.uc_NumNodes = (guc_DsQRx-ILVB_WRPTR_TABLE_SIZE_LW);
         gt_FreeBufList.uc_Head = ILVB_WRPTR_TABLE_SIZE_LW; //Head points to the 4th Node.

         /* Init of Input Buffer list */
         guc_InpBufListIndx = 0;

         #ifdef ENABLE_THREE_NEEDLE_TEST
         guc_StartThreeNeedle = 0;
         guc_ThreeNeedleBadDTUCount = 0;
         guc_ThreeNeedleCount = 0;
         guc_CountToNextNeedle = 0;
         gus_ThreeNeedleDurationCount = 0;
         gus_ThreeNeedleDuration = 100; //Duration between 2 'three needles' - In num of DTUs.
         #endif
      }

      //WriteCoreReg(ZEP_PRAM_ZR_CRC0_LP1_ADDR, gt_ReTXParams.l_ReTXQueue_BaseAddress);

      //Initialize the WR pointer to the begining of the Queue
      WriteCoreReg(ZEP_PRAM_ZR_ILVB_WRAD_LP1_ADDR,
                  (uint32)(gt_ReTXParams.ul_ReTXQueue_BaseAddress +
                           (guca_InpBufList[0]*(gus_DTUPayloadSizeDS + gt_ReTXParams.uc_NumPaddingBytes))));

      gula_ZrIlvbWrPtrTable[0] = (uint32)(ZEP_PRAM_ZR_CRC0_LP1_ADDR);
      gula_ZrIlvbWrPtrTable[1] = (uint32)(ZEP_PRAM_ZR_OHRATE_LP1_ADDR);
      gula_ZrIlvbWrPtrTable[2] = (uint32)(ZEP_PRAM_ZR_ILVB_WRPTR_LP1_ADDR);

      for (i = 0; i < ILVB_WRPTR_TABLE_SIZE_LW; i++) {
         *((uint32 *)gula_ZrIlvbWrPtrTable[i]) =
            (uint32)(gt_ReTXParams.ul_ReTXQueue_BaseAddress +
                     (guca_InpBufList[i]*(gus_DTUPayloadSizeDS + gt_ReTXParams.uc_NumPaddingBytes)));
      }

      //Initialize LAST_DTU_WRAD to begining of Queue
      //WriteCoreReg(ZEP_PRAM_ZR_OHRATE_LP1_ADDR, gt_ReTXParams.l_ReTXQueue_BaseAddress);
      //XDSLRTFW-1223 Qrx Full Fix (End)

      // ZEP_PRAM_ZR_ILVB_RDPTR_LPx_ADDR - Init to 0
      WriteCoreReg(ZEP_PRAM_ZR_ILVB_RDPTR_LP1_ADDR, DTU_POINTERS_LW_BASE_ADDR);

      //Program FIFO1 for LP1
      //It is already initialized

      /*
      //Program FIFO1, This has to change to LP1 when we have dual latency
      // ZEP_PRAM_ZR_FIFO_BASE0_LP0_ADDR (used for LP0)
      ul_data = ZEP_RAM_RX_LP0_OHFIFO1_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
      ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << 19; //31:18 FIFO_Size
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_BASE1_LP0_ADDR, ul_data);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_PTRS1_LP0_ADDR, 0);
      WriteCoreReg(ZEP_PRAM_ZR_FIFO_CNST1_LP0_ADDR, 0);
      */
   } //if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)




   //ZEP_REG_ZR_CONFIG_ADDR - done at start

   ///////////////////////////////////////////
   // GLOBAL REGISTERS INITIALIZATION START //
   ///////////////////////////////////////////

   //ZEP_REG_ZR_PMS_SIZE_ADDR
   //ZEP_REG_ZR_DT_SIZE_ADDR


   if ((pt_Config->s_Nlp < 2) && (pt_Config->s_Lp[LP1_DATA_PATH] > 0))
   {
      //g.dmt.fast
      ul_data  = (uint32)(((pt_Config->s_Lp[LP1_DATA_PATH] >> 3) << 16) | 0);
   }else
   {
      //adsl2/+, g.dmt.interleave
      ul_data  = (uint32)(((pt_Config->s_Lp[LP1_DATA_PATH] >> 3) << 16) | (pt_Config->s_Lp[LP0_DATA_PATH] >> 3));
   }

   WriteCoreReg(ZEP_REG_ZR_PMS_SIZE_ADDR, ul_data);
   WriteCoreReg(ZEP_REG_ZR_DT_SIZE_ADDR,  ul_data);

   // save data transfer size for showtime processing
// gsa_RxDTSize[LP0_DATA_PATH] = us_L >> 3;
// gsa_RxDTSize[LP1_DATA_PATH] = 0;


   //ZEP_REG_ZR_QTDTB_CONFIG_LP0_ADDR - done with right befre showtime
   //ZEP_REG_ZR_QTDTB_CONFIG_LP1_ADDR
   //ZEP_REG_ZR_QTDTB_CONFIG_LP2_ADDR
   //ZEP_REG_ZR_QTDTB_ADDR_LP01_ADDR   - zero
   //ZEP_REG_ZR_QTDTB_ADDR_LP2_ADDR - not used

   //ZEP_REG_ZR_DTB_OFFSET_ADDR
   WriteCoreReg(ZEP_REG_ZR_DTB_OFFSET_ADDR, (ZEP_ILV_RAM_RXDTB_OFFSET<<16)|ZEP_ILV_RAM_RXDTB_OFFSET); // This is a LW address,
   //ZEP_REG_ZR_QTSCORE_ADDR        - zero - written by QT
   WriteCoreReg(ZEP_REG_ZR_QTSCORE_ADDR, (gs_Dmetric_WP<<16));
   //ZEP_REG_ZR_ERR_STAT_ADDR       - read

   FillCoreBuf32((uint32)ZEP_ILV_RAM_DMET_ADDR, 0xFFFFFFFF, 256);
}


void ClearRxZephyrRegs(void)
{
   //zero out pram before RxDataPumpSetup.
   FillCoreBuf32(ZEP_PRAM_RX_LP0_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_RX_LP1_START_ADDR, 0, ZEP_REG_RX_PRAM_SIZE);
}

uint16 Find_Pmd_Step_RXDP(uint16 s_D, uint16 s_I)
{
   int16 i=1;
   int32 l_temp = 0;

   for (i=1; i<s_I;i++)
   {
      l_temp +=  s_D;
      while ( l_temp >=  s_I)
         l_temp -= s_I;

      if (l_temp == 1) break;

   }

   return (i);
}

//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
int16 gs_CodeSwapSectionSaved = -1;

void LoadRxZepMicroCode(void)
{
   uint32 ul_RegBaseAddr = 0, ul_MicroCode_ToAddr = 0;
   int32 *pla_MicroCode_fromAddr = NULL;
   int16 i, j;
   FlagT ft_CopyUcode = FALSE;

   switch (gs_RxDataPumpLoadState)
   {
         case RX_ZEP_FC_LOADING_LP0_UCODE:
         if (( gl_SelectedMode & (MODE_ADSL2)  ))
         {
            // ADSL2 framing mode
            pla_MicroCode_fromAddr = (int32 *)(void *)fci_prog_rx_adsl2_2bc_ibits;
         }
         else
         {
            // ADSL1 framing mode
            if ( gt_rx_config.s_Lp[LP0_DATA_PATH]>0 )
               pla_MicroCode_fromAddr = (int32 *)(void *)fci_prog_rx_gdmt3_lp0;
            else
               pla_MicroCode_fromAddr = (int32 *)(void *)fci_prog_rx_gdmt3_lp1;
         }

         ul_MicroCode_ToAddr = ZEP_RAM_RX_LP0_UCODE_ADDR;
         ul_RegBaseAddr = ZEP_PRAM_RX_LP0_START_ADDR;
         ft_CopyUcode = TRUE;
         if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
         {
            gs_RxDataPumpLoadState = RX_ZEP_FC_CODESWAP_LP1_UCODE;
         }
         else
         {
            gs_RxDataPumpLoadState = RX_ZEP_FC_LOADING_UCODE_DONE;
         }
            break;

        case RX_ZEP_FC_CODESWAP_LP1_UCODE:
         if (gs_CodeSwapStatus == CODESWAP_IDLE)
         {
            //save the present content of gs_CodeSwapSection and restore the value once after LP1 ucode
            //was overlayed.
            gs_CodeSwapSectionSaved = gs_CodeSwapSection;
            gs_CodeSwapSection = CSPAGE_BIS_ZEP_RX_RETX_LP1_UCODE;
            gs_CodeSwapStatus = CODESWAP_START;

               gs_RxDataPumpLoadState = RX_ZEP_FC_WAIT_FOR_LP1_UCODE;
         }

            break;

        case RX_ZEP_FC_WAIT_FOR_LP1_UCODE:
         if (gs_CodeSwapStatus == CODESWAP_IDLE)
         {
            //restore the saved content of gs_CodeSwapSection
            gs_CodeSwapSection = gs_CodeSwapSectionSaved;

            pla_MicroCode_fromAddr = (int32 *)(void *)fci_prog_rx_adsl2_retx_lp1;

                ul_RegBaseAddr = ZEP_PRAM_RX_LP1_START_ADDR;

                ul_MicroCode_ToAddr = ZEP_RAM_RX_LP1_UCODE_ADDR;

            gs_RxDataPumpLoadState = RX_ZEP_FC_LOADING_UCODE_DONE;
                ft_CopyUcode = TRUE;
         }

            break;

   }

    if (ft_CopyUcode)
    {
      uint32 ul_data, ul_addr;
      t_microcode_header *pt_header;
      uint32 ul_MicroCode_ToAddr_InLW;

        ul_MicroCode_ToAddr_InLW = ul_MicroCode_ToAddr >> 2;
        pt_header = (t_microcode_header*)(void *)pla_MicroCode_fromAddr;
        //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
        //Load Rx Microcode version number
        gusa_FW_version_number[3] = (uint16)(pt_header->version & 0xFFFF); //XDSLRTFW-3364 (Start_End)


        // ZEP_PRAM_ZR_FLAG_CTRLx_LPx_ADDR
        WriteCoreReg((ul_RegBaseAddr+ZR_FLAG_CTRL0_OFFSET), pt_header->flags0);
        WriteCoreReg((ul_RegBaseAddr+ZR_FLAG_CTRL1_OFFSET), pt_header->flags1);

        // ZEP_PRAM_ZR_UPROC_ENA_LPx_ADDR
        WriteCoreReg((ul_RegBaseAddr+ZR_UPROC_ENA_OFFSET), pt_header->uproc_ena);

        // Write to ZEP_PRAM_ZR_UPROCxy_BASE_LPx_ADDR, where xy = 01, 23, 45, 67, 89
        {
            ul_addr = ul_RegBaseAddr+ZR_UPROC01_BASE_OFFSET;

            for(i=0; i<NUM_OF_UPROCESSORS; i++)
            {
                ul_data = ul_MicroCode_ToAddr_InLW + (pt_header->engine[i]).base;
                WriteCoreReg(ul_addr, ul_data);
                if (i == 4)
                {
                    ul_addr = ul_RegBaseAddr+ZR_UPROC5_BASE_OFFSET_35B;
                }
                else
                {
                    ul_addr += 4;
                }
            }

        }

        // ZEP_PRAM_ZR_UPROC_INT_LPx_ADDR - Initialize to 0.

        // Write to ZEP_PRAM_ZR_UPROCy_STATEx_LPx_ADDR, y=0,..9, x=0,..,4
        {
            ul_addr = ul_RegBaseAddr + ZR_UPROC0_STATE0_OFFSET;

            //Loop through all micro-processors (total of 9)
            for(i=0; i<NUM_OF_UPROCESSORS; i++)
            {
                for(j=0; j<NUM_OF_UPROC_STATES; j++)
                {
                    WriteCoreReg(ul_addr, pt_header->engine[i].state[j]);
                    ul_addr += 4;
                }
            }
        }

        // Now Copy down microCode.
        {
            void *ptr_mcode;

            //Compute the number of 32-bit words in the header
            i = sizeof(t_microcode_header)/4;

            //Point to the first word following the header
            ptr_mcode = (void *) &pla_MicroCode_fromAddr[i];

            //Load micro-code
            ul_addr = ZEP_RAM_IIBRAM_ADDR + ul_MicroCode_ToAddr;
            WriteCoreBuf32(ul_addr, (int16 *)ptr_mcode, (uint16)pt_header->total_lines);
        }
    }

}
//XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
