/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: datapumpsetup_tx.c
*
*   This file contains engine interface functions to initialize cores
*   for showtime TX path operations.
*
*-------------------------------------------------------------------------------
*/
//*-------------------------------------------------------------------------------//
// Datapumpsetup_tx.c
//
// History
//
// 26/08/2011 Sriram Shastry : Add support for PTM transfer mode (in addition to ATM mode which is normally used in ADSL).
// This includes support in G.HS to indicate PTM support and evaluate CO response regarding possible PTM support
// Interface towards PPE engine -> Exchange of data-> reading of TC status counters from PPE engine and forwarding them to the
// related CMVs such that API can read them
// This feature is contolled via
// cnfg 0 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// cnfg 2 0 2  // 1 : PTM 2: ATM 3: PTM+ATM
// Default : ATM mode
// Grep for XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
//
// 12/01/2012 Kannan: Reconfig Iridia QT to NSC Tx as 32 tones to do the oversampling
//             in showtime for data symbols, selected option (02 << 11) in
//                    IRI_QT_REG_TX_MISC_ADDR to mimic the training equivalent as we
//                    do in the FW statestc.c
//                    Grep for PERF_US_T1413_T1&CNXT_64ptIFFT
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//*-------------------------------------------------------------------------------//

#include "common.h"
#include "gdata.h"
#include "LL_IOf.h"
#include "memrymap.h"
#include "gdata_bis.h"
#include "gdata.h"
#include "datapumpsetup_tx.h"
#include "IRI_Iof.h"
#include "cmv.h"
#include "tone_ord.h"
#include "mul.h"
#include "dsp_op2.h"
#include "fifo.h"
#include "ALP_Iof.h"
#include "IRI_IOf_tables.h"
#include "IRI_Iof.h"
#include "ZPH_Iof.h"
#include "gdata_dmt.h"
#include "T1413.h"
#include "version.h"

#ifdef PPE_ENGINE
#include "ppe_memmap.h"
#include "mul.h"
int16 CalcDataBytesPerSymbol(uint8 uc_bc);
#endif //PPE_ENGINE




void SetUpTxTonesRegister(uint16 us_MinToneIndex, uint16 us_MaxToneIndex);
uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I);

// move these later to a data file.
uint32 gula_txILVBaseAddr[2] = {ZEP_ILV_LP0_BASE, ZEP_ILV_LP1_BASE };
uint32 gula_rxILVBaseAddr[2] = {ZEP_DILV_LP0_BASE, ZEP_DILV_LP1_BASE};
uint16 gusa_txFifoExt[2] = {2 ,2 };
uint16 gusa_rxFifoExt[2] = {2 ,2 };

uint32 PSCRAM32 = 0x00420000;
//#define PSCRAM32 (0x00420000)

#define HDLC_FLAG (0x7e);




/*
*-------------------------------------------------------------------------------
*
*  Prototype: int16 GetFifoReadWriteStep(int16 s_D, int16 s_N)
*
*  This function returns "read-step" or "write-step" - # of FIFO's to be skipped
*  between reads (ILVB to TxDTB) or writes (RxDTB to DILVB), which is uniquely
*  determined by interleave depth (D) and codeword size (N).
*
*  Input Arguments:
*     s_D: interleave depth
*     s_N: actual codeword size in bytes
*
*  Output Arguments:
*
*  Returns:
*     i s.t. i*D mod N == 1
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

static int16 GetFifoReadWriteStep(int16 s_D, int16 s_N)
{
   int16 i, s_odd_cw;
   int32 l_temp;

   s_odd_cw = (s_N | 0x1);
   for (i=1;i<s_odd_cw;i++) {
      // l_temp = i*D mod N
      MULS16(l_temp, i, s_D);
      while (l_temp > s_odd_cw)
         l_temp -= s_odd_cw;
      if (l_temp == 1) break;
   }

   return (i);
}

/*
*-------------------------------------------------------------------------------
*
*  Prototype: void TxDataPumpSetUp(void)
*
*  This function initializes cores for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

// gs_TxDataPumpLoadState
#define TX_CONFIG_TPS_ALP     (0)
#define TX_CONFIG_TPS_ELE     (1)
#define TX_CONFIG_PMS_ZEP_FC  (2)
#define TX_CONFIG_PMS_ZEP_ILV (3)
#define TX_CONFIG_PMD_IRI_QT  (4)
#define TX_CONFIG_PMD_LOAD_BAT   (5)
#define TX_CONFIG_PMD_LOAD_GST   (6)
#define TX_CONFIG_PMD_LOAD_TRT   (7)
#define TX_CONFIG_PMD_LOAD_EGT  (8)
#define TX_CONFIG_PMD_IRI_QTP   (9)
#define TX_CONFIG_CORE_START  (TX_CONFIG_TPS_ALP)
#define TX_CONFIG_CORE_DONE      (TX_CONFIG_PMD_LOAD_TRT+1)

void TxDataPumpSetUp(void)
{

    // initialize gs_TxDataPumpLoadState
   if (guc_TxDataPumpState == TRAINING_WAITING) {
      gs_TxDataPumpLoadState = TX_CONFIG_CORE_START;
      guc_TxDataPumpState = TRAINING_IN_PROGRESS;
   }

   // initialize cores one by one
   // make sure each core initialization is within MIPS budget for TC task
   switch (gs_TxDataPumpLoadState) {

   case TX_CONFIG_TPS_ALP:
#ifdef PPE_ENGINE
      // Configure PPE interface registers
      ConfigurePPETxPath();
#else
      // Configure ALP interface registers
      ConfigAlphaeusTxPath();
#endif
      gs_TxDataPumpLoadState = TX_CONFIG_PMS_ZEP_FC;
      break;

   case TX_CONFIG_PMS_ZEP_FC:
      ConfigZephyrFcTxPath();
      gs_TxDataPumpLoadState = TX_CONFIG_PMD_IRI_QT;
      break;

   case TX_CONFIG_PMD_IRI_QT:
      ConfigIridiaQtTxPath();
      gs_TxDataPumpLoadState = TX_CONFIG_PMD_LOAD_BAT;
      break;

   case TX_CONFIG_PMD_LOAD_BAT:
      LoadTxBitAllocationTable();
      gs_TxDataPumpLoadState = TX_CONFIG_PMD_LOAD_GST;
      break;

   case TX_CONFIG_PMD_LOAD_GST:
      LoadTxGainScaleTable();
      gs_TxDataPumpLoadState = TX_CONFIG_PMD_LOAD_TRT;
      break;

   case TX_CONFIG_PMD_LOAD_TRT:
      LoadTxToneReorderTable();
        gs_TxDataPumpLoadState = TX_CONFIG_PMD_LOAD_EGT;

    case TX_CONFIG_PMD_LOAD_EGT:
        LoadTxExtendedGainTable();
        gs_TxDataPumpLoadState = TX_CONFIG_PMD_IRI_QTP;

    case TX_CONFIG_PMD_IRI_QTP:
        ConfigIridiaQtpTxPath();
      gs_TxDataPumpLoadState = TX_CONFIG_CORE_DONE;
      guc_TxDataPumpState = TRAINING_DONE;
      break;
   }

}

#ifdef ENABLE_ALPHAEUS
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigAlphaeusTxPath(void)
*
*  This function initializes Alphaeus core for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigAlphaeusTxPath(void)
{

   uint16 us_CB_Start, us_CB_NPages;
   uint32 ul_data;

   // all global registers are cleared in InitAlphaeus()

   // A_CVER
   // read-only

   // A_UTP_STAT
   // cleared

   // A_INT_STAT
   // write 1 to clear
   WriteCoreReg(ALP_INT_STAT_ADDR, (uint32)0x03030303);

   // A_INT_MASK
   // cleared

   // A_DEBUG1
   // cleared

   // A_DEBUG2
   // cleared

   // A_DCP_CONFIG
   // ????

   // A_DCP_STAT
   // cleared

   // all TX registers are cleared in InitAlphaeus()

   // AT_CONFIG
   ul_data =
      (uint32)(0x0) // TXIFMODE_BC0 (0: Utopia mode, 1: Utopia bypass mode, 2: DSP intercept mode)
      | (uint32)(0x0 << 2) // TXIFMODE_BC1 (0: Utopia mode, 1: Utopia bypass mode, 2: DSP intercept mode)
      | (uint32)(0 << 4); // TX_PSTM_MODE (1: enable Pseudo STM mode)
   WriteCoreReg(ALP_T_CONFIG_ADDR, ul_data);

   // AT_CB_STAT
   // cleared

   // AT_CB_CFG_BC0
   us_CB_Start = 0;

   // for now we give as many cell buffers as possible to the first bearer channel.
   // for multiple bearer channels we need to restore the logic that partitions available
   // cell buffers between the bearer channels.
   if ((OPTNArray[OPTN_ATMNumCellConfig] & OPTN_TX_BC0_NUM_CELL_PAGES) == 0)
      us_CB_NPages = MAX_NUM_TX_CELL_BUFFERS;
   else
      us_CB_NPages = (OPTNArray[OPTN_ATMNumCellConfig] & OPTN_TX_BC0_NUM_CELL_PAGES) >> 8;
   if (us_CB_NPages > MAX_NUM_TX_CELL_BUFFERS)
      us_CB_NPages = MAX_NUM_TX_CELL_BUFFERS;

   ul_data =
      (uint32)(us_CB_Start & 0x0FFF)
      | ((uint32)(us_CB_NPages & 0x7F) << 16);
   WriteCoreReg(ALP_T_CB_CFG_BC0_ADDR, ul_data);

   // AT_CB_CFG_BC1
   us_CB_Start = (us_CB_NPages * CBPAGE_SIZE) >> 1;

   us_CB_NPages = NUM_TX_CBPAGE - us_CB_NPages;

   ul_data =
      (uint32)(us_CB_Start & 0x0FFF)
      | ((uint32)(us_CB_NPages & 0x7F) << 16);
   WriteCoreReg(ALP_T_CB_CFG_BC1_ADDR, ul_data);

   // AT_PCNTL_BC0
   ul_data =
      (uint32)1 // SCRMENA
      | ((uint32)0 << 1) // TPMODE
      | ((uint32)0 << 2) // BYTE_FLIP (1: disable)
      | ((uint32)0 << 3); // NO_IDLE_HEAD
   if ((STATArray[STAT_Mode1] & STAT_ConfigMode_ETSI_AnnexC) && (gs_fe_T1413_VendorID == T1413_ALA_ID))
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
   {
      ul_data &= ~(0x4);   //BYTE_FLIP (0: enable)
   }
   else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   WriteCoreReg(ALP_T_PCNTL_BC0_ADDR, ul_data);

   // AT_IDLE_BC0
   ul_data =
      (uint32)TX_IDLE_CELL_PAYLOAD;
   WriteCoreReg(ALP_T_IDLE_BC0_ADDR, ul_data);

   // AT_CELL_CNT_BC0
   // cleared

   // AT_IDLE_CNT_BC0
   // cleared

   // AT_PCNTL_BC1
   ul_data =
      (uint32)1 // SCRMENA
      | ((uint32)0 << 1) // TPMODE
      | ((uint32)0 << 2) // BYTE_FLIP (1: disable)
      | ((uint32)0 << 3); // NO_IDLE_HEAD
   if ((STATArray[STAT_Mode1] & STAT_ConfigMode_ETSI_AnnexC) && (gs_fe_T1413_VendorID == T1413_ALA_ID))
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_ENABLE) //Force byte flip on
   {
      ul_data &= ~(0x4);   //BYTE_FLIP (0: enable)
   }
   else if (OPTNArray[OPTN_ATMAddrConfig] & OPTN_ATM_BYTEFLIP_DISABLE) //Force byte flip off
   {
      ul_data |= 0x4;   //BYTE_FLIP (1: disable)
   }
   WriteCoreReg(ALP_T_PCNTL_BC1_ADDR, ul_data);

   // AT_IDLE_BC1
   ul_data =
      (uint32)TX_IDLE_CELL_PAYLOAD;
   WriteCoreReg(ALP_T_IDLE_BC1_ADDR, ul_data);

   // AT_CELL_CNT_BC1
   // cleared

   // AT_IDLE_CNT_BC1
   // cleared

}
#endif //ENABLE_ALPHAEUS

#ifdef PPE_ENGINE
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigurePPETxPath(void)
*
*  This function initializes PPE engine for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*     guc_PortMode -- (I)
*     gula_DREG_AR_CFG_Cnfg[] -- (I)
*     gft_TcTypeSelected -- (I)
*-------------------------------------------------------------------------------
*/
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start)
#define PPE_EFM_MODE (3<<5)
#define PPE_BYTE_FLIP_DISABLE (2)
//XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (End)
void ConfigurePPETxPath(void)
{
   uint32 ul_data,ul_addr;
   uint8 uc_bc, uc_offset;

   for (uc_bc=0; uc_bc<(guc_PortMode+1); uc_bc++)
   {
      uc_offset = uc_bc<<2;

      //Configure bearer channel 0
      if((STATArray[STAT_ACTIVEBCLP_US] & (BC0_ACTIVE << uc_bc)))
      {
         //Configure DREG_AT_CFG0
         ul_data = gula_DREG_AT_CFG_Cnfg[uc_bc];

         if((gl_SelectedMode & (MODE_ADSL2)) && (guca_US_TransferMode_bis[uc_bc] & PTM)) //only ADSL2/2+ support PTM mode
         {
            //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(Start)
            //If EFM preemption is supported, set the corresponding bit in this register
            if(gt_HercADSL_TPS_TC_Params[uc_bc].ta_TPS_TC_Type[0].uc_TPSTCoptions & 1)
            {
            //if(guc_TPSTCoptions & 1)
               ul_data |= (1<<7);
            }

            //If EFM short packets are supported, set the corresponding bit in this register
            if(gt_HercADSL_TPS_TC_Params[uc_bc].ta_TPS_TC_Type[0].uc_TPSTCoptions & 2)
            {
            //if(guc_TPSTCoptions & 2)
               ul_data |= (1<<8);
            }

            ul_data |= (PPE_EFM_MODE | PPE_BYTE_FLIP_DISABLE );
            //XDSLRTFW-284 Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping(End)
            //Set the TX TC mode to EFM TC mode
            ul_data |= (3<<5);   //Sriram : Not required , already initialized above
         }


         else  //ATM mode
         //if (((gl_SelectedMode & (MODE_ADSL2) && (guca_DS_TransferMode_bis[s_bc] == ATM)) || ((gl_SelectedMode & (MODE_ADSL1) && (gft_TransferMode===ATM)))
         {
            //Enable byte flip (seting bit 1 to 0)
                if (gft_disableAlphaeusTxByteFlip)
               ul_data  |= (1<<1);
            else
                    ul_data  |= (0<<1);
            //Enable scrambling
            ul_data |= (1<<2);
         }

         WritePpeReg((DREG_AT_CFG0_ADDR + uc_offset), ul_data);

         //DREG_AT_IDLEx
         if(   (guca_US_TransferMode_bis[0] & PTM)==0 )
            ul_data = 0x6A;
         else
            ul_data = 0;
         WritePpeReg((DREG_AT_IDLE0_ADDR + uc_offset), ul_data);

         //DREG_Bx_LADR
         //Compute the average number of bytes per DMT symbol
         ul_data = (uint32)CalcDataBytesPerSymbol(uc_bc);
         WritePpeReg((DREG_B0_LADR_ADDR + uc_offset), ul_data);
      }
      else //if((STATArray[STAT_ACTIVEBCLP_US] & (BC0_ACTIVE << uc_bc)))
      {
         //Clear all registers
         WriteCoreReg((DREG_AT_CFG0_ADDR + uc_offset), 0);
         WriteCoreReg((DREG_AT_IDLE0_ADDR + uc_offset), 0);
         WritePpeReg((DREG_B0_LADR_ADDR + uc_offset), 0);

      } //if((STATArray[STAT_ACTIVEBCLP_US] & (BC0_ACTIVE << uc_bc)))

      //Clear all the count registers
      //WriteCoreReg((DREG_AT_CELL0_ADDR + uc_offset), 0);
      //Read the number of cells  -------------
      ul_addr = DREG_AT_CELL0_ADDR + uc_offset;
      ReadPpeReg(ul_addr, &gula_DREG_AT_CELL_Shadow[uc_bc]);

      //WriteCoreReg((DREG_AT_IDLE_CNT0_ADDR + uc_offset), 0);
      //Read the number of Idle cells  -------------
      ul_addr = DREG_AT_IDLE_CNT0_ADDR + uc_offset;
      ReadPpeReg(ul_addr, &gula_DREG_AT_IDLE_CNT_Shadow[uc_bc]);


   } //for (s_bc=0; s_bc<(guc_PortMode+1); s_bc++)
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: int16 CalcDataBytesPerSymbol(uint8 uc_bc)
*
*  This function computes the average number of bytes per DMT symbol sent
*  from PPE to DFE.
*
*  Input Arguments:
*     uc_bc -- bearer channel number
*
*  Output Arguments:
*
*  Returns:
*     the average number of payload bytes per DMT symbol for a given bearer channel
*
*  Global Variables:
*     gt_rx_TPS_Map -- (I)
*     gus_ModemOperationMode_Status -- (I)
*
*     gt_tx_config -- (I)
*-------------------------------------------------------------------------------
*/
int16 CalcDataBytesPerSymbol(uint8 uc_bc)
{
   int16 s_P, s_lp;
   Config_t *pt_Config;
   int16 s_Tp, s_Mp, s_Nfecp, s_Bp;
   uint16 us_Lp, us_temp;
   uint32 ul_Acc, ul_Acc1;

   if (STATArray[STAT_ACTIVEBCLP_US] & (BC0_ACTIVE << uc_bc))
   {
      if (gt_TxShowTimeVars.t_BCParms[uc_bc].sa_BC_LPath == LP1_DATA_PATH)
         s_lp = LP1_DATA_PATH;
      else
         s_lp = LP0_DATA_PATH;
   }
   else
      return(-1);

   // map the RX parameter structure
   pt_Config = &gt_tx_config;

   // Number of mux data frames in an OH sub-frame
   s_Tp = pt_Config->s_Tp[s_lp];

   // number of mux data frames in a codeword
   s_Mp = pt_Config->s_Mp[s_lp];

   // number of bits transmitted per data symbol
   us_Lp = pt_Config->s_Lp[s_lp];

   // size of codeword in bytes
   s_Nfecp = gt_TxShowTimeVars.t_FrameParms[s_lp].s_CodewordSize;

   // number of octets from bearer channel per MDF
   s_Bp = pt_Config->sa_Bpn[s_lp][uc_bc];

   if (gl_SelectedMode & (MODE_ADSL2))
   {
      // calculate net data rate for bearer channel 0
      // scale by 16 to preserve the precision
      us_temp = (uint32)((s_Bp<<4) + ((s_Tp-1)<<4)/s_Tp );
   }
    else
    {
        // calculate net data rate for bearer channel 1
        us_temp = (uint32)(s_Bp<<4) ;
    }

   // number of payload octets per data symbol, denoted by s_P,  is calculated by
   // sP = s_Bp*Mp/Sp, where Sp = 8*Nfecp/Lp
   // sP = s_Bp*Mp*Lp/(8*Nfecp) = (us_temp>>4)*Mp*Lp/(8*Nfecp) = (us_temp*Mp*Lp/Nfecp)>>7

   //Compute ul_Acc = ul_temp*ul_Lp
   MULU16(ul_Acc, us_temp, us_Lp);

   //right shift by 4 to undo the previous scale up, also avoid overflow by the next multiply
   ul_Acc = (ul_Acc + (1<<3))>>4;            //where adding (1<<3) is for rounding

   //ul_Acc1 = ul_Acc * s_Mp
   MULS32x16(ul_Acc1, ul_Acc, s_Mp);

   //Compute the final average payload bytes per DMT symbol
   s_P = ((ul_Acc1 / s_Nfecp) + (1<<2))>>3;     //where adding (1<<2) is for rounding


   return(s_P);

} //Flag CalcDataBytesPerSymbol(uint8 uc_bc)

#endif //PPE_ENGINE
/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigIridiaQtTxPath(void)
*
*  This function initializes Iridia-QT core for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigIridiaQtTxPath(void)
{
   FlagT ft_TcmFlag;
   uint32 ul_data;
   int16 s_Tx_NumLogical_Tones,s_Tx_Num0bits_Tones,s_Tx_NumGT1bits_Tones;
    //==============================================
    // Global Registers
    //==============================================
    //IT_ENABLE
    //IR_ENABLE
    //IR_NSC, set during initialization/training
    //IR_PRBS_CTRL
    //IR_PRBS0
    //IR_PRBS1
    //I_ABGT_OFFSET

    //==============================================
    // TXPRAM
    //==============================================

   // IT_CONFG
   // set in initialization

   // IT_TCM_CTRL
   ul_data = (uint32)((gus_Tx_Tcm_Num1bits/2) & 0x0FFF) << 13;
   if (gft_ModemType == G_DMT_BIS)
      ft_TcmFlag = gft_TcmFlag_bis_US;
   else
      ft_TcmFlag = gft_TcmFlag;
   if (ft_TcmFlag == TRUE)
      ul_data |= MASK_BIT25;

    ul_data |= gs_TxNumTones -1;
   WriteCoreReg((uint32)IRI_QT_REG_TX_TCM_CTRL_ADDR, ul_data);

   // IT_MISC

    // IT_ACT_ADDR
   //hardware restriction in the transmit path that when the BAT has an odd number of 1-bit tone pairs.

   //calculate the number of tones with bi=0 and with bi>0
    s_Tx_NumLogical_Tones = gs_TxNumTones;
    s_Tx_Num0bits_Tones =  s_Tx_NumLogical_Tones - gs_TxNumLoadedTones;
    s_Tx_NumGT1bits_Tones = gs_TxNumLoadedTones - gus_Tx_Tcm_Num1bits;

   if ((ft_TcmFlag == TRUE)&&((s_Tx_Num0bits_Tones - gft_Tx_Tcm_X0_YGT1) & 0x1))
      SetUpTxTonesRegister(1, (uint16)(gs_TxNumTones -1));
   else
      SetUpTxTonesRegister(0, (uint16)(gs_TxNumTones -1));

   // IT_LP0_BITS
   ul_data = (uint32)gt_tx_config.s_Lp[LP0_DATA_PATH];
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP0_BITS_ADDR, ul_data);

   // IT_LP1_BITS
   ul_data = (uint32)gt_tx_config.s_Lp[LP1_DATA_PATH];
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if(gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      ul_data = DS_RRC_BITS;
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP1_BITS_ADDR, ul_data);

    // IT_LP2_BITS
   // IT_DUMMY


   // IT_LP0_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP0_BIT_FIFO_ADDR, 0);
   // IT_LP1_BIT_FIFO
   WriteCoreReg((uint32)IRI_QT_REG_TX_LP1_BIT_FIFO_ADDR, 0);


   // IT_LP2_BIT_FIFO
    // IT_PILOT
   // IT_PTINDEX
   // IT_PRBS
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_ADDR, (uint32)0x1FF); // initial PRBS LFSR state.

   // IT_PRBS_MISC
   ul_data  =
      ((uint32)1 << 3)  //1 = PRBS-modulate all zero-bit tones independent of NSSi value
      | ((uint32)8 <<  4)   // d[n] = d[n-4] xor d[n-9] -> LFSR length = 11-1 = 10
      | ((uint32)0 << 11) //  Do not Reset PRBS generator each frame, to generate random OOB for DEC adaptation
      | ((uint32)0 << 12) // Skip 0 bits at end of each symbol.
      | ((uint32)0 << 16) // Pick PRBS output from tail of LFSR
      | ((uint32)0 << 17) // 1 less than the modulo number (=10) of tones for each tone set.
      | ((uint32)0 << 24) // PRBS scrambling when 2 bit PRBS output is "00"
      | ((uint32)1 << 26) // PRBS scrambling when 2 bit PRBS output is "01"
      | ((uint32)2 << 28) // PRBS scrambling when 2 bit PRBS output is "10"
      | ((uint32)3 << 30); // PRBS scrambling when 2 bit PRBS output is "11"
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_MISC_ADDR, ul_data);

   // IT_PRBS_POLY
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_POLY_ADDR, (uint32)0x8); // d[n] = d[n-4] xor d[n-9]


    //IT_PRBS_DATA0
   WriteCoreReg((uint32)IRI_QT_REG_TX_PRBS_DATA0_ADDR, 0);
   //PERF_US_T1413_T1&CNXT_64ptIFFT (START - END)
   if ((gft_TxImages) || (gft_IFFT64_T1413_TxImages == 1))   //program "IRI_QT_REG_TX_MISC_ADDR" based on gft_TxImages flag.
   {
   ul_data  =
          ((uint32)0 << 5)    // Diable PRBS_GEN
      | ((uint32)0 << 6)    // always 0 for adsl
        | ((uint32)2 << 11)   // 00: normal mode = zero fill upper tones
                           // 01: Generate first complex conjugate image, then zero-fill for 64pt emulation
        | ((uint32)0 << 13);  // processing order LP1 then LP0, then LP2 (adsl mode)
   }
   else
   {
      ul_data  =
          ((uint32)0 << 5)    // Diable PRBS_GEN
      | ((uint32)0 << 6)    // always 0 for adsl
        | ((uint32)0 << 11)   // 00: normal mode = zero fill upper tones
                           // 01: Generate first complex conjugate image, then zero-fill for 64pt emulation
        | ((uint32)0 << 13);  // processing order LP1 then LP0, then LP2 (adsl mode)
   }

    WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);

#ifndef ISDN //Only for Anx A
   //PERF_US_T1413_T1&CNXT_64ptIFFT (START)
   //Reconfig NSC Tx to 32 tones, since Iridia QT will be
   //used to send mirrored complex conjugate images in showtime
   //In order to do the oversampling in showtime by Iridia QT,
   //NSC Tx must be configured to properly.
   //Iridia QT uses NSC Tx to do the oversampling.
   if (gft_IFFT64_T1413_TxImages == 1)
   {
      // IT_CONFIG register, NSC_TX BITS
      ReadCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, &ul_data);
      //mask out the NSC_TX bits(0:2); 0 => NSC_TX = 32 tones
      ul_data &= ~0x7;
      WriteCoreReg((uint32)IRI_QT_REG_TX_CNFG_ADDR, ul_data);
      gt_vrx5dfe_dsl_config.ul_QT_REG_TX_CNFG = ul_data;
   //configure NSC to 32
   }
   //PERF_US_T1413_T1&CNXT_64ptIFFT (END)
#endif //ifndef ISDN






   // DisableTxQTEncode();
   {
      // turn off trellis till showtime starts
   ResetCoreReg(IRI_QT_REG_TX_TCM_CTRL_ADDR, MASK_BIT25); //TTE

   // disable PRBS mode
   SetCoreReg(IRI_QT_REG_TX_MISC_ADDR, MASK_BIT5); //PRBS_GEN

   }
   if (gs_TxFftLength_Oversample==1024)
   {
      ReadCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, &ul_data);
      ul_data &= ~(3<<11);
      ul_data |=(1<<11);
      WriteCoreReg((uint32)IRI_QT_REG_TX_MISC_ADDR, ul_data);
   }

   // IT_PRBS_MISC
   // IT_PRBS_POLY
   // IT_PRBS_DATAx, x=0,...,7
   // IT_REF_GAIN
    // IT_NYQ_TONE_DATA

    // IT_TXCGx, x=0,...,15
    // IT_IFFZ_RNGx, x=0,1,2,...,5
    // IT_TONE_DATA
   // IT_DCI_CTRL

#ifdef ZEP_DEBUG_BLD
   //Use the FIFO3 to capture the TX scrambler input data
   if((gft_EnableFifo3Capture) && (guc_PortMode == SINGLE_PORT_MODE))
      EnableTxFifo3Capture();
#endif


}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void ConfigZephyrFcTxPath(void)
*
*  This function initializes Zephyr-FC core for showtime TX path operations.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void ConfigZephyrFcTxPath(void)
{
   uint32 l_ilvSize, l_ilv_param_m;
   int16 sa_bc_buf_sel[NUM_BEARER_CHANNELS], sa_bc_en[NUM_BEARER_CHANNELS];
   uint32 ul_data;
    uint16 us_Iblk=0, us_D=1, us_L=0, us_R=0, us_M=1,us_dummyBytes=0, us_cwsize=0 ;
   int16  s_bc;

   if (gt_tx_config.s_Lp[LP0_DATA_PATH])
   {
      us_Iblk = gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize;
      us_cwsize = gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize;
      us_D = gt_tx_config.s_Dp[LP0_DATA_PATH];
      us_L = gt_tx_config.s_Lp[LP0_DATA_PATH];
      us_R = gt_tx_config.s_Rp[LP0_DATA_PATH];
      us_M = gt_tx_config.s_Mp[LP0_DATA_PATH];
      us_dummyBytes = !(gt_TxShowTimeVars.t_FrameParms[LP0_DATA_PATH].s_CodewordSize & 1); // 1 dummy if cw is even
   }
   else
   {
      us_Iblk = gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize;
      us_cwsize = gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize;
      us_D = gt_tx_config.s_Dp[LP1_DATA_PATH];
      us_L = gt_tx_config.s_Lp[LP1_DATA_PATH];
      us_R = gt_tx_config.s_Rp[LP1_DATA_PATH];
      us_M = gt_tx_config.s_Mp[LP1_DATA_PATH];
      us_dummyBytes = !(gt_TxShowTimeVars.t_FrameParms[LP1_DATA_PATH].s_CodewordSize & 1); // 1 dummy if cw is even
   }
//??
   for (s_bc=0;s_bc<NUM_BEARER_CHANNELS;s_bc++) {
      if ((STATArray[STAT_ACTIVEBCLP_US] & (BC0_ACTIVE << s_bc)) || gt_TxShowTimeVars.t_BCParms[s_bc].sa_BC_CChan) {
         sa_bc_en[s_bc] = 1;
         if (gt_TxShowTimeVars.t_BCParms[s_bc].sa_BC_LPath == LP1_DATA_PATH)
            sa_bc_buf_sel[s_bc] = LP1_DATA_PATH;
         else
            sa_bc_buf_sel[s_bc] = LP0_DATA_PATH;
      } else {
         sa_bc_en[s_bc] = 0;
         sa_bc_buf_sel[s_bc] = LP1_DATA_PATH;
      }
   }
//??

   ////////////////////////////////////////////////
   // Zephyr Tx GLOBAL REGISTERS INITIALIZATION  //
   ////////////////////////////////////////////////
   // ZEP_REG_ZT_FIFO_ACCESS_ADDR
   // ZEP_REG_ZT_CONFIG_ADDR

   // ZEP_REG_ZT_FIFO_ACCESS_ADDR - Init to 0
   // ZEP_REG_ZT_CONFIG_ADDR
   WriteCoreReg(ZEP_REG_ZT_CONFIG_ADDR, ZEP_PRAM_TX_START_ADDR/4); //Longword address

   // Write to IIBRAM locations at the TX_START_CONFIG location.
   ul_data = ZEP_RAM_IIBRAM_ADDR + ZEP_PRAM_TX_START_ADDR;

   WriteCoreReg(ul_data, 1);  //Number of LP, FIXME DUAL_LATENCY

   ul_data += 4;
   WriteCoreReg(ul_data, ZEP_TX_CFG_LP0_PTR/4);

   ul_data += 4;
   WriteCoreReg(ul_data, ZEP_TX_CFG_LP1_PTR/4);

   // The following ones relating to the QT interface are done later in this file.
   // ZEP_REG_ZT_PMS_SIZE_ADDR
   // ZEP_REG_ZT_DT_SIZE_ADDR
   // ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR
   // ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR
   // ZEP_REG_ZT_QTDTB_CONFIG_LP2_ADDR
   // ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR
   // ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR
   // ZEP_REG_ZT_DTB_OFFSET_ADDR
   // ZEP_REG_ZT_ERR_STAT_ADDR

   /////////////////////////////////////////////////////////////
   // Zephyr 62 Tx per Latency PATH REGISTERS INITIALIZATION  //
   /////////////////////////////////////////////////////////////

   //ZT_R0_OFFSET - not used
   //ZT_R4_OFFSET
   //ADSL2 m-code uses reg R4 for dummy byte.
   WriteCoreReg(ZEP_PRAM_ZT_R4_LP0_ADDR, us_dummyBytes);

   //ZT_R8_OFFSET - not used
   //ZT_R12_OFFSET
   //ZT_CODEWORD_OFFSET
   ul_data = ((uint32)us_M<< 24);
   ul_data |= ((uint32)us_R << 16);
   ul_data |= ((uint32)(us_cwsize - us_R)<<8);
   ul_data |= (uint32)us_cwsize;
   WriteCoreReg(ZEP_PRAM_ZT_CODEWORD_LP0_ADDR, ul_data);

   //ZT_VBC_SIZE_OFFSET
   if (gt_TxShowTimeVars.t_BCParms[0].sa_BC_LPath == LP0_DATA_PATH)
      ul_data = (uint32)gt_TxShowTimeVars.t_BCParms[0].sa_BC_Bytes; //BC0
   else
      ul_data = (uint32)gt_TxShowTimeVars.t_BCParms[0].sa_BC_Bytes; //BC0

   if (gt_TxShowTimeVars.t_BCParms[1].sa_BC_LPath == LP1_DATA_PATH)
      ul_data |= (uint32)gt_TxShowTimeVars.t_BCParms[1].sa_BC_Bytes <<16; //BC1
   else
        ul_data |= (uint32)gt_TxShowTimeVars.t_BCParms[1].sa_BC_Bytes <<16; //BC1
   WriteCoreReg(ZEP_PRAM_ZT_VBC_SIZE_LP0_ADDR, ul_data);

   //ZT_FRAMING_OFFSET
   if (( gl_SelectedMode & (MODE_ADSL2)  )) // ADSL2 framing mode
   {
      ul_data = (uint32)(gsa_tx_SEQp[LP0_DATA_PATH] );// //15:0 Max_Frm_Idx -- (1 based, no need to minus 1)
      ul_data |= ((uint32)gt_tx_config.s_Tp[LP0_DATA_PATH] << 16); //Tp
      ul_data |= 1<<24 ; // note bits 31:24 Tx_OHSwitch =1 .(check for adsl2!)
   }
   else // ADSL framing mode
      ul_data = (uint32)(TX_SYMBOLS_PER_SFRAME) ;
   WriteCoreReg(ZEP_PRAM_ZT_FRAMING_LP0_ADDR, ul_data);


   //ZT_OHRATE_OFFSET
   if (( gl_SelectedMode & (MODE_ADSL2)  )) // ADSL2 framing mode
   {
      ul_data = (uint32)1 << 16; //31:16 Max_OH
      ul_data |= 0 << 8; //15:8 Tx_OH2Rate
      ul_data |= (uint32)1; //7:0 Tx_OH1Rate
      WriteCoreReg(ZEP_PRAM_ZT_OHRATE_LP0_ADDR, ul_data);
   }

   //ZT_FLAG_CTRL0_OFFSET
   //ZT_FLAG_CTRL1_OFFSET
   //Set per m-code header.

   //ZT_CRC0_OFFSET
   //zero

   //ZT_CRC_POLY0_OFFSET
   WriteCoreReg(ZEP_PRAM_ZT_CRC_POLY0_LP0_ADDR, 0x8e); //x^8 + x^4 + x^3 + x^2 + x^0

   //ZT_CRC_CTRL0_OFFSET
   WriteCoreReg(ZEP_PRAM_ZT_CRC_CTRL0_LP0_ADDR, 0); //1:0 CRC_Len, 0 = 8-bit CRC

   //ZT_CRC1_OFFSET
   //ZT_CRC_POLY1_OFFSET
   //ZT_CRC_CTRL1_OFFSET
   //not used

   //ZT_SCR_OFFSET
   //zero
   //ZT_SCR_POLY_OFFSET
   if (gft_disableZephyrTxScrambler)
      ul_data = 0;
   else
      ul_data = PSCRAM32;  //Polynomial has degrees 23 and 18
   WriteCoreReg(ZEP_PRAM_ZT_SCR_POLY_LP0_ADDR, ul_data);

   //ZT_SCR_CTRL_OFFSET
   WriteCoreReg(ZEP_PRAM_ZT_SCR_CTRL_LP0_ADDR, 31); //4:0 SCR_Len

   //ZT_SCR_STATE_OFFSET
   //init to 0

   //ZT_DTB_CTRL_OFFSET
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      ul_data = (uint32)(ZEP_ILV_RAM_RETX_TXDTB_LP0_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
      ul_data |= ZEP_ILV_RAM_RETX_TXDTB_LP0_BASE; //11:0 DTB_Base in 32-bit words
   }
   else
   {
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)
      ul_data = (uint32)(ZEP_ILV_RAM_TXDTB_LP0_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
      ul_data |= ZEP_ILV_RAM_TXDTB_LP0_BASE; //11:0 DTB_Base in 32-bit words
   } //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START_END)

   WriteCoreReg(ZEP_PRAM_ZT_DTB_CTRL_LP0_ADDR, ul_data);

   if (gt_tx_config.s_Lp[LP0_DATA_PATH]) // ADSL2 framing mode or g.dmt.interleave
   {
      //ZEP_REG_ZT_QTDTB_CONFIG_ADDR
      //Enable latch DT_SIZES from QT.
      ul_data |= (0xC000 << 16); // 31:30 2 Latch Bits.
      WriteCoreReg(ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR, ul_data);
   }
   else //g.dmt.fast
   {
      //ZEP_REG_ZT_QTDTB_CONFIG_ADDR
      //Enable latch DT_SIZES from QT.
      ul_data |= (0xC000 << 16); // 31:30 2 Latch Bits.
      WriteCoreReg(ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR, ul_data);
   }

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (START)
   if (gt_ReTxConfigInfo.ft_ReTxOn == 1)
   {
      ul_data = (uint32)(ZEP_ILV_RAM_RETX_TXDTB_LP1_SIZE-1) << 16; //27:16 DTB_Size - actual number of words - 1
      ul_data |= ZEP_ILV_RAM_RETX_TXDTB_LP1_BASE; //11:0 DTB_Base in 32-bit words
      WriteCoreReg(ZEP_PRAM_ZT_DTB_CTRL_LP1_ADDR, ul_data);

      //ZEP_REG_ZT_QTDTB_CONFIG_ADDR
      //Enable latch DT_SIZES from QT.
      ul_data |= (0xC000 << 16); // 31:30 2 Latch Bits.
      WriteCoreReg(ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR, ul_data);
   }
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

   //ZT_DTB_PTRS_OFFSET
   //zero
   //ZT_ILVB_WRAD_OFFSET
   //ZT_ILVB_RDAD_OFFSET
   //ZT_ILVB_WRPTR_OFFSET
   //ZT_ILVB_RDPTR_OFFSET
   //not used yet (for writing to ilv buffer without interleaving.)

   //ZT_FIFO_BASE0_OFFSET
   //ZEP_PRAM_ZT_FIFO_BASE0_LP0_ADDR
   ul_data = ZEP_RAM_TX_LP0_OHFIFO0_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
   ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << 19; //25:18 FIFO_Size -1
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE0_LP0_ADDR, ul_data);

   //ZT_FIFO_PTRS0_OFFSET
   //zero
   //ZT_FIFO_CNST0_OFFSET
   //used for EOC, initialize idle byte for EOC (HDLC_FLAG)
   //23:16 FIFO_Step, set to 0
   ul_data = HDLC_FLAG;  //7:0 FIFO_CNST
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_CNST0_LP0_ADDR, ul_data);

   //ZT_FIFO_BASE1_OFFSET
   ul_data = ZEP_RAM_TX_LP0_OHFIFO1_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address
   ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_32-1) << 19; //25:18 FIFO_Size -1
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE1_LP0_ADDR, ul_data);

   //ZT_FIFO_PTRS1_OFFSET
   //zero
   //ZT_FIFO_CNST1_OFFSET
   //ZT_FIFO_BASE2_OFFSET
   ul_data = ZEP_RAM_TX_LP0_OHFIFO2_OFFSET; //17:0 FIFO_Base, the location in IIBRAM as byte address

   ul_data |= (uint32)(ZEP_RAM_OHFIFO_SIZE_6-1) << 19; //26:19 FIFO_Size -1

   WriteCoreReg(ZEP_PRAM_ZT_FIFO_BASE2_LP0_ADDR, ul_data);

   //ZT_FIFO_PTRS2_OFFSET
   //zero
   //ZT_FIFO_CNST2_OFFSET
   // used for IBITS, initialize idle byte for IBITS
   // 23:16 FIFO_Step, set to 0
   ul_data = 0xFF;  //7:0 FIFO_CNST
   WriteCoreReg(ZEP_PRAM_ZT_FIFO_CNST2_LP0_ADDR, ul_data);


   //ZT_FIFO_BASE3_OFFSET
   //ZT_FIFO_PTRS3_OFFSET
   //ZT_FIFO_CNST3_OFFSET

   //ZT_DEPTH_OFFSET
   ul_data = (uint32)us_D << 16; //D_Shadow
    ul_data |= (uint32)us_D; // D
      WriteCoreReg(ZEP_PRAM_ZT_DEPTH_LP0_ADDR, ul_data);

   //ZT_ILV_PARAMS0_OFFSET


   if (us_D <= 64 )
      us_Iblk |= 1; // make odd.
   ul_data = (uint32) Find_Pmd_Step(us_D , us_Iblk);
   ul_data <<= 16;
   ul_data |= 1<<24; //pms_step =1
   ul_data |= (uint32)(us_Iblk <<8); //7:0
   ul_data |= 4 ; //  efficient interleaver
   WriteCoreReg(ZEP_PRAM_ZT_ILV_PARAMS0_LP0_ADDR, ul_data);

   //ZT_ILV_BASE0_OFFSET
   WriteCoreReg(ZEP_PRAM_ZT_ILV_BASE0_LP0_ADDR, gula_txILVBaseAddr[0]);

   //ZT_ILV_SIZE0_OFFSET
   //ZEP_PRAM_ZT_ILV_SIZE0_LP0_ADDR

   // set totalFifo delay to D - M - 1, where  M = floor(D/I)
   if ( us_Iblk == 0 )
      l_ilvSize = 0;
   else {
   l_ilv_param_m = us_D / us_Iblk ;
   l_ilvSize = (us_D - l_ilv_param_m - 1)& 0xFFFF;
   }
   WriteCoreReg(ZEP_PRAM_ZT_ILV_SIZE0_LP0_ADDR, ((gusa_txFifoExt[LP0_DATA_PATH] <<16) |l_ilvSize ));


   //ZT_ILV_MAX_FULLNESS0_OFFSET
   ul_data = (uint32)(us_Iblk ); //Max Fullness
   WriteCoreReg(ZEP_PRAM_ZT_ILV_MAX_FULLNESS0_LP0_ADDR, ul_data);

   //ZT_ILV_MIN_FULLNESS0_OFFSET
   ul_data = 0; // Min Fullness, Init to 0
   WriteCoreReg(ZEP_PRAM_ZT_ILV_MIN_FULLNESS0_LP0_ADDR, ul_data);

   //ZT_ILV_FULLNESS0_OFFSET
   //ZT_ILV_CNTRS0_OFFSET
   //ZT_ILV_PMS_CNTRS0_OFFSET
   //ZT_ILV_PMD_CNTRS0_OFFSET
   //zero

   //ZT_ILV_PARAMS1_OFFSET
   //ZT_ILV_BASE1_OFFSET
   //ZT_ILV_SIZE1_OFFSET
   //ZT_ILV_MAX_FULLNESS1_OFFSET
   //ZT_ILV_MIN_FULLNESS1_OFFSET
   //ZT_ILV_FULLNESS1_OFFSET
   //ZT_ILV_CNTRS1_OFFSET
   //ZT_ILV_PMS_CNTRS1_OFFSET
   //ZT_ILV_PMD_CNTRS1_OFFSET
   //not used

   ////////////////////////////////////////////////////////////
   // Zephyr Tx GLOBAL REGISTERS INITIALIZATION  (continued) //
   ////////////////////////////////////////////////////////////
   //ZEP_REG_ZT_QTDTB_CONFIG_LP0_ADDR
   //ZEP_REG_ZT_QTDTB_CONFIG_LP1_ADDR
   //ZEP_REG_ZT_QTDTB_CONFIG_LP2_ADDR

   //ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR
   WriteCoreReg(ZEP_REG_ZT_QTDTB_ADDR_LP01_ADDR, 0);

   //ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR
   WriteCoreReg(ZEP_REG_ZT_QTDTB_ADDR_LP2_ADDR, 0);

   // ZEP_REG_ZT_DTB_OFFSET_ADDR
   WriteCoreReg(ZEP_REG_ZT_DTB_OFFSET_ADDR, (ZEP_ILV_RAM_TXDTB_OFFSET<<16)|ZEP_ILV_RAM_TXDTB_OFFSET);

#if 0
   // These two global registers are set every frame.
   // ZEP_REG_ZT_DT_SIZE_ADDR
   // ZEP_REG_ZT_PMS_SIZE_ADDR
   // The two registers are initialized with the same parameter.
   s_TransferSize = (int16)(us_L>> 3);
   s_bitsinLp = (int16)(us_L - (int32)(s_TransferSize << 3));
   // transfer size = ceil(Lp/8) bytes
   if (s_bitsinLp)
      s_TransferSize++;
   ul_data = (uint32)s_TransferSize; //15:0 LP0 DT Size
   WriteCoreReg(ZEP_REG_ZT_DT_SIZE_ADDR, ul_data);
   WriteCoreReg(ZEP_REG_ZT_PMS_SIZE_ADDR, ul_data);
#endif

   ///////////////////////////////////////////////////
   // ZEPHYR CODE ENGINE INITIALIZATION START -- LP0//
   ///////////////////////////////////////////////////
   {
   t_microcode_header *pt_header;
    if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      // ADSL2 framing mode
      pt_header = (t_microcode_header*)(void *)&fci_prog_tx_adsl2_2bc_ibits[0];
   }
   else
   {
      // ADSL1.ilv framing mode
      if ( gt_tx_config.s_Lp[LP0_DATA_PATH]>0 )
         pt_header = (t_microcode_header*)(void *)&fci_prog_tx_gdmt3_lp0[0];
      else
         pt_header = (t_microcode_header*)(void *)&fci_prog_tx_gdmt3_lp1[0];
   }

   //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
   //Load Tx Microcode version number
   gusa_FW_version_number[4] = (uint16)(pt_header->version & 0xFFFF); //XDSLRTFW-3364 (Start_End)

   // ZEP_PRAM_ZT_FLAG_CTRLx_LP0_ADDR
   WriteCoreReg(ZEP_PRAM_ZT_FLAG_CTRL0_LP0_ADDR, pt_header->flags0);
   WriteCoreReg(ZEP_PRAM_ZT_FLAG_CTRL1_LP0_ADDR, pt_header->flags1);

   // ZEP_PRAM_ZT_UPROC_ENA_LP0_ADDR
   WriteCoreReg(ZEP_PRAM_ZT_UPROC_ENA_LP0_ADDR, pt_header->uproc_ena);

   // For Micro processor 0 to 4 use PRAM offset from ZT_UPROC01_BASE_OFFSET
   // from 5 to 9 use the offset from ZT_UPROC5_BASE_OFFSET_35B
   // Don't combine the base address of 2 micro processors for VRX518 as we are doing for VRX218 &
   // 318 platforms.
   // Write to ZEP_PRAM_ZT_UPROCxy_BASE_LPx_ADDR, where xy = 01, 23, 45, 67, 89
   {
      uint32 ul_addr;
      int16 i;

      ul_addr = ZEP_PRAM_TX_LP0_START_ADDR + ZT_UPROC01_BASE_OFFSET;

      for(i=0; i<NUM_OF_UPROCESSORS; i++)
      {
      ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[i]).base;
      WriteCoreReg(ul_addr, ul_data);
      if (i == 4)
      {
         ul_addr = ZEP_PRAM_TX_LP0_START_ADDR+ZT_UPROC5_BASE_OFFSET_35B;
      }
      else
      {
         ul_addr += 4;
      }
      }
   }
#if 0
   // ZEP_PRAM_ZT_UPROC??_BASE_LP0_ADDR
   ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[0]).base;
   ul_data |= (ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[1]).base) << 16;
   WriteCoreReg(ZEP_PRAM_ZT_UPROC01_BASE_LP0_ADDR, ul_data);

   ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[2]).base;
   ul_data |= (ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[3]).base) << 16;
   WriteCoreReg(ZEP_PRAM_ZT_UPROC23_BASE_LP0_ADDR, ul_data);

   ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[4]).base;
   ul_data |= (ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[5]).base) << 16;
   WriteCoreReg(ZEP_PRAM_ZT_UPROC45_BASE_LP0_ADDR, ul_data);

   ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[6]).base;
   ul_data |= (ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[7]).base) << 16;
   WriteCoreReg(ZEP_PRAM_ZT_UPROC67_BASE_LP0_ADDR, ul_data);

   ul_data = ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[8]).base;
   ul_data |= (ZEP_RAM_TX_LP0_UCODE_ADDR/4 + (pt_header->engine[9]).base) << 16;
   WriteCoreReg(ZEP_PRAM_ZT_UPROC89_BASE_LP0_ADDR, ul_data);
#endif

   // ZEP_PRAM_ZT_UPROC_INT_LP0_ADDR - Initialize to 0.
   // ZEP_PRAM_ZT_UPROCy_STATEx_LP0_ADDR, y=0,..9, x=0,..,4
   {
      int16 i, j;

      ul_data = ZEP_PRAM_ZT_UPROC0_STATE0_LP0_ADDR;

      //Loop through all micro-processors (total of 9)
      for(i=0; i<NUM_OF_UPROCESSORS; i++)
      {
         for(j=0; j<NUM_OF_UPROC_STATES; j++)
         {
            WriteCoreReg(ul_data, pt_header->engine[i].state[j]);
            ul_data += 4;
         }
      }
   }

   // Now Copy down microCode.
   {
   int16 s_words;
   void *ptr_mcode;

   //Compute the number of 32-bit words in the header
   s_words = sizeof(t_microcode_header)/4;

   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   {
      // Point to the first word following the header
      ptr_mcode = (void *) &fci_prog_tx_adsl2_2bc_ibits[s_words];
   }
   else
   {
      // ADSL1 Point to the first word following the header
      if ( gt_tx_config.s_Lp[LP0_DATA_PATH]>0 )
         ptr_mcode = (void *) &fci_prog_tx_gdmt3_lp0[s_words];
      else
         ptr_mcode = (void *) &fci_prog_tx_gdmt3_lp1[s_words];
   }

   //Load micro-code
   ul_data = ZEP_RAM_IIBRAM_ADDR + ZEP_RAM_TX_LP0_UCODE_ADDR;
   WriteCoreBuf32(ul_data, (int16 *)ptr_mcode, (uint16)pt_header->total_lines);
   }
}
   // write initial overhead bytes into FIFO
   LoadTxOvhdFifo();
}


/*
*-------------------------------------------------------------------------------
*
*  Prototype: void LoadTxOvhdFifo(void)
*
*  This function loads TX overhead (EOC/IB/HDLC) FIFO.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*-------------------------------------------------------------------------------
*/

void LoadTxOvhdFifo(void)
{
   uint32 numbytes;
   uint32 ul_data;
   uint8 eoc_init[14] = {0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc, 0xc}; //eoc channel workaround
   // ZT_FIFO0_CTRL
   // used for EOC in ADSL mode, HDLC in ADSL2 mode
   if (gl_SelectedMode & (MODE_ADSL2)) // ADSL2 framing mode
   {
      ul_data = OPENING_FLAG ;
      WriteHwFifo(LP0_DATA_PATH , HDLC_FIFO , USE_TX_FIFO , 1, (uint8 *)(void *)&ul_data);
   }
   else // ADSL framing mode
   {
      //workaround: have to load 14 bytes at startup as read ptr jumps at first symbol
      WriteHwFifo(LP0_DATA_PATH , EOC_FIFO , USE_TX_FIFO , 14, eoc_init);
   }

   // ZT_FIFO2_BYTE
   // used for IBITS
   if (( gl_SelectedMode & (MODE_ADSL2)  ))
   { // ADSL2 framing mode
      numbytes = 4;
      guc_ibits[0] = (uint8)0x00;
      guc_ibits[1] = (uint8)0xFF;
      guc_ibits[2] = (uint8)0xFF;
      guc_ibits[3] = (uint8)0xFF;
   }
   else
   { // ADSL mode
      numbytes = 3;
      guc_ibits[0] = (uint8)0xFF;
      if ((STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_AB) || (STATArray[STAT_Mode] & STAT_ConfigMode_G992_2_C)) {
         // if G992_2, bit 14 should be set to 0, as there is no cell delineation at start
         // bit 15 is reserved and hence is set to 1
         guc_ibits[1] = (uint8)0xBF;
      } else {
         // if G992_1, bit 14 and 15 should be set to 0, as there is no cell delineation at start
         guc_ibits[1] = (uint8)0x3F;
      }
      guc_ibits[2] = (uint8)0xFF;
   }

   // write data to FIFO 2
   WriteHwFifo(LP0_DATA_PATH , IBITS_FIFO , USE_TX_FIFO , numbytes, guc_ibits);
}



/*-------------------------------------------------------------------------------
*
*  Prototype: uint16 ZEP_ILV_Find_Pmd_Step(uint16 us_D, uint16 us_I)
*
*  This function computes the PMD step size, by solving  1=D*i mod I for i
*
*  Input Arguments:
*            us_D: Interleaver Depth
*            uc_fifo:Block Size
*
*  Output Arguments:
*        Step Size
*-------------------------------------------------------------------------------
*/
uint16 Find_Pmd_Step(uint16 s_D, uint16 s_I)
{
   int16 i=1;
   int32 l_temp = 0;

   for (i=1; i<s_I;i++)
   {
      l_temp +=  s_D;
      while ( l_temp >=  s_I)
         l_temp -= s_I;

      if (l_temp == 1) break;

   }

   return (i);
}


void ClearTxZephyrRegs(void)
{
   FillCoreBuf32(ZEP_PRAM_TX_LP0_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);
   FillCoreBuf32(ZEP_PRAM_TX_LP1_START_ADDR, 0, ZEP_REG_TX_PRAM_SIZE);
}
