/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2009 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: eng_ini.c
;
;  Initialization functions
;
*****************************************************************************/
//*******************************************************************
// eng_ini.c
//
// History
// 26/11/2012 Kannan: 3GLP Power boost initialization as we do it in VDSL.
//            Grep for XDSLRTFW-541: Platform_VRX318
// 11/02/2013 Kannan:
//          1. Orderly shutdown algo implementation and it is applicable for both
//             VR9 & VRX318.
//             Grep for "XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown"
//*****************************************************************************

#include "common.h"
#include "str_ini.h"
#include "zph_ini.h"
#include "iri_ini.h"
#include "alp_ini.h"
#include "cri_ini.h"
#include "cri_iof.h"    //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START_END)
#include "LL_IOf.h"
#include "delay.h"
#include "Gdata.h"


#ifdef  TARGET_HW
    #include "AFED_Functions.h"
    #include "AFED_Data.h"
#else
    #include "afeini.h"
#endif
#include "electra_ini.h"

/***************************************************************************************
;  Subroutine Name: InitEngine
;
;  Description:
;     This function initializes the ADSL cores.
;
;  Prototype:
;     void InitEngine(void)
;
;  Input Arguments:
;     none
;  Output Arguments:
;     none
;  Return Value:
;     none
;
;**********************************************************************************************/
void InitEngine(void)
{

   // need to initialize iridia before cri since cri uses iridia version register number
   // to configure cri differently for 3.1 and 3.0 bm's
   /* Initialize Iridia */
   InitIridia();

   /* Initialize Clock, Reset, Interrupt Controller  */
   // Done in main()
   //InitCRI();

   /* Initialize BCR */
   InitBcr();

    /* Initialize Zephyr */
   InitZephyr();
   /* Initialize Strymon */
   Config_StrymonCPE();
#ifdef VRX518
   gul_Afe_flowtest |=1;

   //Reset DFI BLOCK should be before AFE init. The reason is after AFE Config we are not suppose reset this
   //only RX.FIFO_RSTN should be done later
   //0x30C78C  V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00000000  0x00000000  0x00000000  0x00000000
   //0x30C78C  V_DFI_BLOCK_RSTN_35B       DFI Block Reset Register      0x00070007  0x00070007  0x00070007  0x00070007
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00000000);
   delay(20);
   WriteCoreReg((uint32)(V_DFI_BLK_RSTN_35B_ADDR), 0x00070007);
   delay(20);
   AFED_AnalogRegistersInit();
   gul_Afe_flowtest |=0x20;


#endif

   /* Initialize Alphaeus */
   InitAlphaeus();



   /* Initialize Analog Front End */
#ifdef TARGET_HW

#ifdef VRX518

   gul_Afe_flowtest |=0x40;
   {
      //Later if someone wants to try other than 17a before GHS
      gus_AFE_RxMode = ADSL2_CPE;
      gus_AFE_TxMode = ADSL2_CPE;
   }

AFED_ModeConfig();
gs_Hyb_Hsk_QlnHlog = 1; //Handshake
AFED_HskQlnHlogSetHybrid();

gul_Afe_flowtest |=0x80;

//Need to initialize the PPE registers before sending modem ready message
DFE_PPE_Shared_PPE_Reg_Init();
//Initialise Max & min PGA settings here
gs_max_pga_setting = AFED_SetInitialPgaToMax();
gs_min_pga_setting = AFED_MinPGASetting();




#else
   VR9_InitAFEPowerUp();

   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (START)
   //Need to initialize the PPE registers before sending modem ready message
   DFE_PPE_Shared_PPE_Reg_Init();
   //XDSLRTFW-710 VR9_VRX318_PDBRAM_Handover_OrderlyShutDown (END)

   //XDSLRTFW-541: Platform_VRX318 (START)
   #ifdef VRX318
   PowerBoost3GLP();
   #endif //#VRX318
   //XDSLRTFW-541: Platform_VRX318 (END)
   AFEModeSelect_HS_Init();

#endif
#else
   afe_reset();
   afe_init();
#endif

   // Disable FDQ, TDQ, DEC, AEC.
   UnityTDQ();
   DisableFDQ();
   ClearDEC();
   ClearAEC();
}
