/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: ALP_IOf.h
;
;  Header file for Alphaeus CPE core interface layer.
;
*****************************************************************************/

// ******************************************************************
// ALP_Iof.h
//
// History
//
// 09/08/2011 Vinjam/SriRam: Integrated code which finds "OOS" anamoly by reading the PPE register.
//                           Grep for XDSLRTFW-302:Feature_ALL_ALL_ALL_ReInit_Triggers
//                           Grep for Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping
// ******************************************************************


#ifndef _ALP_IOF_H
#define _ALP_IOF_H

// Number of buffers provided in V2EA Alphaeus
#define MAX_NUM_RX_CELL_BUFFERS 47 // Max is 93.
#define MAX_NUM_TX_CELL_BUFFERS 8



void EnableAAI_TPMODE(void);
void EnableAAI_Tx(int16 s_bc);
void EnableAAI_Rx(int16 s_bc);

// Get Alphaeus Rx Counter info
void ResetARCellCnt(int16 s_bc);
void Get_ATM_Counters(int16 s_bc);

// Get Alphaeus Tx Counter info
uint32 GetTxIdleCellCnt(int16 s_bc);
uint32 GetTxNonIdleCellCnt(int16 s_bc);


uint16 Get_ATM_Status(int16 s_bc);
//Feature_AB_ALL_ALL_NE_PTM_TC_CNTRS_Mapping (Start_End)
uint16 Get_PTM_Status(int16 s_bc);
void ResetATCellCnt(int16 s_bc);

#endif /*_ALP_IOF_H */
